/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.task;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.util.DateUtils;

public class FinOrgPreInsDataDelService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(FinOrgPreInsDataDelService.class);
    private static final String ENTITY_FINORGINFO = "bd_finorginfo";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            result.setLog("Start FinOrgPreInsData Delete Service...");
            ThreadPools.executeOnce((String)FinOrgPreInsDataDelService.class.getName(), () -> {
                HashSet<Long> idList = new HashSet<Long>(Arrays.asList(149783733937926144L, 149190356380972032L, 149190740788933632L, 149190021398687744L, 149190206023564288L, 149197263451748352L, 149189441720710144L, 149189730876028928L, 149190274071951360L, 149190615505074176L, 149190503995309056L, 149189948627514368L, 149185319449689088L, 149186938803354624L, 149189512973545472L, 149189664438254592L, 149190103531548672L, 149190433304506368L, 149196990989761536L, 149197476950209536L));
                idList.removeAll(idList.stream().filter(o -> BaseDataRefrenceHelper.isRefrenced((String)ENTITY_FINORGINFO, (Object)o)).collect(Collectors.toSet()));
                QFilter idFilter = new QFilter("id", "in", idList);
                QFilter modifyTimeFilter = new QFilter("modifytime", "=", (Object)DateUtils.stringToDate((String)"20180821", (String)"yyyyMMdd"));
                DynamicObject[] waitDeleteFinOrgArr = BusinessDataServiceHelper.load((String)ENTITY_FINORGINFO, (String)"id", (QFilter[])new QFilter[]{idFilter, modifyTimeFilter});
                if (waitDeleteFinOrgArr.length > 0) {
                    Object[] waitDeleteIdArr = Arrays.stream(waitDeleteFinOrgArr).map(DataEntityBase::getPkValue).toArray();
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)ENTITY_FINORGINFO, (Object[])waitDeleteIdArr, (OperateOption)OperateOption.create());
                }
            });
            result.setLog("FinOrgPreInsData Delete Finished...");
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.warn((Throwable)e);
        }
        return result;
    }
}

