/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.upgrade.entrust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.consts.DBRouteConst;

public class EntrustPayUpgrade
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(EntrustPayUpgrade.class);
    private static final String[] STATUS_ARR = new String[]{"A", "G", "H"};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog("kd.fi.cas.business.upgrade.entrust.EntrustPayUpgrade");
        try {
            result.setLog(ResManager.loadKDString((String)"\u59d4\u6258\u4ed8\u6b3e\u5f00\u59cb\u6267\u884c\u5386\u53f2\u6570\u636e\u5347\u7ea7\u3002", (String)"EntrustPayUpgrade_1", (String)"fi-cas-business", (Object[])new Object[0]));
            EntrustPayUpgrade.updatePayBillEntrustAmt();
            this.updateAgentBillEntrustAmt();
            result.setLog(ResManager.loadKDString((String)"\u59d4\u6258\u4ed8\u6b3e\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"EntrustPayUpgrade_2", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("entrust pay update history error", (Throwable)e);
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private static void updatePayBillEntrustAmt() {
        block40: {
            String sql = "SELECT COUNT(1) as cnt FROM T_CAS_PaymentBill t inner join T_CAS_PaymentBill_e e on t.fid =e.fid where t.fbillstatus not in ('A','G','H') and e.fentrustorgid != 0";
            try (DataSet countDataSet = DB.queryDataSet((String)"EntrustPayUpgrade_queryPayBillEntrustCount", (DBRoute)DBRouteConst.cas, (String)sql);){
                if (!countDataSet.hasNext()) break block40;
                Row countData = countDataSet.next();
                Long count = countData.getLong("cnt");
                logger.info("\u9700\u8981\u66f4\u65b0\u5df2\u59d4\u6258\u91d1\u989d\u7684\u4ed8\u6b3e\u5355\u6570\u91cf: " + count);
                if (count == null || count.equals(0L)) {
                    return;
                }
                int pageSize = 3000;
                int totalPage = (int)(count / (long)pageSize);
                if (count % (long)pageSize > 0L) {
                    ++totalPage;
                }
                long lastId = 0L;
                for (int i = 0; i < totalPage; ++i) {
                    DynamicObjectCollection targetBills;
                    DynamicObjectCollection sourcePayBills;
                    Throwable throwable;
                    TXHandle tx;
                    block43: {
                        block44: {
                            block41: {
                                block42: {
                                    tx = TX.requiresNew();
                                    throwable = null;
                                    QFilter filter = new QFilter("billstatus", "not in", (Object)STATUS_ARR).and("entrustorg", "is not null", null).and("entrustorg", "!=", (Object)0).and("id", ">", (Object)lastId);
                                    sourcePayBills = QueryServiceHelper.query((String)"EntrustPayUpgrade_queryPayBillEntrustData", (String)"cas_paybill", (String)"id,entrustamt", (QFilter[])filter.toArray(), (String)"id asc", (int)pageSize);
                                    if (!CollectionUtils.isEmpty((Collection)sourcePayBills)) break block41;
                                    if (tx == null) break block40;
                                    if (throwable == null) break block42;
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break;
                                }
                                tx.close();
                                break;
                            }
                            lastId = ((DynamicObject)sourcePayBills.get(sourcePayBills.size() - 1)).getLong("id");
                            logger.info("\u5f00\u59cb\u66f4\u65b0\u7b2c" + i + "\u6279\u4ed8\u6b3e\u5355\u7684\u59d4\u6258\u91d1\u989d, \u6570\u91cf:" + sourcePayBills.size());
                            Set sourceIds = sourcePayBills.stream().map(sourceBill -> sourceBill.getLong("id")).collect(Collectors.toSet());
                            QFilter targetFilter = new QFilter("sourcebillid", "in", sourceIds).and("sourcebilltype", "=", (Object)"cas_paybill").and("billstatus", "not in", (Object)new String[]{"G", "H"}).and("applyorg", "!=", (Object)0);
                            targetBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,sourcebillid,billno,dpamt,totalrefundedamt", (QFilter[])targetFilter.toArray());
                            logger.info("\u7b2c" + i + "\u6279\u83b7\u53d6\u66f4\u65b0\u59d4\u6258\u91d1\u989d\u4ed8\u6b3e\u5355\u7684\u4e0b\u6e38\u4ed8\u6b3e\u5355\u6570\u91cf: " + targetBills.size());
                            if (!CollectionUtils.isEmpty((Collection)targetBills)) break block43;
                            if (tx == null) continue;
                            if (throwable == null) break block44;
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                        continue;
                    }
                    try {
                        try {
                            Map<Long, DynamicObject> targetBillMap = targetBills.stream().collect(Collectors.toMap(t -> t.getLong("sourcebillid"), t -> t, BinaryOperator.maxBy(Comparator.comparingLong(a -> a.getLong("id")))));
                            ArrayList<Object[]> paramList = new ArrayList<Object[]>(sourcePayBills.size());
                            for (DynamicObject sourcePayBill : sourcePayBills) {
                                DynamicObject targetBill = targetBillMap.get(sourcePayBill.getLong("id"));
                                if (targetBill == null) continue;
                                BigDecimal dpAmt = targetBill.getBigDecimal("dpamt");
                                BigDecimal totalRefundedAmt = targetBill.getBigDecimal("totalrefundedamt");
                                Object[] param = new Object[]{dpAmt.subtract(totalRefundedAmt), sourcePayBill.getLong("id")};
                                paramList.add(param);
                            }
                            if (!paramList.isEmpty()) {
                                String updateSql = "update T_CAS_PaymentBill set fentrustamt = ? where fid = ?";
                                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)updateSql, paramList);
                            }
                            logger.info("\u5df2\u66f4\u65b0\u4ed8\u6b3e\u5355\u5df2\u59d4\u6258\u91d1\u989d\u6279\u6b21: " + i + ", \u66f4\u65b0\u6570\u91cf: " + paramList.size());
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            logger.error("update paybill entrust amount error batch no: " + i, (Throwable)e);
                        }
                        continue;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throw throwable5;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                }
            }
        }
    }

    private void updateAgentBillEntrustAmt() {
        block40: {
            String sql = "SELECT COUNT(1) as cnt FROM T_CAS_AgentPayBill where fbillstatus not in ('A','G','H') and fdelegorgid != 0";
            try (DataSet countDataSet = DB.queryDataSet((String)"EntrustPayUpgrade_queryAgentBillEntrustCount", (DBRoute)DBRouteConst.cas, (String)sql);){
                if (!countDataSet.hasNext()) break block40;
                Row countData = countDataSet.next();
                Long count = countData.getLong("cnt");
                logger.info("\u9700\u8981\u66f4\u65b0\u5df2\u59d4\u6258\u91d1\u989d\u7684\u4ee3\u53d1\u5355\u6570\u91cf: " + count);
                if (count == null || count.equals(0L)) {
                    return;
                }
                int pageSize = 3000;
                int totalPage = (int)(count / (long)pageSize);
                if (count % (long)pageSize > 0L) {
                    ++totalPage;
                }
                long lastId = 0L;
                for (int i = 0; i < totalPage; ++i) {
                    DynamicObjectCollection targetBills;
                    DynamicObjectCollection sourceAgentBills;
                    Throwable throwable;
                    TXHandle tx;
                    block43: {
                        block44: {
                            block41: {
                                block42: {
                                    tx = TX.requiresNew();
                                    throwable = null;
                                    QFilter filter = new QFilter("billstatus", "not in", (Object)STATUS_ARR).and("delegorg", "is not null", null).and("delegorg", "!=", (Object)0).and("id", ">", (Object)lastId);
                                    sourceAgentBills = QueryServiceHelper.query((String)"EntrustPayUpgrade_queryAgentBillEntrustData", (String)"cas_agentpaybill", (String)"id,billno,entrustamt", (QFilter[])filter.toArray(), (String)"id asc", (int)pageSize);
                                    if (!CollectionUtils.isEmpty((Collection)sourceAgentBills)) break block41;
                                    if (tx == null) break block40;
                                    if (throwable == null) break block42;
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break;
                                }
                                tx.close();
                                break;
                            }
                            lastId = ((DynamicObject)sourceAgentBills.get(sourceAgentBills.size() - 1)).getLong("id");
                            logger.info("\u5f00\u59cb\u66f4\u65b0\u7b2c" + i + "\u6279\u4ee3\u53d1\u5355\u7684\u59d4\u6258\u91d1\u989d, \u6570\u91cf:" + sourceAgentBills.size());
                            Set sourceBillNos = sourceAgentBills.stream().map(sourceBill -> sourceBill.getString("billno")).collect(Collectors.toSet());
                            QFilter targetFilter = new QFilter("sourcebillnumber", "in", sourceBillNos).and("sourcebilltype", "=", (Object)"repay").and("billstatus", "not in", (Object)new String[]{"G", "H"}).and("applyorg", "!=", (Object)0);
                            targetBills = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id,billno,sourcebillnumber,dpamt,totalrefundedamt", (QFilter[])targetFilter.toArray());
                            logger.info("\u7b2c" + i + "\u6279\u83b7\u53d6\u66f4\u65b0\u59d4\u6258\u91d1\u989d\u4ee3\u53d1\u5355\u7684\u4e0b\u6e38\u4ee3\u53d1\u5355\u6570\u91cf: " + targetBills.size());
                            if (!CollectionUtils.isEmpty((Collection)targetBills)) break block43;
                            if (tx == null) continue;
                            if (throwable == null) break block44;
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                        continue;
                    }
                    try {
                        try {
                            Map<String, DynamicObject> targetBillMap = targetBills.stream().collect(Collectors.toMap(t -> t.getString("sourcebillnumber"), t -> t, BinaryOperator.maxBy(Comparator.comparingLong(a -> a.getLong("id")))));
                            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(sourceAgentBills.size());
                            for (DynamicObject sourceAgentBill : sourceAgentBills) {
                                DynamicObject targetBill = targetBillMap.get(sourceAgentBill.getString("billno"));
                                if (targetBill == null) continue;
                                BigDecimal dpAmt = targetBill.getBigDecimal("dpamt");
                                BigDecimal totalRefundedAmt = targetBill.getBigDecimal("totalrefundedamt");
                                Object[] param = new Object[]{dpAmt.subtract(totalRefundedAmt), sourceAgentBill.getLong("id")};
                                updateParamList.add(param);
                            }
                            if (!updateParamList.isEmpty()) {
                                String updateSql = "update T_CAS_AgentPayBill_e set fentrustamt = ? where fid = ?";
                                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)updateSql, updateParamList);
                            }
                            logger.info("\u5df2\u66f4\u65b0\u4ee3\u53d1\u5355\u5df2\u59d4\u6258\u91d1\u989d\u6279\u6b21: " + i + ", \u66f4\u65b0\u6570\u91cf: " + updateParamList.size());
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            logger.error("update agentbill entrust amount error batch no: " + i, (Throwable)e);
                        }
                        continue;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throw throwable5;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                }
            }
        }
    }
}

