/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cas.business.writeback.AbstractWriteBackValidate;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.util.EmptyUtil;

public class PayBillWriteBackPayApplyValidate
extends AbstractWriteBackValidate {
    private PayBillWriteBackPayApplyValidate() {
    }

    public static PayBillWriteBackPayApplyValidate getInstance() {
        return Singleton.INSTANCE;
    }

    public String execute(List<Map<String, Object>> params) {
        long beginTime = System.currentTimeMillis();
        logger.info("begin validating bill time\uff1a{}", (Object)beginTime);
        Map<String, Object> results = this.handleBillInfo(params);
        Map payBills = (Map)results.get("payBills");
        Map payApplyBills = (Map)results.get("payApplyBills");
        Map payBillAmountMap = (Map)results.get("payBillAmount");
        this.validate(payBills, payApplyBills, payBillAmountMap);
        long endTime = System.currentTimeMillis();
        logger.info("end validating bill time\uff1a{}, lag time:{}", (Object)endTime, (Object)(endTime - beginTime));
        return null;
    }

    private void validate(Map<Long, DynamicObject> payBills, Map<Long, List<DynamicObject>> payApplyBills, Map<Long, AbstractWriteBackValidate.PayBillAmount> payBillAmountMap) {
        for (Map.Entry<Long, List<DynamicObject>> payApplyBillMap : payApplyBills.entrySet()) {
            Long payBillId = payApplyBillMap.getKey();
            DynamicObject payBillObject = payBills.get(payBillId);
            HashMap<Long, Set<Long>> payApplyInfo = new HashMap(16);
            boolean isSavedPayBill = false;
            if (payBillObject != null) {
                isSavedPayBill = true;
                payApplyInfo = this.relatePayApplyPayInfo(payBillObject);
            }
            List<DynamicObject> payApplyBillList = payApplyBillMap.getValue();
            for (DynamicObject payApplyBill : payApplyBillList) {
                Long payApplyId = payApplyBill.getLong("id");
                String billStatus = payApplyBill.getString("billstatus");
                if (!"C".equals(billStatus)) {
                    String error = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u4e0b\u63a8\u3002", (String)"PayBillWriteBackPayApplyValidate_0", (String)"fi-cas-business", (Object[])new Object[0]);
                    throw new KDBizException(error);
                }
                BigDecimal amount = payApplyBill.getBigDecimal("payeeamount");
                BigDecimal amountApplyReceive = BigDecimal.ZERO;
                BigDecimal amountReceive = this.validateAndCount(payApplyBill, isSavedPayBill, payBillAmountMap, payBillId, payApplyInfo);
                DynamicObjectCollection payApplyInfos = payApplyBill.getDynamicObjectCollection("cas_payapplyentry");
                for (DynamicObject payApply : payApplyInfos) {
                    BigDecimal payeeAmount = payApply.getBigDecimal("e_payeeamount");
                    amountApplyReceive = amountApplyReceive.add(payeeAmount);
                }
                if (amount.compareTo(amountReceive) == 0 && amount.compareTo(amountApplyReceive) == 0) continue;
                String error = ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6.\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u7533\u8bf7\u660e\u7ec6.\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u5355\u5934\u6536\u6b3e\u91d1\u989d\u3002", (String)"PayBillWriteBackPayApplyValidate_1", (String)"fi-cas-business", (Object[])new Object[0]);
                this.addLogInfo(payBillId, payApplyId, error);
                throw new KDBizException(error);
            }
        }
    }

    private Map<Long, Set<Long>> relatePayApplyPayInfo(DynamicObject payBillObject) {
        DynamicObjectCollection entries = payBillObject.getDynamicObjectCollection("entry");
        HashMap<Long, Set<Long>> payApplyInfo = new HashMap<Long, Set<Long>>(16);
        if (entries.isEmpty()) {
            return payApplyInfo;
        }
        for (DynamicObject entry : entries) {
            Long payApplyId = entry.getLong("e_sourcebillid");
            Long payApplyEntryId = entry.getLong("e_sourcebillentryid");
            HashSet<Long> payApplyInfos = (HashSet<Long>)payApplyInfo.get(payApplyId);
            if (payApplyInfos == null) {
                payApplyInfos = new HashSet<Long>(16);
                payApplyInfo.put(payApplyId, payApplyInfos);
            }
            payApplyInfos.add(payApplyEntryId);
        }
        return payApplyInfo;
    }

    private BigDecimal validateAndCount(DynamicObject payApplyBill, boolean isSavedPayBill, Map<Long, AbstractWriteBackValidate.PayBillAmount> payBillAmountMap, Long payBillId, Map<Long, Set<Long>> payApplyInfo) {
        Boolean isPartPayment = payApplyBill.getBoolean("ispartpayment");
        Long payApplyId = payApplyBill.getLong("id");
        DynamicObjectCollection payInfos = payApplyBill.getDynamicObjectCollection("cas_payinfo");
        Set<Long> payInfoIds = payApplyInfo.get(payApplyId);
        BigDecimal amountReceive = BigDecimal.ZERO;
        for (DynamicObject payInfo : payInfos) {
            Long payInfoId = payInfo.getLong("id");
            String payStatus = payInfo.getString("entry_paystatus");
            boolean existPayInfo = false;
            if (isSavedPayBill && payInfoIds != null && payInfoIds.contains(payInfoId)) {
                existPayInfo = true;
            }
            this.validateStatus(payInfo, isPartPayment, isSavedPayBill, payBillAmountMap, existPayInfo);
            this.validateEntryStatus(payInfo, payBillAmountMap, payApplyId, payBillId);
            this.validatePayAmount(payInfo, payBillAmountMap, payApplyId, payBillId);
            this.validatePrePostAmount(payInfo, payBillAmountMap, payApplyId, payBillId);
            if (!isPartPayment.booleanValue() && "E".equals(payStatus)) continue;
            BigDecimal payeeAmount = payInfo.getBigDecimal("entry_payeeamount");
            amountReceive = amountReceive.add(payeeAmount);
        }
        if (payApplyBill.getBoolean("refundandrepay")) {
            BigDecimal refundAmount = payInfos.stream().filter(e -> !PayStatusEnum.CLANCEL.getValue().equals(e.getString("entry_paystatus"))).filter(e -> EmptyUtil.isNoEmpty((BigDecimal)e.getBigDecimal("entry_refundamount"))).map(e -> e.getBigDecimal("entry_refundamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            amountReceive = amountReceive.subtract(refundAmount);
        }
        return amountReceive;
    }

    private void validateEntryStatus(DynamicObject payInfo, Map<Long, AbstractWriteBackValidate.PayBillAmount> payBillAmountMap, Long payApplyId, Long payBillId) {
        if (!this.needValidateEntry(payInfo, payBillAmountMap)) {
            return;
        }
        boolean invalid = payInfo.getBoolean("entry_invalid");
        if (invalid) {
            String error = ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6.\u62d2\u4ed8\u9700\u8981\u4e3a\u5426\u3002", (String)"PayBillWriteBackPayApplyValidate_2", (String)"fi-cas-business", (Object[])new Object[0]);
            throw new KDBizException(error);
        }
    }

    private void validateStatus(DynamicObject payInfo, boolean isPartPayment, boolean isSavedPayBill, Map<Long, AbstractWriteBackValidate.PayBillAmount> payBillAmountMap, boolean existPayInfo) {
        String payStatus = payInfo.getString("entry_paystatus");
        if (!this.needValidateEntry(payInfo, payBillAmountMap)) {
            return;
        }
        if (isSavedPayBill && existPayInfo && !"B".contains(payStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6.\u4ed8\u6b3e\u72b6\u6001\u4e0d\u4e3a\u4ed8\u6b3e\u4e2d\u3002", (String)"PayBillWriteBackPayApplyValidate_3", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (!isSavedPayBill || !existPayInfo) {
            if (!isPartPayment && !NON_PART_PAYMENT_STATUS.contains(payStatus)) {
                String error = ResManager.loadKDString((String)"\u5b58\u5728\u4ed8\u6b3e\u660e\u7ec6.\u4ed8\u6b3e\u72b6\u6001\u4e0d\u5728\uff08\u672a\u4ed8\u6b3e/\u5df2\u6392\u6b3e\uff09\u4e2d\u3002", (String)"PayBillWriteBackPayApplyValidate_4", (String)"fi-cas-business", (Object[])new Object[0]);
                throw new KDBizException(error);
            }
            if (isPartPayment && !PART_PAYMENT_STATUS.contains(payStatus)) {
                String error = ResManager.loadKDString((String)"\u5b58\u5728\u4ed8\u6b3e\u660e\u7ec6.\u4ed8\u6b3e\u72b6\u6001\u4e0d\u5728\u201c\u672a\u4ed8\u6b3e/\u5df2\u6392\u6b3e/\u4ed8\u6b3e\u4e2d\u201d\u4e2d\u3002", (String)"PayBillWriteBackPayApplyValidate_5", (String)"fi-cas-business", (Object[])new Object[0]);
                throw new KDBizException(error);
            }
        }
    }

    private void validatePayAmount(DynamicObject payInfo, Map<Long, AbstractWriteBackValidate.PayBillAmount> payBillAmountMap, Long payApplyId, Long payBillId) {
        BigDecimal originPaidAmount;
        BigDecimal originLockedAmount;
        if (!this.needValidateEntry(payInfo, payBillAmountMap)) {
            return;
        }
        BigDecimal payeeAmount = payInfo.getBigDecimal("entry_payeeamount").abs();
        BigDecimal lockedAmount = payInfo.getBigDecimal("entry_lockedamount").abs();
        BigDecimal paidAmount = payInfo.getBigDecimal("entry_paidamount").abs();
        BigDecimal originPayeeAmount = payInfo.getBigDecimal("entry_payeeamount");
        boolean isSameOrientation = this.isSameOrientation(originPayeeAmount, originLockedAmount = payInfo.getBigDecimal("entry_lockedamount"), originPaidAmount = payInfo.getBigDecimal("entry_paidamount"));
        if (!isSameOrientation) {
            String error = ResManager.loadKDString((String)"\u9700\u8981\u6ee1\u8db3\uff1a\u4ed8\u6b3e\u660e\u7ec6.\u6536\u6b3e\u91d1\u989d\u3001\u4ed8\u6b3e\u660e\u7ec6.\u5df2\u9501\u5b9a\u91d1\u989d\u3001\u4ed8\u6b3e\u660e\u7ec6.\u5df2\u4ed8\u6b3e\u91d1\u989d\u7edd\u5bf9\u503c\u90fd\u4e3a\u6b63\u6570\u6216\u8d1f\u6570\u3002", (String)"PayBillWriteBackPayApplyValidate_6", (String)"fi-cas-business", (Object[])new Object[0]);
            throw new KDBizException(error);
        }
        if (payeeAmount.compareTo(lockedAmount) < 0 || lockedAmount.compareTo(paidAmount) < 0) {
            String error = ResManager.loadKDString((String)"\u9700\u8981\u6ee1\u8db3\uff1a\u4ed8\u6b3e\u660e\u7ec6.\u6536\u6b3e\u91d1\u989d\u7684\u7edd\u5bf9\u503c\u5927\u4e8e\u7b49\u4e8e\u4ed8\u6b3e\u660e\u7ec6.\u5df2\u9501\u5b9a\u91d1\u989d\u7edd\u5bf9\u503c\uff0c\u4e14\u5df2\u9501\u5b9a\u91d1\u989d\u7edd\u5bf9\u503c\u5927\u4e8e\u7b49\u4e8e\u5df2\u4ed8\u6b3e\u91d1\u989d\u7edd\u5bf9\u503c\u3002", (String)"PayBillWriteBackPayApplyValidate_7", (String)"fi-cas-business", (Object[])new Object[0]);
            throw new KDBizException(error);
        }
    }

    private void validatePrePostAmount(DynamicObject payInfo, Map<Long, AbstractWriteBackValidate.PayBillAmount> payBillAmountMap, Long payApplyId, Long payBillId) {
        Long entryId = payInfo.getLong("id");
        AbstractWriteBackValidate.PayBillAmount payBillAmount = payBillAmountMap.get(entryId);
        if (!this.needValidateEntry(payInfo, payBillAmountMap)) {
            return;
        }
        BigDecimal payAmount = payInfo.getBigDecimal("entry_payeeamount");
        BigDecimal lockAmount = payInfo.getBigDecimal("entry_lockedamount");
        BigDecimal postPayAmount = payBillAmount.getPostPayAmount();
        BigDecimal postActAmount = payBillAmount.getPostActAmount();
        if (!this.isSameOrientation(payAmount, postPayAmount)) {
            String error = ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u4e3a\u6b63\u6570\uff0c\u53ea\u80fd\u4e0b\u63a8\u6b63\u6570\uff1b\u8d1f\u6570\u53ea\u80fd\u4e0b\u63a8\u8d1f\u6570\u3002", (String)"PayBillWriteBackPayApplyValidate_8", (String)"fi-cas-business", (Object[])new Object[0]);
            throw new KDBizException(error);
        }
        BigDecimal prePayAmount = payBillAmount.getPrePayAmount();
        BigDecimal preActAmount = payBillAmount.getPreActAmount();
        BigDecimal balance = postActAmount.subtract(preActAmount);
        BigDecimal ableBalance = payAmount.subtract(lockAmount);
        logger.error("====PayBillWriteBackPayApplyValidate==validatePrePostAmount:prePayAmount:{}, postPayAmount:{}", (Object)prePayAmount, (Object)postPayAmount);
        logger.error("====PayBillWriteBackPayApplyValidate==validatePrePostAmount:balance:{}, ableBalance:{}", (Object)balance, (Object)ableBalance);
        if (this.negativeDirection(payAmount)) {
            ableBalance = ableBalance.negate();
            balance = balance.negate();
        }
        logger.error("====PayBillWriteBackPayApplyValidate==validatePrePostAmount:ableBalance less than balance :{}", (Object)(ableBalance.compareTo(balance) < 0 ? 1 : 0));
        if (ableBalance.compareTo(balance) < 0) {
            String error = ResManager.loadKDString((String)"\u53ef\u4ed8\u91d1\u989d\u9700\u8981\u5927\u4e8e\u5dee\u989d\u3002", (String)"PayBillWriteBackPayApplyValidate_10", (String)"fi-cas-business", (Object[])new Object[0]);
            throw new KDBizException(error);
        }
    }

    private boolean needValidateEntry(DynamicObject payInfo, Map<Long, AbstractWriteBackValidate.PayBillAmount> payBillAmountMap) {
        Long payInfoId = payInfo.getLong("id");
        return payBillAmountMap.containsKey(payInfoId);
    }

    private void addLogInfo(Long sourceBillId, Long destBillId, String exception) {
        ArrayList logs = new ArrayList(10);
        HashMap<String, Object> log = new HashMap<String, Object>(16);
        log.put("sourcebilltype", "cas_payapplybill");
        log.put("sourcebillid", sourceBillId);
        log.put("destbilltype", "cas_paybill");
        log.put("destbillid", destBillId);
        log.put("traceid", RequestContext.get().getTraceId());
        log.put("createtime", new Date().getTime());
        log.put("exception", exception);
        logs.add(log);
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"repeatLogService", (String)"creatAndSaveRepeatLogs", (Object[])new Object[]{logs});
    }

    static class Singleton {
        private static PayBillWriteBackPayApplyValidate INSTANCE = new PayBillWriteBackPayApplyValidate();

        Singleton() {
        }
    }
}

