/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.writeback.WriteBackConfigInvoker;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.task.WriteBackTask;
import kd.fi.cas.helper.CasHelper;

public class RecClaimWriteBackConsumer
extends WriteBackConfigInvoker {
    @Override
    protected Object[] getInvokeParams(WriteBackTask task) {
        List entryPks;
        Map<String, Object> customParams;
        ArrayList dispostData = new ArrayList();
        Object billPk = task.getBillPk();
        DynamicObjectCollection collection = task.getEntrys();
        if (CasHelper.isNotEmpty((Object)billPk) && task.getOperation() != WriteBackOperateEnum.SUBMITVALIDATE) {
            DynamicObject claimBill = BusinessDataServiceHelper.loadSingle((Object)billPk, (String)"cas_claimbill");
            collection = claimBill.getDynamicObjectCollection("entryentity");
        }
        if ((customParams = task.getCustomParams()) != null && (entryPks = (List)customParams.get("entryPks")) != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                if (entryPks.contains(row.getPkValue())) continue;
                iterator.remove();
            }
        }
        for (DynamicObject entry : collection) {
            HashMap<String, Object> disposeRowInfo = new HashMap<String, Object>();
            BigDecimal paidamt = entry.getBigDecimal("e_receivableamt");
            if (WriteBackOperateEnum.CANCELRECEIVE == task.getOperation() || WriteBackOperateEnum.UNSUBMIT == task.getOperation()) {
                disposeRowInfo.put("amount", paidamt.negate());
            } else {
                disposeRowInfo.put("amount", paidamt);
            }
            disposeRowInfo.put("corebilltype", entry.getString("e_corebilltype"));
            disposeRowInfo.put("corebillno", entry.getString("e_corebillno"));
            disposeRowInfo.put("corebillid", entry.getLong("e_corebillid"));
            disposeRowInfo.put("operation", task.getOperation().getValue());
            disposeRowInfo.put("targetentrypk", entry.getPkValue());
            disposeRowInfo.put("targetpk", billPk);
            disposeRowInfo.put("targetbilltype", task.getEntityKey());
            dispostData.add(disposeRowInfo);
        }
        return new Object[]{dispostData};
    }

    @Override
    protected Object[] getInvokeParamsList(List<WriteBackTask> taskList) {
        ArrayList dispostData = new ArrayList();
        List billPks = taskList.stream().map(o -> o.getBillPk()).collect(Collectors.toList());
        DynamicObject[] recClaimBills = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,entryentity,entryentity.e_receivableamt,entryentity.e_corebilltype,entryentity.e_corebillno,entryentity.e_corebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", billPks)});
        Map recClaimBillMap = Arrays.stream(recClaimBills).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        for (WriteBackTask task : taskList) {
            List entryPks;
            Map<String, Object> customParams;
            Object billPk = task.getBillPk();
            DynamicObjectCollection collection = task.getEntrys();
            if (CasHelper.isNotEmpty((Object)billPk) && task.getOperation() != WriteBackOperateEnum.SUBMITVALIDATE) {
                DynamicObject claimBill = (DynamicObject)recClaimBillMap.get(task.getBillPk());
                collection = claimBill.getDynamicObjectCollection("entryentity");
            }
            if ((customParams = task.getCustomParams()) != null && (entryPks = (List)customParams.get("entryPks")) != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    DynamicObject row = (DynamicObject)iterator.next();
                    if (entryPks.contains(row.getPkValue())) continue;
                    iterator.remove();
                }
            }
            for (DynamicObject entry : collection) {
                HashMap<String, Object> disposeRowInfo = new HashMap<String, Object>();
                BigDecimal paidamt = entry.getBigDecimal("e_receivableamt");
                if (WriteBackOperateEnum.CANCELRECEIVE == task.getOperation() || WriteBackOperateEnum.UNSUBMIT == task.getOperation()) {
                    disposeRowInfo.put("amount", paidamt.negate());
                } else {
                    disposeRowInfo.put("amount", paidamt);
                }
                disposeRowInfo.put("corebilltype", entry.getString("e_corebilltype"));
                disposeRowInfo.put("corebillno", entry.getString("e_corebillno"));
                disposeRowInfo.put("corebillid", entry.getLong("e_corebillid"));
                disposeRowInfo.put("operation", task.getOperation().getValue());
                disposeRowInfo.put("targetentrypk", entry.getPkValue());
                disposeRowInfo.put("targetpk", billPk);
                disposeRowInfo.put("targetbilltype", task.getEntityKey());
                dispostData.add(disposeRowInfo);
            }
        }
        return new Object[]{dispostData};
    }
}

