/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.IAppCache;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.writeback.WriteBackTaskConsumer;
import kd.fi.cas.business.writeback.task.WriteBackTask;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.helper.TmcAppCache;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class WriteBackConfigInvoker
implements WriteBackTaskConsumer {
    private static final Log logger = LogFactory.getLog(WriteBackConfigInvoker.class);
    private static final String LOCK_DELDATE = "CAS_DELWRITEBACK_DLOCK_";
    private IAppCache iAppCache = TmcAppCache.get((String)"cas", (String)"writeback", (String)"del");
    private static final String KEY_DELDATE = "WriteBackConfigInvoker:deldate";
    private static final String FINAL_ONE = "EC";
    private List<String> billIds = new ArrayList<String>(5);
    private static final String WRITE_BACK_CONFIG_PROS = "id,matchoperation,entry.invoketype,entry.operation,entry.default,entry.service,entry.isnew";

    @Override
    public <T> T consumeTask(WriteBackTask task) {
        boolean codeMatchOperate;
        this.deleteWriteBackTask();
        boolean isNew = false;
        Map<String, Object> map = task.getCustomParams();
        if (map != null && map.containsKey("isNew")) {
            isNew = (Boolean)map.get("isNew");
        }
        logger.info(String.format("\u53cd\u5199\u5f00\u59cb---\u6e90\u5355\u6807\u8bc6\uff1a%s\uff0c\u76ee\u6807\u5355\u6807\u8bc6\uff1a%s\uff0c\u53cd\u5199\u64cd\u4f5c\uff1a%s", new Object[]{task.getSourceEntityKey(), task.getEntityKey(), task.getOperation()}));
        QFilter filter = new QFilter("targetentity", "=", (Object)task.getEntityKey()).and(new QFilter("sourceentity", "=", (Object)task.getSourceEntityKey())).and(new QFilter("enable", "=", (Object)"1"));
        if ("cas_payapplybill".equals(task.getSourceEntityKey()) || "pm_purorderbill".equals(task.getSourceEntityKey()) || isNew) {
            filter = filter.and(new QFilter("entry.operation", "=", (Object)task.getOperation().getValue()));
            codeMatchOperate = true;
        } else {
            codeMatchOperate = false;
        }
        DynamicObject writeBackConfig = QueryServiceHelper.queryOne((String)"cas_writebackconfig", (String)WRITE_BACK_CONFIG_PROS, (QFilter[])filter.toArray());
        if (writeBackConfig == null) {
            logger.info(String.format("\u627e\u4e0d\u5230\u53cd\u5199\u670d\u52a1\u914d\u7f6e\uff0c\u6e90\u5355\u6807\u8bc6\uff1a%s\uff0c\u76ee\u6807\u5355\u6807\u8bc6\uff1a%s\uff0c\u53cd\u5199\u64cd\u4f5c\uff1a%s", new Object[]{task.getSourceEntityKey(), task.getEntityKey(), task.getOperation()}));
            return null;
        }
        writeBackConfig = this.matchFinalConfig(Collections.singletonList(task), codeMatchOperate, writeBackConfig);
        if (writeBackConfig == null) {
            return null;
        }
        Object[] invokeParams = this.getInvokeParams(task);
        task.setParams(invokeParams);
        return this.invoke(writeBackConfig, invokeParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteWriteBackTask() {
        block17: {
            try {
                DLock dl;
                String deldate = (String)this.iAppCache.get(KEY_DELDATE, String.class);
                String currDate = DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd");
                if (!StringUtils.isEmpty((String)deldate) && deldate.equals(currDate) || !(dl = DLock.create((String)LOCK_DELDATE)).tryLock(3000L)) break block17;
                try (TXHandle tx = TX.requiresNew();){
                    QFilter dateFilter = new QFilter("lastexecutetime", "<=", (Object)DateUtils.getLastDay((Date)DateUtils.getCurrentDate(), (int)120));
                    QFilter resultFilter = new QFilter("result", "=", (Object)"1");
                    DeleteServiceHelper.delete((String)"cas_writebacktask", (QFilter[])new QFilter[]{dateFilter, resultFilter});
                    this.iAppCache.put(KEY_DELDATE, (Object)currDate);
                }
                finally {
                    dl.unlock();
                }
            }
            catch (Exception e) {
                logger.info("WriteBackConfigInvoker delrecord:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }

    @Override
    public <T> T consumeTaskList(List<WriteBackTask> task) {
        boolean codeMatchOperate;
        this.deleteWriteBackTask();
        boolean isNew = false;
        Map<String, Object> map = task.get(0).getCustomParams();
        if (map != null && map.containsKey("isNew")) {
            isNew = (Boolean)map.get("isNew");
        }
        QFilter filter = new QFilter("targetentity", "=", (Object)task.get(0).getEntityKey()).and(new QFilter("sourceentity", "=", (Object)task.get(0).getSourceEntityKey())).and(new QFilter("enable", "=", (Object)"1"));
        if (this.noSupportNewService().contains(task.get(0).getSourceEntityKey()) || isNew) {
            filter = filter.and(new QFilter("entry.operation", "=", (Object)task.get(0).getOperation().getValue())).and(new QFilter("entry.isnew", "=", (Object)isNew));
            codeMatchOperate = true;
        } else {
            codeMatchOperate = false;
        }
        DynamicObject writeBackConfig = QueryServiceHelper.queryOne((String)"cas_writebackconfig", (String)WRITE_BACK_CONFIG_PROS, (QFilter[])filter.toArray());
        if (writeBackConfig == null) {
            logger.info(String.format("\u627e\u4e0d\u5230\u53cd\u5199\u670d\u52a1\u914d\u7f6e\uff0c\u6e90\u5355\u6807\u8bc6\uff1a%s\uff0c\u76ee\u6807\u5355\u6807\u8bc6\uff1a%s\uff0c\u53cd\u5199\u64cd\u4f5c\uff1a%s", new Object[]{task.get(0).getSourceEntityKey(), task.get(0).getEntityKey(), task.get(0).getOperation()}));
            return null;
        }
        if ((writeBackConfig = this.matchFinalConfig(task, codeMatchOperate, writeBackConfig)) == null) {
            return null;
        }
        Object[] invokeParams = this.getInvokeParamsList(task);
        return this.invoke(writeBackConfig, invokeParams);
    }

    private Set<String> noSupportNewService() {
        HashSet<String> SrcEntityKey = new HashSet<String>();
        SrcEntityKey.add("pm_purorderbill");
        return SrcEntityKey;
    }

    public <T> T invoke(DynamicObject config, Object[] params) {
        String[] serviceInfos = config.getString("entry.service").split("[.]");
        String cloud = serviceInfos[0];
        String app = serviceInfos[1];
        String service = serviceInfos[2];
        String method = "execute";
        if (serviceInfos.length > 3 && StringUtils.isNotEmpty((String)serviceInfos[3])) {
            method = serviceInfos[3];
        }
        if (FINAL_ONE.equals(config.getString("entry.invoketype"))) {
            if (TX.inTX()) {
                return this.invokeFinalOne(config, params, serviceInfos, cloud, app, service);
            }
            try (TXHandle tx = TX.requiresNew();){
                T t = this.invokeFinalOne(config, params, serviceInfos, cloud, app, service);
                return t;
            }
        }
        if (cloud.contains("-")) {
            cloud = cloud.replaceAll("-", ".");
            return (T)DispatchServiceHelper.invokeService((String)cloud, (String)app, (String)service, (String)method, (Object[])params);
        }
        return this.invoke(cloud, app, service, method, params);
    }

    protected <T> T invoke(String cloud, String app, String service, String method, Object ... params) {
        return (T)DispatchServiceHelper.invokeBizService((String)cloud, (String)app, (String)service, (String)method, (Object[])params);
    }

    protected Object[] getInvokeParams(WriteBackTask task) {
        return null;
    }

    protected Object[] getInvokeParamsList(List<WriteBackTask> task) {
        return null;
    }

    private DynamicObject matchFinalConfig(List<WriteBackTask> tasks, boolean codeMatchOperate, DynamicObject writeBackConfig) {
        if (!codeMatchOperate && writeBackConfig.getBoolean("matchoperation")) {
            Optional<DynamicObject> configOp;
            QFilter newFilter = new QFilter("id", "=", writeBackConfig.get("id"));
            DynamicObjectCollection configWithEntrys = QueryServiceHelper.query((String)"cas_writebackconfig", (String)WRITE_BACK_CONFIG_PROS, (QFilter[])newFilter.toArray());
            WriteBackTask writeBackTask = tasks.get(0);
            List configList = configWithEntrys.stream().filter(c -> writeBackTask.getOperation().getValue().equals(c.getString("entry.operation"))).collect(Collectors.toList());
            if (!configList.isEmpty()) {
                configOp = configList.stream().filter(cf -> cf.getBoolean("entry.isnew")).findFirst();
                if (!configOp.isPresent()) {
                    logger.info(String.format("\u53cd\u5199\u670d\u52a1\u914d\u7f6e\u5df2\u7981\u7528\uff0c\u6e90\u5355\u6807\u8bc6\uff1a%s\uff0c\u76ee\u6807\u5355\u6807\u8bc6\uff1a%s\uff0c\u53cd\u5199\u64cd\u4f5c\uff1a%s", new Object[]{writeBackTask.getSourceEntityKey(), writeBackTask.getEntityKey(), writeBackTask.getOperation()}));
                    return null;
                }
            } else {
                configOp = configWithEntrys.stream().filter(c -> c.getBoolean("entry.default") && c.getBoolean("entry.isnew")).findFirst();
                if (!configOp.isPresent()) {
                    logger.info(String.format("\u65e0\u53ef\u7528\u7684\u53cd\u5199\u670d\u52a1\u914d\u7f6e\uff0c\u6e90\u5355\u6807\u8bc6\uff1a%s\uff0c\u76ee\u6807\u5355\u6807\u8bc6\uff1a%s\uff0c\u53cd\u5199\u64cd\u4f5c\uff1a%s", new Object[]{writeBackTask.getSourceEntityKey(), writeBackTask.getEntityKey(), writeBackTask.getOperation()}));
                    return null;
                }
            }
            writeBackConfig = configOp.get();
        }
        if (FINAL_ONE.equals(writeBackConfig.getString("entry.invoketype"))) {
            for (WriteBackTask task : tasks) {
                if (task.getBillPk() != null) {
                    this.billIds.add(String.valueOf(task.getBillPk()));
                    continue;
                }
                if (!ArrayUtils.isNotEmpty((Object[])task.getBillPks())) continue;
                for (Long billPk : task.getBillPks()) {
                    if (billPk == null) continue;
                    this.billIds.add(String.valueOf(billPk));
                }
            }
        }
        return writeBackConfig;
    }

    private <T> T invokeFinalOne(DynamicObject config, Object[] params, String[] serviceInfos, String cloud, String app, String service) {
        String serviceInfoStr = Arrays.toString(serviceInfos);
        String operateType = config.getString("entry.operation");
        if (this.billIds.isEmpty()) {
            logger.error("WriteBackConfigInvoker consistency writeBack no ids, operate=" + operateType + ", serviceInfo =" + serviceInfoStr);
        }
        logger.info("WriteBackConfigInvoker consistency writeBack start, operate=" + operateType + ", serviceInfo =" + serviceInfoStr);
        CommonParam commonParam = new CommonParam();
        commonParam.put((Object)"param", params[0]);
        ECGlobalSession.begin((String)"CAS_WRITEBACK_SOURCE", (DBRoute)DBRouteConst.cas, (boolean)true);
        ECGlobalSession.setBusinessType((String)"CAS_WRITEBACK_SOURCE");
        ECGlobalSession.setBusinessInfo(this.billIds);
        ECGlobalSession.setAsync((boolean)true);
        ECGlobalSession.register((String)cloud, (String)app, (String)service, (Param)commonParam, null, (String)"");
        logger.info("WriteBackConfigInvoker consistency writeBack end, operate=" + operateType + ", serviceInfo =" + serviceInfoStr);
        return null;
    }
}

