/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback.refund;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.refund.RefundWriteBackConsumer;
import kd.fi.cas.business.writeback.task.WriteBackTask;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.refund.RefundEntryInfo;
import kd.fi.cas.refund.RefundPayBillInfo;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;

public class CancelRefundWriteBackConsumer
extends RefundWriteBackConsumer {
    private final Long revId;
    private final List<DynamicObject> bills;
    private Object[] invokeParam;

    public CancelRefundWriteBackConsumer(Long revId, List<DynamicObject> bills) {
        this.revId = revId;
        this.bills = bills;
    }

    public RefundRenoteOrCancelParam initInvokeParams(String entityKey, String sourceEntity, WriteBackOperateEnum operation) {
        WriteBackTask task = new WriteBackTask();
        task.setBillPks((Long[])this.bills.stream().map(b -> (Long)b.getPkValue()).toArray(Long[]::new));
        task.setEntityKey(entityKey);
        task.setSourceEntityKey(sourceEntity);
        task.setOperation(operation);
        task.setConsumer(this.getClass());
        return (RefundRenoteOrCancelParam)this.getInvokeParams(task)[0];
    }

    @Override
    protected Object[] getInvokeParams(WriteBackTask task) {
        if (this.invokeParam != null) {
            return this.invokeParam;
        }
        RefundRenoteOrCancelParam writeBackParam = new RefundRenoteOrCancelParam();
        writeBackParam.setRecId(this.revId);
        writeBackParam.setOperate(task.getOperation().getValue());
        ArrayList<RefundPayBillInfo> refundPayInfos = new ArrayList<RefundPayBillInfo>(this.bills.size());
        writeBackParam.setRefundPayInfos(refundPayInfos);
        Function<DynamicObject, BigDecimal> amtFun = "cas_paybill".equals(task.getEntityKey()) ? payBillEntry -> payBillEntry.getBigDecimal("e_payableamt") : agentBillEntry -> AgentPayBillHelper.decodeAmount((String)agentBillEntry.getString("e_encryptamount"));
        Function<DynamicObject, String> settletNumberFun = this.getSettletNumberFun(task.getEntityKey());
        for (DynamicObject bill : this.bills) {
            RefundPayBillInfo refundPayBillInfo = new RefundPayBillInfo();
            refundPayInfos.add(refundPayBillInfo);
            refundPayBillInfo.setTargetPk((Long)bill.getPkValue());
            refundPayBillInfo.setTargetBillType(task.getEntityKey());
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("entry");
            List refundRevList = bill.getDynamicObjectCollection("refundrevlist").stream().filter(d -> this.revId.equals(d.getLong("revid"))).collect(Collectors.toList());
            BigDecimal totalReAmt = refundRevList.stream().map(r -> r.getBigDecimal("refundamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal amtSum = entryList.stream().map(amtFun).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal eRefundAmtSum = entryList.stream().map(ent -> ent.getBigDecimal("e_refundamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalRefundedAmt = eRefundAmtSum.subtract(totalReAmt);
            refundPayBillInfo.setTotalRefundedAmt(totalRefundedAmt);
            refundPayBillInfo.setTotalRemainRefundAmt(amtSum.subtract(totalRefundedAmt));
            refundPayBillInfo.setSettletnumber(settletNumberFun.apply(bill));
            refundPayBillInfo.setDifferPay(Boolean.valueOf(bill.getBoolean("isdiffcur")));
            Map<Long, BigDecimal> entryIdWithRefundAmt = refundRevList.stream().collect(Collectors.toMap(r -> r.getLong("pentryid"), r -> r.getBigDecimal("refundamt")));
            List refundEntryList = entryList.stream().filter(e -> entryIdWithRefundAmt.containsKey((Long)e.getPkValue())).collect(Collectors.toList());
            List sourceBotpList = BFTrackerServiceHelper.loadSourceRowIds((String)task.getEntityKey(), (String)"entry", (Long[])new Long[]{(Long)bill.getPkValue()}, (Long[])((Long[])refundEntryList.stream().map(r -> (Long)r.getPkValue()).toArray(Long[]::new)), null);
            ArrayList<RefundEntryInfo> entryInfos = new ArrayList<RefundEntryInfo>(refundEntryList.size());
            for (DynamicObject refundEntry : refundEntryList) {
                RefundEntryInfo entryInfo = this.bulidRefundEntryInfo(bill, refundEntry, sourceBotpList, entryIdWithRefundAmt, true);
                entryInfos.add(entryInfo);
            }
            refundPayBillInfo.setEntryInfos(entryInfos);
        }
        this.invokeParam = new Object[]{writeBackParam};
        return this.invokeParam;
    }
}

