/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.compare.comparator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.cas.compare.comparator.AbstractComparator;
import kd.fi.cas.compare.data.ComparePropValue;
import kd.fi.cas.compare.data.CompareRule;
import kd.fi.cas.compare.result.CompareUnitResult;

public class ContainsComparator
extends AbstractComparator {
    @Override
    public List<CompareUnitResult> compare(Set<ComparePropValue> srcValList, Set<ComparePropValue> tarValList, CompareRule rule) {
        Map<String, CompareUnitResult> model = this.buildCompareModel(tarValList, rule);
        this.compare(model, srcValList);
        return new ArrayList<CompareUnitResult>(model.values());
    }

    private Map<String, CompareUnitResult> buildCompareModel(Set<ComparePropValue> tarValList, CompareRule rule) {
        Object extraVal = rule.getExtraVal();
        if (extraVal == null) {
            throw new IllegalArgumentException();
        }
        String separator = extraVal.toString();
        HashMap<String, CompareUnitResult> model = new HashMap<String, CompareUnitResult>();
        for (ComparePropValue tarVal : tarValList) {
            String tarData = this.getStringValue(tarVal.getData());
            ArrayList<String> keyList = new ArrayList<String>();
            if ("_______null_val_______".equals(tarData)) {
                keyList.add(tarData);
            } else {
                String[] keyArr = tarData.split(separator);
                keyList.addAll(Arrays.asList(keyArr));
            }
            for (String key : keyList) {
                CompareUnitResult compareResult = (CompareUnitResult)model.get(key);
                if (compareResult == null) {
                    compareResult = new CompareUnitResult();
                    model.put(key, compareResult);
                }
                compareResult.getTarIdSet().add(tarVal.getId());
            }
        }
        return model;
    }

    private void compare(Map<String, CompareUnitResult> model, Set<ComparePropValue> srcValList) {
        for (ComparePropValue srcVal : srcValList) {
            CompareUnitResult compareResult;
            String srcData = this.getStringValue(srcVal.getData());
            if ("_______null_val_______".equals(srcData) || (compareResult = model.get(srcData)) == null) continue;
            compareResult.getSrcIdSet().add(srcVal.getId());
        }
    }
}

