/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.compare.comparator;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.cas.compare.comparator.AbstractComparator;
import kd.fi.cas.compare.data.ComparePropValue;
import kd.fi.cas.compare.data.CompareRule;
import kd.fi.cas.compare.result.CompareUnitResult;
import org.apache.commons.lang3.tuple.Pair;

public class SubStringComparator
extends AbstractComparator {
    private static final Character KEY_NULL = Character.valueOf('\u2508');
    private static final long MAX_BOX_SIZE = 10000000L;
    private int maxIndexCnt = 0;
    private static final int DIRECT_REVERSE = -1;
    private static final int DIRECT_BOTH = 0;
    private static final int DIRECT_NORMAL = 1;

    @Override
    public List<CompareUnitResult> compare(Set<ComparePropValue> srcValList, Set<ComparePropValue> tarValList, CompareRule rule) {
        List<CompareUnitResult> resultList;
        Integer type = null;
        try {
            type = (Integer)rule.getExtraVal();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type == null) {
            type = 1;
        }
        if (type == 0) {
            resultList = this.compare(srcValList, tarValList, rule, false);
            resultList.addAll(this.compare(srcValList, tarValList, rule, true));
        } else {
            resultList = type == -1 ? this.compare(srcValList, tarValList, rule, true) : this.compare(srcValList, tarValList, rule, false);
        }
        this.watch.printSummary();
        return resultList;
    }

    private List<CompareUnitResult> compare(Set<ComparePropValue> srcValList, Set<ComparePropValue> tarValList, CompareRule rule, boolean isReversed) {
        if (isReversed) {
            this.maxIndexCnt = this.getMaxIndexCnt(tarValList, srcValList);
            Map<Character, Object> model = this.buildCompareModel(tarValList);
            List<CompareUnitResult> resultList = this.compare(model, srcValList, rule);
            ArrayList<CompareUnitResult> reversedResultList = new ArrayList<CompareUnitResult>(resultList.size());
            for (CompareUnitResult originResult : resultList) {
                CompareUnitResult reverseResult = new CompareUnitResult();
                reverseResult.setSrcIdSet(originResult.getTarIdSet());
                reverseResult.setTarIdSet(originResult.getSrcIdSet());
                reversedResultList.add(reverseResult);
            }
            return reversedResultList;
        }
        this.maxIndexCnt = this.getMaxIndexCnt(srcValList, tarValList);
        Map<Character, Object> model = this.buildCompareModel(srcValList);
        List<CompareUnitResult> resultList = this.compare(model, tarValList, rule);
        return resultList;
    }

    private Map<Character, Object> buildCompareModel(Set<ComparePropValue> srcValList) {
        this.watch.nextStep(ResManager.loadKDString((String)"\u521b\u5efaSRC\u7d22\u5f15, \u7d22\u5f15\u7ea7\u6b21:%s", (String)"SubStringComparator_0", (String)"tmc-fbp-common", (Object[])new Object[]{this.maxIndexCnt}));
        HashMap<Character, Object> model = new HashMap<Character, Object>();
        this.createIndex(model, srcValList, true);
        return model;
    }

    private List<CompareUnitResult> compare(Map<Character, Object> model, Set<ComparePropValue> tarValList, CompareRule rule) {
        this.watch.nextStep(ResManager.loadKDString((String)"\u521b\u5efaTAR\u7d22\u5f15", (String)"SubStringComparator_1", (String)"tmc-fbp-common", (Object[])new Object[0]));
        List<Pair<List<Character>, CharObj>> matchedTarIndexList = this.createIndex(model, tarValList, false);
        this.watch.nextStep(ResManager.loadKDString((String)"\u5408\u5e76\u7ed3\u679c", (String)"SubStringComparator_2", (String)"tmc-fbp-common", (Object[])new Object[0]));
        ArrayList<CompareUnitResult> resultList = new ArrayList<CompareUnitResult>();
        for (Pair<List<Character>, CharObj> lastCharIndex : matchedTarIndexList) {
            List charIndexList = (List)lastCharIndex.getLeft();
            Character prevChar = (Character)charIndexList.get(charIndexList.size() - 1);
            CharObj idx = (CharObj)lastCharIndex.getRight();
            Map<Character, Object> lastIndexMap = this.getLastIndexMap(model, charIndexList);
            CharObjModel lastModel = (CharObjModel)lastIndexMap.get(prevChar);
            LinkedList<CharObj> srcIndexList = new LinkedList<CharObj>(lastModel.getSrcCharObjSet());
            if (prevChar.equals(KEY_NULL)) {
                List allSrcList = lastIndexMap.values().stream().map(o -> (CharObjModel)o).map(CharObjModel::getSrcCharObjSet).flatMap(Collection::stream).collect(Collectors.toList());
                srcIndexList.addAll(allSrcList);
            }
            HashSet<CharObj> srcIndexListCopy = new HashSet<CharObj>(srcIndexList.size());
            for (CharObj charObj : srcIndexList) {
                srcIndexListCopy.add(new CharObj(charObj.getId(), charObj.getIndex(), charObj.getCharModel(), charObj.getPrevChar()));
            }
            this.intersectSrcArr(idx, srcIndexListCopy);
            if (srcIndexListCopy.size() <= 0) continue;
            Set<Object> srcIdList = srcIndexListCopy.stream().map(CharObj::getId).collect(Collectors.toSet());
            CompareUnitResult result = new CompareUnitResult(srcIdList, new HashSet<Object>(Collections.singletonList(idx.getId())));
            resultList.add(result);
        }
        return resultList;
    }

    private List<Pair<List<Character>, CharObj>> createIndex(Map<Character, Object> model, Set<ComparePropValue> valList, boolean isSrcIdx) {
        ArrayList<Pair<List<Character>, CharObj>> lastIdxList = new ArrayList<Pair<List<Character>, CharObj>>();
        for (ComparePropValue srcVal : valList) {
            String stringValue = this.getStringValue(srcVal.getData());
            if ("_______null_val_______".equals(stringValue)) continue;
            char[] charArr = stringValue.toCharArray();
            CharObj prevChar = null;
            for (int i = 0; i < charArr.length; ++i) {
                HashMap prevIdxMap = model;
                ArrayList<Character> charIndexList = new ArrayList<Character>(this.maxIndexCnt);
                for (int j = 0; j < this.maxIndexCnt; ++j) {
                    Character c = Character.valueOf(i < j ? KEY_NULL.charValue() : charArr[i - j]);
                    charIndexList.add(c);
                    prevIdxMap = (HashMap)prevIdxMap.computeIfAbsent((Character)c, t -> new HashMap());
                }
                Character lastIndexChar = Character.valueOf(i < this.maxIndexCnt ? KEY_NULL.charValue() : charArr[i - this.maxIndexCnt]);
                charIndexList.add(lastIndexChar);
                CharObjModel charModel = (CharObjModel)prevIdxMap.computeIfAbsent((Character)lastIndexChar, k -> new CharObjModel());
                CharObj charObj = new CharObj(srcVal.getId(), i, charModel, prevChar);
                Set<CharObj> dataList = isSrcIdx ? charModel.getSrcCharObjSet() : charModel.getTarCharObjSet();
                dataList.add(charObj);
                prevChar = charObj;
                if (i != charArr.length - 1) continue;
                lastIdxList.add((Pair<List<Character>, CharObj>)Pair.of(charIndexList, (Object)charObj));
            }
        }
        return lastIdxList;
    }

    private void intersectSrcArr(CharObj idx, Set<CharObj> srcIndexList) {
        if (idx.getIndex() < this.maxIndexCnt + 1 || srcIndexList.size() == 0) {
            return;
        }
        int bakCnt = Math.min(idx.getIndex() - this.maxIndexCnt, this.maxIndexCnt + 1);
        CharObj pChar = idx;
        for (int i = 0; i < bakCnt; ++i) {
            pChar = pChar.getPrevChar();
        }
        HashSet<CharObj> waitRemoveSrcObj = new HashSet<CharObj>();
        for (CharObj charObj : srcIndexList) {
            charObj.setIndex(charObj.getIndex() - bakCnt);
            if (charObj.getIndex() >= 0) continue;
            waitRemoveSrcObj.add(charObj);
        }
        srcIndexList.removeAll(waitRemoveSrcObj);
        if (srcIndexList.size() == 0) {
            return;
        }
        HashSet intersectionSet = new HashSet(Sets.intersection(srcIndexList, pChar.getCharModel().getSrcCharObjSet()));
        srcIndexList.clear();
        srcIndexList.addAll(intersectionSet);
        this.intersectSrcArr(pChar, srcIndexList);
    }

    private int getMaxIndexCnt(Set<ComparePropValue> srcValList, Set<ComparePropValue> tarValList) {
        HashSet<Character> charSet = new HashSet<Character>();
        for (ComparePropValue propVal : srcValList) {
            String data = (String)propVal.getData();
            if (data == null) continue;
            for (char c : data.toCharArray()) {
                charSet.add(Character.valueOf(c));
            }
        }
        int maxCnt = charSet.size();
        int logVal = (int)(Math.log(1.0E7) / Math.log(maxCnt));
        int avaStrLen = tarValList.stream().map(ComparePropValue::getData).filter(Objects::nonNull).map(o -> ((String)o).length()).collect(Collectors.averagingInt(Integer::intValue)).intValue();
        return Math.min(avaStrLen - 1, logVal);
    }

    private Map<Character, Object> getLastIndexMap(Map<Character, Object> model, List<Character> charIndexList) {
        Map prevMap = model;
        for (int i = 0; i < charIndexList.size() - 1; ++i) {
            Character c = charIndexList.get(i);
            prevMap = (Map)prevMap.get(c);
        }
        return prevMap;
    }

    private static class CharObj {
        private Object id;
        private int index;
        private CharObjModel charModel;
        private CharObj prevChar;

        public CharObj() {
        }

        public CharObj(Object id, int index, CharObjModel charModel, CharObj prevChar) {
            this.id = id;
            this.index = index;
            this.charModel = charModel;
            this.prevChar = prevChar;
        }

        public Object getId() {
            return this.id;
        }

        public void setId(Object id) {
            this.id = id;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public CharObjModel getCharModel() {
            return this.charModel;
        }

        public void setCharModel(CharObjModel charModel) {
            this.charModel = charModel;
        }

        public CharObj getPrevChar() {
            return this.prevChar;
        }

        public void setPrevChar(CharObj prevChar) {
            this.prevChar = prevChar;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CharObj charObj = (CharObj)o;
            return this.index == charObj.index && Objects.equals(this.id, charObj.id);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.index);
        }
    }

    private static class CharObjModel {
        private Set<CharObj> srcCharObjSet = new HashSet<CharObj>();
        private Set<CharObj> tarCharObjSet = new HashSet<CharObj>();

        public Set<CharObj> getSrcCharObjSet() {
            return this.srcCharObjSet;
        }

        public void setSrcCharObjSet(Set<CharObj> srcCharObjSet) {
            this.srcCharObjSet = srcCharObjSet;
        }

        public Set<CharObj> getTarCharObjSet() {
            return this.tarCharObjSet;
        }

        public void setTarCharObjSet(Set<CharObj> tarCharObjSet) {
            this.tarCharObjSet = tarCharObjSet;
        }
    }
}

