/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.compare.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.compare.CompareException;

public class MultiThreadOperationExecutor<T, R> {
    private static final Log logger = LogFactory.getLog(MultiThreadOperationExecutor.class);

    public List<R> doBatchOperation(List<T> dataList, int threadCnt, MultiThreadOperation<T, R> operation) {
        ArrayList resultList = new ArrayList();
        int totalSize = dataList.size();
        threadCnt = totalSize < threadCnt ? totalSize : threadCnt;
        int perSize = totalSize / threadCnt;
        if (totalSize % threadCnt > 0) {
            ++perSize;
        }
        int startIndex = 0;
        ArrayList<Future> futureList = new ArrayList<Future>(threadCnt);
        for (int i = 0; i < threadCnt; ++i) {
            int endIndex = i == threadCnt - 1 ? totalSize : (startIndex + perSize > totalSize ? totalSize : startIndex + perSize);
            List currList = dataList.subList(startIndex, endIndex);
            RequestContext context = RequestContext.get();
            Future future = ThreadService.submit(() -> {
                RequestContext.copyAndSet((RequestContext)context);
                List result = operation.doOperation(currList);
                return result;
            }, (TaskType)TaskType.CAS_SPLIT_TASK);
            futureList.add(future);
            startIndex = endIndex;
        }
        try {
            for (Future future : futureList) {
                if (future == null) {
                    logger.info("==MultiThreadOperationExecutor==doBatchOperation==future is null");
                    continue;
                }
                List results = (List)future.get();
                if (results == null) continue;
                resultList.addAll(results);
            }
            return resultList;
        }
        catch (Exception e) {
            throw new CompareException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static interface MultiThreadOperation<T, R> {
        public List<R> doOperation(List<T> var1);
    }
}

