/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.compare.strategy;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.cas.compare.data.CompareData;
import kd.fi.cas.compare.data.ComparePropValue;
import kd.fi.cas.compare.data.CompareRule;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.compare.strategy.ICompareStrategy;
import kd.fi.cas.compare.strategy.StandardCompareStrategy;
import kd.fi.cas.util.StopWatchWithSummary;

public abstract class AbstractMultiRuleCompareStrategy
implements ICompareStrategy {
    private List<List<CompareRule>> ruleList;
    private StopWatchWithSummary watch = StopWatchWithSummary.createUnstarted();

    public AbstractMultiRuleCompareStrategy(List<List<CompareRule>> ruleList) {
        this.ruleList = ruleList;
    }

    @Override
    public List<CompareResult> compare(List<CompareData> srcDataList, List<CompareData> tarDataList) {
        this.watch.nextStep(ResManager.loadKDString((String)"\u62f7\u8d1d\u6570\u636e\u6e90", (String)"AbstractMultiRuleCompareStrategy_0", (String)"fi-cas-common", (Object[])new Object[0]));
        List<CompareData> srcDataListCopy = this.copyCompareData(srcDataList);
        List<CompareData> tarDataListCopy = this.copyCompareData(tarDataList);
        LinkedList<CompareResult> successList = new LinkedList<CompareResult>();
        for (List<CompareRule> compareRules : this.ruleList) {
            this.watch.nextStep(ResManager.loadKDString((String)"\u6267\u884c\u5339\u914d\u7b97\u6cd5", (String)"AbstractMultiRuleCompareStrategy_1", (String)"fi-cas-common", (Object[])new Object[0]));
            StandardCompareStrategy strategy = new StandardCompareStrategy(compareRules);
            List<CompareResult> resultList = strategy.compare(srcDataListCopy, tarDataListCopy);
            this.watch.nextStep(ResManager.loadKDString((String)"\u5904\u7406\u672c\u8f6e\u5339\u914d\u7ed3\u679c", (String)"AbstractMultiRuleCompareStrategy_2", (String)"fi-cas-common", (Object[])new Object[0]));
            this.handleResult(successList, resultList, srcDataListCopy, tarDataListCopy);
        }
        return successList;
    }

    protected void removeFromDataList(List<CompareData> dataList, Collection<Object> idList) {
        for (CompareData data : dataList) {
            HashSet<ComparePropValue> waitRemoveValList = new HashSet<ComparePropValue>(idList.size());
            for (Object id : idList) {
                ComparePropValue propValue = new ComparePropValue();
                propValue.setPropName(data.getPropName());
                propValue.setId(id);
                waitRemoveValList.add(propValue);
            }
            data.getPropValues().removeAll(waitRemoveValList);
        }
    }

    private List<CompareData> copyCompareData(List<CompareData> dataList) {
        LinkedList<CompareData> copyDataList = new LinkedList<CompareData>();
        for (CompareData compareData : dataList) {
            CompareData dataCopy = new CompareData(compareData.getPropName(), new HashSet<ComparePropValue>(compareData.getPropValues()));
            copyDataList.add(dataCopy);
        }
        return copyDataList;
    }

    protected abstract void handleResult(List<CompareResult> var1, List<CompareResult> var2, List<CompareData> var3, List<CompareData> var4);
}

