/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.compare.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.compare.CompareUnit;
import kd.fi.cas.compare.data.CompareData;
import kd.fi.cas.compare.data.ComparePropValue;
import kd.fi.cas.compare.data.CompareRule;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.compare.result.CompareUnitResult;
import kd.fi.cas.compare.result.CompareUnitResultCalcModel;
import kd.fi.cas.compare.strategy.ICompareStrategy;

public class StandardCompareStrategy
implements ICompareStrategy {
    private static final Log LOGGER = LogFactory.getLog(StandardCompareStrategy.class);
    private List<CompareRule> ruleList;

    public StandardCompareStrategy(List<CompareRule> ruleList) {
        this.ruleList = ruleList;
    }

    @Override
    public List<CompareResult> compare(List<CompareData> srcDataList, List<CompareData> tarDataList) {
        List<CompareUnit> compareUnitList = CompareUnit.fromPropValList(srcDataList, tarDataList, this.ruleList);
        CompareUnit prevUnit = null;
        for (int i = 0; i < compareUnitList.size(); ++i) {
            CompareUnit unit = compareUnitList.get(i);
            List<ComparePropValue> srcNullDataList = unit.getSrcValList().stream().filter(o -> o.getData() == null || o.getData() instanceof String && ((String)o.getData()).trim().length() == 0).collect(Collectors.toList());
            List<ComparePropValue> tarNullDataList = unit.getTarValList().stream().filter(o -> o.getData() == null || o.getData() instanceof String && ((String)o.getData()).trim().length() == 0).collect(Collectors.toList());
            ArrayList<CompareUnitResult> nullMatchResultList = new ArrayList<CompareUnitResult>();
            CompareRule rule = unit.getCompareRule();
            if (rule.isNullMatch()) {
                if (rule.isAllNullMatch()) {
                    this.addNullMatchData(unit.getSrcValList(), tarNullDataList, nullMatchResultList, srcNullDataList, unit.getTarValList());
                } else {
                    HashSet<ComparePropValue> srcValList = new HashSet<ComparePropValue>(unit.getSrcValList());
                    HashSet<ComparePropValue> tarValList = new HashSet<ComparePropValue>(unit.getTarValList());
                    srcNullDataList.forEach(srcValList::remove);
                    tarNullDataList.forEach(tarValList::remove);
                    this.addNullMatchData(srcValList, tarNullDataList, nullMatchResultList, srcNullDataList, tarValList);
                }
            } else if (rule.isAllNullMatch()) {
                CompareUnitResult nullMatchResult = new CompareUnitResult();
                nullMatchResult.setSrcIdSet(srcNullDataList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
                nullMatchResult.setTarIdSet(tarNullDataList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
                nullMatchResultList.add(nullMatchResult);
            }
            unit.getSrcValList().removeAll(srcNullDataList);
            unit.getTarValList().removeAll(tarNullDataList);
            if (prevUnit != null) {
                Set remainTarSet = prevUnit.getResult().stream().map(CompareUnitResult::getTarIdSet).flatMap(Collection::stream).collect(Collectors.toSet());
                Set<ComparePropValue> remainTarValList = unit.getTarValList();
                ArrayList<ComparePropValue> removeList = new ArrayList<ComparePropValue>();
                for (ComparePropValue tarVal : remainTarValList) {
                    if (remainTarSet.contains(tarVal.getId())) continue;
                    removeList.add(tarVal);
                }
                remainTarValList.removeAll(removeList);
            }
            if (unit.getTarValList().size() > 0 && unit.getSrcValList().size() > 0) {
                unit.compare();
            } else {
                unit.skip();
            }
            unit.getResult().addAll(nullMatchResultList);
            prevUnit = unit;
        }
        List<CompareResult> results = this.revertResult(compareUnitList);
        LOGGER.info("StandardCompareStrategy\t\tsize: " + String.format("%10d", results.stream().map(CompareResult::getSrcIdSet).count()));
        return results;
    }

    private void addNullMatchData(Set<ComparePropValue> srcValList, List<ComparePropValue> tarNullDataList, List<CompareUnitResult> nullMatchResultList, List<ComparePropValue> srcNullDataList, Set<ComparePropValue> tarValList) {
        CompareUnitResult nullMatchResult = new CompareUnitResult();
        nullMatchResult.setSrcIdSet(srcValList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
        nullMatchResult.setTarIdSet(tarNullDataList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
        nullMatchResultList.add(nullMatchResult);
        CompareUnitResult nullMatchResult2 = new CompareUnitResult();
        nullMatchResult2.setSrcIdSet(srcNullDataList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
        nullMatchResult2.setTarIdSet(tarValList.stream().map(ComparePropValue::getId).collect(Collectors.toSet()));
        nullMatchResultList.add(nullMatchResult2);
    }

    private List<CompareResult> revertResult(List<CompareUnit> compareUnitList) {
        CompareResult result;
        Map<Object, Object> remainResultMap;
        Set<CompareUnitResult> allMatchedResultList = null;
        if (compareUnitList.size() == 1) {
            remainResultMap = new HashMap();
            List<CompareUnitResult> unitResultList = compareUnitList.get(0).getResult();
            for (CompareUnitResult compareUnitResult : unitResultList) {
                for (Object tarId : compareUnitResult.getTarIdSet()) {
                    Set srcIdSet = remainResultMap.computeIfAbsent(tarId, t -> new HashSet());
                    srcIdSet.addAll(compareUnitResult.getSrcIdSet());
                }
            }
        } else if (compareUnitList.size() > 1) {
            List<CompareUnitResultCalcModel> calcModelList = CompareUnitResultCalcModel.fromUnitList(compareUnitList);
            remainResultMap = calcModelList.get(0).getResultMap();
            calcModelList.sort(Comparator.comparingInt(CompareUnitResultCalcModel::getWeight));
            for (int i = calcModelList.size() - 1; i >= 0; --i) {
                CompareUnitResultCalcModel compareUnitResultCalcModel = calcModelList.get(i);
                if (i == calcModelList.size() - 1) {
                    compareUnitResultCalcModel.initFirstModel();
                } else {
                    CompareUnitResultCalcModel prevModel = calcModelList.get(i + 1);
                    compareUnitResultCalcModel.intersection(prevModel);
                }
                if (i != 0) continue;
                allMatchedResultList = compareUnitResultCalcModel.getEntireMatchedList();
                remainResultMap.putAll(compareUnitResultCalcModel.getFinalResult());
            }
        } else {
            remainResultMap = new HashMap();
        }
        ArrayList<CompareResult> finalResult = new ArrayList<CompareResult>(remainResultMap.size());
        for (Map.Entry entry : remainResultMap.entrySet()) {
            if (((Set)entry.getValue()).size() == 0) continue;
            result = new CompareResult();
            HashSet<Object> tarIdSet = new HashSet<Object>();
            tarIdSet.add(entry.getKey());
            result.setTarIdSet(tarIdSet);
            result.setSrcIdSet((Set)entry.getValue());
            finalResult.add(result);
        }
        if (allMatchedResultList != null) {
            for (CompareUnitResult compareUnitResult : allMatchedResultList) {
                if (compareUnitResult.getSrcIdSet().size() == 0 || compareUnitResult.getTarIdSet().size() == 0) continue;
                result = new CompareResult();
                result.setTarIdSet(compareUnitResult.getTarIdSet());
                result.setSrcIdSet(compareUnitResult.getSrcIdSet());
                finalResult.add(result);
            }
        }
        return finalResult;
    }
}

