/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.compare.test.data;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.cas.compare.data.CompareRule;
import kd.fi.cas.compare.result.CompareResult;
import kd.fi.cas.compare.test.ITestDataProvider;
import kd.fi.cas.compare.test.TestUtil;

public abstract class EqualsCompareDataProvider
implements ITestDataProvider {
    private List<Map<String, Object>> srcList;
    private List<Map<String, Object>> tarList;

    @Override
    public List<Map<String, Object>> getSrcDataList() {
        this.srcList = this.getDataList(18, this.getSrcDataCnt());
        return this.srcList;
    }

    @Override
    public List<Map<String, Object>> getTarDataList() {
        this.tarList = this.getDataList(18, this.getTarDataCnt());
        return this.tarList;
    }

    private List<Map<String, Object>> getDataList(int idLen, int size) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(size);
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < size; ++i) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", TestUtil.getRandomId(random, idLen));
            data.put("str", this.getRandomData(random));
            dataList.add(data);
        }
        return dataList;
    }

    protected abstract Object getRandomData(SecureRandom var1);

    protected abstract int getSrcDataCnt();

    protected abstract int getTarDataCnt();

    @Override
    public List<List<CompareRule>> getRule() {
        return Collections.singletonList(Collections.singletonList(new CompareRule(CompareRule.Symbol.EQUALS, "str")));
    }

    @Override
    public List<CompareResult> runBruteForce() {
        ArrayList<CompareResult> resultList = new ArrayList<CompareResult>();
        for (Map<String, Object> tar : this.tarList) {
            CompareResult result = new CompareResult(Collections.singleton(tar.get("id")), new HashSet<Object>());
            Set<Object> srcResList = result.getSrcIdSet();
            for (Map<String, Object> src : this.srcList) {
                String tarStr;
                String srcStr = (String)src.get("str");
                if (!srcStr.equals(tarStr = (String)tar.get("str"))) continue;
                srcResList.add(src.get("id"));
            }
            if (srcResList.size() <= 0) continue;
            resultList.add(result);
        }
        return resultList;
    }
}

