/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.enums;

import java.util.Arrays;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.util.EmptyUtil;

public enum AsstActTypeAddressEnum {
    SUPPLIER(AsstActTypeEnum.SUPPLIER, bizId -> AsstActTypeAddressEnum.querySupOrCusAddress("supplierid", String.valueOf(bizId))),
    CUSTOMER(AsstActTypeEnum.CUSTOMER, bizId -> AsstActTypeAddressEnum.querySupOrCusAddress("customerid", String.valueOf(bizId))),
    EMPLOYEE(AsstActTypeEnum.EMPLOYEE, bizId -> AsstActTypeAddressEnum.queryUserAddress(bizId)),
    COMPANY(AsstActTypeEnum.COMPANY, bizId -> AsstActTypeAddressEnum.queryOrgAddress(bizId)),
    OTHERR(AsstActTypeEnum.OTHER, bizId -> ""),
    UNKNOWN(null, bizId -> "");

    private AsstActTypeEnum asstActTypeEnum;
    private Function<Long, String> addressFunction;

    private AsstActTypeAddressEnum(AsstActTypeEnum asstActTypeEnum, Function<Long, String> addressFunction) {
        this.asstActTypeEnum = asstActTypeEnum;
        this.addressFunction = addressFunction;
    }

    public AsstActTypeEnum getAsstActTypeEnum() {
        return this.asstActTypeEnum;
    }

    public Function<Long, String> getAddressFunction() {
        return this.addressFunction;
    }

    public static String getAddressByAsstActType(String asstActType, Long bizId) {
        return Arrays.stream(AsstActTypeAddressEnum.values()).filter(addressEnum -> addressEnum.asstActTypeEnum != null && addressEnum.asstActTypeEnum.getValue().equals(asstActType)).findFirst().orElse(UNKNOWN).getAddressFunction().apply(bizId);
    }

    private static String querySupOrCusAddress(String bizField, String bizId) {
        QFilter addressFilter = new QFilter("default", "=", (Object)"1").and("invalid", "=", (Object)"0").and(bizField, "=", (Object)bizId);
        DynamicObject address = QueryServiceHelper.queryOne((String)"bd_address", (String)"detailaddress", (QFilter[])addressFilter.toArray());
        if (EmptyUtil.isNoEmpty(address) && EmptyUtil.isNoEmpty(address.getString("detailaddress"))) {
            return address.getString("detailaddress");
        }
        return "";
    }

    private static String queryUserAddress(Long bizId) {
        QFilter addressFilter = new QFilter("id", "=", (Object)bizId).and("contactentity.contacttype.number", "=", (Object)"address").and("contactentity.isdefault", "=", (Object)"1");
        DynamicObject address = QueryServiceHelper.queryOne((String)"bos_user", (String)"contactentity.contact contact", (QFilter[])addressFilter.toArray());
        if (EmptyUtil.isNoEmpty(address) && EmptyUtil.isNoEmpty(address.getString("contact"))) {
            return address.getString("contact");
        }
        return "";
    }

    private static String queryOrgAddress(Long bizId) {
        QFilter addressFilter = new QFilter("id", "=", (Object)bizId);
        DynamicObject address = QueryServiceHelper.queryOne((String)"bos_org", (String)"contactaddress", (QFilter[])addressFilter.toArray());
        if (EmptyUtil.isNoEmpty(address) && EmptyUtil.isNoEmpty(address.getString("contactaddress"))) {
            return address.getString("contactaddress");
        }
        return "";
    }
}

