/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class AccSysHelper {
    private static Log logger = LogFactory.getLog(AccSysHelper.class);

    public static Map<String, Long> getBaseAccountingInfo(Long orgId) {
        Map<String, Object> companyByOrg = AccSysHelper.getCompanyByOrg(orgId);
        if (null == companyByOrg || companyByOrg.size() == 0) {
            return null;
        }
        Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)companyByOrg.get("id")));
        if (null == baseAccountingInfo || baseAccountingInfo.size() == 0) {
            return null;
        }
        return baseAccountingInfo;
    }

    private static Map<String, Object> getCompanyByOrg(Long orgId) {
        return AccSysHelper.getCompanyByOrg(orgId, Boolean.TRUE, Boolean.TRUE);
    }

    private static Map<String, Object> getCompanyByOrg(Long orgId, Boolean isBizUnit, Boolean isSerrchUpward) {
        logger.info(String.format("\u83b7\u53d6\u6240\u5c5e\u516c\u53f8\u53c2\u6570\u4e3a\uff1a[\u7ec4\u7ec7ID-orgId]%s[\u662f\u5426\u53ea\u67e5\u8be2\u4e1a\u52a1\u5b9e\u4f53-isBizUnit]%s[\u662f\u5426\u627e\u4e0a\u7ea7-isSerrchUpward]%s", orgId, isBizUnit, isSerrchUpward));
        HashMap<String, Object> mpCompany = new HashMap<String, Object>(3);
        if (orgId != null && orgId != 0L) {
            String selectFields = "org,org.number,org.name,org.orgpattern.patterntype,longnumber,isbizunit";
            QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"10");
            QFilter isDefaultViewFilter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
            QFilter isbizunitFilter = null;
            if (isBizUnit.booleanValue()) {
                isbizunitFilter = new QFilter("isbizunit", "=", (Object)Boolean.TRUE);
            }
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            QFilter[] filters = null;
            filters = isBizUnit != false ? new QFilter[]{treeTypeFilter, isDefaultViewFilter, orgFilter, isbizunitFilter} : new QFilter[]{treeTypeFilter, isDefaultViewFilter, orgFilter};
            DynamicObject orgInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
            if (orgInfo != null) {
                DynamicObject parentOrg = orgInfo.getDynamicObject("org");
                if (parentOrg != null) {
                    mpCompany.put("id", parentOrg.getPkValue());
                    mpCompany.put("number", parentOrg.get("number"));
                    mpCompany.put("name", parentOrg.getString("name"));
                }
                logger.info("\u5f53\u524d\u4e1a\u52a1\u5355\u5143\u662f\u4e1a\u52a1\u5b9e\u4f53\u6838\u7b97\u4e3b\u4f53\uff1a" + mpCompany);
                return mpCompany;
            }
            if (!isSerrchUpward.booleanValue()) {
                return mpCompany;
            }
            selectFields = "org,org.number,org.name,org.orgpattern.patterntype,longnumber,parent";
            treeTypeFilter = new QFilter("view.treetype", "=", (Object)"15");
            isDefaultViewFilter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
            orgFilter = new QFilter("org", "=", (Object)orgId);
            filters = new QFilter[]{treeTypeFilter, isDefaultViewFilter, orgFilter};
            orgInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
            if (orgInfo != null) {
                DynamicObject parentOrg = orgInfo.getDynamicObject("parent");
                if (parentOrg == null) {
                    parentOrg = orgInfo.getDynamicObject("org");
                    if (parentOrg != null) {
                        mpCompany.put("id", parentOrg.getPkValue());
                        mpCompany.put("number", parentOrg.get("number"));
                        mpCompany.put("name", parentOrg.getString("name"));
                    }
                    return mpCompany;
                }
                return AccSysHelper.getCompanyByOrg(parentOrg.getLong("id"), isBizUnit, isSerrchUpward);
            }
            return mpCompany;
        }
        return mpCompany;
    }

    public static List<Long> getAllAcctGroupSonAcctIds() {
        HashSet set = new HashSet(8);
        Object[] acctGroups = BusinessDataServiceHelper.load((String)"fca_acctgroup", (String)"entrys.bankacct", (QFilter[])new QFilter[0]);
        if (EmptyUtil.isEmpty(acctGroups)) {
            return Collections.EMPTY_LIST;
        }
        for (Object o : acctGroups) {
            DynamicObjectCollection collection = o.getDynamicObjectCollection("entrys");
            collection.forEach(object -> {
                DynamicObject acct = object.getDynamicObject("bankacct");
                if (acct != null && !set.contains(acct.getLong("id"))) {
                    set.add(acct.getLong("id"));
                }
            });
        }
        if (set.size() == 0) {
            return new ArrayList<Long>(8);
        }
        return set.stream().collect(Collectors.toList());
    }
}

