/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.CheckResultEnum;
import kd.fi.cas.model.BankStatementDetail;
import kd.fi.cas.model.BankStatementSet;

public class BankStatementImportCheckHelper {
    private static Log log = LogFactory.getLog(BankStatementImportCheckHelper.class);
    private static final String SYSTEM_ID = "fi-cas-common";
    private static final String PAGE_CAS_BANKSTATEMENT = "cas_bankstatement";

    private BankStatementImportCheckHelper() {
    }

    public static BankStatementImportCheckHelper newInstance() {
        return new BankStatementImportCheckHelper();
    }

    public String calcSystemBalance(BankStatementSet bankStatementSets, BigDecimal sysFristValue) {
        String result = null;
        BankStatementDetail bankStatement = bankStatementSets.getStatistics();
        BigDecimal sysFristAmount = Optional.ofNullable(sysFristValue).map(o -> {
            bankStatement.setSysFristBalance((BigDecimal)o);
            return o;
        }).orElseGet(() -> {
            DynamicObject sysBankStatement = this.getLastBankStatementData(bankStatement.getBankAccountNumber(), bankStatement.getBeginDate(), bankStatement.getCurrencyNumber());
            return Optional.ofNullable(sysBankStatement).map(o -> {
                BigDecimal num = o.getBigDecimal("balanceamt");
                BigDecimal sysFristBalance = this.clacBanlanceByDC(num, bankStatementSets.getDetails().get(0));
                bankStatement.setSysFristBalance(sysFristBalance);
                return sysFristBalance;
            }).orElseGet(() -> null);
        });
        if (sysFristAmount != null) {
            bankStatement.setCalcLastBalance(this.calcLastBalance(bankStatementSets, sysFristAmount));
            if (bankStatement.getFileFristBalance() != null && bankStatement.getFileLastBalance() != null) {
                if (0 == bankStatement.getFileFristBalance().compareTo(sysFristAmount) && 0 != bankStatement.getFileLastBalance().compareTo(bankStatement.getCalcLastBalance())) {
                    result = CheckResultEnum.RESULT_A.getResult();
                } else if (0 == bankStatement.getFileFristBalance().compareTo(sysFristAmount) && 0 == bankStatement.getFileLastBalance().compareTo(bankStatement.getCalcLastBalance())) {
                    result = CheckResultEnum.RESULT_C.getResult();
                } else if (0 != bankStatement.getFileFristBalance().compareTo(sysFristAmount)) {
                    result = CheckResultEnum.RESULT_B.getResult();
                }
            } else if (bankStatement.getFileFristBalance() == null && bankStatement.getFileLastBalance() == null) {
                result = CheckResultEnum.RESULT_D.getResult();
            } else if (bankStatement.getFileFristBalance() == null || bankStatement.getFileLastBalance() == null) {
                result = CheckResultEnum.RESULT_A.getResult();
            }
        } else {
            bankStatement.setSysFristBalance(null);
            bankStatement.setCalcLastBalance(null);
            result = CheckResultEnum.RESULT_E.getResult();
        }
        bankStatement.setResult(result);
        bankStatementSets.setStatistics(bankStatement);
        bankStatementSets.setResult(result);
        return result;
    }

    private BigDecimal clacBanlanceByDC(BigDecimal banlance, BankStatementDetail detail) {
        if (null == detail || null == banlance) {
            return banlance;
        }
        banlance = banlance.add(Optional.ofNullable(detail.getCreditamount()).map(num -> num).orElseGet(() -> BigDecimal.ZERO)).subtract(Optional.ofNullable(detail.getDebitamount()).map(num -> num).orElseGet(() -> BigDecimal.ZERO));
        return banlance;
    }

    private DynamicObject getLastBankStatementData(String bankAccountNumber, Date queryDate, String currency) {
        QFilter accountBankFilter = new QFilter("accountbank.bankaccountnumber", "=", (Object)bankAccountNumber);
        QFilter currencyFilter = new QFilter("currency.number", "=", (Object)currency);
        QFilter bizDateFilter = new QFilter("bizdate", "<", (Object)queryDate);
        QFilter[] qFilters = new QFilter[]{accountBankFilter, currencyFilter, bizDateFilter};
        DynamicObjectCollection bankStatement = QueryServiceHelper.query((String)PAGE_CAS_BANKSTATEMENT, (String)"id,currency,balanceamt,debitamount,creditamount,transtime,createtime,sequencenumber", (QFilter[])qFilters, (String)"bizdate desc, sequencenumber desc", (int)1);
        return Optional.of(bankStatement).map(o -> o.isEmpty() ? null : (DynamicObject)o.get(0)).orElseGet(() -> null);
    }

    private BigDecimal calcLastBalance(BankStatementSet bankStatementSets, BigDecimal sysFirstAmount) {
        List<BankStatementDetail> bankStatementDetails = bankStatementSets.getDetails();
        BigDecimal totalCreditAmount = new BigDecimal(0);
        BigDecimal totalDebitAmount = new BigDecimal(0);
        for (int index = 1; index < bankStatementDetails.size(); ++index) {
            BankStatementDetail bankStatementDetail = bankStatementDetails.get(index);
            BigDecimal debitamount = bankStatementDetail.getDebitamount();
            BigDecimal creditamount = bankStatementDetail.getCreditamount();
            totalCreditAmount = totalCreditAmount.add(creditamount == null ? BigDecimal.ZERO : creditamount);
            totalDebitAmount = totalDebitAmount.add(debitamount == null ? BigDecimal.ZERO : debitamount);
        }
        sysFirstAmount = sysFirstAmount == null ? BigDecimal.ZERO : sysFirstAmount;
        return sysFirstAmount.add(totalCreditAmount).subtract(totalDebitAmount);
    }

    public static Date getPreviousOfDay(Date date) {
        Date today = date;
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        c.add(5, -1);
        return c.getTime();
    }

    public static String moneyDeal(BigDecimal amount, DynamicObject currency) {
        return amount == null ? "" : String.format("%s%s", currency.getString("sign"), amount.setScale(currency.getInt("amtprecision")));
    }

    public static void enableImportBtn(Map<String, String> results, IFormView view, String btnSign) {
        if (!(results.containsValue(CheckResultEnum.RESULT_A.getResult()) || results.containsValue(CheckResultEnum.RESULT_B.getResult()) || results.containsValue(CheckResultEnum.RESULT_E.getResult()))) {
            view.setEnable(Boolean.valueOf(true), new String[]{btnSign});
        } else {
            view.setEnable(Boolean.valueOf(false), new String[]{btnSign});
        }
    }
}

