/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.builder.FormulaGetHandle;
import kd.fi.cas.builder.SingleTaskContext;
import kd.fi.cas.errorcode.KDBatchDealDBException;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class CasBankJournalHelper {
    private static Log logger = LogFactory.getLog(CasBankJournalHelper.class);

    public static void addBalanceTask(DynamicObject[] journals, String businesstype) {
        if (EmptyUtil.isEmpty(journals)) {
            return;
        }
        ArrayList<DynamicObject> saveBalanceList = new ArrayList<DynamicObject>(journals.length);
        for (DynamicObject journal : journals) {
            if (!StringUtils.equals((CharSequence)"cas_bankjournal", (CharSequence)journal.getDynamicObjectType().getName())) continue;
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cas_balancetask");
            newDynamicObject.set("org", journal.get("org"));
            newDynamicObject.set("bankaccount", journal.get("accountbank"));
            newDynamicObject.set("currency", journal.get("currency"));
            newDynamicObject.set("bookdate", (Object)DateUtils.truncateDate(journal.getDate("bookdate")));
            newDynamicObject.set("creditamount", (Object)journal.getBigDecimal("creditamount"));
            newDynamicObject.set("debitamount", (Object)journal.getBigDecimal("debitamount"));
            newDynamicObject.set("businesstype", (Object)businesstype);
            newDynamicObject.set("journaltype", (Object)"bank");
            newDynamicObject.set("createdate", (Object)new Date());
            newDynamicObject.set("modifydate", (Object)new Date());
            newDynamicObject.set("taskstatus", (Object)"0");
            newDynamicObject.set("sourceid", journal.getPkValue());
            saveBalanceList.add(newDynamicObject);
        }
        if (EmptyUtil.isNoEmpty(saveBalanceList)) {
            SaveServiceHelper.save((DynamicObject[])saveBalanceList.toArray(new DynamicObject[0]));
        }
    }

    public static void updateBillValue(DynamicObject[] journals) {
        if (EmptyUtil.isEmpty(journals)) {
            return;
        }
        DynamicObject bill = null;
        for (int i = 0; i < journals.length; ++i) {
            bill = journals[i];
            if (!StringUtils.equals((CharSequence)"cas_bankjournal", (CharSequence)bill.getDynamicObjectType().getName())) continue;
            CasBankJournalHelper.updateRecPayInfo(bill);
            bill.set("isinternal", (Object)CasBankJournalHelper.isInternal(bill));
            CasBankJournalHelper.getAddMetchResult(i, journals);
        }
    }

    public static void updateBalanceTask(DynamicObject[] journals) {
        if (EmptyUtil.isEmpty(journals)) {
            return;
        }
        String key = "";
        HashMap<String, Date> minDateMap = new HashMap<String, Date>();
        Date minDate = null;
        for (DynamicObject journal : journals) {
            key = String.format("%s_%s_%s", DynamicObjectHelper.getPk(journal, "org"), DynamicObjectHelper.getPk(journal, "bankaccount"), DynamicObjectHelper.getPk(journal, "currency"));
            minDate = (Date)minDateMap.get(key);
            if (!EmptyUtil.isEmpty(minDate) && !minDate.after(DateUtils.truncateDate(journal.getDate("bookdate")))) continue;
            minDateMap.put(key, DateUtils.truncateDate(journal.getDate("bookdate")));
        }
        HashMap updateBalanceMap = new HashMap(minDateMap.size());
        ArrayList<Object> updateBalance = null;
        String[] keyArr = null;
        for (Map.Entry entry : minDateMap.entrySet()) {
            keyArr = ((String)entry.getKey()).split("_");
            QFilter orgQFilter = new QFilter("org", "=", (Object)Long.valueOf(keyArr[0]));
            QFilter accQFilter = new QFilter("bankaccount", "=", (Object)Long.valueOf(keyArr[1]));
            QFilter curQFilter = new QFilter("currency", "=", (Object)Long.valueOf(keyArr[2]));
            QFilter bookQFilter = new QFilter("bookdate", ">=", entry.getValue());
            updateBalance = new ArrayList<DynamicObject>(Arrays.asList(BusinessDataServiceHelper.load((String)"cas_accountbalance", (String)String.join((CharSequence)",", EntityPropertyHelper.getPropertys("cas_accountbalance")), (QFilter[])new QFilter[]{orgQFilter, accQFilter, curQFilter, bookQFilter}, (String)"bookdate desc")));
            updateBalanceMap.put(entry.getKey(), updateBalance);
        }
        List<DynamicObject> listjournalTemp = Arrays.asList(journals);
        listjournalTemp.sort((dy1, dy2) -> dy2.getDate("bookdate").compareTo(dy1.getDate("bookdate")));
        for (DynamicObject journal : listjournalTemp) {
            QFilter initQFilter = new QFilter("org", "=", (Object)DynamicObjectHelper.getPk(journal, "org"));
            initQFilter.and(new QFilter("startperiod.begindate", ">", (Object)journal.getDate("bookdate")));
            if (QueryServiceHelper.exists((String)"cas_cashmgtinit", (QFilter[])new QFilter[]{initQFilter})) continue;
            key = String.format("%s_%s_%s", DynamicObjectHelper.getPk(journal, "org"), DynamicObjectHelper.getPk(journal, "bankaccount"), DynamicObjectHelper.getPk(journal, "currency"));
            updateBalance = (ArrayList<DynamicObject>)updateBalanceMap.get(key);
            boolean notHaveData = true;
            if (EmptyUtil.isNoEmpty(updateBalance)) {
                for (DynamicObject dynamicObject : updateBalance) {
                    if (dynamicObject.getDate("bookdate").compareTo(DateUtils.truncateDate(journal.getDate("bookdate"))) == 0) {
                        notHaveData = false;
                        dynamicObject.set("daytradenum", (Object)(dynamicObject.getLong("daytradenum") + 1L));
                        dynamicObject.set("daytradeamount", (Object)dynamicObject.getBigDecimal("daytradeamount").add(journal.getBigDecimal("debitamount")).add(journal.getBigDecimal("creditamount")));
                        dynamicObject.set("creditamount", (Object)dynamicObject.getBigDecimal("creditamount").add(journal.getBigDecimal("creditamount")));
                        dynamicObject.set("debitamount", (Object)dynamicObject.getBigDecimal("debitamount").add(journal.getBigDecimal("debitamount")));
                        dynamicObject.set("amount", (Object)dynamicObject.getBigDecimal("amount").add(journal.getBigDecimal("debitamount")).subtract(journal.getBigDecimal("creditamount")));
                        continue;
                    }
                    if (dynamicObject.getDate("bookdate").compareTo(DateUtils.truncateDate(journal.getDate("bookdate"))) <= 0) continue;
                    dynamicObject.set("daybalance", (Object)dynamicObject.getBigDecimal("daybalance").add(journal.getBigDecimal("debitamount")).subtract(journal.getBigDecimal("creditamount")));
                    dynamicObject.set("amount", (Object)dynamicObject.getBigDecimal("amount").add(journal.getBigDecimal("debitamount")).subtract(journal.getBigDecimal("creditamount")));
                }
            } else {
                updateBalance = new ArrayList(10);
                updateBalanceMap.put(key, updateBalance);
            }
            if (!notHaveData) continue;
            QFilter orgQFilter = new QFilter("org", "=", (Object)DynamicObjectHelper.getPk(journal, "org"));
            QFilter qFilter = new QFilter("bankaccount", "=", (Object)DynamicObjectHelper.getPk(journal, "bankaccount"));
            QFilter curQFilter = new QFilter("currency", "=", (Object)DynamicObjectHelper.getPk(journal, "currency"));
            QFilter bookQFilter = new QFilter("bookdate", "<=", (Object)DateUtils.truncateDate(journal.getDate("bookdate")));
            DynamicObjectCollection queryColl = QueryServiceHelper.query((String)"cas_accountbalance", (String)"id,amount", (QFilter[])new QFilter[]{orgQFilter, qFilter, curQFilter, bookQFilter}, (String)"bookdate desc", (int)1);
            BigDecimal lastBalance = BigDecimal.ZERO;
            if (EmptyUtil.isNoEmpty(queryColl)) {
                lastBalance = ((DynamicObject)queryColl.get(0)).getBigDecimal("amount");
            }
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cas_accountbalance");
            newDynamicObject.set("org", journal.get("org"));
            newDynamicObject.set("bankaccount", journal.get("bankaccount"));
            newDynamicObject.set("currency", journal.get("currency"));
            newDynamicObject.set("daytradenum", (Object)1L);
            newDynamicObject.set("debitamount", (Object)journal.getBigDecimal("debitamount"));
            newDynamicObject.set("creditamount", (Object)journal.getBigDecimal("creditamount"));
            newDynamicObject.set("daytradeamount", (Object)journal.getBigDecimal("debitamount").add(journal.getBigDecimal("creditamount")));
            newDynamicObject.set("daybalance", (Object)lastBalance);
            newDynamicObject.set("amount", (Object)lastBalance.add(journal.getBigDecimal("debitamount")).subtract(journal.getBigDecimal("creditamount")));
            newDynamicObject.set("bookdate", (Object)DateUtils.truncateDate(journal.getDate("bookdate")));
            updateBalance.add(newDynamicObject);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<DynamicObject> saveBalanceList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> dbBalanceList = new ArrayList<DynamicObject>();
        for (Map.Entry updateList : updateBalanceMap.entrySet()) {
            List list = (List)updateList.getValue();
            if (!EmptyUtil.isNoEmpty(list)) continue;
            for (DynamicObject dy : list) {
                if (EmptyUtil.isNoEmpty(dy.getLong("id"))) {
                    dbBalanceList.add(dy);
                    continue;
                }
                saveBalanceList.add(dy);
            }
        }
        if (EmptyUtil.isNoEmpty(saveBalanceList)) {
            SaveServiceHelper.save((DynamicObject[])saveBalanceList.toArray(new DynamicObject[0]));
        }
        if (EmptyUtil.isNoEmpty(dbBalanceList)) {
            SaveServiceHelper.save((DynamicObject[])dbBalanceList.toArray(new DynamicObject[0]));
        }
    }

    public static void updateBalance(DynamicObject[] journals) {
        CasBankJournalHelper.addBalanceTask(journals, "add");
    }

    public static void deleteBalanceTask(DynamicObject[] journals) {
        if (EmptyUtil.isEmpty(journals)) {
            return;
        }
        String key = "";
        HashMap<String, Date> minDateMap = new HashMap<String, Date>();
        Date minDate = null;
        for (DynamicObject journal : journals) {
            QFilter existsBook;
            QFilter existsCurr;
            QFilter existsAcc;
            QFilter qFilter;
            key = String.format("%s_%s_%s", DynamicObjectHelper.getPk(journal, "org"), DynamicObjectHelper.getPk(journal, "bankaccount"), DynamicObjectHelper.getPk(journal, "currency"));
            minDate = (Date)minDateMap.get(key);
            if (EmptyUtil.isEmpty(minDate) || minDate.after(DateUtils.truncateDate(journal.getDate("bookdate")))) {
                minDateMap.put(key, DateUtils.truncateDate(journal.getDate("bookdate")));
            }
            if (QueryServiceHelper.exists((String)"cas_accountbalance", (QFilter[])new QFilter[]{qFilter = new QFilter("org", "=", (Object)DynamicObjectHelper.getPk(journal, "org")), existsAcc = new QFilter("bankaccount", "=", (Object)DynamicObjectHelper.getPk(journal, "bankaccount")), existsCurr = new QFilter("currency", "=", (Object)DynamicObjectHelper.getPk(journal, "currency")), existsBook = new QFilter("bookdate", "=", (Object)DateUtils.truncateDate(journal.getDate("bookdate")))})) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u65e5\u672a\u751f\u6210\u4f59\u989d\u6570\u636e\uff0c\u751f\u6210\u4f59\u989d\u540e\u5904\u7406%s", (String)"CasBankJournalHelper_2", (String)"fi-cas-common", (Object[])new Object[0]), key) + DateUtils.truncateDate(journal.getDate("bookdate")));
        }
        HashMap updateBalanceMap = new HashMap(minDateMap.size());
        ArrayList<DynamicObject> updateBalance = null;
        String[] keyArr = null;
        for (Map.Entry entry : minDateMap.entrySet()) {
            keyArr = ((String)entry.getKey()).split("_");
            QFilter orgQFilter = new QFilter("org", "=", (Object)Long.valueOf(keyArr[0]));
            QFilter accQFilter = new QFilter("bankaccount", "=", (Object)Long.valueOf(keyArr[1]));
            QFilter curQFilter = new QFilter("currency", "=", (Object)Long.valueOf(keyArr[2]));
            QFilter bookQFilter = new QFilter("bookdate", ">=", entry.getValue());
            updateBalance = new ArrayList<DynamicObject>(Arrays.asList(BusinessDataServiceHelper.load((String)"cas_accountbalance", (String)String.join((CharSequence)",", EntityPropertyHelper.getPropertys("cas_accountbalance")), (QFilter[])new QFilter[]{orgQFilter, accQFilter, curQFilter, bookQFilter}, (String)"bookdate desc")));
            updateBalanceMap.put(entry.getKey(), updateBalance);
        }
        List<DynamicObject> listJournals = Arrays.asList(journals);
        listJournals.sort((dy1, dy2) -> dy2.getDate("bookdate").compareTo(dy1.getDate("bookdate")));
        for (DynamicObject journal : listJournals) {
            key = String.format("%s_%s_%s", DynamicObjectHelper.getPk(journal, "org"), DynamicObjectHelper.getPk(journal, "bankaccount"), DynamicObjectHelper.getPk(journal, "currency"));
            updateBalance = (ArrayList<DynamicObject>)updateBalanceMap.get(key);
            if (!EmptyUtil.isNoEmpty(updateBalance)) continue;
            for (DynamicObject updateDy : updateBalance) {
                if (updateDy.getDate("bookdate").compareTo(DateUtils.truncateDate(journal.getDate("bookdate"))) == 0) {
                    updateDy.set("daytradenum", (Object)(updateDy.getLong("daytradenum") - 1L));
                    updateDy.set("daytradeamount", (Object)updateDy.getBigDecimal("daytradeamount").subtract(journal.getBigDecimal("debitamount")).subtract(journal.getBigDecimal("creditamount")));
                    updateDy.set("creditamount", (Object)updateDy.getBigDecimal("creditamount").subtract(journal.getBigDecimal("creditamount")));
                    updateDy.set("debitamount", (Object)updateDy.getBigDecimal("debitamount").subtract(journal.getBigDecimal("debitamount")));
                    updateDy.set("amount", (Object)updateDy.getBigDecimal("amount").subtract(journal.getBigDecimal("debitamount")).add(journal.getBigDecimal("creditamount")));
                    continue;
                }
                if (updateDy.getDate("bookdate").compareTo(DateUtils.truncateDate(journal.getDate("bookdate"))) <= 0) continue;
                updateDy.set("daybalance", (Object)updateDy.getBigDecimal("daybalance").subtract(journal.getBigDecimal("debitamount")).add(journal.getBigDecimal("creditamount")));
                updateDy.set("amount", (Object)updateDy.getBigDecimal("amount").subtract(journal.getBigDecimal("debitamount")).add(journal.getBigDecimal("creditamount")));
            }
        }
        ArrayList arrayList = new ArrayList();
        List tempBalanceList = null;
        for (Map.Entry updateList : updateBalanceMap.entrySet()) {
            tempBalanceList = (List)updateList.getValue();
            if (!EmptyUtil.isNoEmpty(tempBalanceList)) continue;
            arrayList.addAll(tempBalanceList);
        }
        if (EmptyUtil.isNoEmpty(arrayList)) {
            SaveServiceHelper.save((DynamicObject[])arrayList.toArray(new DynamicObject[0]));
        }
    }

    public static void deleteBalance(DynamicObject[] journals) {
        CasBankJournalHelper.addBalanceTask(journals, "delete");
    }

    private static void updateRecPayInfo(DynamicObject bill) {
        if (EmptyUtil.isNoEmpty(bill.getString("sourcebilltype")) && EmptyUtil.isNoEmpty(bill.getLong("sourcebillid"))) {
            DynamicObject billInfo = null;
            String billType = bill.getString("sourcebilltype");
            Object billId = bill.get("sourcebillid");
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", billId)};
            switch (billType) {
                case "cas_paybill": {
                    billInfo = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"id,paymenttype,payeetype,payee", (QFilter[])qFilters);
                    if (!EmptyUtil.isNoEmpty(billInfo)) break;
                    bill.set("recpaytype", (Object)"cas_paymentbilltype");
                    bill.set("recpaytypeid_id", (Object)billInfo.getLong("paymenttype"));
                    bill.set("recpayertype", (Object)billInfo.getString("payeetype"));
                    bill.set("recpayer_id", (Object)billInfo.getLong("payee"));
                    break;
                }
                case "cas_recbill": {
                    billInfo = QueryServiceHelper.queryOne((String)"cas_recbill", (String)"id,receivingtype,payertype,payer", (QFilter[])qFilters);
                    if (!EmptyUtil.isNoEmpty(billInfo)) break;
                    bill.set("recpaytype", (Object)"cas_receivingbilltype");
                    bill.set("recpaytypeid_id", (Object)billInfo.getLong("receivingtype"));
                    bill.set("recpayertype", (Object)billInfo.getString("payertype"));
                    bill.set("recpayer_id", (Object)billInfo.getLong("payer"));
                    break;
                }
                case "cas_agentpaybill": {
                    billInfo = QueryServiceHelper.queryOne((String)"cas_agentpaybill", (String)"id,paymenttype,payeetype,entry.payee", (QFilter[])qFilters);
                    if (!EmptyUtil.isNoEmpty(billInfo)) break;
                    bill.set("recpaytype", (Object)"cas_paymentbilltype");
                    bill.set("recpaytypeid_id", (Object)billInfo.getLong("paymenttype"));
                    bill.set("recpayertype", (Object)billInfo.getString("payeetype"));
                    bill.set("recpayer_id", (Object)billInfo.getLong("entry.payee"));
                    break;
                }
            }
        }
    }

    private static boolean isInternal(DynamicObject bill) {
        String recpayertype = bill.getString("recpayertype");
        Long recpayer = bill.getLong("recpayer_id");
        if (recpayer == 0L || EmptyUtil.isEmpty(recpayertype)) {
            return false;
        }
        if (!recpayertype.equals("bd_supplier") && !recpayertype.equals("bd_customer")) {
            return false;
        }
        try {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)recpayer, (String)recpayertype);
            if (EmptyUtil.isNoEmpty(object)) {
                return object.getLong("internal_company_id") > 0L;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static void getAddMetchResult(int index, DynamicObject[] journals) {
        DynamicObject info = journals[index];
        long orgId = DynamicObjectHelper.getPk(info, "org");
        QFilter qFilter = new QFilter("entryentity.e_org", "=", (Object)orgId).and("datasource", "=", (Object)"bankjournal").and("enable", "=", (Object)"1");
        List<String> lstFiled = Arrays.asList("id", "amountconditon_real_Tag", "sensitivecondition_real_Tag", "focusconditon_real_Tag", "questionconditon");
        DynamicObject tradeObject = QueryServiceHelper.queryOne((String)"mon_transactionplan", (String)String.join((CharSequence)",", lstFiled), (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty(tradeObject)) {
            QFilter debQFilter;
            QFilter creQFilter;
            QFilter dirQFilter;
            QFilter oppQFilter;
            QFilter accQFilter;
            Map<String, DynamicProperty> fldProperties = CasBankJournalHelper.getFilterProperties(info);
            boolean isMatch = CasBankJournalHelper.isMatch(info, tradeObject.getString("amountconditon_real_Tag"), fldProperties);
            info.set("islargeamount", (Object)isMatch);
            isMatch = CasBankJournalHelper.isMatch(info, tradeObject.getString("sensitivecondition_real_Tag"), fldProperties);
            info.set("issensitive", (Object)isMatch);
            isMatch = CasBankJournalHelper.isMatch(info, tradeObject.getString("focusconditon_real_Tag"), fldProperties);
            info.set("isattention", (Object)isMatch);
            int days = tradeObject.getInt("questionconditon");
            Date bookdate = info.getDate("bookdate");
            Long accountbank = DynamicObjectHelper.getPk(info, "accountbank");
            String oppacctnumber = info.getString("oppacctnumber");
            String direction = (String)info.get("direction");
            BigDecimal creditamount = info.getBigDecimal("creditamount");
            BigDecimal debitamount = info.getBigDecimal("debitamount");
            if (EmptyUtil.isEmpty(bookdate) || oppacctnumber == null || EmptyUtil.isEmpty(direction) || EmptyUtil.isEmpty(creditamount) || EmptyUtil.isEmpty(debitamount)) {
                return;
            }
            for (int i = index + 1; i < journals.length; ++i) {
                if (!StringUtils.equals((CharSequence)"cas_bankjournal", (CharSequence)journals[i].getDynamicObjectType().getName()) || accountbank.compareTo(DynamicObjectHelper.getPk(journals[i], "accountbank")) != 0 || !oppacctnumber.equals(journals[i].getString("oppacctnumber")) || direction != journals[i].get("direction") || creditamount.compareTo(journals[i].getBigDecimal("creditamount")) != 0 || debitamount.compareTo(journals[i].getBigDecimal("debitamount")) != 0) continue;
                info.set("isdoubt", (Object)true);
                journals[i].set("isdoubt", (Object)true);
            }
            QFilter bookQFilter = new QFilter("bookdate", ">=", (Object)DateUtils.getLastDay(bookdate, days)).and(new QFilter("bookdate", "<=", (Object)DateUtils.getNextDay(bookdate, days)));
            Object[] dbbills = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,isdoubt", (QFilter[])new QFilter[]{bookQFilter, accQFilter = new QFilter("accountbank.id", "=", (Object)accountbank), oppQFilter = new QFilter("oppacctnumber", "=", (Object)oppacctnumber), dirQFilter = new QFilter("direction", "=", (Object)direction), creQFilter = new QFilter("creditamount", "=", (Object)creditamount), debQFilter = new QFilter("debitamount", "=", (Object)debitamount)});
            if (EmptyUtil.isNoEmpty(dbbills)) {
                info.set("isdoubt", (Object)true);
                for (Object dynamicObject : dbbills) {
                    dynamicObject.set("isdoubt", (Object)true);
                }
                SaveServiceHelper.save((DynamicObject[])dbbills);
            }
        }
    }

    public static void getAllMetchResult(int index, DynamicObject[] journals, DynamicObject tradeObject) {
        DynamicObject info = journals[index];
        if (EmptyUtil.isNoEmpty(tradeObject)) {
            Date bookdate = info.getDate("bookdate");
            if (EmptyUtil.isEmpty(bookdate) || bookdate.before(tradeObject.getDate("validdate"))) {
                return;
            }
            Map<String, DynamicProperty> fldProperties = CasBankJournalHelper.getFilterProperties(info);
            boolean isMatch = CasBankJournalHelper.isMatch(info, tradeObject.getString("amountconditon_real_Tag"), fldProperties);
            info.set("islargeamount", (Object)isMatch);
            isMatch = CasBankJournalHelper.isMatch(info, tradeObject.getString("sensitivecondition_real_Tag"), fldProperties);
            info.set("issensitive", (Object)isMatch);
            isMatch = CasBankJournalHelper.isMatch(info, tradeObject.getString("focusconditon_real_Tag"), fldProperties);
            info.set("isattention", (Object)isMatch);
            int days = tradeObject.getInt("questionconditon");
            Long accountbank = info.getLong("accountbank.id");
            String oppacctnumber = info.getString("oppacctnumber");
            Long direction = info.getLong("direction");
            BigDecimal creditamount = info.getBigDecimal("creditamount");
            BigDecimal debitamount = info.getBigDecimal("debitamount");
            if (oppacctnumber == null || EmptyUtil.isEmpty(direction) || EmptyUtil.isEmpty(creditamount) || EmptyUtil.isEmpty(debitamount)) {
                return;
            }
            Date beginDate = DateUtils.getLastDay(bookdate, days);
            Date endDate = DateUtils.getNextDay(bookdate, days);
            for (int i = index + 1; i < journals.length; ++i) {
                bookdate = journals[i].getDate("bookdate");
                if (EmptyUtil.isEmpty(bookdate) || !bookdate.after(beginDate) || !bookdate.before(endDate) || accountbank.longValue() != journals[i].getLong("accountbank.id") || !oppacctnumber.equals(journals[i].getString("oppacctnumber")) || direction.longValue() != journals[i].getLong("direction") || creditamount.compareTo(journals[i].getBigDecimal("creditamount")) != 0 || debitamount.compareTo(journals[i].getBigDecimal("debitamount")) != 0) continue;
                info.set("isdoubt", (Object)true);
                journals[i].set("isdoubt", (Object)true);
            }
        }
    }

    private static Map<String, DynamicProperty> getFilterProperties(DynamicObject info) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(10);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cas_bankjournal");
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || (propName = property.getName()).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        DynamicObjectType dType = info.getDynamicObjectType();
        for (String prop : selProps) {
            fldProperties.put(prop, dType.getProperty(prop));
        }
        return fldProperties;
    }

    private static boolean isMatch(DynamicObject object, String filterStr, Map<String, DynamicProperty> fldProperties) {
        boolean isMatch = false;
        if (EmptyUtil.isNotEmpty(filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cas_bankjournal");
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (EmptyUtil.isNotEmpty(baseFilterStr)) {
                FormulaGetHandle<Boolean> basebillFilterHandle = new FormulaGetHandle<Boolean>(taskContext, baseFilterStr, Boolean.FALSE);
                isMatch = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, object, null);
            }
        }
        return isMatch;
    }

    public static void updateAllBillValue(DynamicObject[] journals) {
        if (EmptyUtil.isEmpty(journals)) {
            return;
        }
        DynamicObject bill = null;
        Map<Object, Object> transactionplanMap = new HashMap();
        QFilter qFilter = new QFilter("datasource", "=", (Object)"bankjournal").and("enable", "=", (Object)"1");
        Object[] transactionplanDys = BusinessDataServiceHelper.load((String)"mon_transactionplan", (String)"validdate,amountconditon_real_Tag,sensitivecondition_real_Tag,focusconditon_real_Tag,questionconditon,entryentity.e_org", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isNoEmpty(transactionplanDys)) {
            transactionplanMap = Stream.of(transactionplanDys).collect(Collectors.toMap(dy -> dy.getLong("entryentity.e_org.id"), dy -> dy, (m1, m2) -> m1));
        }
        for (int i = 0; i < journals.length; ++i) {
            bill = journals[i];
            CasBankJournalHelper.updateRecPayInfo(bill);
            bill.set("isinternal", (Object)CasBankJournalHelper.isInternal(bill));
            CasBankJournalHelper.getAllMetchResult(i, journals, (DynamicObject)transactionplanMap.get(bill.getLong("org.id")));
        }
    }

    public static void initBalanceAccount(DynamicObject cashMgtInit) {
        QFilter acctFlt = AccountBankHelper.getAccountBankFilterByOrg(cashMgtInit.getLong("org.id"));
        Object[] accts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,company,number,currency", (QFilter[])new QFilter[]{acctFlt});
        if (EmptyUtil.isEmpty(accts)) {
            return;
        }
        DynamicObjectCollection dyColl = cashMgtInit.getDynamicObjectCollection("entrybank");
        Map<String, DynamicObject> initAcct = dyColl.stream().collect(Collectors.toMap(dy -> String.format("%s_%s_%s", DynamicObjectHelper.getPk(cashMgtInit, "org"), DynamicObjectHelper.getPk(dy, "bank_accountbank"), DynamicObjectHelper.getPk(dy, "bank_currency")), dy -> dy, (dy1, dy2) -> dy1));
        DynamicObject newDynamicObject = null;
        ArrayList saveDynamicObject = new ArrayList();
        ArrayList<DynamicObject> accDynamicObject = null;
        String key = "";
        DynamicObject dyInit = null;
        Object currPk = null;
        for (Object acc : accts) {
            DynamicObjectCollection currencys = acc.getDynamicObjectCollection("currency");
            for (DynamicObject dy3 : currencys) {
                accDynamicObject = new ArrayList<DynamicObject>(10);
                currPk = dy3.get("fbasedataid_id");
                key = String.format("%s_%s_%s", DynamicObjectHelper.getPk(cashMgtInit, "org"), DynamicObjectHelper.getPk((DynamicObject)acc, "id"), currPk);
                if (initAcct.containsKey(key)) {
                    dyInit = initAcct.get(key);
                    newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cas_accountbalance");
                    newDynamicObject.set("org", (Object)cashMgtInit.getLong("org.id"));
                    newDynamicObject.set("bookdate", (Object)DateUtils.getLastDay(cashMgtInit.getDate("startperiod.begindate"), 1));
                    newDynamicObject.set("bankaccount", (Object)DynamicObjectHelper.getPk((DynamicObject)acc, "id"));
                    newDynamicObject.set("currency", currPk);
                    newDynamicObject.set("daytradenum", (Object)0L);
                    newDynamicObject.set("debitamount", (Object)dyInit.getBigDecimal("bank_journaldebit"));
                    newDynamicObject.set("creditamount", (Object)dyInit.getBigDecimal("bank_journalcredit"));
                    newDynamicObject.set("daytradeamount", (Object)dyInit.getBigDecimal("bank_journaldebit").add(dyInit.getBigDecimal("bank_journalcredit")));
                    newDynamicObject.set("daybalance", (Object)dyInit.getBigDecimal("bank_journalbalance").subtract(dyInit.getBigDecimal("bank_journaldebit")).add(dyInit.getBigDecimal("bank_journalcredit")));
                    newDynamicObject.set("amount", (Object)dyInit.getBigDecimal("bank_journalbalance"));
                    accDynamicObject.add(newDynamicObject);
                }
                QFilter orgQFilter = new QFilter("org", "=", (Object)cashMgtInit.getLong("org.id"));
                QFilter accQFilter = new QFilter("accountbank", "=", (Object)DynamicObjectHelper.getPk((DynamicObject)acc, "id"));
                QFilter curQFilter = new QFilter("currency", "=", currPk);
                QFilter bookQFilter = new QFilter("bookdate", ">=", (Object)cashMgtInit.getDate("startperiod.begindate"));
                DynamicObjectCollection bankjournalColl = QueryServiceHelper.query((String)"cas_bankjournal", (String)"bookdate,debitamount,creditamount,billno", (QFilter[])new QFilter[]{orgQFilter, accQFilter, curQFilter, bookQFilter});
                HashMap<Date, BigDecimal[]> dateMaps = new HashMap<Date, BigDecimal[]>(bankjournalColl.size());
                BigDecimal[] amount = null;
                Date bookdate = null;
                for (DynamicObject bankjournal : bankjournalColl) {
                    bookdate = bankjournal.getDate("bookdate");
                    amount = (BigDecimal[])dateMaps.get(bookdate = DateUtils.truncateDate(bookdate));
                    if (amount != null && amount.length >= 3) {
                        amount[0] = amount[0].add(bankjournal.getBigDecimal("debitamount"));
                        amount[1] = amount[1].add(bankjournal.getBigDecimal("creditamount"));
                        amount[2] = amount[2].add(BigDecimal.ONE);
                    } else {
                        amount = new BigDecimal[]{bankjournal.getBigDecimal("debitamount") != null ? bankjournal.getBigDecimal("debitamount") : BigDecimal.ZERO, bankjournal.getBigDecimal("creditamount") != null ? bankjournal.getBigDecimal("creditamount") : BigDecimal.ZERO, BigDecimal.ONE};
                    }
                    dateMaps.put(bookdate, amount);
                }
                for (Map.Entry dateMap : dateMaps.entrySet()) {
                    amount = (BigDecimal[])dateMap.getValue();
                    newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cas_accountbalance");
                    newDynamicObject.set("org", (Object)cashMgtInit.getLong("org.id"));
                    newDynamicObject.set("bankaccount", (Object)DynamicObjectHelper.getPk((DynamicObject)acc, "id"));
                    newDynamicObject.set("currency", currPk);
                    newDynamicObject.set("daytradenum", (Object)amount[2]);
                    newDynamicObject.set("debitamount", (Object)amount[0]);
                    newDynamicObject.set("creditamount", (Object)amount[1]);
                    newDynamicObject.set("daytradeamount", (Object)amount[0].add(amount[1]));
                    newDynamicObject.set("bookdate", dateMap.getKey());
                    newDynamicObject.set("daybalance", (Object)BigDecimal.ZERO);
                    newDynamicObject.set("amount", (Object)newDynamicObject.getBigDecimal("debitamount").subtract(newDynamicObject.getBigDecimal("creditamount")));
                    accDynamicObject.add(newDynamicObject);
                }
                accDynamicObject.sort((dy1, dy2) -> dy1.getDate("bookdate").compareTo(dy2.getDate("bookdate")));
                if (accDynamicObject.size() > 1) {
                    BigDecimal daybalance = ((DynamicObject)accDynamicObject.get(0)).getBigDecimal("amount");
                    BigDecimal amountBalance = BigDecimal.ZERO;
                    for (int i = 1; i < accDynamicObject.size(); ++i) {
                        newDynamicObject = (DynamicObject)accDynamicObject.get(i);
                        newDynamicObject.set("daybalance", (Object)daybalance);
                        amountBalance = daybalance.add(newDynamicObject.getBigDecimal("debitamount")).subtract(newDynamicObject.getBigDecimal("creditamount"));
                        newDynamicObject.set("amount", (Object)amountBalance);
                        daybalance = amountBalance;
                    }
                }
                saveDynamicObject.addAll(accDynamicObject);
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveDynamicObject.toArray(new DynamicObject[0]));
    }

    public static void deInitBalanceAccount(DynamicObject cashMgtInit) {
        QFilter companyQf = new QFilter("company", "=", (Object)cashMgtInit.getLong("org.id"));
        Object[] accts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,company,number,currency", (QFilter[])new QFilter[]{companyQf});
        if (EmptyUtil.isEmpty(accts)) {
            return;
        }
        for (Object acc : accts) {
            DynamicObjectCollection currencys = acc.getDynamicObjectCollection("currency");
            for (DynamicObject dy : currencys) {
                Object currPk = dy.get("fbasedataid_id");
                QFilter orgQFilter = new QFilter("org", "=", (Object)cashMgtInit.getLong("org.id"));
                QFilter accQFilter = new QFilter("bankaccount", "=", (Object)DynamicObjectHelper.getPk((DynamicObject)acc, "id"));
                QFilter curQFilter = new QFilter("currency", "=", currPk);
                DeleteServiceHelper.delete((String)"cas_accountbalance", (QFilter[])new QFilter[]{orgQFilter, accQFilter, curQFilter});
            }
        }
    }

    public static void updateBillValues(Map<Long, Exception> errorResult, Map<Long, List<DynamicObject>> journalsMap, Set<Long> errorVoucherIdSet) {
        DynamicObjectCollection billInfo;
        if (EmptyUtil.isEmpty(journalsMap)) {
            return;
        }
        ArrayList journals = new ArrayList();
        for (Map.Entry<Long, List<DynamicObject>> entry : journalsMap.entrySet()) {
            journals.addAll(entry.getValue());
        }
        HashSet<Long> orgids = new HashSet<Long>();
        Map<Object, Object> orgidMap = new HashMap();
        List<String> selProps = CasBankJournalHelper.getProps();
        for (DynamicObject journal : journals) {
            if (!"cas_bankjournal".equalsIgnoreCase(journal.getDynamicObjectType().getName())) continue;
            orgids.add(DynamicObjectHelper.getPk(journal, "org"));
        }
        HashSet<Long> sureInnerMap = new HashSet<Long>();
        HashMap mayBeInnerMap = new HashMap();
        HashSet<Long> cas_paybillIdSet = new HashSet<Long>();
        HashSet<Long> cas_recbillIdSet = new HashSet<Long>();
        HashSet<Long> cas_agentpaybillIdSet = new HashSet<Long>();
        HashSet<Long> accountbankSet = new HashSet<Long>();
        HashSet<String> oppacctnumberSet = new HashSet<String>();
        HashSet<String> directionSet = new HashSet<String>();
        HashSet<BigDecimal> creditamountSet = new HashSet<BigDecimal>();
        HashSet<BigDecimal> debitamountSet = new HashSet<BigDecimal>();
        Date theEarlyTime = null;
        Date theLastTime = null;
        if (orgids.size() > 0) {
            QFilter qFilter = new QFilter("entryentity.e_org", "in", orgids).and("datasource", "=", (Object)"bankjournal").and("enable", "=", (Object)"1");
            List<String> lstFiled = Arrays.asList("id", "amountconditon_real_Tag", "sensitivecondition_real_Tag", "focusconditon_real_Tag", "questionconditon", "entryentity.e_org");
            DynamicObjectCollection tradeObject = QueryServiceHelper.query((String)"mon_transactionplan", (String)String.join((CharSequence)",", (Iterable<? extends CharSequence>)lstFiled), (QFilter[])new QFilter[]{qFilter});
            orgidMap = tradeObject.stream().collect(Collectors.groupingBy(e -> e.getLong("entryentity.e_org")));
        }
        DynamicObject[] dbbills = new DynamicObject[]{};
        for (Object journal : journals) {
            if (!"cas_bankjournal".equalsIgnoreCase(journal.getDynamicObjectType().getName())) continue;
            Long l = DynamicObjectHelper.getPk((DynamicObject)journal, "org");
            String recpayertype = journal.getString("recpayertype");
            Long recpayer = journal.getLong("recpayer_id");
            Long journalId = journal.getLong("id");
            if (recpayer == 0L || EmptyUtil.isEmpty(recpayertype)) {
                sureInnerMap.add(journalId);
            } else if (!recpayertype.equals("bd_supplier") && !recpayertype.equals("bd_customer")) {
                sureInnerMap.add(journalId);
            } else if (null != mayBeInnerMap.get(recpayertype)) {
                ((Set)mayBeInnerMap.get(recpayertype)).add(recpayer);
            } else {
                HashSet<Long> recpayerSet = new HashSet<Long>();
                recpayerSet.add(recpayer);
                mayBeInnerMap.put(recpayertype, recpayerSet);
            }
            String billType = journal.getString("sourcebilltype");
            Long billId = journal.getLong("sourcebillid");
            if (EmptyUtil.isNoEmpty(billType) && EmptyUtil.isNoEmpty(billId)) {
                switch (billType) {
                    case "cas_paybill": {
                        cas_paybillIdSet.add(billId);
                        break;
                    }
                    case "cas_recbill": {
                        cas_recbillIdSet.add(billId);
                        break;
                    }
                    case "cas_agentpaybill": {
                        cas_agentpaybillIdSet.add(billId);
                        break;
                    }
                }
            }
            Date bookdate = journal.getDate("bookdate");
            Long accountbank = DynamicObjectHelper.getPk((DynamicObject)journal, "accountbank");
            String oppacctnumber = journal.getString("oppacctnumber");
            String direction = (String)journal.get("direction");
            BigDecimal creditamount = journal.getBigDecimal("creditamount");
            BigDecimal debitamount = journal.getBigDecimal("debitamount");
            if (EmptyUtil.isEmpty(bookdate) || oppacctnumber == null || EmptyUtil.isEmpty(direction) || EmptyUtil.isEmpty(creditamount) || EmptyUtil.isEmpty(debitamount)) continue;
            accountbankSet.add(accountbank);
            oppacctnumberSet.add(oppacctnumber);
            directionSet.add(direction);
            creditamountSet.add(creditamount);
            debitamountSet.add(debitamount);
            if (!EmptyUtil.isNoEmpty(orgidMap.get(l))) continue;
            int days = ((DynamicObject)((List)orgidMap.get(l)).get(0)).getInt("questionconditon");
            Date earlyTime = DateUtils.getLastDay(bookdate, days);
            Date lastTime = DateUtils.getNextDay(bookdate, days);
            if (null == theEarlyTime || earlyTime.before(theEarlyTime)) {
                theEarlyTime = earlyTime;
            }
            if (null != theLastTime && !lastTime.after(theLastTime)) continue;
            theLastTime = lastTime;
        }
        HashMap allInnerMap = new HashMap();
        if (mayBeInnerMap.size() > 0) {
            try {
                for (Map.Entry entry : mayBeInnerMap.entrySet()) {
                    Map object = BusinessDataServiceHelper.loadFromCache((Object[])((Set)entry.getValue()).toArray(), (String)((String)entry.getKey()));
                    allInnerMap.putAll(object);
                }
            }
            catch (Exception journal) {
                // empty catch block
            }
        }
        DynamicObjectCollection billInfoData = new DynamicObjectCollection();
        if (cas_paybillIdSet.size() > 0) {
            QFilter[] qFilterArray = new QFilter[]{new QFilter("id", "in", cas_paybillIdSet)};
            billInfo = QueryServiceHelper.query((String)"cas_paybill", (String)"id,paymenttype,payeetype,payee", (QFilter[])qFilterArray);
            billInfoData.addAll((Collection)billInfo);
        }
        if (cas_recbillIdSet.size() > 0) {
            QFilter[] qFilterArray = new QFilter[]{new QFilter("id", "in", cas_recbillIdSet)};
            billInfo = QueryServiceHelper.query((String)"cas_recbill", (String)"id,receivingtype,payertype,payer", (QFilter[])qFilterArray);
            billInfoData.addAll((Collection)billInfo);
        }
        if (cas_agentpaybillIdSet.size() > 0) {
            QFilter[] qFilterArray = new QFilter[]{new QFilter("id", "in", cas_agentpaybillIdSet)};
            billInfo = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id,paymenttype,payeetype,entry.payee", (QFilter[])qFilterArray);
            billInfoData.addAll((Collection)billInfo);
        }
        Map<Long, DynamicObject> map = billInfoData.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        if (theLastTime != null && theEarlyTime != null) {
            QFilter bookQFilter = new QFilter("bookdate", ">=", theEarlyTime).and(new QFilter("bookdate", "<=", theLastTime));
            QFilter accQFilter = new QFilter("accountbank.id", "in", accountbankSet);
            QFilter oppQFilter = new QFilter("oppacctnumber", "in", oppacctnumberSet);
            QFilter dirQFilter = new QFilter("direction", "in", directionSet);
            QFilter creQFilter = new QFilter("creditamount", "in", creditamountSet);
            QFilter debQFilter = new QFilter("debitamount", "in", debitamountSet);
            dbbills = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,isdoubt,bookdate,accountbank.id,oppacctnumber,direction,creditamount,debitamount", (QFilter[])new QFilter[]{bookQFilter, accQFilter, oppQFilter, dirQFilter, creQFilter, debQFilter});
        }
        DynamicObject bill = null;
        ArrayList<DynamicObject> willSaveData = new ArrayList<DynamicObject>();
        for (Map.Entry<Long, List<DynamicObject>> voucherId : journalsMap.entrySet()) {
            try {
                for (int i = 0; i < voucherId.getValue().size(); ++i) {
                    boolean isInner;
                    bill = voucherId.getValue().get(i);
                    if (!StringUtils.equals((CharSequence)"cas_bankjournal", (CharSequence)bill.getDynamicObjectType().getName())) continue;
                    if (map.containsKey(bill.getLong("sourcebillid"))) {
                        CasBankJournalHelper.updateRecPayInfos(bill, map.get(bill.getLong("sourcebillid")));
                    }
                    if (isInner = sureInnerMap.contains(bill.getLong("id"))) {
                        bill.set("isinternal", (Object)Boolean.FALSE);
                    } else {
                        Long recpayer = bill.getLong("recpayer");
                        if (EmptyUtil.isNoEmpty((DynamicObject)allInnerMap.get(recpayer))) {
                            DynamicObject object = (DynamicObject)allInnerMap.get(recpayer);
                            boolean isinner = object.getLong("internal_company_id") > 0L;
                            bill.set("isinternal", (Object)isinner);
                        } else {
                            bill.set("isinternal", (Object)Boolean.FALSE);
                        }
                    }
                    Long orgid = DynamicObjectHelper.getPk(bill, "org");
                    List listData = (List)orgidMap.get(orgid);
                    if (null == listData || listData.size() <= 0) continue;
                    willSaveData.addAll(CasBankJournalHelper.getAddMetchResults(i, voucherId.getValue().toArray(new DynamicObject[0]), (DynamicObject)listData.get(0), selProps, dbbills));
                }
            }
            catch (Exception e2) {
                errorVoucherIdSet.add(voucherId.getKey());
                errorResult.put(voucherId.getKey(), e2);
                logger.error("error:", (Throwable)e2);
            }
        }
        if (willSaveData.size() > 0) {
            try {
                SaveServiceHelper.save((DynamicObject[])willSaveData.toArray(new DynamicObject[0]));
            }
            catch (Exception e3) {
                logger.error(e3.getMessage());
                throw new KDBatchDealDBException(ResManager.loadKDString((String)"\u66f4\u65b0\u94f6\u884c\u65e5\u8bb0\u8d26\u8d44\u91d1\u76d1\u63a7\u5b57\u6bb5\u5931\u8d25\u3002", (String)"CasBankJournalHelper_3", (String)"fi-cas-common", (Object[])new Object[0]));
            }
        }
    }

    private static void updateRecPayInfos(DynamicObject bill, DynamicObject billInfo) {
        String billType;
        switch (billType = bill.getString("sourcebilltype")) {
            case "cas_paybill": {
                if (!EmptyUtil.isNoEmpty(billInfo)) break;
                bill.set("recpaytype", (Object)"cas_paymentbilltype");
                bill.set("recpaytypeid_id", (Object)billInfo.getLong("paymenttype"));
                bill.set("recpayertype", (Object)billInfo.getString("payeetype"));
                bill.set("recpayer_id", (Object)billInfo.getLong("payee"));
                break;
            }
            case "cas_recbill": {
                if (!EmptyUtil.isNoEmpty(billInfo)) break;
                bill.set("recpaytype", (Object)"cas_receivingbilltype");
                bill.set("recpaytypeid_id", (Object)billInfo.getLong("receivingtype"));
                bill.set("recpayertype", (Object)billInfo.getString("payertype"));
                bill.set("recpayer_id", (Object)billInfo.getLong("payer"));
                break;
            }
            case "cas_agentpaybill": {
                if (!EmptyUtil.isNoEmpty(billInfo)) break;
                bill.set("recpaytype", (Object)"cas_paymentbilltype");
                bill.set("recpaytypeid_id", (Object)billInfo.getLong("paymenttype"));
                bill.set("recpayertype", (Object)billInfo.getString("payeetype"));
                bill.set("recpayer_id", (Object)billInfo.getLong("entry.payee"));
                break;
            }
        }
    }

    private static List<DynamicObject> getAddMetchResults(int index, DynamicObject[] journals, DynamicObject tradeObject, List<String> selProps, DynamicObject[] allBills) {
        DynamicObject info = journals[index];
        ArrayList<DynamicObject> dbbillsByPart = new ArrayList<DynamicObject>();
        if (EmptyUtil.isNoEmpty(tradeObject)) {
            Map<String, DynamicProperty> fldProperties = CasBankJournalHelper.getFilterPropertiesByBatch(info, selProps);
            boolean isMatch = CasBankJournalHelper.isMatch(info, tradeObject.getString("amountconditon_real_Tag"), fldProperties);
            info.set("islargeamount", (Object)isMatch);
            isMatch = CasBankJournalHelper.isMatch(info, tradeObject.getString("sensitivecondition_real_Tag"), fldProperties);
            info.set("issensitive", (Object)isMatch);
            isMatch = CasBankJournalHelper.isMatch(info, tradeObject.getString("focusconditon_real_Tag"), fldProperties);
            info.set("isattention", (Object)isMatch);
            int days = tradeObject.getInt("questionconditon");
            Date bookdate = info.getDate("bookdate");
            Long accountbank = DynamicObjectHelper.getPk(info, "accountbank");
            String oppacctnumber = info.getString("oppacctnumber");
            String direction = (String)info.get("direction");
            BigDecimal creditamount = info.getBigDecimal("creditamount");
            BigDecimal debitamount = info.getBigDecimal("debitamount");
            if (EmptyUtil.isEmpty(bookdate) || oppacctnumber == null || EmptyUtil.isEmpty(direction) || EmptyUtil.isEmpty(creditamount) || EmptyUtil.isEmpty(debitamount)) {
                return dbbillsByPart;
            }
            for (int i = index + 1; i < journals.length; ++i) {
                if (!StringUtils.equals((CharSequence)"cas_bankjournal", (CharSequence)journals[i].getDynamicObjectType().getName()) || accountbank.compareTo(DynamicObjectHelper.getPk(journals[i], "accountbank")) != 0 || !oppacctnumber.equals(journals[i].getString("oppacctnumber")) || direction != journals[i].get("direction") || creditamount.compareTo(journals[i].getBigDecimal("creditamount")) != 0 || debitamount.compareTo(journals[i].getBigDecimal("debitamount")) != 0) continue;
                info.set("isdoubt", (Object)Boolean.TRUE);
                journals[i].set("isdoubt", (Object)Boolean.TRUE);
            }
            Date theEarlyTime = DateUtils.getLastDay(bookdate, days);
            Date theLastTime = DateUtils.getNextDay(bookdate, days);
            for (DynamicObject dbbill : allBills) {
                if (!dbbill.getDate("bookdate").after(theEarlyTime) || !dbbill.getDate("bookdate").before(theLastTime) || accountbank.compareTo(dbbill.getLong("accountbank.id")) != 0 || !oppacctnumber.equals(dbbill.getString("oppacctnumber")) || !direction.equals(dbbill.getString("direction")) || creditamount.compareTo(dbbill.getBigDecimal("creditamount")) != 0 || debitamount.compareTo(dbbill.getBigDecimal("debitamount")) != 0) continue;
                dbbill.set("isdoubt", (Object)Boolean.TRUE);
                dbbillsByPart.add(dbbill);
            }
            if (dbbillsByPart.size() > 0) {
                info.set("isdoubt", (Object)Boolean.TRUE);
            }
        }
        return dbbillsByPart;
    }

    private static List<String> getProps() {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cas_bankjournal");
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || (propName = property.getName()).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        return selProps;
    }

    private static Map<String, DynamicProperty> getFilterPropertiesByBatch(DynamicObject info, List<String> selProps) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(10);
        DynamicObjectType dType = info.getDynamicObjectType();
        for (String prop : selProps) {
            fldProperties.put(prop, dType.getProperty(prop));
        }
        return fldProperties;
    }

    public static void updateBalances(Map<Long, Exception> errorResult, Map<Long, List<DynamicObject>> journalsMap, Set<Long> errorVoucherIdSet) {
        CasBankJournalHelper.addBalanceTasks(errorResult, journalsMap, errorVoucherIdSet, "add");
    }

    public static void addBalanceTasks(Map<Long, Exception> errorResult, Map<Long, List<DynamicObject>> journalsMap, Set<Long> errorVoucherIdSet, String businesstype) {
        ArrayList allJournalList = new ArrayList(64);
        for (Map.Entry<Long, List<DynamicObject>> entry : journalsMap.entrySet()) {
            Long voucherId = entry.getKey();
            List<DynamicObject> journals = entry.getValue();
            try {
                if (EmptyUtil.isEmpty(journals)) continue;
                ArrayList<DynamicObject> saveBalanceList = new ArrayList<DynamicObject>(journals.size());
                for (DynamicObject journal : journals) {
                    if (!StringUtils.equals((CharSequence)"cas_bankjournal", (CharSequence)journal.getDynamicObjectType().getName())) continue;
                    DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cas_balancetask");
                    newDynamicObject.set("org", journal.get("org"));
                    newDynamicObject.set("bankaccount", journal.get("accountbank"));
                    newDynamicObject.set("currency", journal.get("currency"));
                    newDynamicObject.set("bookdate", (Object)DateUtils.truncateDate(journal.getDate("bookdate")));
                    newDynamicObject.set("creditamount", (Object)journal.getBigDecimal("creditamount"));
                    newDynamicObject.set("debitamount", (Object)journal.getBigDecimal("debitamount"));
                    newDynamicObject.set("businesstype", (Object)businesstype);
                    newDynamicObject.set("journaltype", (Object)"bank");
                    newDynamicObject.set("createdate", (Object)new Date());
                    newDynamicObject.set("modifydate", (Object)new Date());
                    newDynamicObject.set("taskstatus", (Object)"0");
                    newDynamicObject.set("sourceid", journal.getPkValue());
                    saveBalanceList.add(newDynamicObject);
                }
                if (!EmptyUtil.isNoEmpty(saveBalanceList)) continue;
                allJournalList.addAll(saveBalanceList);
            }
            catch (Exception e) {
                errorVoucherIdSet.add(voucherId);
                errorResult.put(voucherId, e);
                logger.error("error:", (Throwable)e);
            }
        }
        try {
            if (allJournalList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])allJournalList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new KDBatchDealDBException(ResManager.loadKDString((String)"\u4f59\u989d\u6570\u636e\u66f4\u65b0\u5931\u8d25\u3002", (String)"CasErrorCode_11", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }

    public static boolean bookByBizBillSettleType(DynamicObject bizBill) {
        DynamicObject settle;
        long orgId = DynamicObjectHelper.getPk(bizBill, "org");
        if (CasBankJournalHelper.considerBillBookJournal(orgId) && (settle = (DynamicObject)bizBill.get("settletype")) != null) {
            String settleType = settle.getString("settlementtype");
            return ExtendConfigHelper.bookBySettleType(settleType) || "1".equals(settleType);
        }
        return true;
    }

    public static boolean bookByBizBillSettleType(DynamicObject bizBill, boolean isSpot) {
        DynamicObject settle;
        long orgId = DynamicObjectHelper.getPk(bizBill, "org");
        if (CasBankJournalHelper.considerBillBookJournal(orgId) && (settle = (DynamicObject)bizBill.get("settletype")) != null) {
            String settleType = settle.getString("settlementtype");
            if ("1".equals(settleType) && isSpot) {
                return true;
            }
            return ExtendConfigHelper.bookBySettleType(settleType);
        }
        return true;
    }

    public static boolean considerBillBookJournal(long orgId) {
        return SystemParameterHelper.isBillBookJournal(orgId) || SystemParameterHelper.isVoucherMixBookJournal(orgId);
    }
}

