/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.DataTypeEnum;
import kd.fi.cas.util.EmptyUtil;
import org.graalvm.collections.Pair;

public class CasDetailInfoExtFieldsHelper {
    private static final Log logger = LogFactory.getLog(CasDetailInfoExtFieldsHelper.class);

    private CasDetailInfoExtFieldsHelper() {
    }

    public static String getSrcDetailInfoSelectFields(String billType) {
        QFilter qFilter = new QFilter("billtype", "=", (Object)billType).and("enable", "=", (Object)"1");
        DynamicObjectCollection extCfgInfo = QueryServiceHelper.query((String)"cas_detailinfoextcfg", (String)"id, billtype, extfieldname", (QFilter[])new QFilter[]{qFilter});
        if (extCfgInfo != null && !extCfgInfo.isEmpty()) {
            return "," + extCfgInfo.stream().filter(info -> EmptyUtil.isNoEmpty(info.getString("extfieldname"))).map(info -> info.getString("extfieldname")).distinct().collect(Collectors.joining(","));
        }
        return "";
    }

    public static Map<String, Pair<String, DataType>> getDetailInfoFields(String billType) {
        QFilter qFilter;
        DynamicObjectCollection extCfgInfo;
        HashMap<String, Pair<String, DataType>> fieldsMap = new HashMap<String, Pair<String, DataType>>(16);
        if ("cas_paybill".equals(billType) || "cas_recbill".equals(billType) || "cas_agentpaybill".equals(billType)) {
            fieldsMap.put("id", Pair.create((Object)"edetailid", (Object)DataTypeEnum.getDataTypeByOrdinal(3)));
            fieldsMap.put("billno", Pair.create((Object)"edetailbillno", (Object)DataTypeEnum.getDataTypeByOrdinal(1)));
            fieldsMap.put("bizdate", Pair.create((Object)"ebizdate", (Object)DataTypeEnum.getDataTypeByOrdinal(6)));
            fieldsMap.put("currency", Pair.create((Object)"ecurrency", (Object)DataTypeEnum.getDataTypeByOrdinal(3)));
            fieldsMap.put("debitamount", (Pair<String, DataType>)Pair.create((Object)"edebitamount", (Object)DataTypeEnum.getDataTypeByOrdinal(5)));
            fieldsMap.put("creditamount", (Pair<String, DataType>)Pair.create((Object)"ecreditamount", (Object)DataTypeEnum.getDataTypeByOrdinal(5)));
        }
        if ((extCfgInfo = QueryServiceHelper.query((String)"cas_detailinfoextcfg", (String)"id, billtype, datatype, extfieldname, tarfieldname", (QFilter[])new QFilter[]{qFilter = new QFilter("billtype", "=", (Object)billType).and("enable", "=", (Object)"1")})) != null && !extCfgInfo.isEmpty()) {
            for (DynamicObject fieldInfo : extCfgInfo) {
                String extField = fieldInfo.getString("extfieldname");
                String tarField = fieldInfo.getString("tarfieldname");
                String dataType = fieldInfo.getString("datatype");
                if (!EmptyUtil.isNoEmpty(extField) || !EmptyUtil.isNoEmpty(tarField) || !EmptyUtil.isNoEmpty(dataType)) continue;
                fieldsMap.put(extField, (Pair<String, DataType>)Pair.create((Object)tarField, (Object)DataTypeEnum.getDataTypeByOrdinal(Integer.parseInt(dataType))));
            }
        }
        return fieldsMap;
    }

    public static void setDetailInfoEntry(DynamicObject detail, DynamicObject targetBillEntryRow, Map<String, Pair<String, DataType>> detailInfoFieldsMap) {
        if (detailInfoFieldsMap != null && !detailInfoFieldsMap.isEmpty()) {
            for (Map.Entry<String, Pair<String, DataType>> fieldEntry : detailInfoFieldsMap.entrySet()) {
                if (!detail.containsProperty(fieldEntry.getKey()) || !targetBillEntryRow.containsProperty((String)fieldEntry.getValue().getLeft())) continue;
                try {
                    Object value = detail.get(fieldEntry.getKey());
                    if (fieldEntry.getValue().getRight() == null || value instanceof DynamicObject || value instanceof DynamicObjectCollection) {
                        targetBillEntryRow.set((String)fieldEntry.getValue().getLeft(), detail.get(fieldEntry.getKey()));
                        continue;
                    }
                    targetBillEntryRow.set((String)fieldEntry.getValue().getLeft(), DataType.convertValue((DataType)((DataType)fieldEntry.getValue().getRight()), (Object)value));
                }
                catch (Exception e) {
                    logger.error("setDetailInfoEntry Exception: " + e.getMessage() + "   fieldEntryInfo: " + fieldEntry);
                }
            }
        }
    }
}

