/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;

public class InitCashHelper {
    private static final Integer INIT_CAPACITY = 4;

    private InitCashHelper() {
    }

    public static String getAccountBankDisplay(DynamicObject accountBank) {
        if (accountBank == null) {
            return "";
        }
        if (accountBank.getString("bankaccountnumber") != null && !accountBank.getString("bankaccountnumber").trim().equals("")) {
            return accountBank.getString("bankaccountnumber") + "\n" + accountBank.getString("name");
        }
        accountBank = AccountBankHelper.getAccountBankById(accountBank.getLong("id"));
        return accountBank.getString("bankaccountnumber") + "\n" + accountBank.getString("name");
    }

    public static String getAccountCashDisplay(DynamicObject accountCash) {
        if (accountCash == null) {
            return "";
        }
        if (accountCash.getString("number") != null && !accountCash.getString("number").trim().equals("")) {
            return accountCash.getString("number") + "\n" + accountCash.getString("name");
        }
        accountCash = AccountCashHelper.getAccountCashById(accountCash.getLong("id"));
        return accountCash.getString("number") + "\n" + accountCash.getString("name");
    }

    public static List<Long> getOrgIds(List<ImportBillData> rowdatas) {
        ArrayList<String> orgNumbers = new ArrayList<String>(rowdatas.size());
        for (ImportBillData data : rowdatas) {
            JSONObject jsonData = data.getData();
            Map org = (Map)jsonData.get((Object)"org");
            String orgNum = (String)org.get("number");
            orgNumbers.add(orgNum);
        }
        if (orgNumbers.size() == 0) {
            return new ArrayList<Long>(INIT_CAPACITY);
        }
        DynamicObjectCollection orgObjects = InitCashHelper.getOrgByNumbers(orgNumbers);
        ArrayList<Long> orgIds = new ArrayList<Long>(rowdatas.size());
        for (DynamicObject orgObject : orgObjects) {
            orgIds.add(orgObject.getLong("id"));
        }
        return orgIds;
    }

    public static Map<String, Object> getCashInit(List<Long> orgIds) {
        QFilter qFilter = new QFilter("org", "in", orgIds);
        DynamicObject[] cashMgtInits = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"org, currentperiod, startperiod, exratetable, periodtype", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, Object> result = new HashMap<String, Object>(cashMgtInits.length);
        for (DynamicObject cashInit : cashMgtInits) {
            HashMap<String, DynamicObject> cashInitMap = new HashMap<String, DynamicObject>();
            DynamicObject period = cashInit.getDynamicObject("currentperiod");
            DynamicObject sPeriod = cashInit.getDynamicObject("startperiod");
            DynamicObject org = cashInit.getDynamicObject("org");
            String orgNumber = org.getString("number");
            DynamicObject periodType = cashInit.getDynamicObject("periodtype");
            DynamicObject exRateTable = cashInit.getDynamicObject("exratetable");
            cashInitMap.put("type", periodType);
            cashInitMap.put("current", period);
            cashInitMap.put("start", sPeriod);
            cashInitMap.put("exratetable", exRateTable);
            result.put(orgNumber, cashInitMap);
        }
        return result;
    }

    public static DynamicObject getRecInit(Long recInitId, Long orgId, long periodId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("initperiod", "=", (Object)periodId), new QFilter("id", "!=", (Object)recInitId)};
        DynamicObjectCollection recInitInfo = QueryServiceHelper.query((String)"cas_rec_init", (String)"id", (QFilter[])filters);
        if (recInitInfo.size() == 0) {
            return null;
        }
        DynamicObject recInit = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)recInitInfo.get(0)).getLong("id"), (String)"cas_rec_init");
        return recInit;
    }

    private static DynamicObjectCollection getOrgByNumbers(List<String> numbers) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter numFilter = new QFilter("number", "in", numbers);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name,fisasset", (QFilter[])new QFilter[]{enableFilter, numFilter});
        return orgs;
    }
}

