/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.fi.cas.errorcode.TmcErrorCode;

public class MutexServiceHelper {
    public static final String MUTEX_DATAOBJID = "dataObjId";
    public static final String MUTEX_GROUPID = "groupId";
    public static final String MUTEX_ENTITYKEY = "entityKey";
    public static final String MUTEX_OPERATIONKEY = "operationKey";
    public static final String MUTEX_ISSTRICT = "isStrict";
    public static final String MUTEX_AUTOCLEARLOSTLOCK = "autoclearlostlock";
    public static final String MUTEX_MAXLOCKTIME = "maxlocktime_s";

    public static Map<String, Boolean> batchRequest(List<String> ids, String entityKey, String opKey) {
        String group = "op_" + opKey;
        return MutexServiceHelper.batchRequest(ids, group, entityKey, opKey);
    }

    public static Map<String, Boolean> batchRequest(List<String> ids, String group, String entityKey, String opKey) {
        ArrayList mutexRequireList = new ArrayList(ids.size());
        for (int index = 0; index < ids.size(); ++index) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put(MUTEX_DATAOBJID, ids.get(index));
            requireParam.put(MUTEX_GROUPID, group);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, opKey);
            requireParam.put(MUTEX_ISSTRICT, Boolean.TRUE);
            mutexRequireList.add(requireParam);
        }
        DataMutex dataMutex = MutexFactory.createDataMutex();
        return dataMutex.batchrequire(mutexRequireList);
    }

    public static Map<String, Boolean> batchRelease(List<String> ids, String entityKey, String opKey) {
        String group = "op_" + opKey;
        return MutexServiceHelper.batchRelease(ids, group, entityKey, opKey);
    }

    public static Map<String, Boolean> batchRelease(List<String> ids, String group, String entityKey, String opKey) {
        ArrayList mutexRequireList = new ArrayList(ids.size());
        for (int index = 0; index < ids.size(); ++index) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put(MUTEX_DATAOBJID, ids.get(index));
            requireParam.put(MUTEX_GROUPID, group);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, opKey);
            requireParam.put(MUTEX_ISSTRICT, Boolean.TRUE);
            mutexRequireList.add(requireParam);
        }
        DataMutex dataMutex = MutexFactory.createDataMutex();
        return dataMutex.batchRelease(mutexRequireList);
    }

    public static boolean request(String id, String entityKey, String opKey) {
        DataMutex dataMutex = MutexFactory.createDataMutex();
        String group = "op_" + opKey;
        return dataMutex.require(id, group, entityKey, opKey, true);
    }

    public static Map<String, String> getLockInfo(String id, String entityKey, String opKey) {
        String group = "op_" + opKey;
        MutexLockInfo info = new MutexLockInfo();
        info.setDataObjId(id);
        info.setGroupId(group);
        info.setEntityNumber(entityKey);
        info.setOperationKey(opKey);
        info.setStrict(Boolean.TRUE.booleanValue());
        DataMutex dataMutex = DataMutex.create();
        Map lockInfo = dataMutex.getLockInfo(id, group, entityKey);
        return lockInfo;
    }

    public static boolean requestWithLostTime(String id, String entityKey, String opKey) {
        String group = "op_" + opKey;
        return MutexServiceHelper.requestWithLostTime(id, group, entityKey, opKey, true, 300L);
    }

    public static Map<String, Boolean> batchRequestWithLostTime(List<String> ids, String entityKey, String opKey) {
        String group = "op_" + opKey;
        return MutexServiceHelper.batchRequestWithLostTime(ids, group, entityKey, opKey, true, 300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requestWithLostTime(String id, String group, String entityKey, String opKey, boolean autoClearLostLock, long maxLockTime) {
        DataMutex dataMutex = MutexFactory.createDataMutex();
        MutexLockInfo lockInfo = new MutexLockInfo(id, null, group, entityKey, opKey, true, null, autoClearLostLock, maxLockTime);
        try {
            boolean bl = dataMutex.require(lockInfo);
            return bl;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Boolean> batchRequestWithLostTime(List<String> ids, String group, String entityKey, String opKey, boolean autoClearLostLock, long maxLockTime) {
        ArrayList mutexRequireList = new ArrayList(ids.size());
        for (String id : ids) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put(MUTEX_DATAOBJID, id);
            requireParam.put(MUTEX_GROUPID, group);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, opKey);
            requireParam.put(MUTEX_ISSTRICT, Boolean.TRUE);
            requireParam.put(MUTEX_AUTOCLEARLOSTLOCK, autoClearLostLock);
            requireParam.put(MUTEX_MAXLOCKTIME, maxLockTime);
            mutexRequireList.add(requireParam);
        }
        DataMutex dataMutex = MutexFactory.createDataMutex();
        try {
            Map map = dataMutex.batchrequire(mutexRequireList);
            return map;
        }
        finally {
            try {
                dataMutex.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean release(String id, String entityKey, String operationKey) {
        DataMutex dataMutex = MutexFactory.createDataMutex();
        return dataMutex.release(id, entityKey, operationKey);
    }

    public static List<String> getRequestResultList(DynamicObject[] dataEntities, List<OperateErrorInfo> errors, Map<String, Boolean> request) {
        ArrayList<String> requestIds = new ArrayList<String>();
        Iterator<Map.Entry<String, Boolean>> it = request.entrySet().iterator();
        TmcErrorCode tmcErrorCode = new TmcErrorCode();
        while (it.hasNext()) {
            Map.Entry<String, Boolean> entry = it.next();
            String id = entry.getKey();
            Boolean value = entry.getValue();
            if (!value.booleanValue()) {
                OperateErrorInfo error = new OperateErrorInfo();
                error.setPkValue((Object)id);
                error.setLevel(ErrorLevel.Warning);
                error.setMessage(tmcErrorCode.BILL_MUTEX_LOCK().getMessage());
                errors.add(error);
                continue;
            }
            for (DynamicObject info : dataEntities) {
                if (!info.getString("id").equals(id)) continue;
                requestIds.add(id);
            }
        }
        return requestIds;
    }

    public static List<String> getRequestResultList(Map<String, String> payDetails, List<OperateErrorInfo> errors, Map<String, Boolean> request) {
        ArrayList<String> requestIds = new ArrayList<String>();
        Iterator<Map.Entry<String, Boolean>> it = request.entrySet().iterator();
        TmcErrorCode tmcErrorCode = new TmcErrorCode();
        while (it.hasNext()) {
            Map.Entry<String, Boolean> entry = it.next();
            String id = entry.getKey();
            Boolean value = entry.getValue();
            if (!value.booleanValue()) {
                OperateErrorInfo error = new OperateErrorInfo();
                error.setPkValue((Object)id);
                error.setLevel(ErrorLevel.Warning);
                error.setMessage(tmcErrorCode.BILL_MUTEX_LOCK().getMessage());
                errors.add(error);
                continue;
            }
            for (String billid : payDetails.keySet()) {
                if (!billid.equals(id)) continue;
                requestIds.add(id);
            }
        }
        return requestIds;
    }

    public static List<String> getRequestResultList(List<String> originIdList, List<OperateErrorInfo> errors, Map<String, Boolean> request) {
        ArrayList<String> requestIds = new ArrayList<String>();
        TmcErrorCode tmcErrorCode = new TmcErrorCode();
        for (Map.Entry<String, Boolean> entry : request.entrySet()) {
            String id = entry.getKey();
            if (!entry.getValue().booleanValue()) {
                OperateErrorInfo error = new OperateErrorInfo();
                error.setPkValue((Object)id);
                error.setLevel(ErrorLevel.Error);
                error.setMessage(tmcErrorCode.BILL_MUTEX_LOCK().getMessage());
                errors.add(error);
                continue;
            }
            for (String originId : originIdList) {
                if (!originId.equals(id)) continue;
                requestIds.add(id);
            }
        }
        return requestIds;
    }
}

