/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;

public class PayApplyHelper {
    private static Log logger = LogFactory.getLog(PayApplyHelper.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void payApplyReceipt(DynamicObject[] payBills, Set<Long> isAllSet, OperationResult operationResult, IFormView view, Object[] payBillIds) {
        if ((EmptyUtil.isEmpty(operationResult) || !operationResult.isSuccess()) && (!CasHelper.isNotEmpty(isAllSet) || isAllSet.size() <= 0)) return;
        List<String> receiptNos = PayApplyHelper.getReceiptNoByDetails(payBillIds, "cas_paybill");
        String bankcheckflagNoDetail = PayApplyHelper.getBankCheckFlagNoDetail(payBillIds, "cas_paybill");
        FormShowParameter para = new FormShowParameter();
        para.setFormId("cas_multitag");
        String appId = view.getFormShowParameter().getAppId();
        appId = appId != null && "cas".equals(appId) ? "cbei" : "bei";
        para.getCustomParams().put("checkRightAppId", appId);
        if (!EmptyUtil.isEmpty(operationResult) && operationResult.isSuccess()) {
            ArrayList<DynamicObject[]> list = new ArrayList<DynamicObject[]>(10);
            for (DynamicObject payBill : payBills) {
                DynamicObject[] bankcheckflag = payBill.getString("bankcheckflag_tag");
                if (!CasHelper.isNotEmpty(bankcheckflag)) continue;
                if (bankcheckflag.contains(",")) {
                    String[] split = bankcheckflag.split(",");
                    Collections.addAll(list, split);
                    continue;
                }
                list.add(bankcheckflag);
            }
            logger.info("\u5bf9\u8d26\u6807\u8bc6\u7801:" + list);
            if (list.size() <= 0) throw new KDBizException(new ErrorCode("cas.COMMON", "%s"), new Object[]{ResManager.loadKDString((String)"\u4e0b\u6e38\u4ed8\u6b3e\u5355\u672a\u5173\u8054\u7535\u5b50\u56de\u5355\u3002", (String)"PayApplyBillReceiptOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0])});
            logger.info("\u6839\u636e\u5bf9\u8d26\u6807\u8bc6\u7801\u83b7\u53d6\u7535\u5b50\u56de\u5355");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bei_elecreceipt", (String)"id,bankcheckflag,matchdetailentry,matchdetailentry.e_transdetailid,matchdetailentry.e_bankcheckflag", (QFilter[])new QFilter[]{new QFilter("matchdetailentry.e_bankcheckflag", "in", (Object)list.toArray())});
            DynamicObject[] receipts = (DynamicObject[])query.toArray((Object[])new DynamicObject[0]);
            if (receipts.length <= 0) throw new KDBizException(new ErrorCode("cas.COMMON", "%s"), new Object[]{ResManager.loadKDString((String)"\u4e0b\u6e38\u4ed8\u6b3e\u5355\u672a\u5173\u8054\u7535\u5b50\u56de\u5355\u3002", (String)"PayApplyBillReceiptOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0])});
            List receiptIdList = Arrays.stream(receipts).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            logger.info("\u7535\u5b50\u56de\u5355ID\u4fe1\u606f:" + receiptIdList);
            StringBuilder sb = new StringBuilder();
            for (DynamicObject receipt : receipts) {
                sb.append(receipt.getString("matchdetailentry.e_bankcheckflag"));
                sb.append(',');
            }
            String temp = sb.toString();
            logger.info(String.format("\u7535\u5b50\u56de\u5355\u4e2d\u5bf9\u5e94\u7684\u5bf9\u8d26\u6807\u8bc6\u7801\u4fe1\u606f:%s", temp));
            para.setCustomParam("receiptID", (Object)bankcheckflagNoDetail);
            para.setCustomParam("receiptNo", (Object)JSON.toJSONString(receiptNos));
        }
        if (isAllSet.size() > 0) {
            para.setCustomParam("detailIds", (Object)JSON.toJSONString(isAllSet));
        }
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(para);
    }

    public static Set<Long> showBotpRtansDetails(Object[] primaryKeyValues, String entityId) {
        HashSet<Long> idsSetAll = new HashSet<Long>(10);
        ArrayList<Long> billIdsBankCheck = new ArrayList<Long>(10);
        for (Object object : primaryKeyValues) {
            Long pkId = (Long)object;
            Set<Long> idsSet = PayApplyHelper.getBotpRtansDetails(pkId, entityId);
            if (idsSet.size() > 0) {
                idsSetAll.addAll(idsSet);
            }
            if (idsSet.size() != 0) continue;
            billIdsBankCheck.add((Long)object);
        }
        QFilter idQf = new QFilter("id", "in", billIdsBankCheck);
        if ("cas_paybill".equals(entityId)) {
            DynamicObject[] bizBills = BusinessDataServiceHelper.load((String)entityId, (String)"id,bankcheckflag_tag", (QFilter[])new QFilter[]{idQf});
            Set<Long> detailIds = PayApplyHelper.getDetailIds(entityId, bizBills);
            if (detailIds != null && detailIds.size() > 0) {
                idsSetAll.addAll(detailIds);
            }
        } else if ("cas_agentpaybill".equals(entityId)) {
            DynamicObject[] bizBills = BusinessDataServiceHelper.load((String)entityId, (String)"id,entry,entry.e_bankcheckflag", (QFilter[])new QFilter[]{idQf});
            Set<Long> detailIds = PayApplyHelper.getDetailIds(entityId, bizBills);
            if (detailIds != null && detailIds.size() > 0) {
                idsSetAll.addAll(detailIds);
            }
        } else if ("cas_exchangebill".equals(entityId)) {
            QFilter qFilter;
            DynamicObject[] ids;
            Set collect;
            DynamicObject[] bizBills = BusinessDataServiceHelper.load((String)entityId, (String)"id,buybankcheckflag,sellingbankcheckflag,feebankcheckflag", (QFilter[])new QFilter[]{idQf});
            List<String> list = new ArrayList<String>();
            for (DynamicObject bizBill : bizBills) {
                String buybankcheckflag = bizBill.getString("buybankcheckflag");
                String sellingbankcheckflag = bizBill.getString("sellingbankcheckflag");
                String feebankcheckflag = bizBill.getString("feebankcheckflag");
                list = PayApplyHelper.getbankcheckflagList(list, buybankcheckflag);
                list = PayApplyHelper.getbankcheckflagList(list, sellingbankcheckflag);
                list = PayApplyHelper.getbankcheckflagList(list, feebankcheckflag);
            }
            if (list.size() > 0 && CasHelper.isNotEmpty(collect = Arrays.stream(ids = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("bankcheckflag", "in", list)})).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet())) && collect.size() > 0) {
                idsSetAll.addAll(collect);
            }
        }
        return idsSetAll;
    }

    private static Set<Long> getDetailIds(String entityId, DynamicObject[] bizBills) {
        if (bizBills == null || bizBills.length < 1) {
            return null;
        }
        List<String> list = new ArrayList<String>(bizBills.length);
        for (DynamicObject bizBill : bizBills) {
            String bankcheckflag = "";
            if ("cas_paybill".equals(entityId)) {
                bankcheckflag = bizBill.getString("bankcheckflag_tag");
                list = PayApplyHelper.getbankcheckflagList(list, bankcheckflag);
                continue;
            }
            DynamicObjectCollection entrys = bizBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entrys) {
                String e_bankcheckflag = row.getString("e_bankcheckflag");
                if (!CasHelper.isNotEmpty(e_bankcheckflag)) continue;
                list = PayApplyHelper.getbankcheckflagList(list, bankcheckflag);
            }
        }
        if (list.size() > 0) {
            QFilter bankcheckflagQf = new QFilter("bankcheckflag", "in", list);
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bei_transdetail_cas", (String)"id", (QFilter[])new QFilter[]{bankcheckflagQf});
            Set<Long> collect = Arrays.stream(ids).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet());
            return collect;
        }
        return null;
    }

    public static String getBankCheckFlagNoDetail(Object[] primaryKeyValues, String entityId) {
        ArrayList<String> bankCheckFlags = new ArrayList<String>(10);
        if (CasHelper.isNotEmpty(primaryKeyValues) && primaryKeyValues.length > 0) {
            DynamicObject[] entityDyObjs;
            for (DynamicObject dyObj : entityDyObjs = BusinessDataServiceHelper.load((String)entityId, (String)"id,bankcheckentity.ebankcheckflag", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)})) {
                Long pkId = dyObj.getLong("id");
                Set<Long> idsSet = PayApplyHelper.getBotpRtansDetails(pkId, entityId);
                if (idsSet.size() != 0) continue;
                DynamicObjectCollection entryEntity = dyObj.getDynamicObjectCollection("bankcheckentity");
                for (DynamicObject entry : entryEntity) {
                    bankCheckFlags.add(entry.getString("ebankcheckflag"));
                }
            }
        }
        String bankCheckFlag = StringUtils.join(bankCheckFlags, (String)",");
        return bankCheckFlag;
    }

    public static List<String> getReceiptNoByDetails(Object[] primaryKeyValues, String entityId) {
        List<String> receiptNos = new ArrayList<String>(10);
        if (CasHelper.isNotEmpty(primaryKeyValues) && primaryKeyValues.length > 0) {
            HashSet<Long> detailIds = new HashSet<Long>(10);
            for (Object primaryKeyValue : primaryKeyValues) {
                Long pkId = (Long)primaryKeyValue;
                Set<Long> idsSet = PayApplyHelper.getBotpRtansDetails(pkId, entityId);
                if (idsSet.size() <= 0) continue;
                detailIds.addAll(idsSet);
            }
            DynamicObjectCollection details = QueryServiceHelper.query((String)"bei_transdetail", (String)"id,company,accountbank,currency,matchreceiptentry.e_receiptno receiptno", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
            receiptNos = details.stream().map(detail -> detail.getString("receiptno")).collect(Collectors.toList());
        }
        return receiptNos;
    }

    public static Set<Long> getBotpRtansDetails(Long pkId, String entityId) {
        Set<Long> oldRecsrcBill = CasBotpHelper.getSrcBillByDestBill(pkId, entityId, "bei_intelrec");
        Set<Long> oldPaysrcBill = CasBotpHelper.getSrcBillByDestBill(pkId, entityId, "bei_intelpay");
        Set<Long> newsrcBill = CasBotpHelper.getSrcBillByDestBill(pkId, entityId, "bei_transdetail");
        Set<Long> handsrcBill = CasBotpHelper.getSrcBillByDestBill(pkId, entityId, "bei_transdetail_cas");
        Set<Long> idsSet = PayApplyHelper.mergerSet(oldPaysrcBill, oldRecsrcBill, newsrcBill);
        if (CasHelper.isNotEmpty(handsrcBill)) {
            idsSet.addAll(handsrcBill);
        }
        return idsSet;
    }

    public static Set<Long> mergerSet(Set<Long> srcBillByDestBill, Set<Long> paysrcBillByDestBill, Set<Long> recsrcBillByDestBill) {
        HashSet<Long> set = new HashSet<Long>();
        if (CasHelper.isNotEmpty(srcBillByDestBill)) {
            set.addAll(srcBillByDestBill);
        }
        if (CasHelper.isNotEmpty(paysrcBillByDestBill)) {
            set.addAll(paysrcBillByDestBill);
        }
        if (CasHelper.isNotEmpty(recsrcBillByDestBill)) {
            set.addAll(recsrcBillByDestBill);
        }
        return set;
    }

    private static List<String> getbankcheckflagList(List<String> list, String bankcheckflag) {
        if (CasHelper.isNotEmpty(bankcheckflag)) {
            if (bankcheckflag.contains(",")) {
                String[] split = bankcheckflag.split(",");
                Collections.addAll(list, split);
            } else {
                list.add(bankcheckflag);
            }
        }
        return list;
    }

    public static boolean checkPayeeTypeFreeze(List<DynamicObject> dataEntities) {
        Map<Long, Set> collectMap = dataEntities.stream().filter(info -> info.getDynamicObjectCollection("cas_payapplyentry").stream().anyMatch(o -> AsstActTypeEnum.SUPPLIER.getValue().equals(o.getString("e_payeetype")) && o.get("e_payee") != null && o.getDynamicObject("e_payee").getLong("id") != 0L)).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getDynamicObjectCollection("cas_payapplyentry").stream().filter(o -> AsstActTypeEnum.SUPPLIER.getValue().equals(o.getString("e_payeetype")) && o.get("e_payee") != null && o.getDynamicObject("e_payee").getLong("id") != 0L).map(o -> o.getDynamicObject("e_payee").getLong("id")).collect(Collectors.toSet())));
        if (collectMap.size() < 1) {
            return false;
        }
        QFilter tQFilter = new QFilter("id", "in", collectMap.values().stream().flatMap(o -> o.stream()).collect(Collectors.toSet()));
        tQFilter.and("payhold", "=", (Object)"1");
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bd_supplier", (String)"id", (QFilter[])tQFilter.toArray());
        return queryResult != null && queryResult.size() >= 1;
    }
}

