/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.basedata.query.BillTypeQueryHelper;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PayInfoChgHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class PayBillListPlugnHelper {
    private static final Log logger = LogFactory.getLog(PayBillListPlugnHelper.class);
    private static final String KEY_CHANGECHG_CALLBACK = "KEY_CHANGECHG_CALLBACK";
    private static final String KEY_CALLBACK_CHARGEBACK = "CALLBACK_CHARGEBACK";
    private static final String KEY_DIFFPAY_CALLBACK = "KEY_DIFFPAY_CALLBACK";
    private static final String KEY_CLOSECALLBACK_CHARGEBACK = "CALLBACK_SELECTDRAFT";

    public static QFilter getFcaFilter(String status) {
        QFilter qFilter = new QFilter("sourcetype", "=", (Object)"FCA");
        logger.info("\u4ed8\u6b3e\u5355-\u8c03\u5ea6\u4e2d\u5fc3 status \uff1a" + status);
        qFilter.and(new QFilter("billtype", "in", Arrays.asList(BillTypeConstants.PAYBILL_SPAN, BillTypeConstants.PAYBILL_SYN)));
        return qFilter;
    }

    public static QFilter getListFilter(String billFormId, String appId) {
        QFilter qFilter = new QFilter("iswaitsche", "=", (Object)"0");
        HashSet<Long> billTypeIds = new HashSet<Long>(10);
        if ("cas_paybill".equals(billFormId)) {
            Set<Long> billTypes = PayBillListPlugnHelper.getBillType();
            if (billTypes != null && billTypes.size() > 0) {
                billTypeIds.addAll(billTypes);
            }
        } else if ("cas_paybill_synonym".equals(billFormId)) {
            billTypeIds.add(BillTypeConstants.PAYBILL_SYN);
        } else if ("cas_paybill_cash".equals(billFormId)) {
            billTypeIds.add(BillTypeConstants.PAYBILL_CASH);
        } else if ("cas_paybill_spanmainpart".equals(billFormId)) {
            billTypeIds.add(BillTypeConstants.PAYBILL_SPAN);
            billTypeIds.add(BillTypeConstants.PAYBILL_SYN);
        } else if ("cas_paybill_dcep".equals(billFormId)) {
            billTypeIds.add(BillTypeConstants.PAYBILL_DCEP);
        }
        if (Objects.equals(appId, "cas")) {
            billTypeIds.remove(BillTypeConstants.PAYBILL_SPAN);
        }
        if (billTypeIds.size() == 1) {
            qFilter.and(new QFilter("billtype", "=", (Object)billTypeIds.toArray(new Long[0])[0]));
        } else if (billTypeIds.size() > 1) {
            qFilter.and(new QFilter("billtype", "in", billTypeIds));
        }
        if (Objects.equals(appId, "fca")) {
            if ("cas_paybill_spanmainpart".equals(billFormId) || "cas_paybill_synonym".equals(billFormId)) {
                QFilter qFilter1 = new QFilter("billtype", "in", Arrays.asList(BillTypeConstants.PAYBILL_SPAN, BillTypeConstants.PAYBILL_SYN));
                qFilter1.and(new QFilter("sourcetype", "=", (Object)"FCA"));
                return qFilter1;
            }
            return qFilter;
        }
        return qFilter;
    }

    public static void closeCallBack(String actionId, IFormView view, Object returnData) {
        if ("listoperation".equals(actionId) && view != null) {
            view.invokeOperation("refresh");
        }
        PayBillListPlugnHelper.changeChg(actionId, view, returnData);
        if ("beforesubmit".equals(actionId)) {
            String confirm = (String)returnData;
            if (confirm != null && confirm.equals("ok") && view != null) {
                view.invokeOperation("submit");
            }
        } else {
            if (StringUtils.equals((CharSequence)actionId, (CharSequence)KEY_CALLBACK_CHARGEBACK)) {
                Map data = (Map)returnData;
                if (null != data) {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("billIdList", String.valueOf(data.get("billid")));
                    option.setVariableValue("reason", String.valueOf(data.get("reason")));
                    option.setVariableValue("entityname", "cas_paybill");
                    String operateKey = String.valueOf(data.get("operateKey"));
                    if (operateKey != null && operateKey.equals("payschback")) {
                        if (view != null) {
                            view.invokeOperation("payschbackwrite", option);
                        }
                    } else if (view != null) {
                        view.invokeOperation("chargebackwrite", option);
                    }
                }
                return;
            }
            if (StringUtils.equals((CharSequence)actionId, (CharSequence)KEY_DIFFPAY_CALLBACK) && view != null) {
                Map data = (Map)returnData;
                OperateOption option = OperateOption.create();
                if (data != null) {
                    for (Map.Entry entry : data.entrySet()) {
                        if (entry.getValue() == null) continue;
                        option.setVariableValue((String)entry.getKey(), entry.getValue().toString());
                    }
                    option.setVariableValue("payConfirm", "1");
                    view.invokeOperation("pay", option);
                } else {
                    view.invokeOperation("refresh", option);
                }
            } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)KEY_CLOSECALLBACK_CHARGEBACK) && returnData != null) {
                OperateOption option = OperateOption.create();
                HashSet<Long> payBillSet = new HashSet<Long>(16);
                Map data = (Map)returnData;
                Object payBillId = data.get("paybillid");
                Object draftBillIdList = data.get("draftBillIdList");
                if (payBillId instanceof JSONArray) {
                    JSONArray payBillIdJsonArr = (JSONArray)payBillId;
                    if (null != payBillIdJsonArr) {
                        for (Object ob : payBillIdJsonArr) {
                            payBillSet.add(Long.parseLong(ob.toString()));
                        }
                    }
                } else {
                    payBillSet.add(Long.parseLong(payBillId.toString()));
                }
                if (payBillSet.size() > 1) {
                    option.setVariableValue("batchselect", JSONArray.toJSONString(payBillSet));
                }
                option.setVariableValue("selectdraft", "true");
                option.setVariableValue("draftids", JSON.toJSONString(draftBillIdList));
                if (view != null) {
                    view.invokeOperation("pay", option);
                }
            }
        }
    }

    private static void changeChg(String actionId, IFormView view, Object returnData) {
        Map data;
        if (KEY_CHANGECHG_CALLBACK.equals(actionId) && null != (data = (Map)returnData)) {
            String btnGroup = (String)data.get("btnGroup");
            String changeCause = (String)data.get("changeCause");
            String sourceType = (String)data.get("sourceType");
            String sourceAction = (String)data.get("sourceAction");
            String openView = (String)data.get("openView");
            switch (btnGroup) {
                case "A": {
                    PayBillListPlugnHelper.payInfoChg(sourceType, sourceAction, openView, changeCause, view);
                    break;
                }
                case "B": 
                case "C": {
                    PayBillListPlugnHelper.saveChangeChg(btnGroup, data, view);
                }
            }
        }
    }

    public static void payInfoChg(String sourceType, String sourceAction, String openView, String changeCause, IFormView view) {
        BillShowParameter showParameter = new BillShowParameter();
        BillList billList = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Long sourceId = 0L;
        if (selectedRows != null && selectedRows.size() > 0) {
            sourceId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        }
        showParameter.setCustomParam("sourceId", (Object)sourceId);
        showParameter.setCustomParam("sourceType", (Object)sourceType);
        showParameter.setCustomParam("sourceAction", (Object)sourceAction);
        showParameter.setCustomParam("changeCause", (Object)changeCause);
        showParameter.setFormId(openView);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.ADDNEW);
        view.showForm((FormShowParameter)showParameter);
    }

    private static void saveChangeChg(String btnGroup, Map<String, Object> data, IFormView view) {
        Object userField = data.get("userField");
        String changeCause = (String)data.get("changeCause");
        Object billNo = data.get("billNo");
        Object billName = data.get("billName");
        Object creator = data.get("creator");
        String sourceType = (String)data.get("sourceType");
        String sourceAction = (String)data.get("sourceAction");
        BillList billList = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Long sourceId = 0L;
        if (selectedRows != null && selectedRows.size() > 0) {
            sourceId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        }
        DynamicObject payBill = sourceId != 0L ? BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)sourceType) : BusinessDataServiceHelper.newDynamicObject((String)sourceType);
        DynamicObject payChgBillObj = BusinessDataServiceHelper.newDynamicObject((String)"cas_paychgbill");
        payChgBillObj.set("billstatus", (Object)"A");
        payChgBillObj.set("sourcebillno", payBill.get("billno"));
        payChgBillObj.set("sourcetype", (Object)sourceType);
        payChgBillObj.set("sourcebilltype", (Object)sourceType);
        payChgBillObj.set("sourcebillid", (Object)sourceId);
        payChgBillObj.set("org", payBill.getDynamicObject("org") == null ? null : payBill.getDynamicObject("org"));
        payChgBillObj.set("sourcecurrency", payBill.getDynamicObject("currency") == null ? null : Long.valueOf(payBill.getDynamicObject("currency").getLong("id")));
        DynamicObjectCollection entryObjCol = payChgBillObj.getDynamicObjectCollection("entrys");
        DynamicObject entryObj = entryObjCol.addNew();
        if ("payAction".equalsIgnoreCase(sourceAction)) {
            payChgBillObj.set("chgtype", (Object)"paychg");
            entryObj.set("paychannel", payBill.get("paymentchannel"));
            DynamicObject settletypeObj = payBill.getDynamicObject("settletype");
            Long settletype = null;
            if (!EmptyUtil.isEmpty(settletypeObj)) {
                settletype = (Long)settletypeObj.getPkValue();
            }
            entryObj.set("settletype", (Object)settletype);
            entryObj.set("settletnumber", (Object)payBill.getString("settletnumber"));
            if (BaseDataHelper.isSettleTypeCash(settletypeObj)) {
                DynamicObject payeracctcashObj = payBill.getDynamicObject("payeracctcash");
                Long payeracctcash = null;
                if (!EmptyUtil.isEmpty(payeracctcashObj)) {
                    payeracctcash = (Long)payeracctcashObj.getPkValue();
                }
                entryObj.set("payeracctcash", (Object)payeracctcash);
            } else {
                DynamicObject payeracctbankObj = payBill.getDynamicObject("payeracctbank");
                Long payeracctbank = null;
                if (!EmptyUtil.isEmpty(payeracctbankObj)) {
                    payeracctbank = (Long)payeracctbankObj.getPkValue();
                }
                entryObj.set("payeracctbank", (Object)payeracctbank);
            }
            DynamicObject payerbankObj = payBill.getDynamicObject("payerbank");
            Long payerbank = null;
            if (!EmptyUtil.isEmpty(payerbankObj)) {
                payerbank = (Long)payerbankObj.getPkValue();
            }
            entryObj.set("payerbank", (Object)payerbank);
            entryObj.set("usage", (Object)payBill.getString("usage"));
            entryObj.set("actpayamt", payBill.get("actpayamt"));
            entryObj.set("bizdate", payBill.get("bizdate"));
            String businessType = payBill.getString("businesstype");
            entryObj.set("businesstype", (Object)businessType);
            if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                entryObj.set("institutioncode", payBill.get("institutioncode"));
                entryObj.set("institutionname", payBill.get("institutionname"));
            }
        } else {
            payChgBillObj.set("chgtype", (Object)"recchg");
            entryObj.set("actpayamt", payBill.get("actpayamt"));
            entryObj.set("recer", payBill.get("payeename"));
            entryObj.set("recername", payBill.get("recaccbankname"));
            entryObj.set("recacctbank", payBill.get("payeebanknum"));
            entryObj.set("recerbank", payBill.get("payeebank"));
            entryObj.set("payeebankname", payBill.get("payeebankname"));
            entryObj.set("usage", payBill.get("usage"));
            entryObj.set("payeetype", payBill.get("payeetype"));
            entryObj.set("recerid", payBill.get("payee"));
            entryObj.set("recprovince", payBill.get("recprovince"));
            entryObj.set("reccity", payBill.get("reccity"));
            entryObj.set("recbanknumber", payBill.get("recbanknumber"));
        }
        entryObj.set("Seq", (Object)0);
        payChgBillObj.set("entrys", (Object)entryObjCol);
        payChgBillObj.set("applyuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
        payChgBillObj.set("remark", (Object)changeCause);
        Object alterationUser = "B".equals(btnGroup) ? creator : userField;
        payChgBillObj.set("alterationuser", alterationUser);
        payChgBillObj.set("billname", billName);
        payChgBillObj.set("billscode", billNo);
        payChgBillObj.set("chgdate", (Object)DateUtils.getCurrentDate());
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"save", (String)"cas_paychgbill", (DynamicObject[])new DynamicObject[]{payChgBillObj}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            HashMap<String, Object> payChgMap = new HashMap<String, Object>();
            payChgMap.put("id", operationResult.getSuccessPkIds().get(0));
            payChgMap.put("btnGroup", btnGroup);
            payChgMap.put("changeCause", changeCause);
            payChgMap.put("alterationUser", alterationUser);
            payChgMap.put("billName", billName);
            payChgMap.put("billNo", billNo);
            Long messageId = PayInfoChgHelper.sendNoticeMessage(payChgMap);
            if (null != messageId) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u901a\u77e5\u6210\u529f\uff0c\u53ef\u5728\u652f\u4ed8\u4fe1\u606f\u53d8\u66f4\u5217\u8868\u67e5\u770b\u53d8\u66f4\u8fdb\u5ea6", (String)"PaymentBillList_27", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
            }
        }
    }

    public static void showDiffPayForm(CloseCallBack closeCallBack, IFormView view, DynamicObject payBill) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("cas_paybill_diffpay");
        para.setCloseCallBack(closeCallBack);
        para.getOpenStyle().setShowType(ShowType.Modal);
        DataEntityPropertyCollection payBillProps = payBill.getDataEntityType().getProperties();
        HashSet payBillPropNames = new HashSet();
        payBillProps.forEach(payBillProp -> payBillPropNames.add(payBillProp.getName()));
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)"cas_paybill_diffpay").getProperties();
        HashMap<String, Object> customParams = new HashMap<String, Object>(properties.size());
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (!payBillPropNames.contains(propName)) continue;
            Object value = payBill.get(propName);
            if (value instanceof DynamicObject) {
                customParams.put(propName, ((DynamicObject)value).getPkValue());
                continue;
            }
            customParams.put(propName, value);
        }
        para.setCustomParams(customParams);
        para.setCustomParam("payamount", (Object)payBill.getBigDecimal("actpayamt"));
        para.setCustomParam("payamt", (Object)payBill.getBigDecimal("dpamt"));
        para.setCustomParam("matchFlag", (Object)payBill.getString("matchflag"));
        para.setCustomParam("sourcebilltype", (Object)payBill.getString("sourcebilltype"));
        para.setCustomParam("payBillId", (Object)payBill.getString("id"));
        String selectLcNo = (String)view.getFormShowParameter().getCustomParam("paySelectLcNo");
        para.setCustomParam("paySelectLcNo", (Object)selectLcNo);
        view.showForm(para);
    }

    public static void showDiffPayDateForm(CloseCallBack closeCallBack, IFormView view) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("cas_paybill_paydate");
        para.setCloseCallBack(closeCallBack);
        para.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(para);
    }

    public static void showDiffPayRateForm(CloseCallBack closeCallBack, IFormView view, DynamicObject payBill) {
        FormShowParameter para = new FormShowParameter();
        para.setFormId("cas_paybill_exchangerate");
        para.setCloseCallBack(closeCallBack);
        para.getOpenStyle().setShowType(ShowType.Modal);
        DataEntityPropertyCollection payBillProps = payBill.getDataEntityType().getProperties();
        HashSet payBillPropNames = new HashSet();
        payBillProps.forEach(payBillProp -> payBillPropNames.add(payBillProp.getName()));
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)"cas_paybill_exchangerate").getProperties();
        HashMap<String, Object> customParams = new HashMap<String, Object>(properties.size());
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (!payBillPropNames.contains(propName)) continue;
            Object value = payBill.get(propName);
            if (value instanceof DynamicObject) {
                customParams.put(propName, ((DynamicObject)value).getPkValue());
                continue;
            }
            customParams.put(propName, value);
        }
        para.setCustomParams(customParams);
        view.showForm(para);
    }

    public static void showSelectDraftForm(CloseCallBack closeCallBack, IFormView view, Object pkValue) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setAppId("cas");
        showParameter.setFormId("cas_payment_selectdraft");
        showParameter.setCustomParam("payBillId", pkValue);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }

    public static void showSelectCreditForm(CloseCallBack closeCallBack, IFormView view, Object pkValue) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setAppId("cas");
        showParameter.setFormId("cas_payment_selectcredit");
        showParameter.setCustomParam("payBillId", pkValue);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }

    private static Set<Long> getBillType() {
        Long[] billTypeIds = BillTypeQueryHelper.queryAllBillTypeID((String)"cas_paybill");
        if (billTypeIds == null || billTypeIds.length == 0) {
            return null;
        }
        HashSet<Long> ids = new HashSet<Long>(billTypeIds.length);
        for (Long billTypeId : billTypeIds) {
            if (BillTypeConstants.PAYBILL_SYN.equals(billTypeId) || BillTypeConstants.PAYBILL_CASH.equals(billTypeId) || BillTypeConstants.PAYBILL_DCEP.equals(billTypeId)) continue;
            ids.add(billTypeId);
        }
        return ids;
    }

    public static String setParamToString(Set<String> params) {
        if (params == null || params.size() <= 0) {
            return "";
        }
        ArrayList<Long> paramList = new ArrayList<Long>(params.size());
        for (String param : params) {
            if (!CasHelper.isNotEmpty(param) || !PayBillListPlugnHelper.isNumeric(param)) continue;
            paramList.add(Long.valueOf(param));
        }
        Collections.sort(paramList);
        return StringUtils.join((Object[])paramList.toArray(new Long[0]), (String)",");
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }
}

