/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.SysParamCs1046Enum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.ViewUtils;

public class PaymentBillPluginHelper {
    public static final String[] proxyBeBankFields = new String[]{"proxybebank", "proxybebanksc", "proxybebankactno", "proxybebankad", "proxybebankcountry", "proxybebankname"};
    public static final String KEY_CACHE_PBBFV = "proxyBeBankFieldVisible";

    public static void fillToolBar(AbstractFormPlugin plugin, IDataModel model, IFormView view) {
        String billStatus = BillStatusEnum.SAVE.getValue();
        if (model.getDataEntity().getDataEntityState().getFromDatabase()) {
            DynamicObject payBill = BusinessDataServiceHelper.loadSingleFromCache((Object)model.getDataEntity().getPkValue(), (String)"cas_paybill", (String)"billstatus");
            if (CasHelper.isEmpty(payBill)) {
                return;
            }
            billStatus = payBill.getString("billstatus");
        }
        if (!((Boolean)model.getValue("issupplecontract")).booleanValue()) {
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_new", "bar_save", "bar_submit", "bar_beforesubmit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_audit", "bar_unaudit", "bar_pay", "bar_cancelpay", "bar_commitbe", "genvoucher", "deletevoucher", "copyentryrow", "bar_commitbeifm"});
            view.setEnable(Boolean.valueOf(false), new String[]{"m_addrow", "copyentryrow", "m_deleterow", "m_rowup", "m_rowdown"});
            if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                view.setVisible(Boolean.valueOf(true), new String[]{"bar_save", "bar_submit", "bar_beforesubmit", "bar_del", "copyentryrow"});
                view.setEnable(Boolean.valueOf(true), new String[]{"m_addrow", "copyentryrow", "m_deleterow", "m_rowup", "m_rowdown"});
            } else if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
                view.setVisible(Boolean.valueOf(true), new String[]{"bar_unsubmit", "bar_audit"});
            } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                view.setVisible(Boolean.valueOf(true), new String[]{"bar_unaudit", "bar_pay", "bar_commitbe", "genvoucher", "deletevoucher", "bar_commitbeifm"});
            } else if (BillStatusEnum.PAY.getValue().equals(billStatus)) {
                view.setVisible(Boolean.valueOf(true), new String[]{"bar_cancelpay", "genvoucher", "deletevoucher"});
            } else if (BillStatusEnum.BEING.getValue().equals(billStatus)) {
                view.setVisible(Boolean.valueOf(true), new String[]{"genvoucher", "deletevoucher"});
            }
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_new", "bar_submit", "bar_beforesubmit", "bar_unsubmit", "bar_submitandnew", "bar_del", "bar_audit", "bar_unaudit", "bar_pay", "bar_cancelpay", "bar_commitbe", "genvoucher", "deletevoucher", "bar_cancelpay", "navbill", "changepayee", "changepayer"});
            view.setEnable(Boolean.valueOf(true), new String[]{"copyentryrow"});
            view.setVisible(Boolean.valueOf(true), new String[]{"bar_save", "bar_close"});
        }
        Long orgId = null;
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            orgId = (Long)org.getPkValue();
        }
        view.setVisible(Boolean.valueOf(true), new String[]{"recbook", "endorse"});
        if (null != orgId && orgId != 0L) {
            boolean isdraft = SystemParameterHelper.getCdmParameterBoolean(orgId, "isdraft");
            boolean ischeck = SystemParameterHelper.getCdmParameterBoolean(orgId, "ischeck");
            boolean ispromissorynote = SystemParameterHelper.getCdmParameterBoolean(orgId, "ispromissorynote");
            if (!(isdraft || ischeck || ispromissorynote)) {
                view.setVisible(Boolean.valueOf(false), new String[]{"recbook", "endorse"});
            }
        }
        Boolean isHeadPush = (Boolean)model.getValue("isheadpush");
        String sourceBillType = (String)model.getValue("sourcebilltype");
        if (!(CasHelper.isEmpty(sourceBillType) || isHeadPush.booleanValue() || ((Boolean)model.getValue("issupplecontract")).booleanValue() || "bei_intelpay".equals(sourceBillType) || "bei_transdetail".equals(sourceBillType))) {
            ViewUtils.setEnable(plugin, false, "m_addrow", "copyentryrow");
        } else if (!BillStatusEnum.DRAFTING.getValue().equals(billStatus)) {
            ViewUtils.setEnable(plugin, true, "m_addrow", "copyentryrow");
        }
        PaymentBillPluginHelper.isSchePayEditable(plugin, model);
    }

    public static void isSchePayEditable(AbstractFormPlugin plugin, IDataModel model) {
        Boolean isSchePay;
        Long billId = (Long)model.getDataEntity().getPkValue();
        if (billId != null && billId != 0L && (isSchePay = (Boolean)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"psd", (String)"tmcPayScheService", (String)"isSchePayBill", (Object[])new Object[]{billId})).booleanValue()) {
            ViewUtils.setVisible(plugin, false, "changepayee");
            ViewUtils.setEnable(plugin, false, "m_addrow", "copyentryrow", "m_deleterow");
            ArrayList<String> props = new ArrayList<String>(){
                {
                    this.add("settletype");
                    this.add("draftbill");
                    this.add("e_fundflowitem");
                    this.add("e_payableamt");
                }
            };
            ViewUtils.setEnable(plugin, false, props.toArray(new String[0]));
            DynamicObject[] paySches = BusinessDataServiceHelper.load((String)"psd_schedulebill", (String)"id,name,number,draftno", (QFilter[])new QFilter[]{new QFilter("entrys.e_payid", "=", (Object)billId), new QFilter("entrys.e_billtype", "=", (Object)"paybill")});
            DynamicObjectCollection drafts = paySches[0].getDynamicObjectCollection("draftno");
            ViewUtils.setEnable(plugin, EmptyUtil.isEmpty(drafts) && model.getDataEntity().getString("billstatus").equals("A"), "draftbill");
        }
    }

    public static boolean needSelectedDraft(DynamicObject paymentBillData) {
        Object settlementType = paymentBillData.get(String.join((CharSequence)".", "settletype", "settlementtype"));
        DynamicObjectCollection draftBillColl = paymentBillData.getDynamicObjectCollection("draftbill");
        if (("1".equals(settlementType) || "2".equals(settlementType) || "5".equals(settlementType) || "6".equals(settlementType)) && draftBillColl.size() == 0) {
            String key = "";
            switch (settlementType.toString()) {
                case "5": 
                case "6": {
                    key = "isdraft";
                    break;
                }
                case "1": {
                    key = "ischeck";
                    break;
                }
                case "2": {
                    key = "ispromissorynote";
                }
            }
            boolean isParamOpen = SystemParameterHelper.getCdmParameterBoolean(paymentBillData.getDynamicObject("org").getLong("id"), key);
            return isParamOpen;
        }
        return false;
    }

    public static boolean paymentIdentify(DynamicObject entity) {
        DynamicObject paymentIdentify = entity.getDynamicObject("paymentidentify");
        return EmptyUtil.isEmpty(paymentIdentify) || "0".equals(paymentIdentify.getString("type"));
    }

    public static boolean payIdentify(DynamicObject entity) {
        DynamicObject paymentIdentify = entity.getDynamicObject("paymentidentify");
        return EmptyUtil.isNoEmpty(paymentIdentify) && "1".equals(paymentIdentify.getString("type"));
    }

    public static boolean isShowPayConfirm(DynamicObject payBill, Set<String> cs1047) {
        Long destCurrencyId;
        boolean isCurrencyDifferent;
        if (cs1047 == null || cs1047.size() <= 0) {
            return false;
        }
        if (cs1047.contains(SysParamCs1046Enum.PAYDATE.getValue())) {
            return true;
        }
        if (cs1047.contains(SysParamCs1046Enum.FEE.getValue())) {
            return true;
        }
        if (cs1047.contains(SysParamCs1046Enum.DIFF.getValue()) && payBill.getBoolean("isdiffcur")) {
            return true;
        }
        Long srcCurrencyId = payBill.getDynamicObject("dpcurrency").getLong("id");
        boolean bl = isCurrencyDifferent = !srcCurrencyId.equals(destCurrencyId = Long.valueOf(payBill.getDynamicObject("basecurrency").getLong("id")));
        return cs1047.contains(SysParamCs1046Enum.FOREIGN.getValue()) && isCurrencyDifferent;
    }

    public static void fillProxyBeBankInfo(IDataModel model, IFormView view, boolean forceUpdate) {
        Boolean iscrosspay = (Boolean)model.getValue("iscrosspay");
        if (!iscrosspay.booleanValue()) {
            return;
        }
        String payeeformid = (String)model.getValue("payeeformid");
        Object payee = model.getValue("payee");
        Long payeeId = Long.parseLong(payee == null ? "0" : payee.toString());
        if (!AsstActTypeEnum.SUPPLIER.getValue().equals(payeeformid) || CasHelper.isEmpty(payeeId)) {
            return;
        }
        String proxyBeBankFieldVis = view.getPageCache().get(KEY_CACHE_PBBFV);
        Map proxyBeBankFieldVisibleM = CasHelper.isNotEmpty(proxyBeBankFieldVis) ? (Map)SerializationUtils.fromJsonString((String)proxyBeBankFieldVis, Map.class) : new HashMap();
        Object supplierBank = model.getValue("supplierBankId");
        if (!CasHelper.isEmpty(supplierBank)) {
            Long supplierBankId = (Long)supplierBank;
            DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeId, (String)payeeformid);
            DynamicObjectCollection bankColls = supplier.getDynamicObjectCollection("entry_bank");
            DynamicObject defaultBankAccountInfo = null;
            for (int i = 0; i < bankColls.size(); ++i) {
                if (!supplierBankId.equals(((DynamicObject)bankColls.get(i)).getPkValue())) continue;
                defaultBankAccountInfo = (DynamicObject)bankColls.get(i);
            }
            if (defaultBankAccountInfo != null) {
                DynamicObject agentbank = defaultBankAccountInfo.getDynamicObject("agentbank");
                if (agentbank != null) {
                    PaymentBillPluginHelper.fillBeBankInfo(agentbank.getPkValue(), proxyBeBankFieldVisibleM, model, forceUpdate);
                } else {
                    PaymentBillPluginHelper.setValueForce(model, "proxybebank", null, forceUpdate);
                }
                PaymentBillPluginHelper.setValueIsVisible(proxyBeBankFieldVisibleM, model, "proxybebankactno", defaultBankAccountInfo.getString("agentbankaccount"), forceUpdate);
            }
        } else {
            PaymentBillPluginHelper.clearProxyBeBankFields(model, forceUpdate);
        }
    }

    public static void fillBeBankInfo(Object beBankPk, Map<String, Boolean> fieldVisibleM, IDataModel model, boolean forceUpdate) {
        DynamicObject beBank = BusinessDataServiceHelper.loadSingle((Object)beBankPk, (String)"bd_bebank", (String)"name,country,swift_code,address");
        PaymentBillPluginHelper.setValueIsVisible(fieldVisibleM, model, "proxybebank", beBank.getPkValue(), forceUpdate);
        PaymentBillPluginHelper.setValueIsVisible(fieldVisibleM, model, "proxybebankname", CasHelper.getLocalValue(beBank, "name"), forceUpdate);
        PaymentBillPluginHelper.setValueIsVisible(fieldVisibleM, model, "proxybebanksc", beBank.getString("swift_code"), forceUpdate);
        PaymentBillPluginHelper.setValueIsVisible(fieldVisibleM, model, "proxybebankad", beBank.getString("address"), forceUpdate);
        PaymentBillPluginHelper.setValueIsVisible(fieldVisibleM, model, "proxybebankcountry", beBank.getDynamicObject("country") == null ? Double.valueOf(0.0) : beBank.getDynamicObject("country").getPkValue(), forceUpdate);
    }

    private static void clearProxyBeBankFields(IDataModel model, boolean forceUpdate) {
        for (String prop : proxyBeBankFields) {
            PaymentBillPluginHelper.setValueForce(model, prop, null, forceUpdate);
        }
    }

    private static void setValueIsVisible(Map<String, Boolean> fieldVisibleM, IDataModel model, String prop, Object value, boolean forceUpdate) {
        Boolean fieldVisible = fieldVisibleM.get(prop);
        if (fieldVisible == null || fieldVisible.booleanValue()) {
            PaymentBillPluginHelper.setValueForce(model, prop, value, forceUpdate);
        } else {
            PaymentBillPluginHelper.setValue(model, prop, null);
        }
    }

    private static void setValueForce(IDataModel model, String prop, Object value, boolean forceUpdate) {
        if (forceUpdate) {
            PaymentBillPluginHelper.setValue(model, prop, value);
        } else {
            PaymentBillPluginHelper.setValueIfAbsent(model, prop, value);
        }
    }

    private static void setValueIfAbsent(IDataModel model, String prop, Object value) {
        if (CasHelper.isEmpty(model.getValue(prop))) {
            model.setValue(prop, value);
        }
    }

    private static void setValue(IDataModel model, String prop, Object value) {
        model.setValue(prop, value);
    }

    public static boolean checkPayeeTypeFreeze(List<DynamicObject> dataEntities) {
        Set collect = dataEntities.stream().filter(info -> AsstActTypeEnum.SUPPLIER.getValue().equals(info.getString("payeetype")) && info.getLong("payee") != 0L).map(k -> k.getLong("payee")).collect(Collectors.toSet());
        if (collect.size() < 1) {
            return false;
        }
        QFilter tQFilter = new QFilter("id", "in", collect);
        tQFilter.and("payhold", "=", (Object)"1");
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"bd_supplier", (String)"id", (QFilter[])tQFilter.toArray());
        return queryResult != null && queryResult.size() > 0;
    }

    public static void initBusinessType(IFormView view, String[] comboValues) {
        ComboEdit comboEdit = (ComboEdit)view.getControl("businesstype");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(16);
        comboEdit.setComboItems(comboItemList);
        for (String comboValue : comboValues) {
            ComboItem comboItem = new ComboItem(new LocaleString(PayBusinessTypeEnum.getName(comboValue)), comboValue);
            comboItemList.add(comboItem);
        }
        comboEdit.setComboItems(comboItemList);
    }
}

