/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentQueryHelper {
    private static final Log LOGGER = LogFactory.getLog(PaymentQueryHelper.class);
    private static final String ENTRIES_PREFIX = "entry.";
    private static final Predicate<QFilter> IS_SINGLE_Q_FILTER = x -> null != x && !x.isJoinFilter() && !x.isExistsFilter() && !x.isExpressValue() && !x.isParseExistsValue() && !x.isOnMetaJoinPropertyFilter() && !x.isJoinSQLFilter();

    public static void enhanceNumFilterToIdFilter(List<QFilter> filterList) {
        Predicate<QFilter> noFilter = x -> x.getProperty().equalsIgnoreCase("billno") && ("=".equalsIgnoreCase(x.getCP()) || "in".equalsIgnoreCase(x.getCP()) || "like".equalsIgnoreCase(x.getCP()) || "ftlike".equalsIgnoreCase(x.getCP()) || "match".equalsIgnoreCase(x.getCP()));
        List<QFilter> numFilterList = PaymentQueryHelper.getFilterMatchOrNestsAnyMatchFilterList(filterList, noFilter);
        LOGGER.info("pay_filter_enhance pay num filter is : " + numFilterList);
        if (!numFilterList.isEmpty()) {
            filterList.removeAll(numFilterList);
            List pkList = QueryServiceHelper.queryPrimaryKeys((String)"cas_paybill", (QFilter[])numFilterList.toArray(new QFilter[0]), null, (int)-1);
            QFilter idFilter = new QFilter("id", "in", (Object)pkList);
            LOGGER.info("pay_filter_enhance pay num to id filter is : " + idFilter);
            filterList.add(idFilter);
        }
    }

    private static List<QFilter> getFilterMatchOrNestsAnyMatchFilterList(List<QFilter> filterList, Predicate<QFilter> matchCondition) {
        return filterList.stream().filter(Objects::nonNull).filter(IS_SINGLE_Q_FILTER).filter(PaymentQueryHelper::isSameFieldFilter).filter(x -> PaymentQueryHelper.isFilterMatchOrNestsAnyMatch(x, matchCondition)).collect(Collectors.toList());
    }

    private static boolean isSameFieldFilter(QFilter filter) {
        if (filter == null) {
            return false;
        }
        List nests = filter.getNests(true);
        if (nests.isEmpty()) {
            return true;
        }
        Set fieldSet = nests.stream().map(x -> PaymentQueryHelper.getFilterMainProp(x.getFilter().getProperty())).collect(Collectors.toSet());
        fieldSet.add(PaymentQueryHelper.getFilterMainProp(filter.getProperty()));
        return fieldSet.size() <= 1;
    }

    private static String getFilterMainProp(String property) {
        String[] split = property.split("\\.");
        if (property.startsWith(ENTRIES_PREFIX)) {
            return ENTRIES_PREFIX + split[0];
        }
        return split[0];
    }

    private static boolean isFilterMatchOrNestsAnyMatch(QFilter filter, Predicate<QFilter> matchCondition) {
        if (matchCondition.test(filter)) {
            return true;
        }
        return filter.getNests(true).stream().anyMatch(x -> matchCondition.test(x.getFilter()));
    }

    public static boolean isCheckOurAccBySysParam(DynamicObject org, DynamicObject settleType) {
        if (EmptyUtil.isAnyoneEmpty(org, settleType)) {
            return true;
        }
        boolean isVirtual = BaseDataHelper.isSettleTypeVirtual(settleType);
        if (isVirtual) {
            return SystemParameterHelper.getParameterBoolean(org.getLong("id"), "cs128");
        }
        return true;
    }
}

