/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;

public class PeriodHelper {
    private static final String SELETOR = "id,number,name,periodyear,periodnumber,isadjustperiod,periodtype,begindate,enddate";
    private static final String SELETORFORBATCHFORBOOK = "id,isadjustperiod,begindate";
    private static final String SELETORFORBATCHFORCANCEL = "id,begindate";

    public static long getPeriodTypeId(long orgId) {
        DynamicObject periodType = SystemStatusCtrolHelper.getPeriodType(orgId);
        return periodType == null ? 0L : periodType.getLong("id");
    }

    public static Map<Long, Long> getBatchPeriodTypeId(List<Long> orgIdList) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIdList)};
        Map cashInit = BusinessDataServiceHelper.loadFromCache((String)"cas_cashmgtinit", (String)"org.id,periodtype.id", (QFilter[])filters);
        HashMap periodTypeMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry entry : cashInit.entrySet()) {
            periodTypeMap.put(((DynamicObject)entry.getValue()).getLong("org.id"), ((DynamicObject)entry.getValue()).getLong("periodtype.id"));
        }
        return periodTypeMap;
    }

    public static DynamicObject getSystemStatusCtrol(long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cas_cashmgtinit", (QFilter[])filters);
    }

    public static Map<Object, DynamicObject> getPeriodsByIds(Set<Long> ids, Boolean isBook) {
        QFilter qFilter = new QFilter("id", "in", ids);
        if (isBook.booleanValue()) {
            return BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)SELETORFORBATCHFORBOOK, (QFilter[])new QFilter[]{qFilter});
        }
        return BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)SELETORFORBATCHFORCANCEL, (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObjectCollection getPeriodList(long periodTypeId) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("isadjustperiod", "=", (Object)"0")};
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_period");
        Map periodMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)entityType, (QFilter[])filters);
        DynamicObjectCollection periodColl = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        for (DynamicObject period : periodMap.values()) {
            periodColl.add((Object)period);
        }
        return periodColl;
    }

    public static DynamicObject[] getPeriodListOrder(long periodTypeId) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("isadjustperiod", "=", (Object)"0")};
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_period");
        DynamicObject[] periodMap = BusinessDataServiceHelper.load((String)entityType.getName(), (String)SELETOR, (QFilter[])filters, (String)"enddate desc");
        return periodMap;
    }

    public static DynamicObject getPeriodByDate(long orgId, Date date) {
        long periodTypeId = PeriodHelper.getPeriodTypeId(orgId);
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", (Object)periodTypeId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static Map<Long, Long> geBatchPeriodByDate(List<Long> orgIdList, Date date) {
        Map<Long, Long> periodTypeMap = PeriodHelper.getBatchPeriodTypeId(orgIdList);
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "in", periodTypeMap.values().stream().distinct().collect(Collectors.toList()))};
        Map period = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)"periodtype.id,id", (QFilter[])filters);
        HashMap periodMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry entry : period.entrySet()) {
            periodMap.put(((DynamicObject)entry.getValue()).getLong("periodtype.id"), ((DynamicObject)entry.getValue()).getLong("id"));
        }
        HashMap periodDateMap = Maps.newHashMapWithExpectedSize((int)10);
        for (long orgId : orgIdList) {
            long periodTypeId = periodTypeMap.get(orgId);
            Long periodId = (Long)periodMap.get(periodTypeId);
            periodDateMap.put(orgId, periodId);
        }
        return periodDateMap;
    }

    public static Map<Long, DynamicObject> getPeriodByOrgsDate(List<Long> orgIdList, Date date) {
        QFilter[] orgFilter = new QFilter[]{new QFilter("org", "in", orgIdList)};
        DynamicObjectCollection periodtypes = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"org.id,periodtype.id", (QFilter[])orgFilter);
        Map<Long, Long> orgTypeMap = periodtypes.stream().collect(Collectors.toMap(p -> p.getLong("org.id"), p -> p.getLong("periodtype.id"), (o1, o2) -> o1));
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("isadjustperiod", "=", (Object)"0"), new QFilter("periodtype", "in", orgTypeMap.values().stream().collect(Collectors.toSet()))};
        DynamicObject[] periods = BusinessDataServiceHelper.load((String)"bd_period", (String)"id,number,name,periodtype,periodyear,periodquarter,periodnumber,begindate,enddate,isadjustperiod", (QFilter[])filters);
        Map periodMap = Arrays.stream(periods).collect(Collectors.toMap(p -> p.getDynamicObject("periodtype").getLong("id"), Function.identity(), (o1, o2) -> o1));
        HashMap<Long, DynamicObject> orgPeriodMap = new HashMap<Long, DynamicObject>(orgIdList.size());
        for (Long orgId : orgIdList) {
            Long ptId = orgTypeMap.get(orgId);
            DynamicObject period = (DynamicObject)periodMap.get(ptId);
            orgPeriodMap.put(orgId, period);
        }
        return orgPeriodMap;
    }

    public static DynamicObject getPeriodById(long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bd_period", (String)SELETOR);
    }

    public static DynamicObject[] getPeriodByIds(Set<Long> ids) {
        return BusinessDataServiceHelper.load((String)"bd_period", (String)SELETOR, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
    }

    public static DynamicObject getPeriodByYearAndNumber(long periodtypeId, int periodyear, int periodnumber) {
        QFilter[] filters = new QFilter[]{new QFilter("periodyear", "=", (Object)periodyear), new QFilter("periodnumber", "=", (Object)periodnumber), new QFilter("periodtype", "=", (Object)periodtypeId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static DynamicObject getPeriodByYearAndNumberNotAdjustPuriod(long periodtypeId, int periodyear, int periodnumber) {
        QFilter[] filters = new QFilter[]{new QFilter("periodyear", "=", (Object)periodyear), new QFilter("periodnumber", "=", (Object)periodnumber), new QFilter("periodtype", "=", (Object)periodtypeId), new QFilter("isadjustperiod", "=", (Object)"0")};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static DynamicObject getNextPeriod(long id) {
        DynamicObject period = PeriodHelper.getPeriodById(id);
        if (period == null) {
            return null;
        }
        int periodYear = period.getInt("periodyear");
        int periodNumber = period.getInt("periodnumber");
        if (periodNumber < 12) {
            ++periodNumber;
        } else {
            ++periodYear;
            periodNumber = 1;
        }
        DynamicObject nextPeriod = PeriodHelper.getPeriodByYearAndNumber(period.getDynamicObject("periodtype").getLong("id"), periodYear, periodNumber);
        return nextPeriod;
    }

    public static DynamicObject getNextPeriodNotAdjustPeriod(long id) {
        DynamicObject period = PeriodHelper.getPeriodById(id);
        if (period == null) {
            return null;
        }
        int periodYear = period.getInt("periodyear");
        int periodNumber = period.getInt("periodnumber");
        if (periodNumber < 12) {
            ++periodNumber;
        } else {
            ++periodYear;
            periodNumber = 1;
        }
        DynamicObject nextPeriod = PeriodHelper.getPeriodByYearAndNumberNotAdjustPuriod(period.getDynamicObject("periodtype").getLong("id"), periodYear, periodNumber);
        return nextPeriod;
    }

    public static DynamicObject getPrevPeriod(long id) {
        DynamicObject period = PeriodHelper.getPeriodById(id);
        if (period == null) {
            return null;
        }
        int periodYear = period.getInt("periodyear");
        int periodNumber = period.getInt("periodnumber");
        if (periodNumber > 1) {
            --periodNumber;
        } else {
            --periodYear;
            periodNumber = 12;
        }
        DynamicObject nextPeriod = PeriodHelper.getPeriodByYearAndNumber(period.getDynamicObject("periodtype").getLong("id"), periodYear, periodNumber);
        return nextPeriod;
    }

    public static DynamicObject getPrevPeriodNotAdjustPeriod(long id) {
        DynamicObject period = PeriodHelper.getPeriodById(id);
        if (period == null) {
            return null;
        }
        int periodYear = period.getInt("periodyear");
        int periodNumber = period.getInt("periodnumber");
        if (periodNumber > 1) {
            --periodNumber;
        } else {
            --periodYear;
            periodNumber = 12;
        }
        DynamicObject nextPeriod = PeriodHelper.getPeriodByYearAndNumberNotAdjustPuriod(period.getDynamicObject("periodtype").getLong("id"), periodYear, periodNumber);
        return nextPeriod;
    }

    public static boolean before(DynamicObject period1, DynamicObject period2) {
        if (period1 == null || period2 == null) {
            return false;
        }
        return period1.getInt("periodyear") < period2.getInt("periodyear") || period1.getInt("periodyear") == period2.getInt("periodyear") && period1.getInt("periodnumber") < period2.getInt("periodnumber");
    }

    public static boolean after(DynamicObject period1, DynamicObject period2) {
        if (period1 == null || period2 == null) {
            return false;
        }
        return period1.getInt("periodyear") > period2.getInt("periodyear") || period1.getInt("periodyear") == period2.getInt("periodyear") && period1.getInt("periodnumber") > period2.getInt("periodnumber");
    }

    public static boolean equal(DynamicObject period1, DynamicObject period2) {
        if (period1 == null || period2 == null) {
            return false;
        }
        return period1.getInt("periodyear") == period2.getInt("periodyear") && period1.getInt("periodnumber") == period2.getInt("periodnumber");
    }

    public static DynamicObject getLastPeriod(long orgid) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)PeriodHelper.getPeriodTypeId(orgid))};
        DynamicObject[] periodArr = BusinessDataServiceHelper.load((String)"bd_period", (String)SELETOR, (QFilter[])filters, (String)"begindate desc", (int)1);
        return periodArr != null && periodArr.length > 0 ? periodArr[0] : null;
    }

    public static List<DynamicObject> getOriginPeriods(long orgId) {
        DynamicObject[] periods;
        ArrayList<DynamicObject> nearstPeriods = new ArrayList<DynamicObject>(10);
        DynamicObject startPeriod = SystemStatusCtrolHelper.getStartPeriod(orgId);
        DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod(orgId);
        if (null == startPeriod || null == currentPeriod) {
            return nearstPeriods;
        }
        nearstPeriods.add(currentPeriod);
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)PeriodHelper.getPeriodTypeId(orgId)), new QFilter("begindate", "<", (Object)currentPeriod.getDate("begindate")), new QFilter("begindate", ">=", (Object)startPeriod.getDate("begindate")), new QFilter("isadjustperiod", "=", (Object)"0")};
        for (DynamicObject period : periods = BusinessDataServiceHelper.load((String)"bd_period", (String)SELETOR, (QFilter[])filters, (String)"begindate desc")) {
            nearstPeriods.add(period);
        }
        return nearstPeriods;
    }

    public static DynamicObject getCasInitInfo(long orgId) {
        return SystemStatusCtrolHelper.getSystemStatusCtrol(orgId);
    }

    public static DynamicObject getBeginPeriod(Long orgId, DynamicObject cPeriod, Date endDate) {
        if (cPeriod == null) {
            return null;
        }
        Date cPeriodEndDate = cPeriod.getDate("enddate");
        if (endDate.after(cPeriodEndDate)) {
            return cPeriod;
        }
        return PeriodHelper.getPeriodByDate(orgId, endDate);
    }

    public static DynamicObject getCashMgtInit(Object orgId) {
        QFilter qFilter = new QFilter("org", "=", orgId);
        DynamicObjectCollection cashMgitInitColl = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty(cashMgitInitColl) || cashMgitInitColl.size() == 0) {
            return null;
        }
        DynamicObject cashMgtInit = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cashMgitInitColl.get(0)).getLong("id"), (String)"cas_cashmgtinit");
        return cashMgtInit;
    }

    public static DynamicObject getBeginPeriodByDate(Long orgId, Date periodDate, Date endDate) {
        if (periodDate == null) {
            return PeriodHelper.getPeriodByDate(orgId, endDate);
        }
        if (endDate.after(periodDate)) {
            return PeriodHelper.getPeriodByDate(orgId, periodDate);
        }
        return PeriodHelper.getPeriodByDate(orgId, endDate);
    }
}

