/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.fi.cas.util.StringUtils;

public class QuotationHelper {
    public static final String INDIRECT_PARITY = "1";
    public static final String DIRECT_PARITY = "0";
    public static final int DF_ROUND = 10;

    public static BigDecimal callToCurrency(BigDecimal amount, BigDecimal rate, String quotation, int round) {
        if (round == 0) {
            round = 10;
        }
        if (StringUtils.isEmpty(quotation) || amount == null || rate == null || BigDecimal.ONE.compareTo(rate) == 0 || BigDecimal.ZERO.compareTo(rate) == 0) {
            return amount;
        }
        if (DIRECT_PARITY.equals(quotation)) {
            return amount.multiply(rate).setScale(round, 4);
        }
        return amount.divide(rate, round, 4);
    }

    public static BigDecimal calAmtByRate(BigDecimal amount, BigDecimal rate, String quotation, int round) {
        if (StringUtils.isEmpty(quotation) || amount == null || rate == null || BigDecimal.ONE.compareTo(rate) == 0 || BigDecimal.ZERO.compareTo(rate) == 0) {
            return amount;
        }
        if (DIRECT_PARITY.equals(quotation)) {
            return amount.multiply(rate).setScale(round, RoundingMode.HALF_UP);
        }
        return amount.divide(rate, round, RoundingMode.HALF_UP);
    }
}

