/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.func.BaseDataBean;
import kd.bos.ext.fi.func.BasedataMatcher;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.ClaimPaymentTypeEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.info.ClaimCoreInfo;
import kd.fi.cas.param.ClaimNoticeMesParam;
import kd.fi.cas.param.RecPayRuleParam;
import kd.fi.cas.util.EmptyUtil;

public class RecClaimHelper {
    private static final Log logger = LogFactory.getLog(RecClaimHelper.class);

    public static DynamicObject[] getAuditNotConfirm(Object[] ids) {
        QFilter filter = new QFilter("id", "in", (Object)ids).and("claimstatus", "=", (Object)ClaimStatusEnum.CLAIMED.getValue());
        DynamicObject[] claimNoticeBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,billno", (QFilter[])new QFilter[]{filter});
        if (!CasHelper.isEmpty(claimNoticeBills)) {
            return claimNoticeBills;
        }
        return null;
    }

    public static DynamicObject[] getClaimNoticeConfirm(Object[] ids) {
        QFilter filter = new QFilter("id", "in", (Object)ids).and(new QFilter("claimstatus", "!=", (Object)ClaimStatusEnum.SURE.getValue()));
        DynamicObject[] claimNoticeBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,claimstatus", (QFilter[])new QFilter[]{filter});
        if (!CasHelper.isEmpty(claimNoticeBills)) {
            return claimNoticeBills;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Long> sendClaimNoticeMessage(Map<Object, Map<String, List<Object>>> claimTypeMap, String noticeType) {
        ArrayList<Long> messIds;
        block19: {
            HashSet allUserId;
            HashMap ruleList;
            block20: {
                messIds = new ArrayList<Long>();
                if (EmptyUtil.isEmpty(claimTypeMap)) break block19;
                Map<String, List<Object>> typeValue = null;
                ruleList = new HashMap(claimTypeMap.size());
                allUserId = new HashSet();
                for (Map.Entry<Object, Map<String, List<Object>>> rule : claimTypeMap.entrySet()) {
                    int i;
                    typeValue = rule.getValue();
                    Iterator userGroupids = typeValue.get("usergroupids");
                    List<Object> list = typeValue.get("orgids");
                    List<Object> roleids = typeValue.get("roleids");
                    List<Object> list2 = typeValue.get("userids");
                    HashSet userIds = new HashSet();
                    if (!EmptyUtil.isEmpty(userGroupids)) {
                        for (i = 0; i < userGroupids.size(); ++i) {
                            DynamicObjectCollection query = QueryServiceHelper.query((String)"fbd_usergroup", (String)"entryentity.userfield", (QFilter[])new QFilter[]{new QFilter("id", "=", userGroupids.get(i)).and("enable", "=", (Object)"1")}, null);
                            userIds.addAll(query.stream().map(o -> o.getLong("entryentity.userfield")).collect(Collectors.toList()));
                        }
                    }
                    if (!EmptyUtil.isEmpty(list) && !EmptyUtil.isEmpty(roleids)) {
                        Set orguserids = UserServiceHelper.getAllUsersOfOrg((int)0, list.stream().map(org -> Long.valueOf(org.toString())).collect(Collectors.toList()), (boolean)true, (boolean)false);
                        List roleuserids = new ArrayList();
                        for (int i2 = 0; i2 < roleids.size(); ++i2) {
                            roleuserids.addAll(PermissionServiceHelper.getUsersByRoleID((String)String.valueOf(roleids.get(i2))));
                        }
                        roleuserids = roleuserids.stream().filter(l -> orguserids.contains(l)).collect(Collectors.toCollection(ArrayList::new));
                        userIds.addAll(roleuserids);
                    } else if (!EmptyUtil.isEmpty(list) && EmptyUtil.isEmpty(roleids)) {
                        userIds.addAll(UserServiceHelper.getAllUsersOfOrg((int)0, list.stream().map(org -> Long.valueOf(org.toString())).collect(Collectors.toList()), (boolean)true, (boolean)false));
                    } else if (!EmptyUtil.isEmpty(roleids) && EmptyUtil.isEmpty(list)) {
                        for (i = 0; i < roleids.size(); ++i) {
                            userIds.addAll(PermissionServiceHelper.getUsersByRoleID((String)String.valueOf(roleids.get(i))));
                        }
                    }
                    if (!EmptyUtil.isEmpty(list2)) {
                        userIds.addAll(list2.stream().filter(EmptyUtil::isNoEmpty).map(u -> Long.valueOf(u.toString())).collect(Collectors.toList()));
                    }
                    ruleList.put(rule.getKey(), userIds);
                    allUserId.addAll(userIds);
                }
                if (!StringUtils.equals((CharSequence)"cancel", (CharSequence)noticeType)) break block20;
                Map<String, List<Object>> claimType = null;
                List<Object> noticeMes = null;
                for (Map.Entry entry : ruleList.entrySet()) {
                    MessageInfo messageInfo = new MessageInfo();
                    messageInfo.setTag(ResManager.loadKDString((String)"\u6536\u4ed8\u8ba4\u9886", (String)"ClaimRecWorkbenchPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    claimType = claimTypeMap.get(entry.getKey());
                    noticeMes = claimType.get("title");
                    if (!EmptyUtil.isEmpty(noticeMes)) {
                        messageInfo.setTitle((String)noticeMes.get(0));
                    }
                    if (!EmptyUtil.isEmpty(noticeMes = claimType.get("content"))) {
                        messageInfo.setContent((String)noticeMes.get(0));
                    }
                    messageInfo.setUserIds(new ArrayList((Collection)entry.getValue()));
                    String string = (String)claimType.get("biztype").get(0);
                    messageInfo.setType(noticeType);
                    messageInfo.setType("message");
                    String formId = "rec".equals(string) ? "bei_intelrec" : "bei_intelpay";
                    String listFormId = "rec".equals(string) ? "bei_intelrec_list" : "bei_intelpay_list";
                    messageInfo.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=" + formId + "&type=list&list_formId=" + listFormId);
                    messIds.add(MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo));
                }
                break block19;
            }
            if (!StringUtils.equals((CharSequence)"notice", (CharSequence)noticeType)) break block19;
            HashMap<Long, Integer> userCount = new HashMap<Long, Integer>(ruleList.size());
            int count = 0;
            for (Long l2 : allUserId) {
                count = 0;
                for (Set set : ruleList.values()) {
                    if (!set.contains(l2)) continue;
                    ++count;
                }
                userCount.put(l2, count);
            }
            HashMap noticeUsers = new HashMap(userCount.size());
            Object var9_15 = null;
            for (Map.Entry entry : userCount.entrySet()) {
                void var9_19;
                Set set = (Set)noticeUsers.get(entry.getValue());
                if (EmptyUtil.isEmpty(set)) {
                    HashSet hashSet = new HashSet();
                }
                var9_19.add(entry.getKey());
                noticeUsers.put(entry.getValue(), var9_19);
            }
            ClaimNoticeMesParam param = null;
            for (Map.Entry notice : noticeUsers.entrySet()) {
                param = new ClaimNoticeMesParam();
                param.setTag(ResManager.loadKDString((String)"\u6536\u4ed8\u8ba4\u9886", (String)"ClaimRecWorkbenchPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                param.setTitle(String.format(ResManager.loadKDString((String)"%s\u7b14\u6b3e\u9879\u9700\u8981\u8ba4\u9886\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406", (String)"RecClaimHelper_2", (String)"fi-cas-common", (Object[])new Object[0]), notice.getKey()));
                param.setContent(ResManager.loadKDString((String)"\u8bf7\u8fdb\u5165PC\u7aef\"\u6536\u4ed8\u8ba4\u9886->\u8ba4\u9886\u516c\u544a\"\u83dc\u5355,\u6216\u70b9\u51fb\u4ee5\u4e0b\u94fe\u63a5\u8fdb\u884c\u5904\u7406\u3002", (String)"RecClaimHelper_3", (String)"fi-cas-common", (Object[])new Object[0]));
                param.setUserIds((Set)notice.getValue());
                param.setNoticeType(noticeType);
                messIds.add(RecClaimHelper.sendNoticeMessage(param));
            }
        }
        return messIds;
    }

    public static Long sendNoticeMessage(ClaimNoticeMesParam param) {
        MessageInfo message = new MessageInfo();
        message.setTag(param.getTag());
        message.setTitle(param.getTitle());
        message.setContent(param.getContent());
        if (StringUtils.equals((CharSequence)"reject", (CharSequence)param.getNoticeType())) {
            String accountId = RequestContext.get().getAccountId();
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=cas_claimbill&pkId=" + param.getPkId());
            String url = String.format("%s/mobile.html?form=cas_claimbill_m&app=tr&pkId=%s&accountId=%s", UrlService.getDomainContextUrl(), param.getPkId(), accountId);
            message.setMobContentUrl(url);
            message.setType("casmessage");
        } else if (StringUtils.equals((CharSequence)"notice", (CharSequence)param.getNoticeType())) {
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=cas_claimannounce&type=list&list_formId=cas_claim");
            String accountId = RequestContext.get().getAccountId();
            String url = String.format("%s/mobile.html?form=cas_claimnotice_m&app=tr&accountId=%s", UrlService.getDomainContextUrl(), accountId);
            message.setMobContentUrl(url);
            message.setType("casmessage");
        } else if (StringUtils.equals((CharSequence)"pay", (CharSequence)param.getNoticeType())) {
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=bei_bankpaybill&pkId=" + param.getPkId());
            message.setNotifyType(MessageChannels.MC.getNumber());
            message.setType("message");
        } else if (StringUtils.equals((CharSequence)"agentpay", (CharSequence)param.getNoticeType())) {
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=bei_bankagentpay&pkId=" + param.getPkId());
            message.setType("message");
        } else if (StringUtils.equals((CharSequence)"chargeback", (CharSequence)param.getNoticeType())) {
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=cas_claimcenterbill&pkId=" + param.getPkId());
            message.setType("casmessage");
        } else if (StringUtils.equals((CharSequence)"payInfoChg", (CharSequence)param.getNoticeType())) {
            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=cas_paychgbill&type=list&list_formId=bos_list");
            message.setType("message");
        } else if (StringUtils.equals((CharSequence)"cancel", (CharSequence)param.getNoticeType())) {
            message.setType("casmessage");
        }
        message.setUserIds(new ArrayList<Long>(param.getUserIds()));
        return MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    public static void updateClaimStatus(String claimNo, Set<String> noUpdateBillNos, String updateStatus) {
        if (EmptyUtil.isNoEmpty(claimNo) && EmptyUtil.isNoEmpty(updateStatus)) {
            Object[] colls;
            QFilter qFilter = new QFilter("claimno", "=", (Object)claimNo);
            if (EmptyUtil.isNoEmpty(noUpdateBillNos)) {
                qFilter.and(new QFilter("billno", "not in", noUpdateBillNos));
            }
            if (EmptyUtil.isNoEmpty(colls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,claimstatus", (QFilter[])new QFilter[]{qFilter}))) {
                DynamicObject[] dys = new DynamicObject[colls.length];
                Object dynamicObject = null;
                for (int i = 0; i < colls.length; ++i) {
                    dynamicObject = colls[i];
                    if (StringUtils.equals((CharSequence)updateStatus, (CharSequence)dynamicObject.getString("claimstatus"))) {
                        return;
                    }
                    dynamicObject.set("claimstatus", (Object)updateStatus);
                    dys[i] = dynamicObject;
                }
                SaveServiceHelper.save((DynamicObject[])dys);
            }
        }
    }

    public static List<DynamicObject> getAllChildNoticeBill(Object noticePk) {
        ArrayList<DynamicObject> childNoticeSet = new ArrayList<DynamicObject>();
        if (EmptyUtil.isNoEmpty(noticePk)) {
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)noticePk, (String)"cas_claimcenterbill");
            Object[] childNotices = RecClaimHelper.getChildNoticeBill(loadSingle.getPkValue());
            if (EmptyUtil.isNoEmpty(childNotices)) {
                for (Object dynamicObject : childNotices) {
                    childNoticeSet.addAll(RecClaimHelper.getAllChildNoticeBill(dynamicObject.getPkValue()));
                }
            } else {
                childNoticeSet.add(loadSingle);
            }
        }
        return childNoticeSet;
    }

    public static DynamicObject[] getChildNoticeBill(Object noticePk) {
        QFilter margeid = new QFilter("margeid", "=", noticePk);
        return BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id", (QFilter[])new QFilter[]{margeid});
    }

    public static HashMap<Long, BigDecimal> getAllChildNoticeBill(DynamicObject[] claimNoticeDts) {
        HashMap<Long, BigDecimal> claimNoticeTranMap = new HashMap<Long, BigDecimal>();
        ArrayList<Long> margeIdList = new ArrayList<Long>(10);
        for (DynamicObject claimNoticeDt : claimNoticeDts) {
            Long sourceId = claimNoticeDt.getLong("sourceid");
            if (!CasHelper.isEmpty(sourceId)) continue;
            margeIdList.add(claimNoticeDt.getLong("id"));
        }
        QFilter margeid = new QFilter("margeid", "in", margeIdList);
        DynamicObject[] claimMargeBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,margeid,sourceid,reamount", (QFilter[])new QFilter[]{margeid});
        Map<Long, List<DynamicObject>> claimNoticeMargeTranceMap = Arrays.stream(claimMargeBills).collect(Collectors.groupingBy(o -> o.getLong("margeid")));
        for (DynamicObject info : claimNoticeDts) {
            Long claimNoticeId = info.getLong("id");
            List<DynamicObject> claimNoticeList = claimNoticeMargeTranceMap.get(claimNoticeId);
            if (null == claimNoticeList) continue;
            for (DynamicObject claimNotice : claimNoticeList) {
                long sourceid = claimNotice.getLong("sourceid");
                BigDecimal reamount = claimNotice.getBigDecimal("reamount");
                claimNoticeTranMap.put(sourceid, reamount);
            }
        }
        return claimNoticeTranMap;
    }

    public static HashMap<Object, List<Object>> getAllChildNoticeBatchBill(DynamicObject[] claimNoticeDts) {
        HashMap<Object, List<Object>> claimNoticeTranMap = new HashMap<Object, List<Object>>();
        HashMap<Object, Long> claimNoticeTransMap = new HashMap<Object, Long>(10);
        ArrayList<Long> margeIdList = new ArrayList<Long>(10);
        for (DynamicObject claimNoticeDt : claimNoticeDts) {
            Long sourceId = claimNoticeDt.getLong("sourceid");
            if (CasHelper.isNotEmpty(sourceId)) {
                claimNoticeTransMap.put(claimNoticeDt.getPkValue(), claimNoticeDt.getLong("sourceid"));
                continue;
            }
            margeIdList.add(claimNoticeDt.getLong("id"));
        }
        QFilter margeid = new QFilter("margeid", "in", margeIdList);
        DynamicObject[] claimMargeBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,margeid,sourceid", (QFilter[])new QFilter[]{margeid});
        Map<Long, List<DynamicObject>> claimNoticeMargeTranceMap = Arrays.stream(claimMargeBills).collect(Collectors.groupingBy(o -> o.getLong("margeid")));
        for (DynamicObject info : claimNoticeDts) {
            ArrayList<Long> sourceIdList = new ArrayList<Long>();
            Long claimNoticeId = info.getLong("id");
            Long tranceId = (Long)claimNoticeTransMap.get(claimNoticeId);
            if (CasHelper.isNotEmpty(tranceId)) {
                sourceIdList.add(tranceId);
            } else {
                List<DynamicObject> claimNoticeList = claimNoticeMargeTranceMap.get(claimNoticeId);
                if (null == claimNoticeList) continue;
                List sourceid = claimNoticeList.stream().map(o -> o.getLong("sourceid")).collect(Collectors.toList());
                sourceIdList.addAll(sourceid);
            }
            claimNoticeTranMap.put(claimNoticeId, sourceIdList);
        }
        return claimNoticeTranMap;
    }

    public static void matchInfo(RecPayRuleParam recPayRuleParam) {
        BaseDataBean baseDataBean;
        if (EmptyUtil.isEmpty(recPayRuleParam) || EmptyUtil.isNoEmpty(recPayRuleParam.getPayer())) {
            return;
        }
        boolean isCustomer = false;
        boolean isSupplier = false;
        if (recPayRuleParam.getIsMatch()) {
            String saveNotifiTAG = recPayRuleParam.getSaveNotifiTAG();
            if (EmptyUtil.isNoEmpty(saveNotifiTAG)) {
                if (saveNotifiTAG.contains("IsCustomer()")) {
                    isCustomer = true;
                }
                if (saveNotifiTAG.contains("IsSupplier()")) {
                    isSupplier = true;
                }
            }
        } else {
            isCustomer = true;
            isSupplier = true;
        }
        if (isCustomer && (baseDataBean = new BasedataMatcher().dealBotpCustomerOrSupplier(AsstActTypeEnum.CUSTOMER.getValue(), String.valueOf(recPayRuleParam.getOppBankNumber()), String.valueOf(recPayRuleParam.getName()), recPayRuleParam.getOrg())) != null) {
            recPayRuleParam.setPayerType(ClaimPaymentTypeEnum.CUSTOMER.getValue());
            recPayRuleParam.setPayer(baseDataBean.getPkId());
            return;
        }
        if (isSupplier && (baseDataBean = new BasedataMatcher().dealBotpCustomerOrSupplier(AsstActTypeEnum.SUPPLIER.getValue(), String.valueOf(recPayRuleParam.getOppBankNumber()), String.valueOf(recPayRuleParam.getName()), recPayRuleParam.getOrg())) != null) {
            recPayRuleParam.setPayerType(baseDataBean.getEntity());
            recPayRuleParam.setPayer(baseDataBean.getPkId());
        }
    }

    public static QFilter getAuthorityQfilter() {
        DynamicObject[] userGroups;
        Set rolesByUsers;
        ArrayList<String> claimtypeids = new ArrayList<String>(100);
        String userId = RequestContext.get().getUserId();
        claimtypeids.add(userId);
        List orgs = PermissionServiceHelper.getUserOrgs((long)Long.parseLong(userId));
        if (orgs != null) {
            ArrayList userOrgs = new ArrayList();
            orgs.forEach(org -> {
                if (!CasHelper.isEmpty(org)) {
                    userOrgs.add(String.valueOf(org));
                }
            });
            if (userOrgs.size() > 0) {
                claimtypeids.addAll(userOrgs);
            }
        }
        if ((rolesByUsers = PermissionServiceHelper.getRolesByUser((Long)Long.parseLong(userId))).size() > 0) {
            claimtypeids.addAll(rolesByUsers);
        }
        if ((userGroups = BusinessDataServiceHelper.load((String)"fbd_usergroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.userfield", "=", (Object)Long.parseLong(userId)).and("enable", "=", (Object)"1")})) != null && userGroups.length > 0) {
            List<Long> idList = CasHelper.getIdList(userGroups);
            List idStrList = idList.stream().map(s -> s.toString()).collect(Collectors.toList());
            claimtypeids.addAll(idStrList);
        }
        return new QFilter("entryentity1.claimtypeid", "in", claimtypeids);
    }

    public static Boolean getCacheUserPermission(Long userId, String appId, String entityId, String permItem) {
        IAppCache cache = AppCache.get((String)"cas..TmcOrgDataHelper");
        String key = userId + "-" + entityId + "-" + permItem;
        cache.remove(key);
        String value = (String)cache.get(key, String.class);
        if (CasHelper.isEmpty(value)) {
            HasPermOrgResult result;
            if (CasHelper.isNotEmpty(appId)) {
                appId = AppMetadataCache.getAppInfo((String)appId).getId();
            }
            if ((result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityId, (String)permItem)).hasAllOrgPerm()) {
                return true;
            }
        }
        return false;
    }

    public static void openCoreBillNo(IFormView iFormView, int rowIndex) {
        String entityId = iFormView.getEntityId();
        String entryName = "entryentity";
        if ("cas_recbill".equals(entityId)) {
            entryName = "entry";
        }
        String propertyName = "billno";
        DynamicObject entryRowEntity = iFormView.getModel().getEntryRowEntity(entryName, rowIndex);
        String corebilltype = entryRowEntity.getString("e_corebilltype");
        if (EntityMetadataCache.getDataEntityType((String)corebilltype).getProperty(propertyName) == null) {
            return;
        }
        String corebillno = entryRowEntity.getString("e_corebillno");
        QFilter billno = new QFilter(propertyName, "=", (Object)corebillno);
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)corebilltype, (String)"id", (QFilter[])new QFilter[]{billno});
        if (ids.length < 1) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u6b64\u6838\u5fc3\u5355\u636e\u53f7\u5bf9\u5e94\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5", (String)"RecClaimHelper_0", (String)"fi-cas-common", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(corebilltype);
        showParameter.setPkId(ids[0].getPkValue());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        iFormView.showForm((FormShowParameter)showParameter);
    }

    public static String validateAmount(DynamicObject dynamicObject) {
        String claimNo;
        QFilter claimNoQ;
        Object[] colls;
        String valuedateInfo = "";
        boolean isExcess = SystemParameterHelper.getParameterBoolean(dynamicObject.getDynamicObject("org").getLong("id"), "cs120");
        if (!isExcess && EmptyUtil.isNoEmpty(colls = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,unclaimamount, reamount", (QFilter[])new QFilter[]{claimNoQ = new QFilter("billno", "=", (Object)(claimNo = dynamicObject.getString("claimno"))).and(new QFilter("claimstatus", "in", (Object)new String[]{ClaimStatusEnum.PART.getValue(), ClaimStatusEnum.CLAIMED.getValue()}))}))) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            BigDecimal sumact = entryentity.stream().map(dy -> dy.getBigDecimal("e_actamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal reamount = colls[0].getBigDecimal("reamount");
            BigDecimal unclaimamount = colls[0].getBigDecimal("unclaimamount");
            if (reamount.compareTo(BigDecimal.ZERO) > 0 && sumact.compareTo(unclaimamount) > 0) {
                valuedateInfo = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8d85\u989d\u8ba4\u9886\uff0c\u5373\u8ba4\u9886\u5355\u660e\u7ec6\u7684\u201c\u5b9e\u6536\u91d1\u989d\u201d\u5408\u8ba1\uff0c\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u672a\u8ba4\u9886\u91d1\u989d\u3002", (String)"RecClaimHelper_1", (String)"fi-cas-common", (Object[])new Object[0]);
            } else if (reamount.compareTo(BigDecimal.ZERO) < 0 && sumact.compareTo(unclaimamount) < 0) {
                valuedateInfo = ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u4e3a\u8d1f\u6570\uff0c\u4e0d\u5141\u8bb8\u8d85\u989d\u8ba4\u9886\uff0c\u5373\u8ba4\u9886\u5355\u660e\u7ec6\u7684\u201c\u5b9e\u6536\u91d1\u989d\u201d\u5408\u8ba1\uff0c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u672a\u8ba4\u9886\u91d1\u989d\u3002", (String)"RecClaimHelper_4", (String)"fi-cas-common", (Object[])new Object[0]);
            }
        }
        return valuedateInfo;
    }

    public static List<ClaimCoreInfo> getDelClaimCoreInfo(DynamicObject claim, List<ClaimCoreInfo> claimCoreInfoList) {
        DynamicObjectCollection entryentity = claim.getDynamicObjectCollection("entryentity");
        if (EmptyUtil.isNoEmpty(entryentity)) {
            List entryDtList = entryentity.stream().filter(o -> "ar_finarbill".equals(o.getString("e_corebilltype")) && o.getBoolean("claimcomtrol")).collect(Collectors.toList());
            Map<String, List<DynamicObject>> claimMap = entryDtList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getString("e_corebillid"))).collect(Collectors.groupingBy(o -> o.getString("e_corebillid") + "-" + o.getString("e_corebillentryid")));
            claimMap.forEach((coreId, dtList) -> {
                ClaimCoreInfo claimCoreInfo = new ClaimCoreInfo();
                BigDecimal receivableamt = dtList.stream().map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                String[] split = coreId.split("-");
                if (CasHelper.isNotEmpty(split) && split.length > 0) {
                    claimCoreInfo.setCoreBillId(Long.valueOf(split[0]));
                    if (split.length > 1) {
                        claimCoreInfo.setCoreBillEntryId(Long.valueOf(split[1]));
                    }
                }
                String claimDimenSion = ((DynamicObject)dtList.get(0)).getString("claimdimension");
                boolean claimComtrol = ((DynamicObject)dtList.get(0)).getBoolean("claimcomtrol");
                claimCoreInfo.setClaimDimension(claimDimenSion);
                claimCoreInfo.setClaimComrol(claimComtrol);
                claimCoreInfo.setRecAmt(receivableamt.negate());
                claimCoreInfo.setRecDiffAmt(receivableamt.negate());
                claimCoreInfoList.add(claimCoreInfo);
            });
        }
        return claimCoreInfoList;
    }

    public static List<ClaimCoreInfo> getClaimCoreInfo(DynamicObject claim, DynamicObject dbClaim, List<ClaimCoreInfo> claimCoreInfoList) {
        DynamicObjectCollection entryentity = claim.getDynamicObjectCollection("entryentity");
        HashSet coreIdStr = new HashSet(16);
        if (EmptyUtil.isNoEmpty(entryentity)) {
            List entryDtList = entryentity.stream().filter(o -> "ar_finarbill".equals(o.getString("e_corebilltype")) && CasHelper.isNotEmpty(o.getString("claimdimension"))).collect(Collectors.toList());
            Map<String, List<DynamicObject>> claimMap = entryDtList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getString("e_corebillid"))).collect(Collectors.groupingBy(o -> o.getString("e_corebillid") + "-" + o.getString("e_corebillentryid")));
            claimMap.forEach((coreId, dtList) -> {
                coreIdStr.add(coreId);
                RecClaimHelper.makeClaimCore(claimCoreInfoList, coreId, dtList, false);
            });
        }
        if (null != dbClaim) {
            Map claimCoreInfoMap = claimCoreInfoList.stream().collect(Collectors.toMap(o -> o.getCoreBillId() + "-" + o.getCoreBillEntryId(), Function.identity()));
            DynamicObjectCollection dbEntry = dbClaim.getDynamicObjectCollection("entryentity");
            List DbEntryDtList = dbEntry.stream().filter(o -> "ar_finarbill".equals(o.getString("e_corebilltype")) && CasHelper.isNotEmpty(o.getString("claimdimension"))).collect(Collectors.toList());
            if (null != DbEntryDtList && DbEntryDtList.size() > 0) {
                Map<String, List<DynamicObject>> claimDbMap = DbEntryDtList.stream().filter(k -> StringUtils.isNotEmpty((CharSequence)k.getString("e_corebillid"))).collect(Collectors.groupingBy(o -> o.getString("e_corebillid") + "-" + o.getString("e_corebillentryid")));
                claimDbMap.forEach((coreId, dtList) -> {
                    if (!coreIdStr.contains(coreId)) {
                        RecClaimHelper.makeClaimCore(claimCoreInfoList, coreId, dtList, true);
                    } else {
                        ClaimCoreInfo claimCoreInfo = (ClaimCoreInfo)claimCoreInfoMap.get(coreId);
                        BigDecimal dbAmt = dtList.stream().map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                        BigDecimal diffAmt = claimCoreInfo.getRecAmt().subtract(dbAmt);
                        claimCoreInfo.setRecDiffAmt(diffAmt);
                    }
                });
            }
        }
        return claimCoreInfoList;
    }

    private static void makeClaimCore(List<ClaimCoreInfo> claimCoreInfoList, String coreId, List<DynamicObject> dtList, boolean diffBool) {
        ClaimCoreInfo claimCoreInfo = new ClaimCoreInfo();
        BigDecimal receivableamt = dtList.stream().map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        String[] split = coreId.split("-");
        if (CasHelper.isNotEmpty(split) && split.length > 0) {
            claimCoreInfo.setCoreBillId(Long.valueOf(split[0]));
            if (split.length > 1) {
                claimCoreInfo.setCoreBillEntryId(Long.valueOf(split[1]));
            }
        }
        String claimDimenSion = dtList.get(0).getString("claimdimension");
        boolean claimComtrol = dtList.get(0).getBoolean("claimcomtrol");
        claimCoreInfo.setClaimDimension(claimDimenSion);
        claimCoreInfo.setClaimComrol(claimComtrol);
        claimCoreInfo.setRecAmt(receivableamt);
        claimCoreInfo.setRecDiffAmt(diffBool ? receivableamt.negate() : receivableamt);
        claimCoreInfoList.add(claimCoreInfo);
    }

    public static void writeBackAmt(List<ClaimCoreInfo> coreInfoList) {
        ArrayList paramList = new ArrayList(coreInfoList.size());
        for (ClaimCoreInfo claimCoreInfo : coreInfoList) {
            BigDecimal recDiffAmt = claimCoreInfo.getRecDiffAmt();
            if (BigDecimal.ZERO.compareTo(recDiffAmt) == 0) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("corebillid", claimCoreInfo.getCoreBillId());
            map.put("corebillentryid", claimCoreInfo.getCoreBillEntryId());
            map.put("recamt", claimCoreInfo.getRecAmt());
            map.put("recdiffamt", claimCoreInfo.getRecDiffAmt());
            map.put("claimdimension", claimCoreInfo.getClaimDimension());
            map.put("claimcomrol", claimCoreInfo.isClaimComrol());
            map.put("needbuildjournal", Boolean.TRUE);
            paramList.add(map);
        }
        if (paramList.size() > 0) {
            logger.info("begin ReceiptClaimSetlleService : " + paramList);
            List msgList = (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"ReceiptClaimSetlleService", (String)"writebackFinArBillLockAmt", (Object[])new Object[]{paramList});
            if (EmptyUtil.isNoEmpty(msgList) && msgList.size() > 0) {
                StringBuilder buf = new StringBuilder();
                for (String msg : msgList) {
                    buf.append(msg).append('\n');
                }
                throw new KDBizException(buf.toString());
            }
        }
    }

    public static void setRefundDetailId(DynamicObject sourceClaimNoticeBill, DynamicObject targetRecBill) {
        if ("bei_transdetail".equals(sourceClaimNoticeBill.getString("sourcetype"))) {
            long claimNoticeSourceId = sourceClaimNoticeBill.getLong("sourceid");
            if (EmptyUtil.isEmpty(claimNoticeSourceId)) {
                return;
            }
            QFilter transFilter = new QFilter("id", "=", (Object)claimNoticeSourceId);
            DynamicObject transDetail = QueryServiceHelper.queryOne((String)"bei_transdetail_cas", (String)"id,refundsource", (QFilter[])transFilter.toArray());
            if (transDetail != null && StringUtils.isNotBlank((CharSequence)transDetail.getString("refundsource"))) {
                targetRecBill.set("refunddetailid", transDetail.get("id"));
            }
        }
    }
}

