/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.ChangeStatusEnum;
import kd.fi.cas.enums.ChgTypeEnum;
import kd.fi.cas.enums.SBillTypeEnum;
import kd.fi.cas.util.EmptyUtil;

public class SBillTypeHelper {
    private static Log logger = LogFactory.getLog(SBillTypeHelper.class);
    private static final String SQL_UPDATE_AGPAYBILL = "update t_cas_agentpaybill_e set fchangestatus = ? where fid = ? and fchangestatus in('unchange','changing','changed')";
    private static final String SQL_UPDATE_PAYMENTBILL = "update t_cas_paymentbill_e set fchangestatus = ? where fid = ? and fchangestatus in('unchange','changing','changed')";

    public static void setSBillType(DynamicObject[] payChgBills) {
        ArrayList<Long> payApplyBillIds = new ArrayList<Long>();
        ArrayList<Long> paymentBillIds = new ArrayList<Long>();
        ArrayList<Long> agentPayBillIds = new ArrayList<Long>();
        SBillTypeHelper.splitDifList(payChgBills, payApplyBillIds, paymentBillIds, agentPayBillIds);
        DynamicObject[] payApplyBills = BusinessDataServiceHelper.load((String)"cas_payapplybill", (String)"id", (QFilter[])new QFilter("id", "in", payApplyBillIds).toArray());
        DynamicObject[] paymentBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"billtype", (QFilter[])new QFilter("id", "in", paymentBillIds).toArray());
        DynamicObject[] agentPayBills = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"billtype", (QFilter[])new QFilter("id", "in", agentPayBillIds).toArray());
        for (DynamicObject payChgBill : payChgBills) {
            if (StringUtils.isNotEmpty((CharSequence)payChgBill.getString("sbilltype"))) continue;
            for (DynamicObject payApplyBill : payApplyBills) {
                if (!Objects.equals(payChgBill.get("sourcebillid"), payApplyBill.getPkValue())) continue;
                payChgBill.set("sbilltype", (Object)SBillTypeEnum.PAY_APPLY.getValue());
            }
            for (DynamicObject paymentBill : paymentBills) {
                if (!Objects.equals(payChgBill.get("sourcebillid"), paymentBill.getPkValue())) continue;
                SBillTypeHelper.setPaymentBillSBillType(payChgBill, paymentBill);
            }
            for (DynamicObject agentPayBill : agentPayBills) {
                if (!Objects.equals(payChgBill.get("sourcebillid"), agentPayBill.getPkValue())) continue;
                SBillTypeHelper.setAgentPayBillSBillType(payChgBill, agentPayBill);
            }
        }
    }

    private static void splitDifList(DynamicObject[] payChgBills, List<Long> payApplyBillIds, List<Long> paymentBillIds, List<Long> agentPayBillIds) {
        for (DynamicObject payChgBill : payChgBills) {
            String sourceType = payChgBill.getString("sourcetype");
            if (Objects.equals(sourceType, "cas_payapplybill")) {
                payApplyBillIds.add(payChgBill.getLong("sourcebillid"));
                continue;
            }
            if (Objects.equals(sourceType, "cas_paybill")) {
                paymentBillIds.add(payChgBill.getLong("sourcebillid"));
                continue;
            }
            if (!Objects.equals(sourceType, "cas_agentpaybill")) continue;
            agentPayBillIds.add(payChgBill.getLong("sourcebillid"));
        }
    }

    private static void updateBill(DynamicObject[] paymentBills, String sql, String changeStaus) {
        if (EmptyUtil.isNoEmpty(paymentBills)) {
            for (DynamicObject paymentBill : paymentBills) {
                Long billId = paymentBill.getLong("id");
                int result = DB.update((DBRoute)DBRouteConst.cas, (String)sql, (Object[])new Object[]{changeStaus, billId});
                logger.info("update bill sql result,billId:" + billId + ";result:" + result);
                if (result >= 1) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e90\u4ee3\u53d1\u5355\u3010%1$s\u3011\u66f4\u65b0\u53d8\u66f4\u72b6\u6001\u4e0d\u6210\u529f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"PaySureRecChgOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), paymentBill.getString("billno")));
            }
        }
    }

    public static void setSBillTypeForSave(DynamicObject[] payChgBills) {
        ArrayList<Long> payApplyBillIds = new ArrayList<Long>();
        ArrayList<Long> paymentBillIds = new ArrayList<Long>();
        ArrayList<Long> agentPayBillIds = new ArrayList<Long>();
        SBillTypeHelper.splitDifList(payChgBills, payApplyBillIds, paymentBillIds, agentPayBillIds);
        DynamicObject[] payApplyBills = BusinessDataServiceHelper.load((String)"cas_payapplybill", (String)"id", (QFilter[])new QFilter("id", "in", payApplyBillIds).toArray());
        DynamicObject[] paymentBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billtype,changestatus,billno,isdiffcur,currency,dpcurrency", (QFilter[])new QFilter("id", "in", paymentBillIds).toArray());
        DynamicObject[] agentPayBills = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"id,billtype,changestatus,billno", (QFilter[])new QFilter("id", "in", agentPayBillIds).toArray());
        String changeStaus = ChangeStatusEnum.CHANGING.getValue();
        SBillTypeHelper.updateBill(paymentBills, SQL_UPDATE_PAYMENTBILL, changeStaus);
        SBillTypeHelper.updateBill(agentPayBills, SQL_UPDATE_AGPAYBILL, changeStaus);
        for (DynamicObject payChgBill : payChgBills) {
            if (StringUtils.isNotEmpty((CharSequence)payChgBill.getString("sbilltype"))) continue;
            for (DynamicObject payApplyBill : payApplyBills) {
                if (!Objects.equals(payChgBill.get("sourcebillid"), payApplyBill.getPkValue())) continue;
                payChgBill.set("sbilltype", (Object)SBillTypeEnum.PAY_APPLY.getValue());
            }
            for (DynamicObject paymentBill : paymentBills) {
                if (!Objects.equals(payChgBill.get("sourcebillid"), paymentBill.getPkValue())) continue;
                SBillTypeHelper.setPaymentBillSBillType(payChgBill, paymentBill);
                if (!ChgTypeEnum.PAYCHG.getValue().equals(payChgBill.getString("chgtype")) || !paymentBill.getBoolean("isdiffcur")) continue;
                payChgBill.set("sourcecurrency", paymentBill.get("dpcurrency"));
            }
            for (DynamicObject agentPayBill : agentPayBills) {
                if (!Objects.equals(payChgBill.get("sourcebillid"), agentPayBill.getPkValue())) continue;
                SBillTypeHelper.setAgentPayBillSBillType(payChgBill, agentPayBill);
            }
        }
    }

    private static void setAgentPayBillSBillType(DynamicObject payChgBill, DynamicObject sourceBill) {
        DynamicObject billType = sourceBill.getDynamicObject("billtype");
        if (Objects.nonNull(billType)) {
            Object billTypeId = billType.getPkValue();
            if (Objects.equals(billTypeId, 343122285806233600L)) {
                payChgBill.set("sbilltype", (Object)SBillTypeEnum.EXPENSES.getValue());
            } else if (Objects.equals(billTypeId, 343121063871251456L)) {
                payChgBill.set("sbilltype", (Object)SBillTypeEnum.WAGE_PAYMENT.getValue());
            }
        }
    }

    private static void setPaymentBillSBillType(DynamicObject payChgBill, DynamicObject sourceBill) {
        DynamicObject billType;
        if (Objects.nonNull(sourceBill) && Objects.nonNull(billType = sourceBill.getDynamicObject("billtype"))) {
            Object billTypeId = billType.getPkValue();
            if (Objects.equals(billTypeId, BillTypeConstants.PAYBILL_CASH)) {
                payChgBill.set("sbilltype", (Object)SBillTypeEnum.CASH_ACCESS.getValue());
            } else if (Objects.equals(billTypeId, BillTypeConstants.PAYBILL_EXP)) {
                payChgBill.set("sbilltype", (Object)SBillTypeEnum.OTHER_SETTLEMENT.getValue());
            } else if (Objects.equals(billTypeId, BillTypeConstants.PAYBILL_OTR)) {
                payChgBill.set("sbilltype", (Object)SBillTypeEnum.OTHER.getValue());
            } else if (Objects.equals(billTypeId, BillTypeConstants.PAYBILL_PUR)) {
                payChgBill.set("sbilltype", (Object)SBillTypeEnum.PURCHASE.getValue());
            } else if (Objects.equals(billTypeId, BillTypeConstants.PAYBILL_SPAN)) {
                payChgBill.set("sbilltype", (Object)SBillTypeEnum.SPAN.getValue());
            } else if (Objects.equals(billTypeId, BillTypeConstants.PAYBILL_SYN)) {
                payChgBill.set("sbilltype", (Object)SBillTypeEnum.TRANSFER_SAME.getValue());
            }
        }
    }

    private SBillTypeHelper() {
    }
}

