/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.DynamicObjectHelper;

public class CashMgtInitAction {
    private static final String[] field1 = new String[]{"cash_yeardebit", "cash_yearcredit", "cash_balance"};
    private static final String[] field2 = new String[]{"bank_journaldebit", "bank_journalcredit", "bank_journalbalance"};

    public static CashMgtInitAction getInstance() {
        return Singleton.instance;
    }

    public void execute(DynamicObject[] cashMgtInits) {
        List<DynamicObject> dealCashMgtInit = this.delNullEntry(cashMgtInits);
        SaveServiceHelper.save((DynamicObject[])dealCashMgtInit.toArray(new DynamicObject[0]));
        List<DynamicObject> cashList = this.createCashes(cashMgtInits);
        SaveServiceHelper.save((DynamicObject[])cashList.toArray(new DynamicObject[0]));
        Map<String, List<DynamicObject>> banks = this.createBank(cashMgtInits);
        List<DynamicObject> bankList = banks.get("bankList");
        SaveServiceHelper.save((DynamicObject[])bankList.toArray(new DynamicObject[0]));
        List<DynamicObject> finalCheckouts = this.finalCheckout(cashMgtInits);
        SaveServiceHelper.save((DynamicObject[])finalCheckouts.toArray(new DynamicObject[0]));
        CashMgtInitAction.initBalanceAccounts(cashMgtInits);
    }

    private List<DynamicObject> delNullEntry(DynamicObject[] cashMgtInits) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        for (DynamicObject cashMgtInit : cashMgtInits) {
            DynamicObjectCollection cash = cashMgtInit.getDynamicObjectCollection("entrycash");
            for (int i = cash.size() - 1; i >= 0; --i) {
                String[] strFields;
                DynamicObject dynamicObject = (DynamicObject)cash.get(i);
                if (!CashMgtInitAction.valueEqualsZero(dynamicObject, strFields = field1)) continue;
                cash.remove(i);
            }
            DynamicObjectCollection bank = cashMgtInit.getDynamicObjectCollection("entrybank");
            for (int i = bank.size() - 1; i >= 0; --i) {
                String[] strFields;
                DynamicObject dynamicObject = (DynamicObject)bank.get(i);
                if (!CashMgtInitAction.valueEqualsZero(dynamicObject, strFields = field2)) continue;
                bank.remove(i);
            }
            result.add(cashMgtInit);
        }
        return result;
    }

    private List<DynamicObject> createCashes(DynamicObject[] cashMgtInits) {
        ArrayList<DynamicObject> cashes = new ArrayList<DynamicObject>(16);
        for (DynamicObject cashMgtInit : cashMgtInits) {
            DynamicObjectCollection entryCashList = cashMgtInit.getDynamicObjectCollection("entrycash");
            for (DynamicObject entryCash : entryCashList) {
                DynamicObject journalbalance = BusinessDataServiceHelper.newDynamicObject((String)"cas_journalbalance");
                DynamicObjectHelper.setValue(journalbalance, "type", "1");
                DynamicObjectHelper.setValue(journalbalance, "enable", 1);
                DynamicObjectHelper.setValue(journalbalance, "ctrlstrategy", 5);
                DynamicObjectHelper.setValue(journalbalance, "creator", cashMgtInit.getDynamicObject("creator"));
                DynamicObjectHelper.setValue(journalbalance, "createtime", cashMgtInit.getDate("createtime"));
                DynamicObjectHelper.setValue(journalbalance, "org", cashMgtInit.getDynamicObject("org"));
                DynamicObjectHelper.setValue(journalbalance, "period", cashMgtInit.getDynamicObject("startperiod"));
                DynamicObjectHelper.setValue(journalbalance, "accountcash", entryCash.getDynamicObject("cash_accountcash"));
                DynamicObjectHelper.setValue(journalbalance, "currency", entryCash.getDynamicObject("cash_currency"));
                DynamicObjectHelper.setValue(journalbalance, "monthstart", entryCash.getBigDecimal("cash_balance"));
                DynamicObjectHelper.setValue(journalbalance, "monthdebit", new BigDecimal(0));
                DynamicObjectHelper.setValue(journalbalance, "monthcredit", new BigDecimal(0));
                DynamicObjectHelper.setValue(journalbalance, "monthbalance", entryCash.getBigDecimal("cash_balance"));
                DynamicObjectHelper.setValue(journalbalance, "yearstart", entryCash.getBigDecimal("cash_balance").subtract(entryCash.getBigDecimal("cash_yeardebit")).add(entryCash.getBigDecimal("cash_yearcredit")));
                DynamicObjectHelper.setValue(journalbalance, "yeardebit", entryCash.getBigDecimal("cash_yeardebit"));
                DynamicObjectHelper.setValue(journalbalance, "yearcredit", entryCash.getBigDecimal("cash_yearcredit"));
                DynamicObjectHelper.setValue(journalbalance, "yearbalance", entryCash.getBigDecimal("cash_balance"));
                DynamicObjectHelper.setValue(journalbalance, "isbalanced", 0);
                cashes.add(journalbalance);
            }
        }
        return cashes;
    }

    private Map<String, List<DynamicObject>> createBank(DynamicObject[] cashMgtInits) {
        ArrayList checkResults = new ArrayList(16);
        ArrayList<DynamicObject> banks = new ArrayList<DynamicObject>(16);
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject cashMgtInit : cashMgtInits) {
            DynamicObjectCollection entryBankList = cashMgtInit.getDynamicObjectCollection("entrybank");
            for (DynamicObject entrybank : entryBankList) {
                DynamicObject journalbalance = BusinessDataServiceHelper.newDynamicObject((String)"cas_journalbalance");
                DynamicObjectHelper.setValue(journalbalance, "type", "2");
                DynamicObjectHelper.setValue(journalbalance, "enable", 1);
                DynamicObjectHelper.setValue(journalbalance, "ctrlstrategy", 5);
                DynamicObjectHelper.setValue(journalbalance, "creator", cashMgtInit.getDynamicObject("creator"));
                DynamicObjectHelper.setValue(journalbalance, "createtime", cashMgtInit.getDate("createtime"));
                DynamicObjectHelper.setValue(journalbalance, "org", cashMgtInit.getDynamicObject("org"));
                DynamicObjectHelper.setValue(journalbalance, "period", cashMgtInit.getDynamicObject("startperiod"));
                DynamicObjectHelper.setValue(journalbalance, "accountbank", entrybank.getDynamicObject("bank_accountbank"));
                DynamicObjectHelper.setValue(journalbalance, "currency", entrybank.getDynamicObject("bank_currency"));
                DynamicObjectHelper.setValue(journalbalance, "monthstart", entrybank.getBigDecimal("bank_journalbalance"));
                DynamicObjectHelper.setValue(journalbalance, "monthdebit", new BigDecimal(0));
                DynamicObjectHelper.setValue(journalbalance, "monthcredit", new BigDecimal(0));
                DynamicObjectHelper.setValue(journalbalance, "monthbalance", entrybank.getBigDecimal("bank_journalbalance"));
                DynamicObjectHelper.setValue(journalbalance, "yearstart", entrybank.getBigDecimal("bank_journalbalance").subtract(entrybank.getBigDecimal("bank_journaldebit")).add(entrybank.getBigDecimal("bank_journalcredit")));
                DynamicObjectHelper.setValue(journalbalance, "yeardebit", entrybank.getBigDecimal("bank_journaldebit"));
                DynamicObjectHelper.setValue(journalbalance, "yearcredit", entrybank.getBigDecimal("bank_journalcredit"));
                DynamicObjectHelper.setValue(journalbalance, "yearbalance", entrybank.getBigDecimal("bank_journalbalance"));
                DynamicObjectHelper.setValue(journalbalance, "openorg", entrybank.getDynamicObject("bank_accountbank").getDynamicObject("openorg"));
                DynamicObjectHelper.setValue(journalbalance, "isbalanced", 0);
                banks.add(journalbalance);
            }
        }
        result.put("bankList", banks);
        result.put("checkResult", checkResults);
        return result;
    }

    private List<DynamicObject> finalCheckout(DynamicObject[] cashMgtInits) {
        ArrayList<DynamicObject> finalCheckouts = new ArrayList<DynamicObject>(16);
        for (DynamicObject cashMgtInit : cashMgtInits) {
            DynamicObject finalcheckout = BusinessDataServiceHelper.newDynamicObject((String)"cas_finalcheckout");
            DynamicObjectHelper.setValue(finalcheckout, "checkoutstatus", 1);
            DynamicObjectHelper.setValue(finalcheckout, "creator", cashMgtInit.getDynamicObject("creator"));
            DynamicObjectHelper.setValue(finalcheckout, "createtime", cashMgtInit.getDate("createtime"));
            DynamicObjectHelper.setValue(finalcheckout, "org", cashMgtInit.getDynamicObject("org"));
            DynamicObjectHelper.setValue(finalcheckout, "period", cashMgtInit.getDynamicObject("startperiod"));
            finalCheckouts.add(finalcheckout);
        }
        return finalCheckouts;
    }

    private static void initBalanceAccounts(DynamicObject[] cashMgtInits) {
        for (DynamicObject cashMgtInit : cashMgtInits) {
            CasBankJournalHelper.initBalanceAccount(cashMgtInit);
        }
    }

    private static boolean valueEqualsZero(DynamicObject dy, String ... values) {
        boolean result = true;
        for (String v : values) {
            if (dy.getBigDecimal(v).compareTo(BigDecimal.ZERO) != 0 || !result) {
                result = false;
            }
            if (result) continue;
            return result;
        }
        return result;
    }

    static class Singleton {
        private static final CashMgtInitAction instance = new CashMgtInitAction();

        Singleton() {
        }
    }
}

