/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.init;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CodeRuleHelper;
import kd.fi.cas.util.StringUtils;

public class MatchingRuleSynDataHelper {
    private static HashMap<String, Object> containUseId;
    private static String recPayRule;

    public static void syncMatchingRule() {
        QFilter isupdateFilter = new QFilter("isupdate", "=", (Object)"0");
        DynamicObject[] orgData = BusinessDataServiceHelper.load((String)"cas_matchingrule", (String)"org", (QFilter[])new QFilter[]{isupdateFilter});
        if (CasHelper.isEmpty(orgData) || orgData.length == 0) {
            return;
        }
        String matchRuleStr = "id,org,businesstype,accountbank,auditdate,createtime,modifier,modifytime,billno,billstatus,creator,enable,entryentity,entryentity.customer,entryentity.payaccount,entryentity.isinternal,entryentity.fundflowitem,entryentity.rectype,entryentity.paytype,entryentity.abstract,isupdate,rulecoding,schemename,auditor,expirationdate,effectivedate,customerf7";
        QFilter recPayFilter = new QFilter("businesstype", "in", Arrays.asList("REC", "PAY"));
        DynamicObject[] recPayData = BusinessDataServiceHelper.load((String)"cas_matchingrule", (String)matchRuleStr, (QFilter[])new QFilter[]{recPayFilter, isupdateFilter});
        Map<String, List<DynamicObject>> recPayDataMap = Arrays.stream(recPayData).collect(Collectors.groupingBy(r -> r.getString("businesstype")));
        List<DynamicObject> recData = recPayDataMap.get("REC");
        List<DynamicObject> payData = recPayDataMap.get("PAY");
        HashMap<String, List<DynamicObject>> typeAndOrg = new HashMap<String, List<DynamicObject>>();
        for (DynamicObject orgDatum : orgData) {
            List<DynamicObject> recOrgList;
            DynamicObject org = orgDatum.getDynamicObject("org");
            for (DynamicObject recDatum : recData) {
                DynamicObject recorg = recDatum.getDynamicObject("org");
                if (!org.getPkValue().equals(recorg.getPkValue()) && org.getPkValue() != recorg.getPkValue()) continue;
                recOrgList = typeAndOrg.get(String.format(ResManager.loadKDString((String)"%s-\u6536\u6b3e\u5355", (String)"MatchingRuleSynDataHelper_2", (String)"fi-cas-common", (Object[])new Object[0]), org.getString("name")));
                if (CasHelper.isEmpty(recOrgList) || recOrgList.size() == 0) {
                    recOrgList = new ArrayList<DynamicObject>();
                }
                recOrgList.add(recDatum);
                typeAndOrg.put(String.format(ResManager.loadKDString((String)"%s-\u6536\u6b3e\u5355", (String)"MatchingRuleSynDataHelper_2", (String)"fi-cas-common", (Object[])new Object[0]), org.getString("name")), recOrgList);
            }
            for (DynamicObject payDatum : payData) {
                DynamicObject payorg = payDatum.getDynamicObject("org");
                if (!org.equals(payorg) && org != payorg) continue;
                recOrgList = typeAndOrg.get(String.format(ResManager.loadKDString((String)"%s-\u4ed8\u6b3e\u5355", (String)"MatchingRuleSynDataHelper_3", (String)"fi-cas-common", (Object[])new Object[0]), org.getString("name")));
                if (CasHelper.isEmpty(recOrgList) || recOrgList.size() == 0) {
                    recOrgList = new ArrayList<DynamicObject>();
                }
                recOrgList.add(payDatum);
                typeAndOrg.put(String.format(ResManager.loadKDString((String)"%s-\u4ed8\u6b3e\u5355", (String)"MatchingRuleSynDataHelper_3", (String)"fi-cas-common", (Object[])new Object[0]), org.getString("name")), recOrgList);
            }
        }
        containUseId = new HashMap();
        MatchingRuleSynDataHelper.getNewTableData();
        ArrayList<String> only = new ArrayList<String>();
        for (Map.Entry orgAndBizEntry : typeAndOrg.entrySet()) {
            String orgAndBizType = (String)orgAndBizEntry.getKey();
            Object recPayRuleData = containUseId.get(orgAndBizType);
            if (CasHelper.isEmpty(recPayRuleData) || "".equals(recPayRuleData)) {
                DynamicObject cas_recpayrule = BusinessDataServiceHelper.newDynamicObject((String)"cas_recpayrule");
                List matchRuleDatas = (List)orgAndBizEntry.getValue();
                Object org = null;
                String biztype = null;
                Date createtime = null;
                Date modifytime = null;
                Object modifier = null;
                Object creator = null;
                Object enable = null;
                Object status = null;
                DynamicObjectCollection entryentity = cas_recpayrule.getDynamicObjectCollection("entryentity");
                for (DynamicObject matchRuleData : matchRuleDatas) {
                    if (!CasHelper.isEmpty(only) && only.size() > 0 && only.contains(matchRuleData.getString("id"))) continue;
                    DynamicObject recPayRuleHasData = (DynamicObject)containUseId.get(orgAndBizType);
                    if (CasHelper.isEmpty(recPayRuleHasData) || "".equals(recPayRuleHasData)) {
                        org = matchRuleData.getDynamicObject("org").getPkValue();
                        biztype = matchRuleData.getString("businesstype").toLowerCase();
                        createtime = matchRuleData.getDate("createtime");
                        modifytime = matchRuleData.getDate("modifytime");
                        modifier = matchRuleData.get("modifier");
                        creator = matchRuleData.get("creator");
                        enable = matchRuleData.get("enable");
                        status = matchRuleData.get("billstatus");
                        Integer fesq = 1;
                        DynamicObject accountbank = matchRuleData.getDynamicObject("accountbank");
                        String old_bankname = accountbank.getString("name");
                        DynamicObjectCollection old_entryentity = matchRuleData.getDynamicObjectCollection("entryentity");
                        if (!CasHelper.isEmpty(old_entryentity) && old_entryentity.size() > 0) {
                            for (DynamicObject old_entry : old_entryentity) {
                                DynamicObject load;
                                QFilter biztype1;
                                DynamicObject addNewRecPayRuleDataEntry = entryentity.addNew();
                                DynamicObject fundflowitem = old_entry.getDynamicObject("fundflowitem");
                                String fundflowitemName = fundflowitem.getString("name");
                                DynamicObject rectype = old_entry.getDynamicObject("rectype");
                                DynamicObject paytype = old_entry.getDynamicObject("paytype");
                                DynamicObject old_fundflowitem = old_entry.getDynamicObject("fundflowitem");
                                addNewRecPayRuleDataEntry.set("e_rulesname", (Object)(old_bankname + "/" + fundflowitemName));
                                CRCondition crCondition = new CRCondition();
                                StringBuilder stringBuilder = new StringBuilder();
                                if (!CasHelper.isEmpty(accountbank.get("bankaccountnumber")) && !"".equals(accountbank.get("bankaccountnumber"))) {
                                    stringBuilder.append("accountbank.bankaccountnumber = '").append(accountbank.get("bankaccountnumber")).append('\'').append(" and  ");
                                }
                                if (!CasHelper.isEmpty(old_entry.getString("abstract")) && !"".equals(old_entry.getString("abstract"))) {
                                    stringBuilder.append("  description  = '").append(old_entry.getString("abstract")).append('\'').append(" and ");
                                }
                                if (!CasHelper.isEmpty(old_entry.getString("customer")) && !"".equals(old_entry.getString("customer"))) {
                                    stringBuilder.append(" oppunit = '").append(old_entry.getString("customer")).append('\'').append(" and ");
                                }
                                if (!CasHelper.isEmpty(old_entry.getString("payaccount")) && !"".equals(old_entry.getString("payaccount"))) {
                                    stringBuilder.append("  oppbanknumber  = '").append(old_entry.getString("payaccount")).append('\'').append(" and ");
                                }
                                crCondition.setExpression(stringBuilder.append(" IsInnerSC() = ").append(old_entry.getBoolean("isinternal")).toString());
                                String conditionJson = SerializationUtils.toJsonString((Object)crCondition);
                                CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
                                if (StringUtils.isNotEmpty(filterObj.getExpression().trim())) {
                                    addNewRecPayRuleDataEntry.set("e_datafilterdesc", (Object)filterObj.getExpression());
                                }
                                addNewRecPayRuleDataEntry.set("e_datafilter_TAG", (Object)conditionJson);
                                addNewRecPayRuleDataEntry.set("e_receivingtype", (Object)rectype);
                                if (CasHelper.isEmpty(rectype) || "".equals(rectype)) {
                                    biztype1 = new QFilter("biztype", "=", (Object)"999");
                                    load = BusinessDataServiceHelper.loadSingle((String)"cas_receivingbilltype", (String)"id", (QFilter[])new QFilter[]{biztype1});
                                    addNewRecPayRuleDataEntry.set("e_receivingtype", load.getPkValue());
                                }
                                addNewRecPayRuleDataEntry.set("e_payertype", (Object)MatchingRuleSynDataHelper.getPayerType(rectype));
                                addNewRecPayRuleDataEntry.set("e_paymenttype", (Object)paytype);
                                if (CasHelper.isEmpty(paytype) || "".equals(paytype)) {
                                    biztype1 = new QFilter("biztype", "=", (Object)"999");
                                    load = BusinessDataServiceHelper.loadSingle((String)"cas_paymentbilltype", (String)"id", (QFilter[])new QFilter[]{biztype1});
                                    addNewRecPayRuleDataEntry.set("e_paymenttype", load.getPkValue());
                                }
                                addNewRecPayRuleDataEntry.set("e_payeetype", (Object)MatchingRuleSynDataHelper.getRecerType(paytype));
                                addNewRecPayRuleDataEntry.set("e_fundflowitem", (Object)old_fundflowitem);
                                addNewRecPayRuleDataEntry.set("seq", (Object)fesq);
                                Integer n = fesq;
                                Integer n2 = fesq = Integer.valueOf(fesq + 1);
                            }
                            cas_recpayrule.set("name", (Object)orgAndBizType);
                            cas_recpayrule.set("org", org);
                            cas_recpayrule.set("createorg", org);
                            cas_recpayrule.set("biztype", (Object)biztype);
                            cas_recpayrule.set("createtime", (Object)createtime);
                            cas_recpayrule.set("modifytime", (Object)modifytime);
                            cas_recpayrule.set("modifier", modifier);
                            cas_recpayrule.set("creator", creator);
                            cas_recpayrule.set("enable", enable);
                            cas_recpayrule.set("status", status);
                            cas_recpayrule.set("number", (Object)MatchingRuleSynDataHelper.getNumber(cas_recpayrule, String.valueOf(org)));
                            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cas_recpayrule});
                            matchRuleData.set("isupdate", (Object)true);
                            Object[] matchRuleDataSave = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{matchRuleData});
                            QFilter recPayRuleName = new QFilter("name", "=", (Object)orgAndBizType);
                            DynamicObject recpayrule = BusinessDataServiceHelper.loadSingle((String)"cas_recpayrule", (String)recPayRule, (QFilter[])new QFilter[]{recPayRuleName});
                            containUseId.put(orgAndBizType, recpayrule);
                            containUseId.put(orgAndBizType + "fesq", fesq);
                        }
                        String useId = matchRuleData.getString("id");
                        if (CasHelper.isEmpty(only) || only.size() == 0) {
                            only = new ArrayList();
                        }
                        only.add(useId);
                        continue;
                    }
                    MatchingRuleSynDataHelper.containData(recPayRuleHasData, typeAndOrg, recPayRuleHasData.getString("name"), only);
                }
                continue;
            }
            DynamicObject recPayRuleData1 = (DynamicObject)recPayRuleData;
            MatchingRuleSynDataHelper.containData(recPayRuleData1, typeAndOrg, orgAndBizType, null);
        }
    }

    private static void containData(DynamicObject recPayRuleData, HashMap<String, List<DynamicObject>> typeAndOrg, String orgAndBizType, List<String> only) {
        DynamicObjectCollection entryentity = recPayRuleData.getDynamicObjectCollection("entryentity");
        List<DynamicObject> matchTableDatas = typeAndOrg.get(orgAndBizType);
        for (DynamicObject matchTableData : matchTableDatas) {
            if (!CasHelper.isEmpty(only) && only.size() > 0 && only.contains(matchTableData.getString("id"))) continue;
            DynamicObject accountbank = matchTableData.getDynamicObject("accountbank");
            String old_bankname = accountbank.getString("name");
            DynamicObjectCollection old_entryentity = matchTableData.getDynamicObjectCollection("entryentity");
            if (!CasHelper.isEmpty(old_entryentity) && old_entryentity.size() > 0) {
                Integer entry_fesq = (Integer)containUseId.get(orgAndBizType + "fesq");
                for (DynamicObject old_entry : old_entryentity) {
                    DynamicObject load;
                    QFilter biztype1;
                    DynamicObject recPayNewEntry = entryentity.addNew();
                    DynamicObject fundflowitem = old_entry.getDynamicObject("fundflowitem");
                    String fundflowitemname = fundflowitem.getString("name");
                    DynamicObject rectype = old_entry.getDynamicObject("rectype");
                    DynamicObject paytype = old_entry.getDynamicObject("paytype");
                    DynamicObject old_fundflowitem = old_entry.getDynamicObject("fundflowitem");
                    recPayNewEntry.set("e_rulesname", (Object)(old_bankname + "/" + fundflowitemname));
                    CRCondition crCondition = new CRCondition();
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!CasHelper.isEmpty(accountbank.get("bankaccountnumber")) && !"".equals(accountbank.get("bankaccountnumber"))) {
                        stringBuilder.append("accountbank.bankaccountnumber = '").append(accountbank.get("bankaccountnumber")).append('\'').append(" and  ");
                    }
                    if (!CasHelper.isEmpty(old_entry.getString("abstract")) && !"".equals(old_entry.getString("abstract"))) {
                        stringBuilder.append("  description  = '").append(old_entry.getString("abstract")).append('\'').append(" and ");
                    }
                    if (!CasHelper.isEmpty(old_entry.getString("customer")) && !"".equals(old_entry.getString("customer"))) {
                        stringBuilder.append(" oppunit = '").append(old_entry.getString("customer")).append('\'').append(" and ");
                    }
                    if (!CasHelper.isEmpty(old_entry.getString("payaccount")) && !"".equals(old_entry.getString("payaccount"))) {
                        stringBuilder.append("  oppbanknumber  = '").append(old_entry.getString("payaccount")).append('\'').append(" and ");
                    }
                    crCondition.setExpression(stringBuilder.append(" IsInnerSC() = ").append(old_entry.getBoolean("isinternal")).toString());
                    String conditionJson = SerializationUtils.toJsonString((Object)crCondition);
                    CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
                    if (StringUtils.isNotEmpty(filterObj.getExpression().trim())) {
                        recPayNewEntry.set("e_datafilterdesc", (Object)filterObj.getExpression());
                    }
                    recPayNewEntry.set("e_datafilter_TAG", (Object)conditionJson);
                    recPayNewEntry.set("e_receivingtype", (Object)rectype);
                    if (CasHelper.isEmpty(rectype) || "".equals(rectype)) {
                        biztype1 = new QFilter("biztype", "=", (Object)"999");
                        load = BusinessDataServiceHelper.loadSingle((String)"cas_receivingbilltype", (String)"id", (QFilter[])new QFilter[]{biztype1});
                        recPayNewEntry.set("e_receivingtype", load.getPkValue());
                    }
                    recPayNewEntry.set("e_payertype", (Object)MatchingRuleSynDataHelper.getPayerType(rectype));
                    recPayNewEntry.set("e_paymenttype", (Object)paytype);
                    if (CasHelper.isEmpty(paytype) || "".equals(paytype)) {
                        biztype1 = new QFilter("biztype", "=", (Object)"999");
                        load = BusinessDataServiceHelper.loadSingle((String)"cas_paymentbilltype", (String)"id", (QFilter[])new QFilter[]{biztype1});
                        recPayNewEntry.set("e_paymenttype", load.getPkValue());
                    }
                    recPayNewEntry.set("e_payeetype", (Object)MatchingRuleSynDataHelper.getRecerType(paytype));
                    recPayNewEntry.set("e_fundflowitem", (Object)old_fundflowitem);
                    recPayNewEntry.set("seq", (Object)entry_fesq);
                    Integer n = entry_fesq;
                    Integer n2 = entry_fesq = Integer.valueOf(entry_fesq + 1);
                }
                Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recPayRuleData});
                matchTableData.set("isupdate", (Object)true);
                Object[] matchTableDataSave = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{matchTableData});
                QFilter orgFilter = new QFilter("org", "=", matchTableData.getDynamicObject("org").getPkValue());
                QFilter biztypeFilter = new QFilter("biztype", "=", (Object)matchTableData.getString("businesstype").toLowerCase());
                DynamicObject cas_recpayrule1 = BusinessDataServiceHelper.loadSingle((String)"cas_recpayrule", (String)recPayRule, (QFilter[])new QFilter[]{orgFilter, biztypeFilter});
                containUseId.put(orgAndBizType, cas_recpayrule1);
                containUseId.put(orgAndBizType + "fesq", entry_fesq);
            }
            if (!CasHelper.isNotEmpty(only)) continue;
            only.add(matchTableData.getString("id"));
        }
    }

    private static void getNewTableData() {
        DynamicObject[] newTableData = BusinessDataServiceHelper.load((String)"cas_recpayrule", (String)recPayRule, null);
        if (CasHelper.isEmpty(newTableData) || newTableData.length == 0) {
            return;
        }
        for (DynamicObject newTableDatum : newTableData) {
            DynamicObject org = newTableDatum.getDynamicObject("org");
            String orgName = org.getString("name");
            String biztype = newTableDatum.getString("biztype");
            biztype = "rec".equalsIgnoreCase(biztype) ? ResManager.loadKDString((String)"-\u6536\u6b3e\u5355", (String)"MatchingRuleSynDataHelper_0", (String)"fi-cas-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"-\u4ed8\u6b3e\u5355", (String)"MatchingRuleSynDataHelper_1", (String)"fi-cas-common", (Object[])new Object[0]);
            DynamicObjectCollection entryentity = newTableDatum.getDynamicObjectCollection("entryentity");
            Integer entry_fesq = 1;
            for (DynamicObject dynamicObject : entryentity) {
                int anInt = dynamicObject.getInt("seq");
                entry_fesq = entry_fesq > anInt ? entry_fesq : anInt;
            }
            containUseId.put(orgName + biztype, newTableDatum);
            containUseId.put(orgName + biztype + "fesq", entry_fesq + 1);
        }
    }

    private static String getPayerType(DynamicObject recType) {
        String payerType = "other";
        if (CasHelper.isEmpty(recType) || "".equals(recType)) {
            return payerType;
        }
        DynamicObject cas_receivingbilltype = BusinessDataServiceHelper.loadSingle((Object)recType.getPkValue(), (String)"cas_receivingbilltype");
        boolean ispartreceivable = cas_receivingbilltype.getBoolean("ispartreceivable");
        payerType = ispartreceivable ? "bd_customer" : "other";
        return payerType;
    }

    private static String getRecerType(DynamicObject payType) {
        String payerType = "other";
        if (CasHelper.isEmpty(payType) || "".equals(payType)) {
            return payerType;
        }
        DynamicObject cas_receivingbilltype = BusinessDataServiceHelper.loadSingle((Object)payType.getPkValue(), (String)"cas_paymentbilltype");
        boolean ispartreceivable = cas_receivingbilltype.getBoolean("ispartpayment");
        payerType = ispartreceivable ? "bd_supplier" : "other";
        return payerType;
    }

    private static String getNumber(DynamicObject recPayRule, String orgId) {
        String number = CodeRuleHelper.generateNumber("cas_recpayrule", recPayRule, orgId, null);
        return number;
    }

    static {
        recPayRule = "number,name,org,biztype,entryentity,createtime,modifytime,modifier,creator,createorg,useorg,enable,ctrlstrategy,status,masterid,entryentity.e_rulesname,entryentity.e_datafilterdesc,entryentity.e_datafilter,entryentity.e_receivingtype,entryentity.e_payertype,entryentity.e_paymenttype,entryentity.e_payeetype,entryentity.e_fundflowitem,entryentity.e_datafilter_TAG,entryentity.e_remark,entryentity.seq";
    }
}

