/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.sign;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ClientCallback;
import kd.bos.form.ClientMethodResult;
import kd.bos.form.IFormView;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.SignCallbackLisenter;
import kd.bos.form.operate.SignOperateCallback;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.sign.ISignExecutor;
import kd.fi.cas.sign.ISignInvoker;
import kd.fi.cas.util.EmptyUtil;

public class SignHandler {
    private static Log logger = LogFactory.getLog(SignHandler.class);
    public static final String KEY_DATALIST = "KEY_DATALIST";
    public static final String KEY_ERR_MSG = "_SignHandler_KEY_ERR_MSG";
    public static final String KEY_EXECUTORID = "KEY_EXECUTORID";
    private IFormView view;
    private ISignInvoker invoker;
    private ISignExecutor[] executors;
    private List<String> errMsgList = new ArrayList<String>();

    public SignHandler(IFormView view, ISignInvoker invoker, boolean isInit, ISignExecutor ... executors) {
        if (executors == null || executors.length == 0) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u7b7e\u540d\u6267\u884c\u5668", (String)"SignHandler_0", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        Set idSet = Arrays.stream(executors).map(ISignExecutor::getId).collect(Collectors.toSet());
        if (idSet.size() != executors.length) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u591a\u6267\u884c\u5668\u4e0b, \u8bf7\u4e3a\u6bcf\u4e2a\u6267\u884c\u5668\u8d4b\u503c\u4e0d\u540c\u7684ID", (String)"SignHandler_1", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        this.executors = executors;
        this.view = view;
        this.invoker = invoker;
        if (!isInit) {
            try {
                String errMsg = view.getPageCache().get(KEY_ERR_MSG);
                if (errMsg != null) {
                    List cachedErrMsgList = JSON.parseArray((String)errMsg, String.class);
                    this.errMsgList.addAll(cachedErrMsgList);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        } else {
            view.getPageCache().remove(KEY_ERR_MSG);
        }
    }

    public boolean sign() {
        boolean needSign = false;
        try {
            for (ISignExecutor executor : this.executors) {
                if (!this.doSign(null, executor.getId())) continue;
                needSign = true;
            }
        }
        catch (Exception e) {
            for (ISignExecutor executor : this.executors) {
                executor.doSignOperateFailed(e);
            }
            throw e;
        }
        finally {
            for (ISignExecutor executor : this.executors) {
                String errMsg = executor.getErrorMessage();
                if (!EmptyUtil.isNotEmpty(errMsg)) continue;
                this.errMsgList.add(errMsg);
            }
            this.view.getPageCache().put(KEY_ERR_MSG, JSON.toJSONString(this.errMsgList));
        }
        return needSign;
    }

    public String getErrorMessage() {
        StringBuilder sb = new StringBuilder();
        for (String errMsg : this.errMsgList) {
            sb.append(errMsg).append('\n');
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private boolean doSign(SignCallbackEvent evt, String executorId) {
        OperationResult signResult;
        boolean isSuccess;
        ISignExecutor executor;
        List waitSignBillIdList;
        HashMap<String, Object> callbackMap;
        String callbackId;
        boolean needSign = false;
        String string = callbackId = evt != null ? evt.getCallbackId() : null;
        if (callbackId != null) {
            callbackMap = (HashMap<String, Object>)SerializationUtils.fromJsonString((String)callbackId, Map.class);
            if (executorId != null && !executorId.equals(callbackMap.get(KEY_EXECUTORID))) {
                return false;
            }
            waitSignBillIdList = (List)callbackMap.get(KEY_DATALIST);
            executor = this.getExecutor((String)callbackMap.get(KEY_EXECUTORID));
        } else {
            executor = this.getExecutor(executorId);
            waitSignBillIdList = executor.prepareSignData();
            if (waitSignBillIdList.size() == 0) {
                return false;
            }
            callbackMap = new HashMap<String, Object>();
            callbackMap.put(KEY_EXECUTORID, executorId);
            callbackMap.put(KEY_DATALIST, waitSignBillIdList);
            callbackId = SerializationUtils.toJsonString(callbackMap);
        }
        OperateOption operateOption = OperateOption.create();
        if (evt != null) {
            ClientMethodResult ret = evt.getResult();
            operateOption.setVariableValue("signCallbackFlag", "true");
            operateOption.setVariableValue("signFirstSave", "false");
            operateOption.setVariableValue("signResult", SerializationUtils.toJsonString((Object)ret.getResult()));
            operateOption.setVariableValue("clearResult", evt.getClearText());
        }
        if (!(isSuccess = (signResult = executor.doSignOperation(waitSignBillIdList, operateOption)).isSuccess()) && signResult.isNeedSign()) {
            needSign = true;
            SignOperateCallback signOperate = new SignOperateCallback(this.view, (SignCallbackLisenter)this.invoker, operateOption, ClientCallback.SignClientType.Secondry, callbackId);
            if (!(signResult = signOperate.sign(signResult)).isSuccess() && signResult.isShowMessage()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25: %s", (String)"SignHandler_2", (String)"fi-cas-common", (Object[])new Object[0]), OperateServiceHelper.decodeErrorMsg(signResult)));
            }
        } else if (isSuccess) {
            List successPkIds = signResult.getSuccessPkIds();
            if (!CollectionUtils.isEmpty((Collection)successPkIds)) {
                executor.doSignOperateSuccess(successPkIds);
            }
        } else {
            throw new KDBizException(OperateServiceHelper.decodeErrorMsg(signResult));
        }
        return needSign;
    }

    private ISignExecutor getExecutor(String customCallBackId) {
        if (this.executors.length == 1) {
            return this.executors[0];
        }
        for (ISignExecutor executor : this.executors) {
            if (customCallBackId == null || !customCallBackId.equals(executor.getId())) continue;
            return executor;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25", (String)"SignHandler_3", (String)"fi-cas-common", (Object[])new Object[0]));
    }

    public void signCallback(SignCallbackEvent evt) {
        logger.info("\u7b7e\u540d\u56de\u8c03, evt = " + evt);
        if (evt == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u540d\u5f02\u5e38", (String)"SignHandler_4", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        ClientMethodResult ret = evt.getResult();
        if (ret.getSuccess().booleanValue()) {
            try {
                this.doSign(evt, null);
            }
            catch (Exception e) {
                for (ISignExecutor executor : this.executors) {
                    executor.doSignOperateFailed(e);
                }
                throw e;
            }
        } else {
            for (ISignExecutor executor : this.executors) {
                executor.doSignOperateFailed((Exception)((Object)new KDBizException(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25", (String)"SignHandler_3", (String)"fi-cas-common", (Object[])new Object[0]))));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba2\u6237\u7aef\u7b7e\u540d\u5931\u8d25", (String)"SignHandler_5", (String)"fi-cas-common", (Object[])new Object[0]));
        }
    }
}

