/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    private static final Log LOGGER = LogFactory.getLog(DateUtils.class);
    public static final String FORMAT_YMD = "yyyy-MM-dd";
    public static final String FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_yyyyMMdd = "yyyyMMdd";
    public static final String FORMAT_HHMMSS = "yyyyMMddhhmmss";
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final ZoneId DEFAULT_ZONE = ZoneId.systemDefault();

    public static Date truncateDate(Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static Date getNextSeconds(Date date, int second) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(13, second);
        return c.getTime();
    }

    public static Date getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = (int)diff + 1;
        return days;
    }

    public static Date getDataFormat(Date date, boolean isStart) {
        String dateStr = new SimpleDateFormat(FORMAT_YMD).format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return new SimpleDateFormat(FORMAT_YMDHMS).parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static Date stringToDate(String datestr, String dateformat) {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            date = df.parse(datestr);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f[%s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:", (String)"DateUtils_0", (String)"fi-cas-common", (Object[])new Object[0]), datestr) + dateformat);
        }
        return date;
    }

    public static int getDay(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(8));
    }

    public static int getMonth(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(5, 7));
    }

    public static int getYear(Date date) {
        return Integer.parseInt(new DateTime((Object)date).toString(DATE_FORMATTER).substring(0, 4));
    }

    public static boolean isSameYear(Date date1, Date date2) {
        return DateUtils.getYear(date1) == DateUtils.getYear(date2);
    }

    public static String getYearMonth(Date date) {
        return new DateTime((Object)date).toString(DATE_FORMATTER).substring(0, 7);
    }

    public static String getMonthDay(Date date) {
        String str = FORMAT_YMD;
        return new DateTime((Object)date).toString(str);
    }

    public static Date getMinMonthDate(Date date) {
        date = DateUtils.getDataFormat(date, true);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMaxMonthDate(Date date) {
        date = DateUtils.getDataFormat(date, false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return DateUtils.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            return false;
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static String formatString(Date date, String forPattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(forPattern);
        return sdf.format(date);
    }

    public static Date getBeforeDate(Date endDate, Date currDate) {
        if (endDate.compareTo(currDate) > 0) {
            return currDate;
        }
        return endDate;
    }

    public static Date getBeforeDateNearest(List<Date> dates, Date currentDate) {
        Date date;
        int i;
        if (dates == null || dates.size() == 0) {
            return currentDate;
        }
        Collections.sort(dates, new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                try {
                    if (o1.getTime() < o2.getTime()) {
                        return -1;
                    }
                    return 1;
                }
                catch (Exception e) {
                    LOGGER.error("error:", (Throwable)e);
                    return 0;
                }
            }
        });
        int index = 0;
        for (i = 0; i < dates.size(); ++i) {
            date = dates.get(i);
            if (date.getTime() != currentDate.getTime()) continue;
            index = i;
            break;
        }
        if (index <= 0) {
            return currentDate;
        }
        for (i = index - 1; i < dates.size(); ++i) {
            date = dates.get(i);
            if (date.getTime() >= currentDate.getTime()) continue;
            return date;
        }
        return currentDate;
    }

    public static Date getAfterDateNearest(List<Date> dates, Date currentDate) {
        Date date;
        int i;
        if (dates == null || dates.size() == 0) {
            return currentDate;
        }
        Collections.sort(dates, new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                try {
                    if (o1.getTime() < o2.getTime()) {
                        return -1;
                    }
                    return 1;
                }
                catch (Exception e) {
                    LOGGER.error("error:", (Throwable)e);
                    return 0;
                }
            }
        });
        int index = 0;
        for (i = 0; i < dates.size(); ++i) {
            date = dates.get(i);
            if (date.getTime() != currentDate.getTime()) continue;
            index = i;
            break;
        }
        for (i = index + 1; i < dates.size(); ++i) {
            date = dates.get(i);
            if (date.getTime() <= currentDate.getTime()) continue;
            return date;
        }
        return currentDate;
    }

    public static Date preDate(Set<Date> dateSet, Date currentDate) {
        Date date;
        int i;
        ArrayList<Date> dates = new ArrayList<Date>(dateSet.size());
        dates.addAll(dateSet);
        if (dates.size() == 0) {
            return currentDate;
        }
        Collections.sort(dates, new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                try {
                    if (o1.getTime() < o2.getTime()) {
                        return -1;
                    }
                    return 1;
                }
                catch (Exception e) {
                    LOGGER.error("error:", (Throwable)e);
                    return 0;
                }
            }
        });
        int index = 0;
        for (i = 0; i < dates.size(); ++i) {
            date = (Date)dates.get(i);
            if (date.getTime() != currentDate.getTime()) continue;
            index = i;
            break;
        }
        if (index == 0) {
            return (Date)dates.get(index);
        }
        for (i = index - 1; i < dates.size(); ++i) {
            date = (Date)dates.get(i);
            if (date.getTime() >= currentDate.getTime()) continue;
            return date;
        }
        return currentDate;
    }

    public static Date postDate(List<Date> dates, Date currentDate) {
        Date date;
        int i;
        if (dates == null || dates.size() == 0) {
            return currentDate;
        }
        Collections.sort(dates, new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                try {
                    if (o1.getTime() < o2.getTime()) {
                        return -1;
                    }
                    return 1;
                }
                catch (Exception e) {
                    LOGGER.error("error:", (Throwable)e);
                    return 0;
                }
            }
        });
        int index = 0;
        for (i = 0; i < dates.size(); ++i) {
            date = dates.get(i);
            if (date.getTime() != currentDate.getTime()) continue;
            index = i;
            break;
        }
        for (i = index + 1; i < dates.size(); ++i) {
            date = dates.get(i);
            if (date.getTime() <= currentDate.getTime()) continue;
            return date;
        }
        return currentDate;
    }

    public static Date getYearFirst(int year) {
        return DateUtils.localDate2Date(LocalDate.of(year, 1, 1));
    }

    public static Date getFirstDayOfMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(5, cal.getActualMinimum(5));
        return DateUtils.truncateDate(cal.getTime());
    }

    private static Date localDate2Date(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(DEFAULT_ZONE).toInstant());
    }

    public static Date getBeginDayOfPreMonth(int preMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtils.getNowYear(), DateUtils.getNowMonth() - preMonth, 1);
        return DateUtils.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfPreMonth(int preMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtils.getNowYear(), DateUtils.getNowMonth() - preMonth, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateUtils.getNowYear(), DateUtils.getNowMonth() - preMonth, day);
        return DateUtils.getDayEndTime(calendar.getTime());
    }

    public static Date getPreMonth(Date date, int preMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -preMonth);
        return DateUtils.getDayStartTime(calendar.getTime());
    }

    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static Date getFrontDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static Date getDateWithMaxTime(Date date) {
        String dayStr = DateFormatUtils.format((Date)date, (String)FORMAT_YMD);
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)(dayStr + " 23:59:59"), (String[])new String[]{FORMAT_YMDHMS});
        }
        catch (ParseException e) {
            LOGGER.error("getDateWithMaxTime error:", (Throwable)e);
            return date;
        }
    }
}

