/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.fi.cas.validator.AccountCashSaveValidator;
import kd.fi.cas.validator.AcctCheckReferenceValidator;

public class AccountCashSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("isdefaultpayee");
        fields.add("isdefaultpayer");
        fields.add("status");
        fields.add("openorg");
        fields.add("defaultcurrency");
        fields.add("currency");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AccountCashSaveValidator());
        AcctCheckReferenceValidator checkRef = new AcctCheckReferenceValidator();
        checkRef.setEntityKey("cas_accountcash");
        checkRef.setOperateKey("save");
        e.addValidator((AbstractValidator)checkRef);
        super.onAddValidators(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] infos;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject info : infos = e.getDataEntities()) {
            info.set("status", (Object)BillStatus.C.name());
            DynamicObjectCollection currencyCol = info.getDynamicObjectCollection("currency");
            String currencyName = this.getCurrencyName(currencyCol);
            if (currencyName != null) {
                info.set("currencyname", (Object)currencyName);
            }
            if (currencyCol.size() == 1) {
                info.set("isbycurrency", (Object)"1");
                continue;
            }
            info.set("isbycurrency", (Object)"0");
        }
    }

    private String getCurrencyName(DynamicObjectCollection props) {
        DynamicObjectCollection currencys = props;
        StringBuilder currencyStr = new StringBuilder(20);
        for (DynamicObject currency : currencys) {
            if (currencyStr.length() == 0) {
                currencyStr.append(currency.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue());
                continue;
            }
            currencyStr.append(',');
            currencyStr.append(currency.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue());
        }
        return currencyStr.toString();
    }
}

