/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.VoucherCheckHepler;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.opservice.helper.AgentPayServiceHelper;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;
import kd.fi.cas.validator.AgentCancelPayValidator;
import kd.fi.cas.validator.AgentPayBillWriteValidator;

public class AgentPayCancelPayOp
extends AbstractOperationServicePlugIn {
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("iscommitbe");
        fieldKeys.add("actpayamount");
        fieldKeys.add("actcount");
        fieldKeys.add("cashier");
        fieldKeys.add("billtype");
        fieldKeys.add("source");
        fieldKeys.add("e_issuccess");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("delegorg");
        fieldKeys.add("e_isrefund");
        fieldKeys.add("fee");
        fieldKeys.add("paymentchannel");
        fieldKeys.add("payeracctbank");
        fieldKeys.add("acctstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        List validators = e.getValidators();
        validators.add(new AgentCancelPayValidator(this.journalServiceAdapter));
        validators.add(new AgentPayBillWriteValidator(WriteBackOperateEnum.CANCELPAYVALIDATE));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] agentPayBillDts = e.getDataEntities();
        List agentIdList = Arrays.stream(agentPayBillDts).map(o -> o.getLong("id")).collect(Collectors.toList());
        Set sourceBillNoList = Arrays.stream(agentPayBillDts).filter(o -> !StringUtils.isBlank((String)o.getString("sourcebillnumber"))).map(o -> o.getString("sourcebillnumber")).collect(Collectors.toSet());
        QFilter srcBillId = new QFilter("sourcebillid", "in", agentIdList.stream().map(o -> String.valueOf(o)).collect(Collectors.toList()));
        QFilter srcbilltype = new QFilter("sourcebilltype", "=", (Object)"cas_agentpaybill");
        DynamicObject[] arBillDts = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,sourcebillid,recorg.name,billstatus,billno", (QFilter[])new QFilter[]{srcBillId, srcbilltype});
        Map agentDtsMap = Arrays.stream(arBillDts).collect(Collectors.toMap(o -> o.get("sourcebillid"), Function.identity()));
        ArrayList<DynamicObject> agentPayBillList = new ArrayList<DynamicObject>(10);
        DynamicObject[] agentPaySourceBills = BusinessDataServiceHelper.load((Object[])agentIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_agentpaybill"));
        agentPayBillList.addAll(Arrays.asList(agentPaySourceBills));
        for (DynamicObject agentPayBill : agentPayBillDts) {
            DynamicObject otherarbill;
            if (!AgentPayBillHelper.isDelegPush((DynamicObject)agentPayBill) || null == (otherarbill = (DynamicObject)agentDtsMap.get(agentPayBill.getPkValue()))) continue;
            OperateOption delOp = OperateOption.create();
            delOp.setVariableValue("app", "cas");
            OperateServiceHelper.execOperate((String)"delete", (String)"ar_finarbill", (Object[])new Long[]{otherarbill.getLong("id")}, (OperateOption)delOp);
        }
        DynamicObject[] agentPaySourceBillList = AgentPayServiceHelper.getSourceAgentBillList(agentIdList);
        for (DynamicObject agentPaySourceBill : agentPaySourceBillList) {
            if (!sourceBillNoList.contains(agentPaySourceBill.getString("billno"))) continue;
            agentPayBillList.add(agentPaySourceBill);
        }
        for (DynamicObject agentPayBill : agentPayBillList) {
            agentPayBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            agentPayBill.set("actpayamount", null);
            agentPayBill.set("actcount", null);
            agentPayBill.set("cashier", null);
            agentPayBill.set("paytime", null);
            DynamicObjectCollection entry = agentPayBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                row.set("e_issuccess", (Object)"0");
                row.set("e_paytime", null);
            }
        }
        List agentIdAllList = agentPayBillList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        this.journalServiceAdapter.cancelBooks(agentIdAllList);
        SaveServiceHelper.save((DynamicObject[])agentPayBillList.toArray(new DynamicObject[0]));
        for (DynamicObject agentPayBill : agentPayBillList) {
            String source = agentPayBill.getString("source");
            if (!"BOTP".equals(source)) continue;
            WriteBackTaskHelper.addRealtimeTask((DynamicObject)agentPayBill, (String)agentPayBill.getString("sourcebilltype"), (WriteBackOperateEnum)WriteBackOperateEnum.CANCELPAY, AgentWriteBackConsumer.class);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        ArrayList<DynamicObject> cancelCheckBills = new ArrayList<DynamicObject>();
        List agentIdList = Arrays.stream(e.getDataEntities()).map(o -> o.getPkValue()).collect(Collectors.toList());
        QFilter pkids = new QFilter("id", "in", agentIdList);
        DynamicObject[] agentDts = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"id,billstatus", (QFilter[])pkids.toArray());
        Map agentDtsMap = Arrays.stream(agentDts).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        for (DynamicObject info : e.getDataEntities()) {
            DynamicObject bill = (DynamicObject)agentDtsMap.get(info.getPkValue());
            if (null == bill || !BillStatusEnum.AUDIT.getValue().equals(bill.getString("billstatus"))) continue;
            cancelCheckBills.add(info);
        }
        if (EmptyUtil.isNoEmpty(cancelCheckBills)) {
            VoucherCheckHepler.batchoCancelCoucherCheck(cancelCheckBills);
        }
    }
}

