/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.business.helper.ReceredWayHelper;
import kd.fi.cas.business.opservice.IOpService;
import kd.fi.cas.business.opservice.factory.AgentPayBillFactory;
import kd.fi.cas.business.opservice.helper.HandLinkBillHelper;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.helper.EntrustHelper;
import kd.fi.cas.opplugin.CommonOpServicePlugIn;
import kd.fi.cas.validator.AgentPayBillDeleteValidator;
import kd.fi.cas.validator.AgentPayBillWriteValidator;
import kd.fi.cas.validator.common.TxLockValidator;

public class AgentPayDeleteOp
extends CommonOpServicePlugIn {
    @Override
    protected IOpService registerService() {
        return AgentPayBillFactory.getDeleteService();
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("matchflag");
        fieldKeys.add("sourcebilltype");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AgentPayBillDeleteValidator());
        e.getValidators().add(new TxLockValidator());
        e.addValidator((AbstractValidator)new AgentPayBillWriteValidator(WriteBackOperateEnum.DELETEVALIDATE));
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(10);
        for (DynamicObject info : e.getDataEntities()) {
            HandLinkBillHelper.dealHandLink((DynamicObject)info);
            ReceredWayHelper.setReceredWayByAgentPay((DynamicObject)info);
            String sourceBillType = info.getString("sourcebilltype");
            if ("fr_glreim_paybill".equals(sourceBillType)) {
                WriteBackTaskHelper.addRealtimeTask((DynamicObject)info, (String)sourceBillType, (WriteBackOperateEnum)WriteBackOperateEnum.DELETE, AgentWriteBackConsumer.class);
            } else {
                bills.add(info);
            }
            EntrustHelper.delEntrustRelation((Long)((Long)info.getPkValue()), (String)"cas_agentpaybill");
        }
        WriteBackServiceImpl.getInstance().batchWrite(bills, WriteBackOperateEnum.DELETE, AgentWriteBackConsumer.class);
    }
}

