/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.AgentFillPropHelper;
import kd.fi.cas.business.opservice.IOpService;
import kd.fi.cas.business.opservice.factory.AgentPayBillFactory;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.opplugin.CommonOpServicePlugIn;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.AgentBillVirtualValidator;
import kd.fi.cas.validator.AgentPayBillIsFreezeValidator;
import kd.fi.cas.validator.AgentPayBillWriteValidator;
import kd.fi.cas.validator.BillNoSaveValidator;
import kd.fi.cas.validator.CrossBorderPayLicenseValidator;
import kd.fi.cas.validator.OrgFinishinitValidator;
import kd.fi.cas.validator.QuotationOpPayOrAgentValidator;
import kd.fi.cas.validator.agent.AgentAccountCashValidator;
import kd.fi.cas.validator.common.TxLockValidator;

public class AgentPaySaveOp
extends CommonOpServicePlugIn {
    @Override
    protected IOpService registerService() {
        return AgentPayBillFactory.getSaveService();
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillNoSaveValidator());
        e.addValidator((AbstractValidator)new CrossBorderPayLicenseValidator());
        e.addValidator((AbstractValidator)new AgentBillVirtualValidator());
        e.getValidators().add(new OrgFinishinitValidator());
        e.getValidators().add(new QuotationOpPayOrAgentValidator());
        e.getValidators().add(new AgentPayBillIsFreezeValidator());
        e.getValidators().add(new TxLockValidator());
        e.addValidator((AbstractValidator)new AgentAccountCashValidator());
        e.addValidator((AbstractValidator)new AgentPayBillWriteValidator(WriteBackOperateEnum.SAVEVALIDATE));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        RefundHelper.setSomeRefundAmtFields((DynamicObject[])e.getDataEntities(), (String)"cas_agentpaybill");
        AgentFillPropHelper.setDefaultProviceCity((DynamicObject[])e.getDataEntities());
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(10);
        for (DynamicObject info : e.getDataEntities()) {
            DynamicObjectCollection entry;
            String sourceBillType = info.getString("sourcebilltype");
            if ("fr_glreim_paybill".equals(sourceBillType)) {
                WriteBackTaskHelper.addRealtimeTask((DynamicObject)info, (String)sourceBillType, (WriteBackOperateEnum)WriteBackOperateEnum.SAVE, AgentWriteBackConsumer.class);
            } else {
                bills.add(info);
            }
            if ("repay".equals(sourceBillType) || (entry = info.getDynamicObjectCollection("entry")) == null || entry.size() <= 0) continue;
            for (DynamicObject row : entry) {
                long eOriginalAgentEntryId = row.getLong("e_originalagententryid");
                if (!EmptyUtil.isEmpty((Long)eOriginalAgentEntryId)) continue;
                row.set("e_originalagententryid", row.get("id"));
            }
        }
        SaveServiceHelper.update((DynamicObject[])e.getDataEntities());
        WriteBackServiceImpl.getInstance().batchWrite(bills, WriteBackOperateEnum.SAVE, AgentWriteBackConsumer.class);
    }
}

