/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.service.BalanceAdjustService;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.opplugin.AbstractCashMgtInitObserver;

public class BalanceAdjustObserver
extends AbstractCashMgtInitObserver {
    @Override
    public void afterFinishInit(DynamicObject cashMgtInit) {
        DynamicObject[] balAdjustList;
        Long orgId = (Long)cashMgtInit.getDynamicObject("org").getPkValue();
        ArrayList<Long> accountIds = new ArrayList<Long>();
        DynamicObjectCollection accountColl = cashMgtInit.getDynamicObjectCollection("entrybank");
        for (DynamicObject object : accountColl) {
            accountIds.add(object.getDynamicObject("bank_accountbank").getLong("id"));
        }
        this.updBalAdjust(orgId, accountIds);
        ArrayList<Long> redIds = new ArrayList<Long>();
        for (DynamicObject balAdjust : balAdjustList = this.getBalAdjustList(orgId)) {
            if (!accountIds.contains(balAdjust.getLong("bankaccount.id"))) {
                redIds.add(balAdjust.getLong("id"));
            }
            balAdjust.set("billstatus", (Object)"B");
            balAdjust.set("auditdate", (Object)new Date());
            balAdjust.set("auditor", (Object)CasHelper.getCurrentUser());
        }
        SaveServiceHelper.save((DynamicObject[])balAdjustList);
        DeleteServiceHelper.delete((String)"cas_balanceadjust", (QFilter[])new QFilter[]{new QFilter("id", "in", redIds)});
    }

    @Override
    public void afterAntiInit(DynamicObject cashMgtAntiInit) {
        DynamicObject[] balAdjustList;
        Long orgId = (Long)cashMgtAntiInit.getDynamicObject("org").getPkValue();
        for (DynamicObject balAdjust : balAdjustList = this.getBalAdjustList(orgId)) {
            balAdjust.set("billstatus", (Object)"A");
            balAdjust.set("auditdate", null);
            balAdjust.set("auditor", null);
        }
        SaveServiceHelper.save((DynamicObject[])balAdjustList);
    }

    private void updBalAdjust(Long orgId, List<Long> accountIds) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("id", "in", accountIds)};
        this.updBalAdjust(orgId, filters);
    }

    private void updBalAdjust(Long orgId, QFilter[] filters) {
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])filters);
        if (accountBanks != null && accountBanks.length > 0) {
            BalanceAdjustService iBalAdjService = BalanceAdjustService.getInstance();
            for (DynamicObject accountBank : accountBanks) {
                QFilter[] acctfilters = new QFilter[]{new QFilter("id", "=", (Object)accountBank.getLong("id"))};
                DynamicObjectCollection acctColl = QueryServiceHelper.query((String)"getAcctPlainColl", (String)"bd_accountbanks", (String)"id,currency.fbasedataid.id as currencyid,currency.fbasedataid.name as currencyname", (QFilter[])acctfilters, null);
                if (acctColl == null || acctColl.size() <= 0) continue;
                for (DynamicObject acct : acctColl) {
                    iBalAdjService.updBalAdjust(orgId, null, (Long)accountBank.getPkValue(), Long.valueOf(acct.getLong("currencyid")));
                }
            }
        }
    }

    private DynamicObject[] getBalAdjustList(Long orgId) {
        QFilter[] balAdjustFilters = new QFilter[]{new QFilter("org.id", "=", (Object)orgId), new QFilter("period.id", "=", (Object)0)};
        DynamicObject[] balAdjustList = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"id, billstatus,auditdate,auditor,bankaccount", (QFilter[])balAdjustFilters);
        return balAdjustList;
    }
}

