/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.validator.BankStatementDeleteValidator;

public class BankStatementDeleteOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        BankStatementDeleteValidator v = new BankStatementDeleteValidator();
        v.setEntityKey("cas_bankstatement");
        e.addValidator((AbstractValidator)v);
        super.onAddValidators(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("source");
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("debitamount");
        e.getFieldKeys().add("creditamount");
        e.getFieldKeys().add("accountbank");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("bizdate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        ArrayList<Long> statementIDs = new ArrayList<Long>(datas.length);
        ArrayList<Long> detailPks = new ArrayList<Long>();
        for (DynamicObject bankStatement : datas) {
            statementIDs.add(bankStatement.getLong("id"));
            if (bankStatement.getInt("source") != 1) continue;
            detailPks.add(bankStatement.getLong("sourcebillid"));
        }
        if (detailPks.size() > 0) {
            String sql = "update t_bei_transdetail set FisDownToBankState=0 where fid in (" + CasHelper.idListToInClause(detailPks) + ")";
            try (TXHandle tx = TX.requiresNew();){
                DB.execute((DBRoute)DBRouteConst.TMC, (String)sql, (Object[])new Object[0]);
            }
        }
        if (statementIDs.size() > 0) {
            OperateServiceHelper.execOperateWithoutThrow((String)"unaudit", (String)"cas_bankstatement", (Object[])statementIDs.toArray(), (OperateOption)OperateOption.create());
        }
    }
}

