/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class CasFillDraftBillEntryOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CasFillDraftBillEntryOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("billno");
        list.add("id");
        list.add("billstatus");
        list.add("bizdate");
        list.add("billtype");
        list.add("draftbill");
        list.add("entry");
        list.add(String.join((CharSequence)".", "entry", "e_sourcebillid"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "transamount"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "srcbillindex"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "paybillcurrency"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        logger.info("beginOperationTransaction to fillBillDraftInfoEntry start");
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.fillBillDraftInfoEntry(dataEntities);
        logger.info("beginOperationTransaction to fillBillDraftInfoEntry end");
    }

    private void fillBillDraftInfoEntry(DynamicObject[] datas) {
        ArrayList<DynamicObject> listArr = new ArrayList<DynamicObject>(8);
        for (DynamicObject data : datas) {
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_draftinfo");
            DynamicObjectCollection newDrafts = data.getDynamicObjectCollection("draftbill");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)newDrafts) || newDrafts.size() <= 0 || !EmptyUtil.isEmpty((DynamicObjectCollection)entrys) && entrys.size() != 0) continue;
            for (DynamicObject newDraft : newDrafts) {
                DynamicObject fbasedataid = newDraft.getDynamicObject("fbasedataid");
                if (!EmptyUtil.isNoEmpty((DynamicObject)fbasedataid)) continue;
                DynamicObject cas_draftinfo = entrys.addNew();
                cas_draftinfo.set("transamount", (Object)fbasedataid.getBigDecimal("amount"));
                cas_draftinfo.set("paybillcurrency", (Object)fbasedataid.getDynamicObject("currency").getLong("id"));
                cas_draftinfo.set("draftbillinfo", (Object)fbasedataid);
                cas_draftinfo.set("srcbillindex", (Object)0);
            }
            listArr.add(data);
        }
        logger.info("listArr size is" + listArr.size());
        if (listArr.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])listArr.toArray(new DynamicObject[0]));
        }
    }
}

