/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.cas.business.opservice.impl.BillPropertyValueHandle;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.validator.ExchangeBillWriteBackValidator;
import kd.fi.cas.validator.OrgFinishinitValidator;

public class ExchangeBillSubmitOp
extends AbstractOperationServicePlugIn {
    private List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>(30);
        list.add("billno");
        list.add("billstatus");
        list.add("bizdate");
        list.add("sellinglocalamount");
        list.add("buyinglocalamount");
        list.add("exchangegainorloss");
        list.add("commissionlocalamount");
        list.add("paycommissionaccount");
        list.add("sellingaccount");
        list.add("org");
        list.add("buyingcurrency");
        list.add("sellingcurrency");
        list.add("commissioncurrency");
        list.add("basecurrency");
        list.add("buyingexchangerate");
        list.add("sellingexchangerate");
        list.add("commissionexchangerate");
        list.add("quotation");
        list.add("salequotation");
        list.add("otherquotation");
        list.add("exratetable");
        list.add("exratedate");
        list.add("buymatchamount");
        list.add("buyunmatchamount");
        list.add("buymatchflagmsg");
        list.add("sellmatchamount");
        list.add("sellunmatchamount");
        list.add("sellmatchflagmsg");
        list.add("feematchamount");
        list.add("feeunmatchamount");
        list.add("feematchflagmsg");
        list.add("commissionamount");
        list.add("sourcebilltype");
        return list;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(this.getSelector());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new OrgFinishinitValidator());
        e.getValidators().add(new ExchangeBillWriteBackValidator(WriteBackOperateEnum.SUBMITVALIDATE));
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject paycommissionAccount;
                    boolean isNotValue;
                    DynamicObject exchangeBill = dataEntity.getDataEntity();
                    DynamicObject buyingcurrency = exchangeBill.getDynamicObject("buyingcurrency");
                    DynamicObject sellingcurrency = exchangeBill.getDynamicObject("sellingcurrency");
                    boolean bl = isNotValue = CasHelper.isNotEmpty((Object)buyingcurrency) && CasHelper.isNotEmpty((Object)sellingcurrency);
                    if (isNotValue && buyingcurrency.getPkValue().equals(sellingcurrency.getPkValue())) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u4e70\u5165\u548c\u5356\u51fa\u5e01\u79cd\u4e0d\u53ef\u4ee5\u4e3a\u540c\u4e00\u5e01\u79cd\u3002", (String)"ExchangeBillSubmitOp_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), exchangeBill.getString("billno")));
                    }
                    Date bizDate = exchangeBill.getDate("bizdate");
                    DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)exchangeBill.getDynamicObject("org").getLong("id"));
                    boolean parameterBoolean = SystemParameterHelper.getParameterBoolean((long)exchangeBill.getDynamicObject("org").getLong("id"), (String)"cs103");
                    if (currentPeriod != null && bizDate.before(currentPeriod.getDate("beginDate")) && !parameterBoolean) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u5141\u8bb8\u5f55\u5165\u5f53\u524d\u671f\u95f4\u4e4b\u524d\u7684\u5916\u5e01\u5151\u6362\u5355\u3002", (String)"ExchangeBillSubmitOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), exchangeBill.getString("billno")));
                    }
                    BigDecimal actualSellingLocalAmt = exchangeBill.getBigDecimal("sellinglocalamount");
                    BigDecimal buyingLocalAmount = exchangeBill.getBigDecimal("buyinglocalamount");
                    BigDecimal exchangeGainorLoss = exchangeBill.getBigDecimal("exchangegainorloss");
                    BigDecimal commissionLocalAmount = exchangeBill.getBigDecimal("commissionlocalamount");
                    BigDecimal theoreticalSellingLocalAmt = buyingLocalAmount.add(exchangeGainorLoss);
                    if (actualSellingLocalAmt.compareTo(theoreticalSellingLocalAmt) != 0) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u91d1\u989d\u3002\u73b0\u6709\u7684\u8f93\u5165\u91d1\u989d\u4e0d\u6ee1\u8db3\u3010\u5356\u51fa\u672c\u5e01\u91d1\u989d=\u4e70\u5165\u672c\u5e01\u91d1\u989d+\u6c47\u5151\u635f\u76ca\u3011", (String)"ExchangeBillSubmitOp_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), exchangeBill.getString("billno")));
                    }
                    if (commissionLocalAmount.compareTo(BigDecimal.ZERO) > 0 && (paycommissionAccount = exchangeBill.getDynamicObject("paycommissionaccount")) == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u8bf7\u9009\u62e9\u624b\u7eed\u8d39\u4ed8\u6b3e\u8d26\u6237\u3002", (String)"ExchangeBillSubmitOp_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), exchangeBill.getString("billno")));
                    }
                    DynamicObject buyAccount = exchangeBill.getDynamicObject("buyingaccount");
                    DynamicObject sellingAccount = exchangeBill.getDynamicObject("sellingaccount");
                    boolean isSellInnerAcc = PayBillCrossHelper.isIfmBankAcc((DynamicObject)sellingAccount);
                    boolean isPayInnerAcc = PayBillCrossHelper.isIfmBankAcc((DynamicObject)buyAccount);
                    if (isSellInnerAcc && isPayInnerAcc || !isSellInnerAcc && !isPayInnerAcc) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u5916\u5e01\u5151\u6362\u4e0d\u652f\u6301\u94f6\u884c\u8d26\u6237\u548c\u5185\u90e8\u8d26\u6237\u4e4b\u95f4\u7684\u5151\u6362\u3002", (String)"ExchangeBillSubmitOp_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), exchangeBill.getString("billno")));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            new BillPropertyValueHandle(info);
        }
    }
}

