/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AppLogHelper;
import kd.fi.cas.helper.FinalCheckOutHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.info.AccountAmount;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;
import kd.fi.cas.validator.FinalCheckOutAntiCheckValidator;

public class FinalCheckOutAntiCheckOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinalCheckOutAntiCheckOp.class);
    private FinalCheckOutHelper finalCheckOutHelper = FinalCheckOutHelper.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("checkoutstatus");
        e.getFieldKeys().add("period");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        FinalCheckOutAntiCheckValidator v = new FinalCheckOutAntiCheckValidator();
        v.setEntityKey("cas_finalcheckout");
        e.addValidator((AbstractValidator)v);
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            AppLogInfo appLogInfo = this.createAppLog(dataEntity.getPkValue());
            appLogInfos.add(appLogInfo);
        }
        LogServiceHelper.addBatchLog(appLogInfos);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        boolean isClosePeriod = this.getOption().containsVariable("closeCacheKey");
        for (int i = 0; i < e.getDataEntities().length; ++i) {
            DynamicObject finalcheckout = e.getDataEntities()[i];
            DynamicObject org = finalcheckout.getDynamicObject("org");
            long orgId = org.getLong("id");
            DynamicObject cashMgtInit = SystemStatusCtrolHelper.getSystemStatusCtrol((long)orgId);
            DynamicObject currentPeriod = cashMgtInit.getDynamicObject("currentperiod");
            this.deleteCurrentCheckoutRecord(org, currentPeriod);
            this.deleteCurrentBalance(org, currentPeriod);
            DynamicObject prevPeriod = SystemStatusCtrolHelper.moveToPrevPeriod((long)orgId);
            if (null == prevPeriod) {
                logger.info("orgid:{}, \u4e0a\u4e00\u671f\u95f4\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            this.updatePreviousCheckoutRecord(org, prevPeriod);
            this.updatePreviousBalance(org, prevPeriod);
            Boolean checkBalance = this.finalCheckOutHelper.toCreateBalanceAdjust(finalcheckout, isClosePeriod);
            if (!checkBalance.booleanValue()) continue;
            this.updateBalanceAdjust(cashMgtInit);
        }
    }

    private AppLogInfo createAppLog(Object finalCheckOutId) {
        long orgId = 0L;
        String orgNumber = "";
        String orgName = "";
        String currentPeriod = "";
        DynamicObject fCheckOutBill = null;
        DynamicObject[] fCheckOutBills = BusinessDataServiceHelper.load((Object[])new Object[]{finalCheckOutId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_finalcheckout"));
        if (fCheckOutBills != null && fCheckOutBills.length > 0) {
            fCheckOutBill = fCheckOutBills[0];
            orgId = fCheckOutBill.getDynamicObject("org").getLong("id");
        }
        if (fCheckOutBill != null) {
            orgNumber = fCheckOutBill.getDynamicObject("org").getString("number");
            orgName = fCheckOutBill.getDynamicObject("org").getString("name");
            currentPeriod = fCheckOutBill.getDynamicObject("period").getString("name");
        }
        MultiLangEnumBridge str = AppLogHelper.buildMultiLangBridge((String)"%1$s%2$s%3$s\u53cd\u7ed3\u8d26\u6210\u529f", (String)"FinalCheckOutAntiCheckOp_0", (String)"fi-cas-opplugin");
        if (this.operateOption.containsVariable("clientType") && this.operateOption.containsVariable("clientIP")) {
            RequestContext.get().setClient(this.operateOption.getVariableValue("clientType"));
            RequestContext.get().setLoginIP(this.operateOption.getVariableValue("clientIP"));
        }
        MultiLangEnumBridge opNameBridge = AppLogHelper.buildMultiLangBridge((String)"\u53cd\u7ed3\u8d26", (String)"FinalCheckOutAntiCheckOp_1", (String)"fi-cas-opplugin");
        return AppLogHelper.createAppLog((String)"cas_finalcheckout", (long)orgId, (String)"anticheckout", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)str, (Object[])new Object[]{orgNumber, orgName, currentPeriod});
    }

    private void updateBalanceAdjust(DynamicObject cashMgtInit) {
        DynamicObject currentPeriod = cashMgtInit.getDynamicObject("currentperiod");
        DynamicObject prevPeriod = PeriodHelper.getPrevPeriod((long)currentPeriod.getLong("id"));
        Date date = prevPeriod.getDate("enddate");
        QFilter filter = new QFilter("org", "=", cashMgtInit.getDynamicObject("org").getPkValue()).and("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)date, (boolean)false)).and("bizdate", ">=", (Object)DateUtils.getDataFormat((Date)date, (boolean)true)).and("billstatus", "in", Arrays.asList(BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue()));
        DynamicObject[] balanceAdjusts = BusinessDataServiceHelper.load((String)"cas_balanceadjust", (String)"id,billstatus,auditdate,auditor,billno", (QFilter[])new QFilter[]{filter});
        if (balanceAdjusts != null && balanceAdjusts.length > 0) {
            ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>(balanceAdjusts.length);
            for (DynamicObject balanceAdjust : balanceAdjusts) {
                balanceAdjust.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                balanceAdjust.set("auditdate", null);
                balanceAdjust.set("auditor", null);
                MultiLangEnumBridge opDesc = AppLogHelper.buildMultiLangBridge((String)"\u53cd\u7ed3\u8d26\u81ea\u52a8\u89e6\u53d1\uff0c\u7f16\u53f7%s\uff0c\u64a4\u9500\u6210\u529f/\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"FinalCheckOutAntiCheckOp_2", (String)"fi-cas-opplugin");
                MultiLangEnumBridge opNameBridge = AppLogHelper.buildMultiLangBridge((String)"\u53cd\u7ed3\u8d26", (String)"FinalCheckOutAntiCheckOp_1", (String)"fi-cas-opplugin");
                AppLogInfo appLog = AppLogHelper.createAppLog((String)"cas_finalcheckout", (long)RequestContext.get().getOrgId(), (String)"anticheckout", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDesc, (Object[])new Object[]{balanceAdjust.getString("billno")});
                appLogInfos.add(appLog);
            }
            SaveServiceHelper.save((DynamicObject[])balanceAdjusts);
            LogServiceHelper.addBatchLog(appLogInfos);
        }
    }

    private void updatePreviousBalance(DynamicObject org, DynamicObject prevPeriod) {
        DynamicObject[] journalBalanceList;
        List<AccountAmount> cashJournalList = this.getCashJournals(org, prevPeriod);
        List<AccountAmount> bankJournalList = this.getBankJournals(org, prevPeriod);
        QFilter[] balanceFilters = this.createFilters(org, prevPeriod);
        for (DynamicObject journalbalance : journalBalanceList = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, type, org, openorg, accountcash, accountbank, currency, period, monthstart, monthdebit, monthcredit, monthbalance, yearstart, yeardebit, yearcredit, yearbalance, isbalanced", (QFilter[])balanceFilters)) {
            DynamicObject bank;
            long acctId;
            String type = journalbalance.getString("type");
            journalbalance.set("isbalanced", (Object)0);
            if (type.equals("3")) continue;
            long currencyId = journalbalance.getDynamicObject("currency").getLong("id");
            if (type.equals("1")) {
                DynamicObject cash = journalbalance.getDynamicObject("accountcash");
                if (cash == null) continue;
                acctId = cash.getLong("id");
                this.calculateBalance(cashJournalList, journalbalance, currencyId, acctId);
                continue;
            }
            if (!type.equals("2") || (bank = journalbalance.getDynamicObject("accountbank")) == null) continue;
            acctId = journalbalance.getDynamicObject("accountbank").getLong("id");
            this.calculateBalance(bankJournalList, journalbalance, currencyId, acctId);
        }
        SaveServiceHelper.save((DynamicObject[])journalBalanceList);
    }

    private void deleteCurrentCheckoutRecord(DynamicObject org, DynamicObject currentPeriod) {
        QFilter[] filters = this.createFilters(org, currentPeriod);
        DynamicObject[] finalcheckoutList = BusinessDataServiceHelper.load((String)"cas_finalcheckout", (String)"id", (QFilter[])filters);
        if (finalcheckoutList.length > 0) {
            Object[] pks = Arrays.stream(finalcheckoutList).map(obj -> obj.getLong("id")).toArray();
            DeleteServiceHelper.delete((IDataEntityType)finalcheckoutList[0].getDataEntityType(), (Object[])pks);
        }
    }

    private QFilter[] createFilters(DynamicObject org, DynamicObject period) {
        QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
        QFilter periodFilter = new QFilter("period", "=", (Object)period.getLong("id"));
        return new QFilter[]{orgFilter, periodFilter};
    }

    private QFilter[] createFilters4Balance(DynamicObject org, DynamicObject period) {
        QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
        QFilter periodFilter = new QFilter("period", "=", (Object)period.getLong("id"));
        QFilter[] qFilters = null;
        boolean filterState = this.filterState(org, period);
        if (filterState) {
            QFilter qType = new QFilter("type", "!=", (Object)"3");
            qFilters = new QFilter[]{orgFilter, periodFilter, qType};
        } else {
            qFilters = new QFilter[]{orgFilter, periodFilter};
        }
        return qFilters;
    }

    private boolean filterState(DynamicObject org, DynamicObject period) {
        DynamicObject startState = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (QFilter[])this.createStateStartFilters(org, period));
        if (startState == null || EmptyUtil.isEmpty((DynamicObject)startState)) {
            return false;
        }
        DynamicObject initState = BusinessDataServiceHelper.loadSingle((String)"cas_rec_init", (QFilter[])this.createStateInitFilters(org, period));
        return initState != null && !EmptyUtil.isEmpty((DynamicObject)initState);
    }

    private QFilter[] createStateStartFilters(DynamicObject org, DynamicObject period) {
        QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
        QFilter periodFilter = new QFilter("recperiod", "=", (Object)period.getLong("id"));
        return new QFilter[]{orgFilter, periodFilter};
    }

    private QFilter[] createStateInitFilters(DynamicObject org, DynamicObject period) {
        QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
        QFilter periodFilter = new QFilter("initperiod", "=", (Object)period.getLong("id"));
        QFilter initFilter = new QFilter("isfinishinit", "=", (Object)"1");
        return new QFilter[]{orgFilter, periodFilter, initFilter};
    }

    private void deleteCurrentBalance(DynamicObject org, DynamicObject currentPeriod) {
        QFilter[] curPeriodBalanceFilters = this.createFilters4Balance(org, currentPeriod);
        DynamicObject[] journalBalanceList = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id", (QFilter[])curPeriodBalanceFilters);
        if (journalBalanceList.length > 0) {
            DeleteServiceHelper.delete((IDataEntityType)journalBalanceList[0].getDataEntityType(), (Object[])StringUtils.getPks((DynamicObject[])journalBalanceList));
        }
    }

    private void updatePreviousCheckoutRecord(DynamicObject org, DynamicObject prePeriod) {
        QFilter[] preCheckoutRecordFilters = this.createFilters(org, prePeriod);
        Object[] preFinalcheckoutList = BusinessDataServiceHelper.load((String)"cas_finalcheckout", (String)"id, checkoutstatus, org, period, checkoutmsg", (QFilter[])preCheckoutRecordFilters);
        if (EmptyUtil.isEmpty((Object[])preFinalcheckoutList)) {
            return;
        }
        Object perCheckoutRecord = preFinalcheckoutList[0];
        perCheckoutRecord.set("checkoutstatus", (Object)1);
        perCheckoutRecord.set("checkoutmsg", null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{perCheckoutRecord});
    }

    private List<AccountAmount> getBankJournals(DynamicObject org, DynamicObject prevPeriod) {
        LinkedList<AccountAmount> bankJournalList = new LinkedList<AccountAmount>();
        QFilter[] bankJournalFilters = this.createFilters(org, prevPeriod);
        try (DataSet bankJournalRawDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".bankjournal"), (String)"cas_bankjournal", (String)"accountbank,currency,debitamount,creditamount", (QFilter[])bankJournalFilters, null);
             DataSet bankJournalGroupByDataSet = bankJournalRawDataSet.groupBy(new String[]{"accountbank", "currency"}).sum("debitamount").sum("creditamount").finish();){
            bankJournalGroupByDataSet.forEach(row -> {
                AccountAmount acctAmount = new AccountAmount();
                acctAmount.setAccount(row.getLong("accountbank").longValue());
                acctAmount.setCurrency(row.getLong("currency").longValue());
                acctAmount.setCreditAmount(row.getBigDecimal("creditamount"));
                acctAmount.setDebitAmount(row.getBigDecimal("debitamount"));
                bankJournalList.add(acctAmount);
            });
        }
        return bankJournalList;
    }

    private List<AccountAmount> getCashJournals(DynamicObject org, DynamicObject prevPeriod) {
        LinkedList<AccountAmount> cashJournalList = new LinkedList<AccountAmount>();
        QFilter[] cashJournalFilters = this.createFilters(org, prevPeriod);
        try (DataSet cashJournalRawDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".cashjournal"), (String)"cas_cashjournal", (String)"accountcash,currency,debitamount,creditamount", (QFilter[])cashJournalFilters, null);
             DataSet cashJournalGroupByDataSet = cashJournalRawDataSet.groupBy(new String[]{"accountcash", "currency"}).sum("debitamount").sum("creditamount").finish();){
            cashJournalGroupByDataSet.forEach(row -> {
                AccountAmount acctAmount = new AccountAmount();
                acctAmount.setAccount(row.getLong("accountcash").longValue());
                acctAmount.setCurrency(row.getLong("currency").longValue());
                acctAmount.setCreditAmount(row.getBigDecimal("creditamount"));
                acctAmount.setDebitAmount(row.getBigDecimal("debitamount"));
                cashJournalList.add(acctAmount);
            });
        }
        return cashJournalList;
    }

    private void calculateBalance(List<AccountAmount> cashJournalList, DynamicObject journalbalance, long currencyId, long acctId) {
        for (AccountAmount journal : cashJournalList) {
            long journalAcctId = journal.getAccount();
            long journalCurrencyId = journal.getCurrency();
            if (acctId != journalAcctId || currencyId != journalCurrencyId) continue;
            journalbalance.set("monthdebit", (Object)journalbalance.getBigDecimal("monthdebit").subtract(journal.getDebitAmount()));
            journalbalance.set("monthcredit", (Object)journalbalance.getBigDecimal("monthcredit").subtract(journal.getCreditAmount()));
            journalbalance.set("monthbalance", (Object)journalbalance.getBigDecimal("monthstart").subtract(journalbalance.getBigDecimal("monthcredit")).add(journalbalance.getBigDecimal("monthdebit")));
            journalbalance.set("yeardebit", (Object)journalbalance.getBigDecimal("yeardebit").subtract(journal.getDebitAmount()));
            journalbalance.set("yearcredit", (Object)journalbalance.getBigDecimal("yearcredit").subtract(journal.getCreditAmount()));
            journalbalance.set("yearbalance", (Object)journalbalance.getBigDecimal("yearstart").subtract(journalbalance.getBigDecimal("yearcredit")).add(journalbalance.getBigDecimal("yeardebit")));
            break;
        }
    }
}

