/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.service.BalanceCalculateService;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.AppLogHelper;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.info.AccountAmount;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.ViewUtils;
import kd.fi.cas.validator.CheckOutAdjustValidator;
import kd.fi.cas.validator.CheckOutValidator;
import kd.fi.cas.validator.FinalCheckOutCheckValidator;
import kd.fi.cas.validator.closeperiod.ClosePeriodCheckItemValidator;

public class FinalCheckOutCheckOp
extends AbstractOperationServicePlugIn {
    private BalanceCalculateService balanceCalculateService = new BalanceCalculateService();
    private static final Log logger = LogFactory.getLog(FinalCheckOutCheckOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("auditor");
        fields.add("auditdate");
        fields.add("checkoutmsg");
        fields.add("checkoutstatus");
        fields.add("createtime");
        fields.add("creator");
        fields.add("modifier");
        fields.add("modifytime");
        fields.add("billno");
        fields.add("org");
        fields.add("org.number");
        fields.add("org.name");
        fields.add("period");
        fields.add("period.name");
        fields.add("period.begindate");
        fields.add("period.enddate");
        fields.add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CheckOutValidator());
        e.addValidator((AbstractValidator)new CheckOutAdjustValidator());
        e.addValidator((AbstractValidator)new FinalCheckOutCheckValidator(this.balanceCalculateService));
        e.addValidator((AbstractValidator)new ClosePeriodCheckItemValidator());
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            AppLogInfo appLog = this.createAppLog(dataEntity);
            appLogInfos.add(appLog);
        }
        LogServiceHelper.addBatchLog(appLogInfos);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] finalCheckOutList;
        super.endOperationTransaction(e);
        ArrayList<Long> listCheckPks = new ArrayList<Long>(10);
        int size = e.getDataEntities().length;
        if (size <= 0) {
            this.getOperationResult().setSuccessPkIds(listCheckPks);
            return;
        }
        Object[] ids = new Long[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = e.getDataEntities()[i].getLong("id");
        }
        for (DynamicObject finalcheckout : finalCheckOutList = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)e.getDataEntities()[0].getDynamicObjectType())) {
            finalcheckout.set("checkoutstatus", (Object)3);
            finalcheckout.set("checkoutmsg", (Object)ResManager.loadKDString((String)"\u7ed3\u8d26\u6210\u529f\u3002", (String)"FinalCheckOutCheckOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        SaveServiceHelper.save((DynamicObject[])finalCheckOutList);
        ArrayList<DynamicObject> nextCheckOutRecordList = new ArrayList<DynamicObject>(size);
        for (DynamicObject finalcheckout : finalCheckOutList) {
            DynamicObject org = finalcheckout.getDynamicObject("org");
            long orgId = org.getLong("id");
            DynamicObject nextPeriod = SystemStatusCtrolHelper.moveToNextPeriod((long)orgId);
            nextCheckOutRecordList.add(this.genNextCheckoutRecord(org, nextPeriod));
            DynamicObject currentPeriod = finalcheckout.getDynamicObject("period");
            long currentPeriodId = currentPeriod.getLong("id");
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            QFilter periodFilter = new QFilter("period", "=", (Object)currentPeriodId);
            List<AccountAmount> cashJournals = this.getCurrentCashJournals(org, currentPeriod);
            List<AccountAmount> bankJournals = this.getCurrentBankJournals(org, currentPeriod);
            QFilter[] filters = new QFilter[]{orgFilter, periodFilter};
            DynamicObject[] currentBalanceRecords = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, type, org, openorg, accountcash, accountbank, currency, period, monthstart, monthdebit, monthcredit, monthbalance, yearstart, yeardebit, yearcredit, yearbalance, isbalanced", (QFilter[])filters);
            this.updateCurrentBalance(cashJournals, bankJournals, currentBalanceRecords);
            Map<String, DynamicObject> resetData = this.getResetBalance(nextPeriod, finalcheckout);
            Map<String, DynamicObject> initData = this.getRecInit(nextPeriod, finalcheckout);
            HashMap<String, DynamicObject> reSetInitData = new HashMap<String, DynamicObject>();
            reSetInitData.putAll(resetData);
            reSetInitData.putAll(initData);
            this.insertNextBalanceWithExistedAccounts(nextPeriod, currentBalanceRecords, reSetInitData, resetData);
            this.insertBalanceWithNewAccounts(finalcheckout, nextPeriod, cashJournals, bankJournals, resetData, reSetInitData);
            this.addBalanceInitData(resetData, org, nextPeriod);
            listCheckPks.add(finalcheckout.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])nextCheckOutRecordList.toArray(new DynamicObject[0]));
        logger.info("--->> FinalCheckOutCheckOp.endOperationTransaction(),listCheck.size()={}", (Object)size);
        this.createBalanceAdjust();
        this.getOperationResult().setSuccessPkIds(listCheckPks);
    }

    private AppLogInfo createAppLog(DynamicObject fCheckOutBill) {
        long orgId = fCheckOutBill.getDynamicObject("org").getLong("id");
        String orgNumber = fCheckOutBill.getDynamicObject("org").getString("number");
        String orgName = fCheckOutBill.getDynamicObject("org").getString("name");
        String currentPeriod = fCheckOutBill.getDynamicObject("period").getString("name");
        MultiLangEnumBridge str = AppLogHelper.buildMultiLangBridge((String)"%1$s%2$s%3$s\u7ed3\u8d26\u6210\u529f", (String)"FinalCheckOutCheckOp_8", (String)"fi-cas-opplugin");
        if (this.operateOption.containsVariable("clientType") && this.operateOption.containsVariable("clientIP")) {
            RequestContext.get().setClient(this.operateOption.getVariableValue("clientType"));
            RequestContext.get().setLoginIP(this.operateOption.getVariableValue("clientIP"));
        }
        MultiLangEnumBridge opNameBridge = AppLogHelper.buildMultiLangBridge((String)"\u7ed3\u8d26", (String)"FinalCheckOutCheckOp_9", (String)"fi-cas-opplugin");
        return AppLogHelper.createAppLog((String)"cas_finalcheckout", (long)orgId, (String)"checkout", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)str, (Object[])new Object[]{orgNumber, orgName, currentPeriod});
    }

    private void addBalanceInitData(Map<String, DynamicObject> resetData, DynamicObject org, DynamicObject nextPeriod) {
        if (resetData.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> saveBalances = new ArrayList<DynamicObject>();
        for (DynamicObject reset : resetData.values()) {
            String type = reset.getString("type");
            if ("cash".equals(type)) {
                saveBalances.add(this.createCash(reset, org, nextPeriod));
                continue;
            }
            saveBalances.add(this.createBank(reset, org, nextPeriod));
        }
        SaveServiceHelper.save((DynamicObject[])saveBalances.toArray(new DynamicObject[0]));
    }

    private DynamicObject genNextCheckoutRecord(DynamicObject org, DynamicObject nextPeriod) {
        DynamicObject nextFinalcheckout = BusinessDataServiceHelper.newDynamicObject((String)"cas_finalcheckout");
        DynamicObjectHelper.setValue((DynamicObject)nextFinalcheckout, (String)"checkoutstatus", (Object)1);
        DynamicObjectHelper.setValue((DynamicObject)nextFinalcheckout, (String)"creator", (Object)CasHelper.getCurrentUser());
        DynamicObjectHelper.setValue((DynamicObject)nextFinalcheckout, (String)"createtime", (Object)new Date());
        DynamicObjectHelper.setValue((DynamicObject)nextFinalcheckout, (String)"org", (Object)org);
        DynamicObjectHelper.setValue((DynamicObject)nextFinalcheckout, (String)"period", (Object)nextPeriod);
        return nextFinalcheckout;
    }

    private void createBalanceAdjust() {
        String existdjuts = this.getOption().getVariableValue("existdjut");
        if (!StringUtils.isEmpty((CharSequence)existdjuts)) {
            int count = DeleteServiceHelper.delete((String)"cas_balanceadjust", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)Arrays.asList(existdjuts.split(",")).stream().mapToLong(Long::parseLong).toArray())});
            logger.info("--->> FinalCheckOutCheckOp.createBalanceAdjust(),existdjut={},delete count={}", (Object)existdjuts, (Object)count);
        }
        List adjustDtList = this.balanceCalculateService.getAdjustList();
        logger.info("--->> FinalCheckOutCheckOp.createBalanceAdjust(),adjustDtList.size()={}", (Object)adjustDtList.size());
        if (adjustDtList.size() == 0) {
            return;
        }
        adjustDtList.forEach(dy -> BalanceAdjustHelper.setDiffAndBankCg((DynamicObject)dy));
        SaveServiceHelper.save((DynamicObject[])adjustDtList.toArray(new DynamicObject[0]));
        ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>();
        List currencyIds = adjustDtList.stream().map(e -> e.get("currency_id")).collect(Collectors.toList());
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (QFilter[])new QFilter("id", "in", currencyIds).toArray());
        for (DynamicObject balanceAdjust : adjustDtList) {
            DynamicObject currency = (DynamicObject)currencyMap.get(balanceAdjust.get("currency_id"));
            MultiLangEnumBridge opDesc = AppLogHelper.buildMultiLangBridge((String)"\u671f\u672b\u7ed3\u8d26\u89e6\u53d1\u751f\u6210\u4f59\u989d\u8c03\u8282\u8868\uff0c\u7f16\u53f7%1$s\uff08\u7ec4\u7ec7\uff1a%2$s\uff0c\u8d26\u53f7\uff1a%3$s\uff0c\u5e01\u79cd\uff1a%4$s\uff0c\u622a\u6b62\u65e5\u671f\uff1a%5$s\uff09\uff0c\u7cfb\u7edf\u81ea\u52a8\u7f6e\u4e3a\u5df2\u63d0\u4ea4\u72b6\u6001\u3002", (String)"FinalCheckOutCheckOp_10", (String)"fi-cas-opplugin");
            MultiLangEnumBridge opNameBridge = AppLogHelper.buildMultiLangBridge((String)"\u7ed3\u8d26", (String)"FinalCheckOutCheckOp_9", (String)"fi-cas-opplugin");
            AppLogInfo appLogInfo = AppLogHelper.createAppLog((String)"cas_finalcheckout", (long)RequestContext.get().getOrgId(), (String)"checkout", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDesc, (Object[])new Object[]{balanceAdjust.getString("billno"), balanceAdjust.getDynamicObject("org").getString("name"), balanceAdjust.getString("bankaccountnumber"), currency.getString("name"), DateUtils.getMonthDay((Date)balanceAdjust.getDate("bizdate"))});
            appLogInfos.add(appLogInfo);
        }
        LogServiceHelper.addBatchLog(appLogInfos);
    }

    private void insertBalanceWithNewAccounts(DynamicObject currentCheckoutRecord, DynamicObject nextPeriod, List<AccountAmount> cashJournals, List<AccountAmount> bankJournals, Map<String, DynamicObject> resetData, Map<String, DynamicObject> reSetInitData) {
        DynamicObject nextJournalBalance;
        DynamicObject journalBalance;
        LinkedList<DynamicObject> balanceRecords = new LinkedList<DynamicObject>();
        for (AccountAmount journal : cashJournals) {
            journalBalance = this.createCurrentBalanceWithNewAccounts(currentCheckoutRecord, journal);
            balanceRecords.add(journalBalance);
            nextJournalBalance = this.createNextBalanceWithNewAccounts(currentCheckoutRecord, nextPeriod, journal, resetData, reSetInitData);
            balanceRecords.add(nextJournalBalance);
        }
        for (AccountAmount journal : bankJournals) {
            journalBalance = this.createCurrentBalanceWithNewAccounts(currentCheckoutRecord, journal);
            balanceRecords.add(journalBalance);
            nextJournalBalance = this.createNextBalanceWithNewAccounts(currentCheckoutRecord, nextPeriod, journal, resetData, reSetInitData);
            balanceRecords.add(nextJournalBalance);
        }
        SaveServiceHelper.save((DynamicObject[])balanceRecords.toArray(new DynamicObject[0]));
    }

    private DynamicObject createNextBalanceWithNewAccounts(DynamicObject finalcheckout, DynamicObject nextPeriod, AccountAmount journal, Map<String, DynamicObject> resetData, Map<String, DynamicObject> reSetInitData) {
        BigDecimal debitAmount = journal.getDebitAmount();
        BigDecimal creditAmount = journal.getCreditAmount();
        DynamicObject nextJournalBalance = this.createBaseBalance(journal);
        boolean isCash = "cas_cashjournal".equals(journal.getSource());
        String typeNumber = isCash ? "1" : "2";
        String keyMap = this.getMapKay(typeNumber, String.valueOf(journal.getOrg()), String.valueOf(nextPeriod.getLong("id")), String.valueOf(journal.getCurrency()), String.valueOf(journal.getAccount()));
        DynamicObject resetDynamic = reSetInitData.get(keyMap);
        resetData.remove(keyMap);
        BigDecimal monthstart = debitAmount.subtract(creditAmount);
        BigDecimal monthbalance = debitAmount.subtract(creditAmount);
        if (EmptyUtil.isNoEmpty((DynamicObject)resetDynamic)) {
            BigDecimal initMonthStart = resetDynamic.getBigDecimal("initbalance");
            monthbalance = monthstart = initMonthStart.add(debitAmount).subtract(creditAmount);
        }
        DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"org", (Object)finalcheckout.getDynamicObject("org"));
        DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"period", (Object)nextPeriod);
        DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"monthstart", (Object)monthstart);
        DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"monthdebit", (Object)0);
        DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"monthcredit", (Object)0);
        DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"monthbalance", (Object)monthbalance);
        if (nextPeriod.getInt("periodnumber") == 1) {
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yearstart", (Object)monthstart);
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yeardebit", (Object)0);
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yearcredit", (Object)0);
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yearbalance", (Object)monthbalance);
        } else {
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yearstart", (Object)0);
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yeardebit", (Object)debitAmount);
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yearcredit", (Object)creditAmount);
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yearbalance", (Object)monthbalance);
        }
        DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"isbalanced", (Object)"0");
        return nextJournalBalance;
    }

    private DynamicObject createCurrentBalanceWithNewAccounts(DynamicObject finalcheckout, AccountAmount journal) {
        BigDecimal debitAmount = journal.getDebitAmount();
        BigDecimal creditAmount = journal.getCreditAmount();
        DynamicObject journalBalance = this.createBaseBalance(journal);
        journalBalance.set("org", (Object)finalcheckout.getDynamicObject("org"));
        journalBalance.set("period", (Object)finalcheckout.getDynamicObject("period"));
        journalBalance.set("monthstart", (Object)0);
        journalBalance.set("monthdebit", (Object)debitAmount);
        journalBalance.set("monthcredit", (Object)creditAmount);
        journalBalance.set("monthbalance", (Object)debitAmount.subtract(creditAmount));
        journalBalance.set("yearstart", (Object)0);
        journalBalance.set("yeardebit", (Object)debitAmount);
        journalBalance.set("yearcredit", (Object)creditAmount);
        journalBalance.set("yearbalance", (Object)debitAmount.subtract(creditAmount));
        journalBalance.set("isbalanced", (Object)"1");
        return journalBalance;
    }

    private DynamicObject createBaseBalance(AccountAmount journal) {
        boolean isCash = "cas_cashjournal".equals(journal.getSource());
        DynamicObject accountCash = isCash ? AccountCashHelper.getAccountCashById((long)journal.getAccount()) : null;
        DynamicObject accountBank = isCash ? null : AccountBankHelper.getAccountBankById((long)journal.getAccount());
        DynamicObject journalBalance = BusinessDataServiceHelper.newDynamicObject((String)"cas_journalbalance");
        journalBalance.set("accountbank", (Object)accountBank);
        journalBalance.set("accountcash", (Object)accountCash);
        journalBalance.set("currency", (Object)BusinessDataServiceHelper.loadSingle((Object)journal.getCurrency(), (String)"bd_currency"));
        if (accountBank != null) {
            journalBalance.set("openorg", (Object)accountBank.getDynamicObject("openorg"));
        }
        journalBalance.set("type", (Object)(isCash ? "1" : "2"));
        journalBalance.set("enable", (Object)"1");
        journalBalance.set("ctrlstrategy", (Object)"5");
        journalBalance.set("creator", (Object)ViewUtils.getCurrentUser());
        journalBalance.set("createtime", (Object)new Date());
        return journalBalance;
    }

    private List<AccountAmount> getCurrentBankJournals(DynamicObject org, DynamicObject currentPeriod) {
        ArrayList<AccountAmount> bankJournalList = new ArrayList<AccountAmount>();
        String bankJournalSelectors = "org,accountbank,currency,debitamount,creditamount,id";
        QFilter[] journalFilters = this.createFilters(org, currentPeriod);
        try (DataSet bankJournalDataSet = QueryServiceHelper.queryDataSet((String)"cas.finalcheckout.querybankjournal", (String)"cas_bankjournal", (String)bankJournalSelectors, (QFilter[])journalFilters, null);
             DataSet groupedBankJournal = bankJournalDataSet.groupBy(new String[]{"org", "accountbank", "currency"}).sum("debitamount").sum("creditamount").finish();){
            groupedBankJournal.forEach(row -> {
                Long bankId = row.getLong("accountbank");
                if (!CasHelper.isEmpty((Object)bankId)) {
                    AccountAmount acctAmount = new AccountAmount();
                    acctAmount.setSource("cas_bankjournal");
                    acctAmount.setOrg(row.getLong("org").longValue());
                    acctAmount.setAccount(bankId.longValue());
                    acctAmount.setCurrency(row.getLong("currency").longValue());
                    acctAmount.setDebitAmount(row.getBigDecimal("debitamount"));
                    acctAmount.setCreditAmount(row.getBigDecimal("creditamount"));
                    bankJournalList.add(acctAmount);
                }
            });
        }
        return bankJournalList;
    }

    private List<AccountAmount> getCurrentCashJournals(DynamicObject org, DynamicObject currentPeriod) {
        ArrayList<AccountAmount> cashJournalList = new ArrayList<AccountAmount>();
        String cashJournalSelectors = "accountcash,currency,debitamount,creditamount,org,id";
        QFilter[] journalFilters = this.createFilters(org, currentPeriod);
        try (DataSet cashJournalDataSet = QueryServiceHelper.queryDataSet((String)"cas.finalcheckout.querycashjournal", (String)"cas_cashjournal", (String)cashJournalSelectors, (QFilter[])journalFilters, null);
             DataSet groupedCashJournal = cashJournalDataSet.groupBy(new String[]{"accountcash", "currency", "org"}).sum("debitamount").sum("creditamount").finish();){
            groupedCashJournal.forEach(row -> {
                Long cashId = row.getLong("accountcash");
                if (!CasHelper.isEmpty((Object)cashId)) {
                    AccountAmount acctAmount = new AccountAmount();
                    acctAmount.setSource("cas_cashjournal");
                    acctAmount.setAccount(cashId.longValue());
                    acctAmount.setOrg(row.getLong("org").longValue());
                    acctAmount.setCurrency(row.getLong("currency").longValue());
                    acctAmount.setDebitAmount(row.getBigDecimal("debitamount"));
                    acctAmount.setCreditAmount(row.getBigDecimal("creditamount"));
                    cashJournalList.add(acctAmount);
                }
            });
        }
        return cashJournalList;
    }

    private Map<String, DynamicObject> getResetBalance(DynamicObject nextPeriod, DynamicObject finalcheckout) {
        QFilter statusFilter;
        QFilter periodFilter;
        HashMap<String, DynamicObject> resetData = new HashMap<String, DynamicObject>(8);
        DynamicObject org = finalcheckout.getDynamicObject("org");
        long orgId = org.getLong("id");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{orgFilter, periodFilter = new QFilter("resetinitbalperiod", "=", nextPeriod.getPkValue()), statusFilter = new QFilter("billstatus", "=", (Object)"C")};
        DynamicObject[] resetBalanceBills = BusinessDataServiceHelper.load((String)"cas_resetinitbalance", (String)"id, entryentity.cash_accountcash, entryentity.bank_accountbank,org,resetinitbalperiod, entryentity.type, entryentity.currency, entryentity.discarded, entryentity.initbalance", (QFilter[])filters);
        if (resetBalanceBills == null) {
            return resetData;
        }
        for (DynamicObject resetBalanceBill : resetBalanceBills) {
            DynamicObjectCollection entryEntity = resetBalanceBill.getDynamicObjectCollection("entryentity");
            if (entryEntity == null || entryEntity.size() == 0) continue;
            for (DynamicObject entry : entryEntity) {
                Boolean discard = entry.getBoolean("discarded");
                if (discard.booleanValue()) continue;
                String type = entry.getString("type");
                String typeNumber = "";
                Long accountId = null;
                if ("cash".equals(type)) {
                    typeNumber = "1";
                    accountId = entry.getDynamicObject("cash_accountcash").getLong("id");
                } else if ("bank".equals(type)) {
                    typeNumber = "2";
                    accountId = entry.getDynamicObject("bank_accountbank").getLong("id");
                }
                Long currencyId = entry.getDynamicObject("currency").getLong("id");
                String keyMap = this.getMapKay(typeNumber, String.valueOf(orgId), String.valueOf(nextPeriod.getLong("id")), String.valueOf(currencyId), String.valueOf(accountId));
                resetData.put(keyMap, entry);
            }
        }
        return resetData;
    }

    private Map<String, DynamicObject> getRecInit(DynamicObject nextPeriod, DynamicObject finalcheckout) {
        HashMap<String, DynamicObject> initData = new HashMap<String, DynamicObject>(8);
        DynamicObject org = finalcheckout.getDynamicObject("org");
        long orgId = org.getLong("id");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter filterFinish = new QFilter("isfinishinit", "=", (Object)true);
        QFilter initPeriodFilter = new QFilter("initperiod", "=", nextPeriod.getPkValue());
        QFilter[] filter = new QFilter[]{orgFilter, initPeriodFilter, filterFinish};
        DynamicObject recInitObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_init", (String)"id, isfinishinit,entrybank, entrybank.bank_statementbalance,entrybank.bank_statementdebit,entrybank.bank_statementcredit, entrybank.bank_accountbank, entrybank.bank_currency", (QFilter[])filter);
        if (recInitObject == null) {
            return initData;
        }
        DynamicObjectCollection dynamicObjectCollection = recInitObject.getDynamicObjectCollection("entrybank");
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            return initData;
        }
        for (DynamicObject entry : dynamicObjectCollection) {
            DynamicObject currency = entry.getDynamicObject("bank_currency");
            DynamicObject account = entry.getDynamicObject("bank_accountbank");
            if (currency == null || account == null) continue;
            Long currencyId = currency.getLong("id");
            Long accountId = account.getLong("id");
            String keyMap = this.getMapKay("3", String.valueOf(orgId), String.valueOf(nextPeriod.getLong("id")), String.valueOf(currencyId), String.valueOf(accountId));
            initData.put(keyMap, entry);
        }
        return initData;
    }

    private void insertNextBalanceWithExistedAccounts(DynamicObject nextPeriod, DynamicObject[] currentBalanceRecords, Map<String, DynamicObject> reSetInitData, Map<String, DynamicObject> resetData) {
        ArrayList<DynamicObject> nextBalanceRecords = new ArrayList<DynamicObject>(1);
        for (DynamicObject balanceRecord : currentBalanceRecords) {
            String typeNumber = balanceRecord.getString("type");
            Long orgId = balanceRecord.getDynamicObject("org").getLong("id");
            Long currencyId = balanceRecord.getDynamicObject("currency").getLong("id");
            Long accountId = null;
            DynamicObject cashDynamic = balanceRecord.getDynamicObject("accountcash");
            DynamicObject bankDynamic = balanceRecord.getDynamicObject("accountbank");
            if ("1".equals(typeNumber) && EmptyUtil.isNoEmpty((DynamicObject)cashDynamic)) {
                accountId = cashDynamic.getLong("id");
            } else if (EmptyUtil.isNoEmpty((DynamicObject)bankDynamic) && ("2".equals(typeNumber) || "3".equals(typeNumber))) {
                accountId = balanceRecord.getDynamicObject("accountbank").getLong("id");
            }
            String keyMap = this.getMapKay(typeNumber, String.valueOf(orgId), String.valueOf(nextPeriod.getLong("id")), String.valueOf(currencyId), String.valueOf(accountId));
            DynamicObject resetDynamic = reSetInitData.get(keyMap);
            resetData.remove(keyMap);
            BigDecimal monthstart = balanceRecord.getBigDecimal("monthbalance");
            BigDecimal monthbalance = balanceRecord.getBigDecimal("monthbalance");
            BigDecimal yearstart = balanceRecord.getBigDecimal("yearstart");
            BigDecimal yeardebit = balanceRecord.getBigDecimal("yeardebit");
            BigDecimal yearcredit = balanceRecord.getBigDecimal("yearcredit");
            BigDecimal yearbalance = balanceRecord.getBigDecimal("yearbalance");
            if (EmptyUtil.isNoEmpty((DynamicObject)resetDynamic)) {
                if (!"3".equals(typeNumber)) {
                    monthbalance = monthstart = resetDynamic.getBigDecimal("initbalance");
                } else {
                    monthstart = resetDynamic.getBigDecimal("bank_statementbalance");
                }
            }
            DynamicObject nextJournalBalance = BusinessDataServiceHelper.newDynamicObject((String)"cas_journalbalance");
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"type", (Object)balanceRecord.get("type"));
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"enable", (Object)"1");
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"ctrlstrategy", (Object)"5");
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"creator", (Object)ViewUtils.getCurrentUser());
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"createtime", (Object)new Date());
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"org", (Object)balanceRecord.get("org"));
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"openorg", (Object)balanceRecord.get("openorg"));
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"period", (Object)nextPeriod);
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"accountcash", (Object)balanceRecord.get("accountcash"));
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"accountbank", (Object)balanceRecord.get("accountbank"));
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"currency", (Object)balanceRecord.get("currency"));
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"monthstart", (Object)monthstart);
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"monthdebit", (Object)0);
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"monthcredit", (Object)0);
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"monthbalance", (Object)monthbalance);
            if (nextPeriod.getInt("periodnumber") == 1) {
                DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yearstart", (Object)monthbalance);
                DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yeardebit", (Object)0);
                DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yearcredit", (Object)0);
                DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yearbalance", (Object)monthbalance);
            } else {
                DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yearstart", (Object)yearstart);
                DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yeardebit", (Object)yeardebit);
                DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yearcredit", (Object)yearcredit);
                DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"yearbalance", (Object)yearbalance);
            }
            DynamicObjectHelper.setValue((DynamicObject)nextJournalBalance, (String)"isbalanced", (Object)"0");
            nextBalanceRecords.add(nextJournalBalance);
        }
        SaveServiceHelper.save((DynamicObject[])nextBalanceRecords.toArray(new DynamicObject[0]));
    }

    private DynamicObject createCash(DynamicObject entryCash, DynamicObject org, DynamicObject nextPeriod) {
        DynamicObject journalBalance = BusinessDataServiceHelper.newDynamicObject((String)"cas_journalbalance");
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"type", (Object)"1");
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"enable", (Object)1);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"ctrlstrategy", (Object)5);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"creator", (Object)ViewUtils.getCurrentUser());
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"createtime", (Object)new Date());
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"org", (Object)org);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"period", (Object)nextPeriod);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"accountcash", (Object)entryCash.getDynamicObject("cash_accountcash"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"currency", (Object)entryCash.getDynamicObject("currency"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthstart", (Object)entryCash.getBigDecimal("initbalance"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthdebit", (Object)new BigDecimal(0));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthcredit", (Object)new BigDecimal(0));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthbalance", (Object)entryCash.getBigDecimal("initbalance"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"yearstart", (Object)new BigDecimal(0));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"isbalanced", (Object)0);
        return journalBalance;
    }

    private DynamicObject createBank(DynamicObject entryBank, DynamicObject org, DynamicObject nextPeriod) {
        DynamicObject journalBalance = BusinessDataServiceHelper.newDynamicObject((String)"cas_journalbalance");
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"type", (Object)"2");
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"enable", (Object)1);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"ctrlstrategy", (Object)5);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"creator", (Object)ViewUtils.getCurrentUser());
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"createtime", (Object)new Date());
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"org", (Object)org);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"period", (Object)nextPeriod);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"accountbank", (Object)entryBank.getDynamicObject("bank_accountbank"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"currency", (Object)entryBank.getDynamicObject("currency"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthstart", (Object)entryBank.getBigDecimal("initbalance"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthdebit", (Object)new BigDecimal(0));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthcredit", (Object)new BigDecimal(0));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"monthbalance", (Object)entryBank.getBigDecimal("initbalance"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"yearstart", (Object)entryBank.getBigDecimal("initbalance").subtract(BigDecimal.ZERO).add(BigDecimal.ZERO));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"yeardebit", (Object)BigDecimal.ZERO);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"yearcredit", (Object)BigDecimal.ZERO);
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"yearbalance", (Object)entryBank.getBigDecimal("initbalance"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"openorg", (Object)entryBank.getDynamicObject("bank_accountbank").getDynamicObject("openorg"));
        DynamicObjectHelper.setValue((DynamicObject)journalBalance, (String)"isbalanced", (Object)0);
        return journalBalance;
    }

    private void updateCurrentBalance(List<AccountAmount> cashJournalList, List<AccountAmount> bankJournalList, DynamicObject[] currentBalanceRecords) {
        for (DynamicObject balanceRecord : currentBalanceRecords) {
            DynamicObject acountBank;
            String type = balanceRecord.getString("type");
            balanceRecord.set("isbalanced", (Object)"1");
            if (type.equals("3")) continue;
            long currencyId = balanceRecord.getDynamicObject("currency").getLong("id");
            Long orgId = balanceRecord.getDynamicObject("org").getLong("id");
            if (type.equals("1")) {
                DynamicObject accountBank = balanceRecord.getDynamicObject("accountcash");
                if (accountBank == null) continue;
                this.updateCurrentBalance(cashJournalList, balanceRecord, orgId, currencyId, accountBank.getLong("id"));
                continue;
            }
            if (!type.equals("2") || (acountBank = balanceRecord.getDynamicObject("accountbank")) == null) continue;
            long accountId = acountBank.getLong("id");
            this.updateCurrentBalance(bankJournalList, balanceRecord, orgId, currencyId, accountId);
        }
        SaveServiceHelper.save((DynamicObject[])currentBalanceRecords);
    }

    private void updateCurrentBalance(List<AccountAmount> journals, DynamicObject journalbalance, Long orgId, long currencyId, long accountId) {
        for (AccountAmount journal : journals) {
            if (orgId.longValue() != journal.getOrg() || accountId != journal.getAccount() || currencyId != journal.getCurrency()) continue;
            journalbalance.set("monthdebit", (Object)journal.getDebitAmount());
            journalbalance.set("monthcredit", (Object)journal.getCreditAmount());
            journalbalance.set("monthbalance", (Object)journalbalance.getBigDecimal("monthstart").subtract(journalbalance.getBigDecimal("monthcredit")).add(journalbalance.getBigDecimal("monthdebit")));
            journalbalance.set("yeardebit", (Object)journalbalance.getBigDecimal("yeardebit").add(journalbalance.getBigDecimal("monthdebit")));
            journalbalance.set("yearcredit", (Object)journalbalance.getBigDecimal("yearcredit").add(journalbalance.getBigDecimal("monthcredit")));
            journalbalance.set("yearbalance", (Object)journalbalance.getBigDecimal("yearstart").subtract(journalbalance.getBigDecimal("yearcredit")).add(journalbalance.getBigDecimal("yeardebit")));
            journals.remove(journal);
            break;
        }
    }

    private QFilter[] createFilters(DynamicObject org, DynamicObject period) {
        QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong("id"));
        QFilter periodFilter = new QFilter("period", "=", (Object)period.getLong("id"));
        return new QFilter[]{orgFilter, periodFilter};
    }

    public DynamicObject[] fixCurrentBalance(DynamicObject currentPeriod, DynamicObject org) {
        long orgId = org.getLong("id");
        long currentPeriodId = currentPeriod.getLong("id");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter periodFilter = new QFilter("period", "=", (Object)currentPeriodId);
        List<AccountAmount> cashJournals = this.getCurrentCashJournals(org, currentPeriod);
        List<AccountAmount> bankJournals = this.getCurrentBankJournals(org, currentPeriod);
        QFilter[] filters = new QFilter[]{orgFilter, periodFilter};
        DynamicObject[] currentBalanceRecords = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, type, org, openorg, accountcash, accountbank, currency, period, monthstart, monthdebit, monthcredit, monthbalance, yearstart, yeardebit, yearcredit, yearbalance, isbalanced", (QFilter[])filters);
        this.updateCurrentBalance(cashJournals, bankJournals, currentBalanceRecords);
        return currentBalanceRecords;
    }

    private String getMapKay(String ... string) {
        StringBuilder sb = new StringBuilder();
        for (String str : string) {
            sb.append(str);
            sb.append("_");
        }
        return sb.substring(0, sb.lastIndexOf("_"));
    }
}

