/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.DirectionEnum;

public class FundFlowItemImportOp
implements IImportPlugin {
    public void checkNull(Map<String, Object> data, String key, String title) throws Exception {
        Object value = data.get(key);
        if (value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"FundFlowItemImportOp_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), title));
        }
    }

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        super.beforeImportData(data, option, importlogs);
        try {
            DynamicObject fFItem;
            if (!"new".equals(option.get("importtype")) && (fFItem = QueryServiceHelper.queryOne((String)"cas_fundflowitem", (String)"id,enable,status", (QFilter[])new QFilter[]{new QFilter("number", "=", data.get("number"))})) != null && "1".equals(fFItem.getString("enable"))) {
                throw new Exception(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u72b6\u6001\u6570\u636e\u4e0d\u5141\u8bb8\u8986\u76d6\u3002", (String)"FundFlowItemImportOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            this.checkNull(data, "createorg", ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"FundFlowItemImportOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            HashMap orgMap = (HashMap)JSONUtils.cast((String)data.get("createorg").toString(), HashMap.class);
            Object orgNumber = orgMap.get("number");
            QFilter orgFilter = new QFilter("number", "=", orgNumber);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{orgFilter});
            if (load.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u4e0d\u5b58\u5728\u3002", (String)"FundFlowItemImportOp_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            Map parent = (Map)data.get("parent");
            if (parent == null) {
                return true;
            }
            DynamicObject parentFFItem = QueryServiceHelper.queryOne((String)"cas_fundflowitem", (String)"id,direction,property", (QFilter[])new QFilter[]{new QFilter("number", "=", parent.get("number"))});
            if (parentFFItem != null) {
                parent.put("id", parentFFItem.getString("id"));
            }
        }
        catch (Exception exc) {
            if (exc instanceof KDBizException) {
                importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
            } else {
                importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
            }
            return false;
        }
        return true;
    }

    public void afterImportData(List<Object> pkIds, List<ImportLogger.ImportLog> importlogs) {
        super.afterImportData(pkIds, importlogs);
        DynamicObject fFItem = BusinessDataServiceHelper.loadSingle((Object)pkIds.get(0), (String)"cas_fundflowitem");
        fFItem.set("status", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObject parentFFItem = fFItem.getDynamicObject("parent");
        if (parentFFItem != null) {
            if (!DirectionEnum.INOROUT.getValue().equals(parentFFItem.getString("direction"))) {
                fFItem.set("direction", (Object)parentFFItem.getString("direction"));
            }
            fFItem.set("level", (Object)(parentFFItem.getInt("level") + 1));
            fFItem.set("longnumber", (Object)(parentFFItem.getString("longnumber") + "." + fFItem.getString("number")));
        }
        OperationServiceImpl impl = new OperationServiceImpl();
        impl.invokeOperation("save", new DynamicObject[]{fFItem}, null);
    }
}

