/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.paymentbill.PayImpTemplateValidator;

public class PayImpTemplateOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PayImpTemplateValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities != null && dataEntities.length > 0 && this.getOption().containsVariable("tempid")) {
            String tempid = this.getOption().getVariableValue("tempid");
            if (CasHelper.isEmpty((Object)tempid)) {
                return;
            }
            QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(tempid));
            filter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObject payPlan = BusinessDataServiceHelper.loadSingle((String)"cas_interpayplan", (String)"id,number,org,filtercon,payeracctbank,settletype,paymentchannel,usage", (QFilter[])new QFilter[]{filter});
            Set idSet = Arrays.stream(dataEntities).map(d -> d.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billno,payeracctbank,payeracctcash,payerbank,settletype,paymentchannel,usage,openorg,settleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
            if (!CasHelper.isEmpty((DynamicObject[])payBills)) {
                for (DynamicObject payBill : payBills) {
                    Object paymentchannel;
                    DynamicObject payerAcctBank = payPlan.getDynamicObject("payeracctbank");
                    if (payerAcctBank != null) {
                        payerAcctBank = BusinessDataServiceHelper.loadSingleFromCache((Object)payerAcctBank.getPkValue(), (String)"bd_accountbanks", (String)"id,bankaccountnumber,bank,isdefaultpay,openorg,isopenbank,issetbankinterface");
                        DynamicObject openOrg = payBill.getDynamicObject("openorg");
                        if (CasHelper.isNotEmpty((Object)payerAcctBank) && openOrg == null) {
                            payBill.set("openorg", (Object)payerAcctBank.getDynamicObject("openorg"));
                            this.setSettleorg(payBill);
                        }
                    }
                    payBill.set("payeracctbank", (Object)payerAcctBank);
                    payBill.set("payerbank", payPlan.getDynamicObject("payeracctbank").get("bank"));
                    payBill.set("payeracctcash", null);
                    DynamicObject payPlanSettleType = payPlan.getDynamicObject("settletype");
                    if (EmptyUtil.isNoEmpty((DynamicObject)payPlanSettleType)) {
                        payBill.set("settletype", (Object)payPlanSettleType);
                    }
                    if (EmptyUtil.isNoEmpty((Object)(paymentchannel = payPlan.get("paymentchannel")))) {
                        payBill.set("paymentchannel", paymentchannel);
                    }
                    payBill.set("usage", payPlan.get("usage"));
                }
                SaveServiceHelper.save((DynamicObject[])payBills);
            }
        }
    }

    private void setSettleorg(DynamicObject payBill) {
        DynamicObjectCollection entry = payBill.getDynamicObjectCollection("entry");
        DynamicObject openorg = payBill.getDynamicObject("openorg");
        for (DynamicObject rowInfo : entry) {
            rowInfo.set("settleorg", (Object)openorg);
        }
    }
}

