/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.message.MessageTemplateEnum;

public class PaymentBillBitBackOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PaymentBillBitBackOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("actpayamt");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("payeracctbank");
        fieldKeys.add("issetbankinterface");
        fieldKeys.add("settletype");
        fieldKeys.add("ispaythroughbe");
        fieldKeys.add("isonlyread");
        fieldKeys.add("actpayamt");
        fieldKeys.add("payeename");
        fieldKeys.add("payeebanknum");
        fieldKeys.add("recprovince");
        fieldKeys.add("reccity");
        fieldKeys.add("usage");
        fieldKeys.add("reccountry");
        fieldKeys.add("org");
        fieldKeys.add("payeracctbank");
        fieldKeys.add("sourcebilltype");
        fieldKeys.add("bankpayingid");
        fieldKeys.add("iscommitbe");
        fieldKeys.add("bankpaystatus");
        fieldKeys.add("commitbetime");
        fieldKeys.add("paydate");
        fieldKeys.add("isrepulsed");
        fieldKeys.add("repulsedreason");
        fieldKeys.add("creator");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        logger.info("--------\u4ed8\u6b3e\u5355\u6253\u56de\u64cd\u4f5c\uff0cbegin --------");
        DynamicObject[] dataEntities = e.getDataEntities();
        String isbitback = this.getOption().getVariableValue("isbitback");
        String bitbackopinion = this.getOption().getVariableValue("bitbackopinion");
        logger.info("isrepulsed \u662f\uff1a" + isbitback + ";repulsedreason \u662f\uff1a" + bitbackopinion + "");
        for (DynamicObject data : dataEntities) {
            data.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            data.set("paydate", null);
            data.set("iscommitbe", (Object)"0");
            data.set("isrepulsed", (Object)isbitback);
            data.set("repulsedreason", (Object)bitbackopinion);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
        }
        for (DynamicObject payBill : dataEntities) {
            DynamicObject creator = payBill.getDynamicObject("creator");
            if (creator == null) continue;
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setTemplateNumber(MessageTemplateEnum.CAS_PAYBILL_BITBACK.getValue());
            messageInfo.setEntityNumber("cas_paybill");
            messageInfo.setType("message");
            messageInfo.setBizDataId(Long.valueOf(payBill.getLong("id")));
            messageInfo.setUserIds(Collections.singletonList(creator.getLong("id")));
            messageInfo.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=cas_paybill&pkId=" + payBill.getLong("id"));
            MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
    }
}

