/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.opservice.helper.PaymentServiceHelper;
import kd.fi.cas.business.writeback.WriteBackConfigInvoker;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.ar.ArWriteBackHelper;
import kd.fi.cas.business.writeback.ar.bean.Result;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.refund.CancelRefundWriteBackConsumer;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.opplugin.refund.RefundWriteBackHelper;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.ReceivingBillCancelRefundValidator;
import org.apache.commons.lang3.ArrayUtils;

public class ReceivingBillCancelRefundOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ReceivingBillCancelRefundOp.class);
    private DynamicObject[] bills;
    private Map<Long, DynamicObject> entrustSourceBills;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("isrefund");
        lst.add("isfullrefund");
        lst.add("actrecamt");
        lst.add("receivingtype.biztype");
        lst.add("refundtype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        List validators = e.getValidators();
        OperateOption option = this.getOption();
        if (!option.containsVariable("revId")) {
            validators.add(new ReceivingBillCancelRefundValidator());
            return;
        }
        Long revId = Long.valueOf(option.getVariableValue("revId"));
        DynamicObject revBill = BusinessDataServiceHelper.loadSingle((Object)revId, (String)"cas_recbill", (String)"id,receivingtype.biztype");
        if (!PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(revBill.getString("receivingtype.biztype"))) {
            Object[] payBills = RefundHelper.queryHadRefundBills((Long)revId, (String)"cas_paybill");
            if (ArrayUtils.isNotEmpty((Object[])payBills)) {
                this.bills = payBills;
                this.entrustSourceBills = RefundWriteBackHelper.getEntrustSourceBills(this.bills);
                validators.add(new ReceivingBillCancelRefundValidator(this.bills, this.entrustSourceBills));
                return;
            }
            Object[] agentBills = RefundHelper.queryHadRefundBills((Long)revId, (String)"cas_agentpaybill");
            if (ArrayUtils.isNotEmpty((Object[])agentBills)) {
                this.bills = agentBills;
                this.entrustSourceBills = RefundWriteBackHelper.getEntrustSourceBills(this.bills);
                validators.add(new ReceivingBillCancelRefundValidator(this.bills, this.entrustSourceBills));
                return;
            }
            validators.add(new ReceivingBillCancelRefundValidator());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List<Object> recBillIdList = Arrays.stream(dataEntities).filter(d -> PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(d.getString("receivingtype.biztype"))).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (!recBillIdList.isEmpty()) {
            QFilter qFilter = new QFilter("recbill.id", "in", recBillIdList).and(new QFilter("paidstatus", "in", Arrays.asList("E", "F")));
            DynamicObject[] ifmTransHandleBill = BusinessDataServiceHelper.load((String)"ifm_transhandlebill", (String)"id", (QFilter[])qFilter.toArray());
            if (ifmTransHandleBill.length == 0) throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u6536\u6b3e\uff0c\u67e5\u8be2\u4e0d\u5230\u4ed8\u6b3e\u4ea4\u6613\u5904\u7406\u5355\u3002", (String)"ReceivingBillCancelRefundOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            OperationResult operationResult = OperateServiceHelper.execOperate((String)"cancelrefund", (String)"ifm_transhandlebill", (DynamicObject[])ifmTransHandleBill, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) throw new KDBizException(operationResult.getMessage());
            this.saveRecBill(recBillIdList);
        }
        if (recBillIdList.size() == dataEntities.length) {
            return;
        }
        DynamicObject revBill = dataEntities[0];
        if (PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(revBill.getString("receivingtype.biztype"))) {
            return;
        }
        if (ArrayUtils.isEmpty((Object[])this.bills)) {
            String msg = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u672a\u67e5\u5230\u5173\u8054\u7684\u5355\u636e,\u8bf7\u68c0\u67e5\u3002", (String)"ReceivingBillCancelRefundValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        if ("cas_paybill".equals(this.bills[0].getDataEntityType().getName())) {
            for (DynamicObject payBill : this.bills) {
                BigDecimal totalCancelAmt = this.cancelRefundPayBill(payBill, revBill);
                if (!CasHelper.isNotEmpty((Object)payBill.get("entrustorg"))) continue;
                RefundHelper.updateEntrustAmt((DynamicObject)payBill, (BigDecimal)totalCancelAmt, (boolean)true);
            }
        } else {
            for (DynamicObject agentBill : this.bills) {
                BigDecimal totalCancelAmt = this.cancelRefundAgentBill(agentBill, revBill);
                if (!CasHelper.isNotEmpty((Object)agentBill.get("delegorg"))) continue;
                RefundHelper.updateEntrustAmt((DynamicObject)agentBill, (BigDecimal)totalCancelAmt, (boolean)true);
            }
        }
        this.saveRecBill(revBill);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject revBill = e.getDataEntities()[0];
        Long revId = (Long)revBill.getPkValue();
        String refundType = revBill.getString("refundtype");
        WriteBackOperateEnum operate = "refund".equals(refundType) ? WriteBackOperateEnum.CANCELREFUND : WriteBackOperateEnum.CANCELRENOTE;
        if (ArrayUtils.isNotEmpty((Object[])this.bills)) {
            if ("cas_paybill".equals(this.bills[0].getDataEntityType().getName())) {
                List writeBackBills = Arrays.stream(this.bills).filter(b -> !PaymentServiceHelper.isEntrustTargetPayBill((DynamicObject)b)).collect(Collectors.toList());
                Map<String, List<DynamicObject>> billBySourceMap = writeBackBills.stream().collect(Collectors.groupingBy(p -> p.getString("sourcebilltype")));
                ArrayList<RefundRenoteOrCancelParam> refundParams = new ArrayList<RefundRenoteOrCancelParam>(billBySourceMap.size());
                for (Map.Entry<String, List<DynamicObject>> billEntry : billBySourceMap.entrySet()) {
                    String sourceBillType = billEntry.getKey();
                    List<DynamicObject> payBillList = billEntry.getValue();
                    try {
                        Object sourceValidatorRes;
                        Result sourceValidatorResult;
                        CancelRefundWriteBackConsumer cancelConsumer = new CancelRefundWriteBackConsumer(revId, payBillList);
                        RefundRenoteOrCancelParam cancelParam = cancelConsumer.initInvokeParams("cas_paybill", sourceBillType, operate);
                        refundParams.add(cancelParam);
                        if (ArWriteBackHelper.isArApSourceType((String)sourceBillType) || (sourceValidatorResult = (Result)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)(sourceValidatorRes = WriteBackTaskHelper.batchAddWriteBackTask((DynamicObject[])payBillList.toArray(new DynamicObject[0]), (String)sourceBillType, (WriteBackOperateEnum)operate, (WriteBackConfigInvoker)cancelConsumer, null))), Result.class)) == null || "0".equals(sourceValidatorResult.getCode())) continue;
                        throw new KDBizException(sourceValidatorResult.getErrorInfo());
                    }
                    catch (Exception ex) {
                        logger.error("rev cancel refund renote err", (Throwable)ex);
                        throw new KDBizException(ex.getMessage());
                    }
                }
                if (this.entrustSourceBills.isEmpty()) {
                    ArWriteBackHelper.writerBackAP((Long)revId, (WriteBackOperateEnum)operate, refundParams, (String)"CancelRefundAndRenoteECService");
                } else {
                    List billList = Arrays.stream(this.bills).collect(Collectors.toList());
                    RefundRenoteOrCancelParam invokeParams = ArWriteBackHelper.buildApCancelRefundParam((Long)revId, billList, this.entrustSourceBills, (WriteBackOperateEnum)operate);
                    ArWriteBackHelper.writerBackAP((Long)revId, (WriteBackOperateEnum)operate, Collections.singletonList(invokeParams), (String)"CancelRefundAndRenoteECService");
                }
                ArrayList<DynamicObject> allBills = new ArrayList<DynamicObject>(this.bills.length + this.entrustSourceBills.size());
                allBills.addAll(this.entrustSourceBills.values());
                Collections.addAll(allBills, this.bills);
                OperateServiceHelper.execOperate((String)"pregenpurpay", (String)"cas_paybill", (DynamicObject[])allBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            } else {
                RefundWriteBackHelper.agentWriteBack(revId, operate, this.bills);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private BigDecimal cancelRefundPayBill(DynamicObject payBill, DynamicObject revBill) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private BigDecimal cancelRefundAgentBill(DynamicObject agentBill, DynamicObject revBill) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void batchExecute(DynamicObject bill, List<Object[]> paramsList, String entrySql) {
        int[] resultCounts;
        for (int resultCount : resultCounts = DB.executeBatch((DBRoute)DBRouteConst.cas, (String)entrySql, paramsList)) {
            if (resultCount != 0) continue;
            String msg = ResManager.loadKDString((String)"\u5173\u8054\u7684\u5355\u636e[%s]\u5df2\u53d1\u751f\u53d8\u66f4, \u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivingBillCancelRefundOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            throw new KDBizException(String.format(msg, bill.getString("billno")));
        }
    }

    private void updateBillHead(DynamicObject revBill, DynamicObject bill, List<DynamicObject> refundRevList) {
        Object[] payBillParams;
        String sql;
        String billStatus;
        BigDecimal newLocalRemainRefundAmt;
        BigDecimal totalRefundedAmt = bill.getBigDecimal("totalrefundedamt");
        BigDecimal totalRemainRefundAmt = bill.getBigDecimal("totalremainrefundamt");
        BigDecimal localRefundedAmt = bill.getBigDecimal("localrefundedamt");
        BigDecimal localRemainRefundAmt = bill.getBigDecimal("localremainrefundamt");
        DynamicObjectCollection entryList = bill.getDynamicObjectCollection("entry");
        BigDecimal payAmtSum = "cas_paybill".equals(bill.getDataEntityType().getName()) ? entryList.stream().map(ent -> ent.getBigDecimal("e_payableamt")).reduce(BigDecimal.ZERO, BigDecimal::add) : entryList.stream().filter(entry -> entry.getBoolean("e_issuccess")).map(ent -> AgentPayBillHelper.decodeAmount((String)ent.getString("e_encryptamount"))).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalReAmt = refundRevList.stream().map(r -> r.getBigDecimal("refundamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal newTotalRefundedAmt = totalRefundedAmt.subtract(totalReAmt);
        BigDecimal newTotalRemainRefundAmt = payAmtSum.subtract(newTotalRefundedAmt);
        BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
        String payQuotation = bill.getString("payquotation");
        BigDecimal newLocalRefundedAmt = "0".equals(payQuotation) ? newTotalRefundedAmt.multiply(exchangeRate) : newTotalRefundedAmt.divide(exchangeRate, 10, RoundingMode.DOWN);
        BigDecimal bigDecimal = newLocalRemainRefundAmt = "0".equals(payQuotation) ? newTotalRemainRefundAmt.multiply(exchangeRate) : newTotalRemainRefundAmt.divide(exchangeRate, 10, RoundingMode.DOWN);
        if (newTotalRefundedAmt.compareTo(BigDecimal.ZERO) == 0) {
            billStatus = BillStatusEnum.PAY.getValue();
        } else {
            String refundType = revBill.getString("refundtype");
            String string = billStatus = "refund".equals(refundType) ? BillStatusEnum.REFUND.getValue() : BillStatusEnum.RENOTE.getValue();
        }
        if ("cas_paybill".equals(bill.getDataEntityType().getName())) {
            sql = "update T_CAS_PAYMENTBILL set fbillstatus = ?,ftotalrefundedamt = ?,ftotalremainrefundamt = ?,flocalrefundedamt = ?,flocalremainrefundamt = ? where fid = ? and fbillstatus = ? and ftotalrefundedamt = ? and ftotalremainrefundamt = ? and flocalrefundedamt = ? and flocalremainrefundamt = ?";
            payBillParams = new Object[]{billStatus, newTotalRefundedAmt, newTotalRemainRefundAmt, newLocalRefundedAmt, newLocalRemainRefundAmt, bill.getPkValue(), bill.getString("billstatus"), totalRefundedAmt, totalRemainRefundAmt, localRefundedAmt, localRemainRefundAmt};
            Object[] idParam = new Object[]{bill.getPkValue()};
            String updateDetailIdSql = "update T_CAS_PAYMENTBILL_E set frefunddetailid = 0 where fid = ?";
            DB.update((DBRoute)DBRouteConst.cas, (String)updateDetailIdSql, (Object[])idParam);
        } else {
            sql = "update T_CAS_AGENTPAYBILL set ftotalrefundedamt = ?,ftotalremainrefundamt = ?,flocalrefundedamt = ?,flocalremainrefundamt = ? where fid = ? and ftotalrefundedamt = ? and ftotalremainrefundamt = ? and flocalrefundedamt = ? and flocalremainrefundamt = ?";
            payBillParams = new Object[]{newTotalRefundedAmt, newTotalRemainRefundAmt, newLocalRefundedAmt, newLocalRemainRefundAmt, bill.getPkValue(), totalRefundedAmt, totalRemainRefundAmt, localRefundedAmt, localRemainRefundAmt};
        }
        int updateCount = DB.update((DBRoute)DBRouteConst.cas, (String)sql, (Object[])payBillParams);
        if (updateCount == 0) {
            String msg = ResManager.loadKDString((String)"\u5173\u8054\u7684\u5355\u636e[%s]\u5df2\u53d1\u751f\u53d8\u66f4, \u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivingBillCancelRefundOp_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            throw new KDBizException(String.format(msg, bill.getString("billno")));
        }
    }

    private void saveRecBill(DynamicObject revBill) {
        String sql = "update T_CAS_RECEIVINGBILL_E set fisrefund = ?,frefundtype = ? where fid = ? and fisrefund = '1' and frefundtype = ?";
        Object[] params = new Object[]{Character.valueOf('0'), "", revBill.getPkValue(), revBill.get("refundtype")};
        int updateCount = DB.update((DBRoute)DBRouteConst.cas, (String)sql, (Object[])params);
        if (updateCount == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5df2\u53d1\u751f\u53d8\u66f4, \u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivingBillCancelRefundOp_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }

    private void saveRecBill(List<Object> recBillIdList) {
        DynamicObject[] recBills;
        for (DynamicObject recBill : recBills = BusinessDataServiceHelper.load((Object[])recBillIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"))) {
            recBill.set("isrefund", (Object)false);
            recBill.set("isfullrefund", (Object)false);
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])recBills);
        }
    }

    private void feeBillCancelRefundSave(DynamicObject payBill) {
        String paySourceBillType = payBill.getString("sourcebilltype");
        if (EmptyUtil.isNotEmpty((String)paySourceBillType) && "cfm_feebill".equals(paySourceBillType)) {
            long feeBillId = payBill.getLong("sourcebillid");
            DynamicObject feeBill = BusinessDataServiceHelper.loadSingle((Object)feeBillId, (String)"cfm_feebill");
            if (EmptyUtil.isEmpty((DynamicObject)feeBill)) {
                return;
            }
            feeBill.set("issettle", (Object)Boolean.TRUE);
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{feeBill});
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }
}

