/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.AutoMatchHelper;
import kd.fi.cas.business.helper.CasFlowConfirmLogHelper;
import kd.fi.cas.business.helper.RecClaimBillHelper;
import kd.fi.cas.business.helper.ReceredWayHelper;
import kd.fi.cas.business.opservice.IOpService;
import kd.fi.cas.business.opservice.factory.RecBillFactory;
import kd.fi.cas.business.opservice.helper.DealCasSameTransAndRuleNameHelper;
import kd.fi.cas.business.opservice.helper.RecBillSupDivideHelper;
import kd.fi.cas.business.opservice.helper.RecPayRuleHelper;
import kd.fi.cas.business.opservice.helper.ValidAndSetMatchInfoHelper;
import kd.fi.cas.business.writeback.RecBillSaveOrSubmitWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.task.WriteDetailParam;
import kd.fi.cas.consts.ReceivingBillModel;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.PayAndRecFillTypeHelper;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.params.ParamMap;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.BillNoSaveValidator;
import kd.fi.cas.validator.CommonOpValidator;
import kd.fi.cas.validator.OrgFinishinitValidator;
import kd.fi.cas.validator.ReceivingBillSaveValidator;
import kd.fi.cas.validator.common.TxLockValidator;
import kd.fi.cas.validator.rec.ReceivingAccountCashValidator;
import kd.fi.cas.validator.receivingbill.RecAutoRenoteValidator;
import kd.fi.cas.validator.receivingbill.ReceivingIntelRecValidator;
import kd.fi.cas.validator.receivingbill.ReceivingTypeValidator;

public class ReceivingBillSaveOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ReceivingBillSaveOp.class);
    private IOpService iService = RecBillFactory.getSaveService();
    private ParamMap param = new ParamMap();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        ReceivingBillSaveValidator validator = new ReceivingBillSaveValidator();
        this.iService.prepare(e.getDataEntities(), this.param);
        e.getValidators().add(new CommonOpValidator(this.iService, "cas_recbill", ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u4fdd\u5b58", (String)"ReceivingBillSaveOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0])));
        validator.setEntityKey("cas_recbill");
        e.addValidator((AbstractValidator)validator);
        e.addValidator((AbstractValidator)new BillNoSaveValidator());
        e.getValidators().add(new OrgFinishinitValidator());
        e.getValidators().add(new ReceivingTypeValidator());
        e.getValidators().add(new ReceivingIntelRecValidator());
        e.getValidators().add(new TxLockValidator());
        e.addValidator((AbstractValidator)new ReceivingAccountCashValidator());
        e.addValidator((AbstractValidator)new RecAutoRenoteValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.addAll(EntityPropertyHelper.getPropertys((String)"cas_recbill"));
        list.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry"));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject recbill : e.getDataEntities()) {
            CasBotpHelper.linkSourceRow((DynamicObject)recbill, (String)"er_repaymentbill", (String)"repaymententry");
        }
    }

    private void setRecValueByRule(Map<String, Object> returnRec, DynamicObject recBill, DynamicObject entry, String sourceBillType) {
        String payertype = String.valueOf(returnRec.get("e_payertype"));
        Object e_payer = returnRec.get("e_payer");
        if (("bei_transdetail_cas".equals(sourceBillType) || "bei_transdetail".equals(sourceBillType) || "bei_intelrec".equals(sourceBillType)) && EmptyUtil.isEmpty((Object)e_payer)) {
            logger.info("ReceivingBillSaveOp.setRecValueByRule.validAndSetMatchInfo");
            ValidAndSetMatchInfoHelper.validAndSetMatchInfo((DynamicObject)recBill, (String)payertype, (String)"rec", (boolean)false);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        List<DynamicObject> claimList;
        super.beginOperationTransaction(e);
        HashMap recInfo = new HashMap(8);
        List detailIds = new ArrayList(8);
        ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(e.getDataEntities().length);
        for (DynamicObject info : e.getDataEntities()) {
            String selectEntryIdStr;
            String returnDataByOpHand;
            if (this.getOption().containsVariable("returnDataByOpHand")) {
                returnDataByOpHand = this.getOption().getVariableValue("returnDataByOpHand");
                this.param.put("returnDataByOpHand", (Object)returnDataByOpHand);
            }
            if (this.getOption().containsVariable("returnDataByOpHandMerge")) {
                returnDataByOpHand = this.getOption().getVariableValue("returnDataByOpHandMerge");
                this.param.put("returnDataByOpHandMerge", (Object)returnDataByOpHand);
            }
            if (this.getOption().containsVariable("thisRecOptype")) {
                this.param.put("thisRecOptype", (Object)"thisRecOptype");
            }
            this.iService.prepare(e.getDataEntities(), this.param);
            this.iService.process(info);
            boolean isSupContract = info.getBoolean("issupplecontract");
            boolean isorgsdivide = info.getBoolean("isorgsdivide");
            String thisRecOptype = (String)this.getOption().getVariables().get("thisRecOptype");
            if ((isSupContract || isorgsdivide) && EmptyUtil.isNotEmpty((String)thisRecOptype) && ("suppleContract".equals(thisRecOptype) || "cancelContract".equals(thisRecOptype)) || "orgsDivideOp".equals(thisRecOptype) || "cancelOrgsDivide".equals(thisRecOptype)) {
                selectEntryIdStr = (String)this.getOption().getVariables().get("beforeOpselectEntryId");
                HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
                paramMap.put("dobj", info);
                paramMap.put("selectEntryIdStr", selectEntryIdStr);
                paramMap.put("opType", thisRecOptype);
            }
            if (isorgsdivide && EmptyUtil.isNotEmpty((String)thisRecOptype)) {
                selectEntryIdStr = (String)this.getOption().getVariables().get("beforeOpselectEntryId");
                if ("orgsDivideOp".equals(thisRecOptype)) {
                    this.getOption().setVariableValue("recOpFlagStr", thisRecOptype);
                }
                if ("cancelOrgsDivide".equals(thisRecOptype) && EmptyUtil.isNotEmpty((String)selectEntryIdStr)) {
                    ArrayList<Long> selectEntryList = new ArrayList<Long>();
                    selectEntryList.add(Long.valueOf(selectEntryIdStr));
                    RecBillSupDivideHelper.recBillSaveOpDoCancelDivideOp((DynamicObject)info, selectEntryList);
                }
            }
            String sourceBillType = info.getString("sourcebilltype");
            boolean isFromDb = info.getDataEntityState().getFromDatabase();
            if (!isFromDb && "bei_intelrec".equals(sourceBillType)) {
                QFilter filter;
                DynamicObject e_payerObj;
                String ruleWay;
                String ruleName = null;
                if (this.getOption().containsVariable("returnDataByOpHand")) {
                    ruleWay = ReceredWayEnum.HAND.getValue();
                } else if (this.getOption().containsVariable("returnDataByOpHandMerge")) {
                    ruleWay = ReceredWayEnum.HANDMERGE.getValue();
                } else {
                    ruleWay = ReceredWayEnum.RULE.getValue();
                    DynamicObject payEntry = (DynamicObject)info.getDynamicObjectCollection("entry").get(0);
                    Map returnPay = RecPayRuleHelper.getInfoByMatchRule((DynamicObject)info, (String)"rec");
                    if (!CasHelper.isEmpty((Object)returnPay) && returnPay.size() > 0) {
                        this.setRecValueByRule(returnPay, info, payEntry, "bei_intelrec");
                        ruleName = (String)returnPay.get("e_rulesname");
                    }
                }
                detailIds = ReceredWayHelper.writeInfoBeiRecInfoBei((String)ruleWay, ruleName, (DynamicObject)info, recInfo, detailIds, (String)this.operateOption.getVariableValue("opnumber", ""), (String)"rec");
                String payertype = info.getString("payertype");
                Long payer = info.getLong("payer");
                if (!AsstActTypeEnum.OTHER.getValue().equals(payertype) && EmptyUtil.isNoEmpty((Long)payer) && (e_payerObj = QueryServiceHelper.queryOne((String)payertype, (String)"id,name", (QFilter[])(filter = new QFilter("id", "=", (Object)payer)).toArray())) != null) {
                    info.set("payername", (Object)e_payerObj.getString("name"));
                }
                this.operateOption.setVariableValue("ruleWay", ruleWay);
            }
            PayAndRecFillTypeHelper.fillReceBillEntryType((DynamicObject)info);
            if (ReceivingBillModel.NOT_WRITE_BACK_BILLS.contains(sourceBillType)) continue;
            WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
            taskInfo.setBillId((Long)info.getPkValue());
            taskInfo.setDataEntity(info.getDataEntityType().getName());
            taskInfo.setSourceEntity(sourceBillType);
            HashMap<String, DynamicObject> param = new HashMap<String, DynamicObject>();
            param.put("info", info);
            taskInfo.setParam(param);
            taskInfos.add(taskInfo);
        }
        if (recInfo != null && recInfo.size() > 0) {
            WriteDetailParam param = new WriteDetailParam();
            param.setRecInfo(recInfo);
            ECGlobalSession.begin((String)"WRITE_DETAIL", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
            ECGlobalSession.setBusinessType((String)"workbench");
            ECGlobalSession.setAsync((boolean)true);
            ECGlobalSession.setBusinessInfo(detailIds);
            ECGlobalSession.register((String)"fi", (String)"cas", (String)"RecPayWriteDetailService", (Param)param, null, (String)"");
            CasFlowConfirmLogHelper.saveEnterLog(recInfo);
        }
        if ((claimList = Arrays.stream(e.getDataEntities()).filter(dynamicObject -> !dynamicObject.getDataEntityState().getFromDatabase() && "cas_claimcenterbill".equals(dynamicObject.getString("sourcebilltype"))).collect(Collectors.toList())) != null && claimList.size() > 0) {
            RecClaimBillHelper.writeBackByClaimBatch((DynamicObject[])claimList.toArray(new DynamicObject[claimList.size()]), (Boolean)true);
        }
        WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, (WriteBackOperateEnum)WriteBackOperateEnum.SAVE, RecBillSaveOrSubmitWriteBackConsumer.class);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        for (DynamicObject recbill : e.getDataEntities()) {
            String sourceBillType = recbill.getString("sourcebilltype");
            try {
                if ("bei_transdetail_cas".equals(sourceBillType) || "bei_transdetail".equals(sourceBillType) || "bei_intelrec".equals(sourceBillType)) {
                    if (recbill.getBoolean("relateotherflow") && this.getOption().containsVariable("ruleWay")) {
                        DealCasSameTransAndRuleNameHelper.dealSameNameTrans((DynamicObject)recbill, (String)this.getOption().getVariableValue("ruleWay"));
                    }
                    Map tMatchResult = AutoMatchHelper.getMatchAmount((BigDecimal)BigDecimal.ZERO, (BigDecimal)recbill.getBigDecimal("matchamountrec"), (BigDecimal)recbill.getBigDecimal("unmatchamountrec"), (Boolean)recbill.getBoolean("relateotherflow"), (BigDecimal)recbill.getBigDecimal("matchamountpay"), (BigDecimal)recbill.getBigDecimal("unmatchamountpay"));
                    AutoMatchHelper.initMatchAmount((DynamicObject)recbill, (Map)tMatchResult, (String)"matchamountrec", (String)"unmatchamountrec", (String)"matchflag", (String)"matchflagmsg");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recbill});
                }
            }
            catch (Exception e2) {
                logger.error("\u4e1a\u52a1\u5355\u636e\u4fdd\u5b58\u65f6\u5904\u7406\u540c\u540d\u8f6c\u8d26\u4e1a\u52a1\u62a5\u9519", (Throwable)e2);
            }
            boolean isorgsdivide = recbill.getBoolean("isorgsdivide");
            String recOpFlagStr = (String)this.getOption().getVariables().get("recOpFlagStr");
            if (!isorgsdivide || EmptyUtil.isEmpty((String)recOpFlagStr) || !"orgsDivideOp".equals(recOpFlagStr)) continue;
            try {
                RecBillSupDivideHelper.recBillSaveOrgsDivideOp((DynamicObject)recbill);
            }
            catch (Exception e1) {
                logger.info("\u4e1a\u52a1\u5355\u636e\u4fdd\u5b58\u65f6\u7ec4\u7ec7\u6e05\u5206\u64cd\u4f5c\u64cd\u4f5c\u62a5\u9519");
                logger.error((Throwable)e1);
                throw new KDBizException(e1.getMessage());
            }
        }
        this.writeBackEleRecTicket(e.getDataEntities());
    }

    private void writeBackEleRecTicket(DynamicObject[] recBills) {
        block15: {
            List fromClaimCenterBillIds = Arrays.stream(recBills).filter(o -> "cas_claimcenterbill".equals(o.getString("sourcebilltype"))).map(o -> o.getLong("sourcebillid")).collect(Collectors.toList());
            try {
                if (fromClaimCenterBillIds.size() <= 0) break block15;
                logger.info("ReceivRecOp writeBackEleRecTicket fromClaimCenterBills = ", (Object)fromClaimCenterBillIds.toString());
                DynamicObject[] claimCenterBills = BusinessDataServiceHelper.load((Object[])fromClaimCenterBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimannounce"));
                if (claimCenterBills.length <= 0) break block15;
                Map<Long, String> eleRecTicketMap = Arrays.stream(claimCenterBills).filter(o -> "elerecticket".equals(o.getString("datasource"))).collect(Collectors.toMap(o -> Long.parseLong(o.getString("sourceid")), o -> o.getString("description") == null ? "" : ((OrmLocaleValue)o.get("description")).getLocaleValue()));
                logger.info("ReceivRecOp writeBackEleRecTicket eleRecTicketMap = ", eleRecTicketMap.keySet().toArray());
                DynamicObject[] eleRecTicketBills = BusinessDataServiceHelper.load((Object[])eleRecTicketMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal"));
                if (eleRecTicketBills.length <= 0) break block15;
                for (DynamicObject eleRecTicketBill : eleRecTicketBills) {
                    eleRecTicketBill.set("signopinion", (Object)"sign");
                    eleRecTicketBill.set("remark", (Object)eleRecTicketMap.get(eleRecTicketBill.getLong("id")));
                    eleRecTicketBill.set("username", (Object)RequestContext.get().getUserName());
                }
                try (TXHandle tx = TX.requiresNew();){
                    SaveServiceHelper.save((DynamicObject[])eleRecTicketBills);
                }
                logger.info("ReceivRecOp writeBackEleRecTicket eleRecTicketBills save success size = ", (Object)eleRecTicketBills.length);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw e;
            }
        }
    }
}

