/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.business.helper.RecBillOverAmountHelper;
import kd.fi.cas.business.opservice.helper.ReceServiceHelper;
import kd.fi.cas.business.opservice.impl.BillPropertyValueHandle;
import kd.fi.cas.business.writeback.RecBillSaveOrSubmitWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.ReceivingBillModel;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.PayAndRecFillTypeHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.util.CheckUtils;
import kd.fi.cas.util.FormUtils;
import kd.fi.cas.util.StringUtils;
import kd.fi.cas.validator.OrgFinishinitValidator;
import kd.fi.cas.validator.RecBillInnerAccountValidator;
import kd.fi.cas.validator.ReceivingBillSubmitValidator;
import kd.fi.cas.validator.common.TxLockValidator;
import kd.fi.cas.validator.rec.ReceivingAccountCashValidator;
import kd.fi.cas.validator.rec.ReceivingDcepSubmitValidator;
import kd.fi.cas.validator.receivingbill.RecAutoRenoteValidator;
import kd.fi.cas.validator.receivingbill.ReceivingTypeValidator;

public class ReceivingBillSubmitOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ReceivingBillSubmitOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        ReceivingBillSubmitValidator validator = new ReceivingBillSubmitValidator();
        validator.setEntityKey("cas_recbill");
        e.addValidator((AbstractValidator)validator);
        e.getValidators().add(new OrgFinishinitValidator());
        e.getValidators().add(new ReceivingTypeValidator());
        e.getValidators().add(new RecBillInnerAccountValidator());
        e.getValidators().add(new TxLockValidator());
        e.getValidators().add(new ReceivingDcepSubmitValidator());
        e.addValidator((AbstractValidator)new ReceivingAccountCashValidator());
        e.addValidator((AbstractValidator)new RecAutoRenoteValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("billstatus");
        lst.add("biztype");
        lst.add("sourcebilltype");
        lst.add("billno");
        lst.add("bizdate");
        lst.add("receivingtype");
        lst.add("payertype");
        lst.add("org");
        lst.add("org.id");
        lst.add("currency");
        lst.add("exchangerate");
        lst.add("exratetable");
        lst.add("exratedate");
        lst.add("actrecamt");
        lst.add("localamt");
        lst.add("accountbank");
        lst.add("accountcash");
        lst.add("settletype");
        lst.add("payeebank");
        lst.add("payeraccformid");
        lst.add("payertype");
        lst.add("payeracctbank");
        lst.add("isagent");
        lst.add("sourcebillid");
        lst.add("sourcebillnumber");
        lst.add("payer");
        lst.add("payername");
        lst.add("itempayertype");
        lst.add("itempayer");
        lst.add("payeracctbanknum");
        lst.add("openorg");
        lst.add("payeraccformid");
        lst.add("isvirtual");
        lst.add("entry");
        lst.add("e_sourcebillentryid");
        lst.add("e_actamt");
        lst.add("e_localamt");
        lst.add("realreccompany");
        lst.add("currency.amtprecision");
        lst.add("sourcetype");
        lst.add("e_lockAmt");
        lst.add("e_unlockAmt");
        lst.add("e_unsettledamt");
        lst.add("e_receivableamt");
        lst.add("e_sourcebillid");
        lst.add("e_corebilltype");
        lst.add("confirmlogo");
        lst.add("e_settleorg");
        lst.add("txt_description");
        lst.add("confirmlogo");
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry"));
        lst.add("entry.entry_lk");
        lst.add("fee");
        lst.add("e_unsettledlocalamt");
        lst.add("quotation");
        lst.add("basecurrency");
        lst.add("inneraccount");
        lst.add("settlestatus");
        lst.add("unsettleamount");
        lst.add("unsettleamountbase");
        lst.add("settleamount");
        lst.add("settleamountbase");
        lst.add("e_settledlocalamt");
        lst.add("relateotherflow");
        lst.add("org");
        lst.add("matchamountpay");
        lst.add("unmatchamountpay");
        lst.add("matchamountrec");
        lst.add("unmatchamountrec");
        lst.add("matchflag");
        lst.add("matchflagmsg");
        lst.add("multireceivingtype");
        lst.add("e_receivingtype");
        lst.add("businesstype");
        lst.add("refunddetailid");
        lst.add("payeedate");
        lst.add("sourcebillid");
        lst.add("settletnumber");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject recbill : e.getDataEntities()) {
            PayAndRecFillTypeHelper.fillReceBillEntryType((DynamicObject)recbill);
            CasBotpHelper.linkSourceRow((DynamicObject)recbill, (String)"er_repaymentbill", (String)"repaymententry");
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(e.getDataEntities().length);
        for (DynamicObject info : e.getDataEntities()) {
            String sourcebillnumber;
            String sourceBillType;
            DynamicObject settleType = info.getDynamicObject("settletype");
            BigDecimal exchangeRate = info.getBigDecimal("exchangerate");
            int round = info.getDynamicObject("basecurrency").getInt("amtprecision");
            String quotation = info.getString("quotation");
            if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
                info.set("accountbank", null);
            }
            FormUtils.deleteEmptyRows((DynamicObject)info, (String)"entry", (String[])new String[]{"e_actamt"});
            BigDecimal settledamt = BigDecimal.ZERO;
            BigDecimal settledlocalamt = BigDecimal.ZERO;
            BigDecimal unsettledamt = BigDecimal.ZERO;
            BigDecimal unsettledlocalamtAll = BigDecimal.ZERO;
            DynamicObjectCollection entryColl = info.getDynamicObjectCollection("entry");
            String entityName = info.getDataEntityType().getName();
            logger.info("\u5b9e\u4f53\u662f\u5426\u4e0d\u4e3acas_recbill_change\uff1a{}", (Object)(!"cas_recbill_change".equals(entityName) ? 1 : 0));
            if (!"cas_recbill_change".equals(entityName)) {
                for (Object entry : entryColl) {
                    BigDecimal e_receivableamt = entry.getBigDecimal("e_receivableamt");
                    BigDecimal e_lockamt = entry.getBigDecimal("e_lockamt");
                    BigDecimal e_settledamt = entry.getBigDecimal("e_settledamt");
                    DynamicObjectHelper.setValueIfAbsent((DynamicObject)entry, (String)"e_unlockAmt", (Object)e_receivableamt.subtract(e_lockamt));
                    DynamicObjectHelper.setValueIfAbsent((DynamicObject)entry, (String)"e_unsettledamt", (Object)e_receivableamt.subtract(e_settledamt));
                    logger.info("\u5e94\u6536\u91d1\u989d\uff1a{}\uff0c\u5df2\u9501\u5b9a\u91d1\u989d\uff1a{}\uff0c\u5df2\u7ed3\u7b97\u91d1\u989d\uff1a{}", new Object[]{e_receivableamt, e_lockamt, e_settledamt});
                    BigDecimal unsettledlocalamt = QuotationHelper.callToCurrency((BigDecimal)e_receivableamt.subtract(e_settledamt), (BigDecimal)exchangeRate, (String)quotation, (int)round);
                    DynamicObjectHelper.setValueIfAbsent((DynamicObject)entry, (String)"e_unsettledlocalamt", (Object)unsettledlocalamt);
                    settledamt = settledamt.add(entry.getBigDecimal("e_settledamt"));
                    settledlocalamt = settledlocalamt.add(entry.getBigDecimal("e_settledlocalamt"));
                    unsettledamt = unsettledamt.add(e_receivableamt.subtract(e_settledamt));
                    unsettledlocalamtAll = unsettledlocalamtAll.add(unsettledlocalamt);
                }
            }
            info.set("settleamount", (Object)settledamt);
            info.set("settleamountbase", (Object)settledlocalamt);
            info.set("unsettleamount", (Object)unsettledamt);
            info.set("unsettleamountbase", (Object)unsettledlocalamtAll);
            if (settledamt.compareTo(BigDecimal.ZERO) > 0 && unsettledamt.compareTo(BigDecimal.ZERO) == 0) {
                info.set("settlestatus", (Object)"settled");
            }
            if (settledamt.compareTo(BigDecimal.ZERO) > 0 && unsettledamt.compareTo(BigDecimal.ZERO) > 0) {
                info.set("settlestatus", (Object)"partsettle");
            }
            if (settledamt.compareTo(BigDecimal.ZERO) == 0 && unsettledamt.compareTo(BigDecimal.ZERO) != 0) {
                info.set("settlestatus", (Object)"unsettle");
            }
            if ("ar_finarbill".equals(sourceBillType = info.getString("sourcebilltype"))) {
                Object entry;
                entry = entryColl.iterator();
                while (entry.hasNext()) {
                    DynamicObject entry2 = (DynamicObject)entry.next();
                    entry2.set("e_lockAmt", (Object)entry2.getBigDecimal("e_receivableamt"));
                    entry2.set("e_unlockAmt", (Object)BigDecimal.ZERO);
                }
            }
            if (StringUtils.isNotEmpty((String)(sourcebillnumber = info.getString("sourcebillnumber"))) && sourcebillnumber.length() > 255) {
                sourcebillnumber = sourcebillnumber.substring(0, 252) + "...";
                info.set("sourcebillnumber", (Object)sourcebillnumber);
            }
            DynamicObjectHelper.setValue((DynamicObject)info, (String)"payeracctbanknum", (Object)CheckUtils.bankNumberCheck((String)info.getString("payeracctbanknum")));
            for (DynamicObject entry : entryColl) {
                if (!CasHelper.isEmpty((Object)entry.get("e_settleorg"))) continue;
                entry.set("e_settleorg", (Object)info.getDynamicObject("openorg"));
            }
            long payerAcctBank = info.getLong("payeracctbank");
            if (CasHelper.isEmpty((Object)payerAcctBank)) {
                Map bankAccount;
                long payer = info.getLong("payer");
                String payerAcctBankNum = info.getString("payeracctbanknum");
                if (CasHelper.isNotEmpty((Object)payer) && CasHelper.isNotEmpty((Object)payerAcctBankNum) && (bankAccount = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("company", "=", (Object)payer), new QFilter("bankaccountnumber", "=", (Object)payerAcctBankNum)})) != null && bankAccount.size() > 0) {
                    info.set("payeraccformid", (Object)"bd_accountbanks");
                    info.set("payeracctbank", bankAccount.keySet().iterator().next());
                }
            }
            new BillPropertyValueHandle(info);
            RecBillHepler.dealMatchInfo((DynamicObject)info);
            DynamicObjectHelper.subStringPropMaxLenth((DynamicObject)info, (String)"txt_description");
            if (ReceivingBillModel.NOT_WRITE_BACK_BILLS.contains(sourceBillType)) continue;
            WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
            taskInfo.setBillId((Long)info.getPkValue());
            taskInfo.setDataEntity(info.getDataEntityType().getName());
            taskInfo.setSourceEntity(info.getString("sourcebilltype"));
            HashMap<String, DynamicObject> param = new HashMap<String, DynamicObject>();
            param.put("info", info);
            taskInfo.setParam(param);
            taskInfos.add(taskInfo);
        }
        WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, (WriteBackOperateEnum)WriteBackOperateEnum.SUBMIT, RecBillSaveOrSubmitWriteBackConsumer.class);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            if (!ReceServiceHelper.isNeedValidate((DynamicObject)info)) continue;
            RecBillOverAmountHelper.getWriteBackVad((DynamicObject)info, (WriteBackOperateEnum)WriteBackOperateEnum.SUBMIT, (boolean)false);
        }
    }
}

