/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.validator.ReconciliationlRuleValidator;
import org.apache.commons.lang.StringUtils;

public class ReconciliationlRuleSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ReconciliationlRuleValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dynamicObjects;
        String key = this.getOption().getVariableValue("save");
        if (key != null) {
            String[] keys = key.split(",");
            List list = Arrays.asList(keys).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", list);
            DeleteServiceHelper.delete((String)"cas_reconciliationrule", (QFilter[])new QFilter[]{filter});
        }
        for (DynamicObject dynamicObjectss : dynamicObjects = e.getDataEntities()) {
            DynamicObjectCollection orgs = dynamicObjectss.getDynamicObjectCollection("org");
            ArrayList<Long> orgIds = new ArrayList<Long>(orgs.size());
            for (int i = 0; i < orgs.size(); ++i) {
                orgIds.add(((DynamicObject)orgs.get(i)).getDynamicObject("fbasedataid").getLong("id"));
            }
            QFilter filter = new QFilter("orgfield", "in", orgIds);
            DeleteServiceHelper.delete((String)"cas_reconciliationrule", (QFilter[])new QFilter[]{filter});
        }
        List<Object> list = this.transformBill(e);
        this.getOption().setVariableValue("key", StringUtils.join(list, (String)","));
    }

    private List<Object> transformBill(BeforeOperationArgs e) {
        DynamicObject[] de = e.getDataEntities();
        LinkedList<Object> savedPks = new LinkedList<Object>();
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            for (DynamicObject doj : de) {
                DynamicObjectCollection orgs = doj.getDynamicObjectCollection("org");
                DynamicObjectCollection entrysdoj = doj.getDynamicObjectCollection("entryentity");
                for (int i = 0; i < orgs.size(); ++i) {
                    DynamicObject org = (DynamicObject)orgs.get(i);
                    DynamicObject recon = BusinessDataServiceHelper.newDynamicObject((String)"cas_reconciliationrule");
                    DynamicObjectCollection entrys = recon.getDynamicObjectCollection("entryentity");
                    recon.set("orgfield", (Object)org.getDynamicObject("fbasedataid").getLong("id"));
                    recon.set("enable", (Object)"1");
                    recon.set("creator", doj.get("creator"));
                    recon.set("modifier", doj.get("creator"));
                    recon.set("createtime", (Object)new Date());
                    recon.set("modifytime", (Object)new Date());
                    for (int j = 0; j < entrysdoj.size(); ++j) {
                        DynamicObject sdoj = (DynamicObject)entrysdoj.get(j);
                        DynamicObject entry = entrys.addNew();
                        long entryID = DB.genLongId((String)"t_cas_checkedresultentry");
                        entry.set("id", (Object)entryID);
                        entry.set("seq", (Object)(j + 1));
                        entry.set("e_rulesname", sdoj.get("e_rulesname"));
                        entry.set("e_datafilterdesc", sdoj.get("e_datafilterdesc"));
                        entry.set("e_datafilterdesc_real_tag", sdoj.get("e_datafilterdesc_real_tag"));
                    }
                    Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recon});
                    for (int j = 0; j < save.length; ++j) {
                        DynamicObject obj = (DynamicObject)save[j];
                        savedPks.add(obj.getLong("id"));
                    }
                }
            }
            LinkedList<Object> linkedList = savedPks;
            return linkedList;
        }
        catch (KDException throwable2) {
            try {
                tx.markRollback();
                throw throwable2;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }
}

