/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.validator.MainTransferValidator;
import kd.fi.cas.validator.ReceivingBillRefundValidator;

public class RefundOrRenoteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(RefundOrRenoteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("sourcebilltype");
        lst.add("e_refundamt");
        lst.add("e_refunddes");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        List validators = e.getValidators();
        validators.add(new ReceivingBillRefundValidator());
        validators.add(new MainTransferValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        logger.info("--\u9000\u6b3e\uff0c\u5168\u989d\u9000\u6b3e--RefundOrRenoteOp.beginOperationTransaction(BeginOperationTransactionArgs)");
        DynamicObject[] dataEntities = e.getDataEntities();
        String rebillid = this.getOption().getVariableValue("rebillid");
        if ("cas_paybill".equals(this.getOption().getVariableValue("billtype"))) {
            for (DynamicObject bill : dataEntities) {
                bill.set("billstatus", (Object)BillStatusEnum.REFUND.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
                CasBotpHelper.saveRelation((String)"cas_recbill", (Long)Long.valueOf(rebillid), (String)"cas_paybill", (Long)((Long)bill.getPkValue()));
                HashMap<String, Object> param = new HashMap<String, Object>();
                this.saveRecBill(Long.valueOf(rebillid), bill, param);
                WriteBackTaskHelper.addRealtimeTask((DynamicObject)bill, (String)bill.getString("sourcebilltype"), (WriteBackOperateEnum)WriteBackOperateEnum.REFUND, PaymentDisposeConsumer.class, param);
                WriteBackTaskHelper.addRealtimeTask((DynamicObject)bill, (String)"ap_settle", (WriteBackOperateEnum)WriteBackOperateEnum.REFUND, PaymentDisposeConsumer.class, param);
            }
        }
    }

    private void saveRecBill(Long rebillid, DynamicObject bill, Map<String, Object> param) {
        DynamicObject recbill = BusinessDataServiceHelper.loadSingle((Object)rebillid, (String)"cas_recbill");
        recbill.set("isrefund", (Object)true);
        BigDecimal actpayamt = bill.getBigDecimal("actpayamt");
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
        BigDecimal refundAmt = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : entry) {
            refundAmt = refundAmt.add(dynamicObject.getBigDecimal("e_refundamt"));
        }
        param.put("isfullrefund", refundAmt.compareTo(actpayamt) == 0);
        recbill.set("isfullrefund", (Object)(refundAmt.compareTo(actpayamt) == 0 ? 1 : 0));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recbill});
    }
}

