/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.changebill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.PayApplyRecChgStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.helper.DcepConverHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.changebill.PayApplyRecChgAuditValidator;

public class PayApplyRecChgAuditOp
extends AbstractOperationServicePlugIn {
    private static final String RECCHG = "recchg";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("chgtype");
        fieldKeys.add("sourcetype");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("entrys");
        fieldKeys.add("entrys.sourceentryid");
        fieldKeys.add("entrys.afterrecerbank");
        fieldKeys.add("entrys.chguseraccbank");
        fieldKeys.add("entrys.changerecacctbank");
        fieldKeys.add("entrys.chgpayeeaccbankid");
        fieldKeys.add("entrys.chgpayeeaccbank");
        fieldKeys.add("entrys.afterinstitutioncode");
        fieldKeys.add("entrys.afterinstitutionname");
        fieldKeys.add("entrys.chgaccountname");
        fieldKeys.add("iscashconfirm");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        PayApplyRecChgAuditValidator validator = new PayApplyRecChgAuditValidator();
        e.addValidator((AbstractValidator)validator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            if (!dynamicObject.getString("chgtype").equals(RECCHG) || !dynamicObject.getString("sourcetype").equals("cas_payapplybill")) continue;
            Long sourcebillid = dynamicObject.getLong("sourcebillid");
            DynamicObject cas_payapplybill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)"cas_payapplybill");
            DynamicObjectCollection entrys = (DynamicObjectCollection)dynamicObject.get("entrys");
            DynamicObjectCollection applyentrys = cas_payapplybill.getDynamicObjectCollection("cas_payapplyentry");
            applyentrys.forEach(item -> entrys.forEach(entry -> {
                if (((Long)item.getPkValue()).longValue() == entry.getLong("sourceentryid")) {
                    item.set("e_chgstatus", (Object)PayApplyRecChgStatusEnum.CHGED.getValue());
                    if (EmptyUtil.isNotBlank((Object)entry.get("afterrecerbank"))) {
                        item.set("e_chgpayeebank", entry.get("afterrecerbank"));
                    }
                    if (EmptyUtil.isNotBlank((Object)entry.get("changerecacctbank"))) {
                        item.set("e_chgpayeeaccbanknum", entry.get("changerecacctbank"));
                        item.set("e_chgpayeeaccbankid", entry.get("chgpayeeaccbankid"));
                        item.set("e_chguseraccbank", entry.get("chguseraccbank"));
                        item.set("e_chgpayeeaccbank", entry.get("chgpayeeaccbank"));
                    }
                }
            }));
            DynamicObjectCollection payinfoentry = cas_payapplybill.getDynamicObjectCollection("cas_payinfo");
            payinfoentry.forEach(item -> entrys.forEach(entry -> {
                if (item.getLong("entry_applyid") == entry.getLong("sourceentryid") && PayStatusEnum.NOTPAYING.getValue().equals(item.getString("entry_paystatus"))) {
                    if (EmptyUtil.isNotBlank((Object)entry.getDynamicObject("afterrecerbank"))) {
                        item.set("entry_payeebank", entry.get("afterrecerbank"));
                        DynamicObject payeeBank = entry.getDynamicObject("afterrecerbank");
                        item.set("entry_recbanknumber", payeeBank.get("union_number"));
                        item.set("entry_recswiftcode", payeeBank.get("swift_code"));
                        item.set("entry_recroutingnum", payeeBank.get("routingnum"));
                        item.set("entry_recothercode", payeeBank.get("other_code"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)entry.getString("changerecacctbank"))) {
                        item.set("entry_payeeaccbanknum", entry.get("changerecacctbank"));
                        DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((Object)entry.get("chgpayeeaccbankid"), (String)"bd_accountbanks");
                        item.set("entry_recinstitutioncode", (Object)DcepConverHelper.getInstitUtionCode((DynamicObject)acct));
                        item.set("entry_recinstitutionname", (Object)DcepConverHelper.getInstitutionName((DynamicObject)acct));
                        if (StringUtils.isNotBlank((CharSequence)entry.getString("chgaccountname"))) {
                            item.set("entry_accountname", (Object)entry.getString("chgaccountname"));
                        }
                    }
                    if (EmptyUtil.isNotBlank((Object)entry.get("afterinstitutioncode"))) {
                        item.set("entry_recinstitutioncode", entry.get("afterinstitutioncode"));
                        item.set("entry_recinstitutionname", entry.get("afterinstitutionname"));
                    }
                }
            }));
            dynamicObject.set("iscashconfirm", (Object)true);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            SaveServiceHelper.update((DynamicObject)cas_payapplybill);
        }
    }
}

